/*
    GSrnd
    
    A control panel for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998,99 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/

#include <gtk/gtk.h>
#include <stdio.h>
#include "message_dialog.h"



void dialog_destroy (GtkWidget *widget, gpointer data)
{
	GtkWidget *dialog;

	dialog = (GtkWidget *)data;

	gtk_grab_remove(dialog);
	gtk_widget_destroy(dialog);
}


void gsrnd_message_dialog_create (const char *format, const char *str)
{
	GtkWidget *dialog;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *button;
	char buffer[256];


	dialog = gtk_dialog_new();
	gtk_window_set_wmclass(GTK_WINDOW(dialog), "gsrnd_message", "GSrnd");
	gtk_window_set_title(GTK_WINDOW(dialog), "GSrnd Message");
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
	gtk_signal_connect(GTK_OBJECT(dialog), "destroy", (GtkSignalFunc)dialog_destroy, dialog);
	gtk_widget_realize(dialog);

	sprintf(buffer, format, str);

	hbox = gtk_hbox_new(FALSE, 0);
	label = gtk_label_new(buffer);
	gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 10);
	gtk_widget_show(label);

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), hbox, TRUE, TRUE, 10);
	gtk_widget_show(hbox);

	gtk_widget_show(GTK_DIALOG(dialog)->vbox);
	
	button = gtk_button_new_with_label("OK");
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button), "clicked", (GtkSignalFunc)dialog_destroy, dialog);
	gtk_widget_set_usize(button, 80, 0);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, FALSE, FALSE, 10);
	gtk_widget_grab_default(button);
	gtk_widget_show(button);
	gtk_widget_show(GTK_DIALOG(dialog)->action_area);
	gtk_grab_add(dialog);
	gtk_widget_show(dialog);
}
