/*
    GSrnd
    
    A control panel for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998,99 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/

#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#include "preferences_dialog.h"
#include "resources.h"


extern GtkTooltips *gsrnd_tooltips;


GSrndPreferences gsrnd_preferences = { (char *)NULL, (char *)NULL, 0, 0 };


static GtkWidget *device;
static GtkWidget *mixer;
static GtkWidget *tooltips;
static GtkWidget *savesettings;


static GtkWidget *gsrnd_preferences_dialog = (GtkWidget *)NULL;


void gsrnd_load_preferences (void)
{
	if (gsrnd_preferences.device != (char *)NULL)
		free(gsrnd_preferences.device);
	if (gsrnd_preferences.mixer != (char *)NULL)
		free(gsrnd_preferences.mixer);

	rc_set_group("Main");
	gsrnd_preferences.device = strdup(rc_read_str("Device", "/dev/srnd"));
	gsrnd_preferences.mixer = strdup(rc_read_str("Mixer", "xmix"));
	gsrnd_preferences.tooltips = rc_read_bool("ToolTips", TRUE);
	gsrnd_preferences.savesettings = rc_read_bool("SaveOnExit", TRUE);

	if (gsrnd_preferences.tooltips)
		gtk_tooltips_enable(gsrnd_tooltips);
	else
		gtk_tooltips_disable(gsrnd_tooltips);
}


void gsrnd_save_preferences (void)
{
	if (gsrnd_preferences.device != (char *)NULL)
		free(gsrnd_preferences.device);
	if (gsrnd_preferences.mixer != (char *)NULL)
		free(gsrnd_preferences.mixer);

	gsrnd_preferences.device = strdup(gtk_entry_get_text(GTK_ENTRY(device)));
	gsrnd_preferences.mixer = strdup(gtk_entry_get_text(GTK_ENTRY(mixer)));
	gsrnd_preferences.tooltips = GTK_TOGGLE_BUTTON(tooltips)->active;
	gsrnd_preferences.savesettings = GTK_TOGGLE_BUTTON(savesettings)->active;

	if (gsrnd_preferences.tooltips)
		gtk_tooltips_enable(gsrnd_tooltips);
	else
		gtk_tooltips_disable(gsrnd_tooltips);

	rc_set_group("Main");
	rc_write_str("Device", gsrnd_preferences.device);
	rc_write_str("Mixer", gsrnd_preferences.mixer);
	rc_write_bool("ToolTips", gsrnd_preferences.tooltips);
	rc_write_bool("SaveOnExit", gsrnd_preferences.savesettings);
	rc_save();
}


void gsrnd_preferences_default (void)
{
	gtk_entry_set_text(GTK_ENTRY(device), gsrnd_preferences.device);
	gtk_entry_set_text(GTK_ENTRY(mixer), gsrnd_preferences.mixer);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tooltips), gsrnd_preferences.tooltips);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(savesettings), gsrnd_preferences.savesettings);
}	
	

void gsrnd_preferences_dialog_destroy (GtkWidget *widget, gpointer *data)
{
	gtk_widget_destroy(gsrnd_preferences_dialog);
	gsrnd_preferences_dialog = NULL;
}


void gsrnd_preferences_dialog_ok (GtkWidget *widget, gpointer *data)
{
	gsrnd_save_preferences();
	gtk_widget_hide(gsrnd_preferences_dialog);
}


void gsrnd_preferences_dialog_default (GtkWidget *widget, gpointer *data)
{
	gsrnd_preferences_default();
}


void gsrnd_preferences_dialog_apply (GtkWidget *widget, gpointer *data)
{
	gsrnd_save_preferences();
}


void gsrnd_preferences_dialog_cancel (GtkWidget *widget, gpointer *data)
{
	gtk_widget_hide(gsrnd_preferences_dialog);
}


void gsrnd_preferences_dialog_create (void)
{
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *button;
	GtkWidget *table;
	
	
	if (!gsrnd_preferences_dialog) {
		gsrnd_preferences_dialog = gtk_dialog_new();
		gtk_window_set_wmclass(GTK_WINDOW(gsrnd_preferences_dialog), "preferences_dialog", "GSrnd");
		gtk_window_set_title(GTK_WINDOW(gsrnd_preferences_dialog), "GSrnd Preferences");
		gtk_signal_connect(GTK_OBJECT(gsrnd_preferences_dialog), "destroy", GTK_SIGNAL_FUNC(gsrnd_preferences_dialog_destroy), NULL);

		hbox = gtk_hbox_new(FALSE, 0);
		table = gtk_table_new(4, 2, FALSE);
	
		label = gtk_label_new("SRND Device:");
		gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
		gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1, GTK_FILL, GTK_FILL | GTK_EXPAND, 2, 5);
		gtk_widget_show(label);
		label = gtk_label_new("Mixer Command:");
		gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
		gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL | GTK_EXPAND, 2, 5);
		gtk_widget_show(label);

		device = gtk_entry_new();
		gtk_table_attach(GTK_TABLE(table), device, 1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 5);
		gtk_widget_show(device);
		gtk_tooltips_set_tip(gsrnd_tooltips, device, "Device of the miroMEDIA Surround Board", "");

		mixer = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(mixer), "xmix");
		gtk_table_attach(GTK_TABLE(table), mixer, 1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 5);
		gtk_widget_show(mixer);
		gtk_tooltips_set_tip(gsrnd_tooltips, mixer, "Mixer Command", "");

		tooltips = gtk_check_button_new_with_label("Show Tooltips");
		gtk_table_attach(GTK_TABLE(table), tooltips, 0, 2, 2, 3, GTK_FILL, GTK_FILL | GTK_EXPAND, 2, 5);
		gtk_widget_show(tooltips);
		gtk_tooltips_set_tip(gsrnd_tooltips, tooltips, "Show Tooltips in Dialogs", "");

		savesettings = gtk_check_button_new_with_label("Save Main Settings on Exit");
		gtk_table_attach(GTK_TABLE(table), savesettings, 0, 2, 3, 4, GTK_FILL, GTK_FILL | GTK_EXPAND, 2, 5);
		gtk_widget_show(savesettings);
		gtk_tooltips_set_tip(gsrnd_tooltips, savesettings, "Save Settings of Main Window on Exit", "");
	
		gtk_box_pack_start(GTK_BOX(hbox), table, TRUE, TRUE, 10);
		gtk_widget_show(table);

		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(gsrnd_preferences_dialog)->vbox), hbox, TRUE, TRUE, 10);
		gtk_widget_show(hbox);


		gtk_widget_show(GTK_DIALOG(gsrnd_preferences_dialog)->vbox);

		button = gtk_button_new_with_label("OK");
		gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gsrnd_preferences_dialog_ok), NULL);
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(gsrnd_preferences_dialog)->action_area), button, TRUE, TRUE, 0);
		gtk_widget_grab_default(button);
		gtk_widget_show(button);

		button = gtk_button_new_with_label("Default");
		gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gsrnd_preferences_dialog_default), NULL);
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(gsrnd_preferences_dialog)->action_area), button, TRUE, TRUE, 0);
		gtk_widget_show(button);

		button = gtk_button_new_with_label("Apply");
		gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gsrnd_preferences_dialog_apply), NULL);
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(gsrnd_preferences_dialog)->action_area), button, TRUE, TRUE, 0);
		gtk_widget_show(button);

		button = gtk_button_new_with_label("Cancel");
		gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gsrnd_preferences_dialog_cancel), NULL);
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(gsrnd_preferences_dialog)->action_area), button, TRUE, TRUE, 0);
		gtk_widget_show(button);

		gtk_widget_show(GTK_DIALOG(gsrnd_preferences_dialog)->action_area);

		gsrnd_preferences_default();
	}

	if (!GTK_WIDGET_VISIBLE(gsrnd_preferences_dialog))
		gtk_widget_show(gsrnd_preferences_dialog);
	else
		gdk_window_raise(gsrnd_preferences_dialog->window);
}
