/*
    GSrnd
    
    A control panel for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998,99 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/

#ifndef __SETUP_DIALOG_H__
#define __SETUP_DIALOG_H__


#include <gtk/gtk.h>

typedef struct _GSrndSetupPreferences GSrndSetupPreferences;

struct _GSrndSetupPreferences {
	int dbspeaker;
	int dbvollr, dbvolc, dbvols;
	int dbdelay;
	int tdeffect;
	int tdlevel;
	int nmode;
	int nlevel;
};
	

extern GSrndSetupPreferences gsrnd_setup_preferences;

extern int srnd_fd;

void gsrnd_setup_load_preferences (void);

void gsrnd_setup_set_mode (int mode);
void gsrnd_setup_set_volume (int volume);
void gsrnd_setup_set_bypass (int bypass);
char *gsrnd_setup_get_version (char *buffer);

void gsrnd_setup_dialog_create (void);



#endif /* __SETUP_DIALOG_H__ */
