/*
    KSrnd
    
    A control panel for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/

#include "dockwidget.h"
#include "dockwidget.moc"

#include "ksrnd.h"


#include <qpopmenu.h>  // <qpopupmenu.h>
#include <qstring.h>
#include <qevent.h>
#include <qpoint.h>

#include <kapp.h>
#include <kiconloader.h>
#include <kwm.h>


extern KApplication * mykapp;
extern KSrnd * ksrnd;



DockWidget::DockWidget( const char * name ) : QWidget( 0, name, 0 )
{
	KIconLoader *KIL;

	docked = false;

	KIL = mykapp->getIconLoader();
	pix = KIL->loadIcon("docked.xpm");

	// popup menu for right mouse button
	dock_menu = new QPopupMenu();
	dock_menu->setCheckable(true);
	modeID[0] = dock_menu->insertItem(i18n("Dolby Pro Logic"), this, SLOT(menuDBPL()));
	modeID[1] = dock_menu->insertItem(i18n("3D-Phonic"), this, SLOT(menu3DPhon()));
	modeID[2] = dock_menu->insertItem(i18n("Through Stereo"), this, SLOT(menuThrough()));
	modeID[3] = dock_menu->insertItem(i18n("Noise Generator"), this, SLOT(menuNoise()));
	dock_menu->insertSeparator();
	bypassID = dock_menu->insertItem(i18n("Bypass"), this, SLOT(menuBypass()));
	dock_menu->insertSeparator();
	toggleID = dock_menu->insertItem("", this, SLOT(menuVisible()));
	dock_menu->insertItem(i18n("Quit"), this, SLOT(menuQuit()));

	//  QToolTip::add( this, statstring.data() );
}


DockWidget::~DockWidget()
{
}


bool DockWidget::isDocked()
{
	return docked;
}


void DockWidget::markMode( int mode )
{
	int i;

	for (i=0; i < 4; i++)
		dock_menu->setItemChecked(modeID[i], mode == i);
}


void DockWidget::markBypass( bool on )
{
	dock_menu->setItemChecked(bypassID, on);
}


void DockWidget::markVisible( bool visible )
{
	QString text = visible ? i18n("Minimize") : i18n("Restore");

	dock_menu->changeItem(text, toggleID);
}


void DockWidget::paintEvent( QPaintEvent * )
{
	bitBlt(this, 0, 0, &pix);
}


void DockWidget::mousePressEvent( QMouseEvent * e )
{
	// open/close connect-window on left mouse button 
	if ( e->button() == LeftButton )
		emit dock_toggle_visible();

	// open popup menu on right or middle mouse button
	if ( (e->button() == RightButton)  || (e->button() == MidButton)) {
		markVisible(ksrnd->isVisible());
		dock_menu->popup(QPoint(e->x()+x(), e->y()+y()));
		dock_menu->exec();
	}

}


void DockWidget::menuDBPL()
{
	emit dock_mode(0);
}


void DockWidget::menu3DPhon()
{
	emit dock_mode(1);
}


void DockWidget::menuThrough()
{
	emit dock_mode(2);
}


void DockWidget::menuNoise()
{
	emit dock_mode(3);

}


void DockWidget::menuBypass()
{
	emit dock_bypass(!dock_menu->isItemChecked(bypassID));

}


void DockWidget::menuVisible()
{
	emit dock_toggle_visible();
}


void DockWidget::menuQuit()
{
	emit dock_quit();
}


void DockWidget::dock()
{
	if (!docked) {
		KWM::setDockWindow(winId());
		setFixedSize(24, 24);
		show();
		docked = true;
	}
}


void DockWidget::undock()
{
	if (docked) {
		destroy(true, true);
		create(0, true, false);
		docked = false;
	}
}
