/*
    KSrnd
    
    A control panel for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/

#ifndef KSRND_H 
#define KSRND_H 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include "ksrndwidget.h"
#include "ksrndprefs.h"
#include "ksrndsetup.h"
#include "dockwidget.h"

#include <ktopwidget.h>
#include <kmenubar.h>
#include <kconfig.h>




class KSrnd : public KTopLevelWidget
{
	Q_OBJECT

public:
	KSrnd( QWidget * parent = 0, const char * name = 0 );
	~KSrnd();

	void resetMain();
	void saveMain();

public slots:
	void setMode( int mode );
	void setVolume( int vol );
	void setBypass( bool on );
	void toggleVisible();

	void newPrefs();
	void invokeMixer();
	void showPrefs();
	void showSetup();
	void invokeHelp();
	void showAbout();

private slots:
	void quit();

protected:
	virtual void closeEvent( QCloseEvent * e );

private:
	KConfig * KsConfig;

	int mode, volume;
	bool bypass;

	KMenuBar * menuBar;
	KSrndWidget * view;
	KSrndPrefs * prefs;
	KSrndSetup * setup;
	DockWidget * dock_widget;
	int pos_x, pos_y;
	
	void savePosition();
};

#endif // KSRND_H 
