/*
    KSrnd
    
    A control panel for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/


#include "ksrndprefs.h"
#include "ksrndprefs.moc"

#include <kapp.h>

#include <qsize.h>
#include <qlabel.h>
#include <qdialog.h>
#include <qwidget.h>
#include <qlined.h> // <qlineedit.h>
#include <qpushbt.h> // <qpushbutton.h>
#include <qtooltip.h>
#include <stdlib.h>
#include <string.h>


extern KApplication * mykapp;


KSrndPrefs::KSrndPrefs( QWidget * parent ) : QDialog ( parent )
{
	QSize size;
	QLabel * label1, * label2;
	QPushButton * ok, * def, * apply, * cancel;
	int width, xpos, ypos;

	gotToolTips = false;
	device_buf = 0;
	mixer_buf = 0;

	KsConfig = mykapp->getConfig();

	label1 = new QLabel(i18n("SRND &Device:"), this);
	label1->adjustSize();
	label2 = new QLabel(i18n("&Mixer Command:"), this);
	label2->adjustSize();
	width = (label1->width() > label2->width()) ? label1->width() : label2->width();

	device = new QLineEdit( this );
	size = device->sizeHint();
	device->setGeometry(width+15, 10, 160, size.height());
	label1->setBuddy(device);

	mixer = new QLineEdit( this );
	size = mixer->sizeHint();
	mixer->setGeometry(width+15, device->height()+20, 160, size.height());
	label2->setBuddy(mixer);
	
	label1->move(10, device->y()+(device->height()-label1->height())/2);
	label2->move(10, mixer->y()+(mixer->height()-label2->height())/2);

	docking = new QCheckBox(i18n("&Allow Docking"), this);
	docking->adjustSize();
	docking->move(10, mixer->y()+mixer->height()+10);
	startdocked = new QCheckBox(i18n("Start Docked"), this);
	startdocked->adjustSize();
	startdocked->move(docking->x()+docking->width()+10, mixer->y()+mixer->height()+10);
	connect(docking, SIGNAL(clicked()), SLOT(dockedSlot()));
	tooltips = new QCheckBox(i18n("Show &Tooltips"), this);
	tooltips->adjustSize();
	tooltips->move(10, docking->y()+docking->height()+10);
	save = new QCheckBox(i18n("&Save Main Settings on Exit"), this);
	save->adjustSize();
	save->move(10, tooltips->y()+tooltips->height()+10);
	ypos = save->y() + save->height() + 10;

	ok = new QPushButton(i18n("OK"), this);
	ok->setDefault(true);
	ok->adjustSize();
	width = ok->width();

	def = new QPushButton(i18n("Default"), this);
	def->adjustSize();
	if (def->width() > width)
		width = def->width();

	apply = new QPushButton(i18n("Apply"), this);
	apply->adjustSize();
	if (apply->width() > width)
		width = apply->width();

	cancel = new QPushButton(i18n("Cancel"), this);
	cancel->adjustSize();
	if (cancel->width() > width)
		width = cancel->width();

	xpos = 10;
	ok->setGeometry(xpos, ypos, width, ok->height());
	xpos += width+7;
	def->setGeometry(xpos, ypos, width, def->height());
	xpos += width+7;
	apply->setGeometry(xpos, ypos, width, apply->height());
	xpos += width+7;
	cancel->setGeometry(xpos, ypos, width, cancel->height());
	
	connect(ok, SIGNAL(clicked()), SLOT(accept()));
	connect(def, SIGNAL(clicked()), SLOT(reset()));
	connect(apply, SIGNAL(clicked()), SLOT(apply()));
	connect(cancel, SIGNAL(clicked()), SLOT(reject()));

	setCaption(i18n("KSrnd Preferences"));

	adjustSize();
	setFixedSize(this->width(), this->height());
}


KSrndPrefs::~KSrndPrefs()
{
	if (device_buf != 0)
		free(device_buf);
	if (mixer_buf != 0)
		free(mixer_buf);
}


void KSrndPrefs::addToolTips(bool on)
{
	if (on == gotToolTips)
		return;

	gotToolTips = on;

	if (gotToolTips) {
		QToolTip::add(device, i18n("Device of the miroMEDIA Surround Board"));
		QToolTip::add(mixer, i18n("Mixer Command"));
		QToolTip::add(docking, i18n("Allow Docking to KPanel"));
		QToolTip::add(startdocked, i18n("Start minimized if Docking is allowed"));
		QToolTip::add(tooltips, i18n("Show Tooltips in Dialogs"));
		QToolTip::add(save, i18n("Save Settings of Main Window on Exit"));
	}
	else {
		QToolTip::remove(device);
		QToolTip::remove(mixer);
		QToolTip::remove(docking);
		QToolTip::remove(startdocked);
		QToolTip::remove(tooltips);
		QToolTip::remove(save);
	}
}	


char * KSrndPrefs::deviceText()
{
	return device_buf;

}


char * KSrndPrefs::mixerText()
{
	return mixer_buf;

}


bool KSrndPrefs::isDocking()
{
	return docking_buf;
}


bool KSrndPrefs::startDocked()
{
	return startdocked_buf;
}


bool KSrndPrefs::isToolTips()
{
	return tooltips_buf;
}


bool KSrndPrefs::isSave()
{
	return save_buf;
}


void KSrndPrefs::accept()
{
	apply();
	hide();
}


void KSrndPrefs::reset()
{
	if (device_buf != 0)
		free(device_buf);
	if (mixer_buf != 0)
		free(mixer_buf);

	KsConfig->setGroup("Main");

	device_buf = strdup(KsConfig->readEntry("Device", "/dev/srnd"));
	device->setText(device_buf);
	mixer_buf = strdup(KsConfig->readEntry("Mixer", "kmix"));
	mixer->setText(mixer_buf);

	docking_buf = KsConfig->readBoolEntry("Docking", true);
	docking->setChecked(docking_buf);
	startdocked_buf = KsConfig->readBoolEntry("StartDocked", false);
	startdocked->setChecked(startdocked_buf);
	tooltips_buf = KsConfig->readBoolEntry("ToolTips", true);
	tooltips->setChecked(tooltips_buf);
	save_buf = KsConfig->readBoolEntry("SaveOnExit", true);
	save->setChecked(save_buf);
	dockedSlot();
}


void KSrndPrefs::apply()
{
	if (device_buf != 0)
		free(device_buf);
	if (mixer_buf != 0)
		free(mixer_buf);

	KsConfig->setGroup("Main");

	device_buf = strdup(device->text());
	KsConfig->writeEntry("Device", device_buf);
	mixer_buf = strdup(mixer->text());
	KsConfig->writeEntry("Mixer", mixer_buf);

	KsConfig->writeEntry("Docking", docking->isChecked());
	KsConfig->writeEntry("StartDocked", startdocked->isChecked());
	tooltips_buf = tooltips->isChecked();
	KsConfig->writeEntry("ToolTips", tooltips_buf);
	save_buf = save->isChecked();
	KsConfig->writeEntry("SaveOnExit", save_buf);

	KsConfig->sync();

	emit apply_clicked();
}


void KSrndPrefs::dockedSlot()
{
	startdocked->setEnabled(docking->isChecked());
}

