/*
    KSrnd
    
    A control panel for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/

#ifndef KSRNDPREFS_H 
#define KSRNDPREFS_H 


#include <kconfig.h>

#include <qdialog.h>
#include <qlined.h> // <qlineedit.h>
#include <qchkbox.h> // <qcheckbox.h>



class KSrndPrefs : public QDialog
{
	Q_OBJECT

public:
	KSrndPrefs( QWidget * parent );
	virtual ~KSrndPrefs();

	void addToolTips(bool on);

	char * deviceText();
	char * mixerText();
	bool isDocking();
	bool startDocked();
	bool isToolTips();
	bool isSave();
	
protected slots:
	void accept();

public slots:
	void reset();
	void apply();

private slots:
	void dockedSlot();

signals:
	void apply_clicked();

private:
	KConfig *KsConfig;

	bool gotToolTips;
	char * device_buf;
	char * mixer_buf;
	bool docking_buf;
	bool startdocked_buf;
	bool tooltips_buf;
	bool save_buf;

	QLineEdit * device;
	QLineEdit * mixer;
	QCheckBox * docking;
	QCheckBox * startdocked;
	QCheckBox * tooltips;
	QCheckBox * save;
};


#endif // KSRNDPREFS_H
