/*
    KSrnd
    
    A control panel for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/

#include "ksrndwidget.h"
#include "ksrndwidget.moc"

#include <qlabel.h>
#include <qpushbt.h> // <qpushbutton.h>
#include <qradiobt.h> // <qradiobutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qpixmap.h>

#include <string.h>

#include <kiconloader.h>
#include <kwm.h>
#include <kapp.h>



extern KApplication * mykapp;


KSrndWidget::KSrndWidget( QWidget * parent, const char * name) : QWidget( parent, name )
{
	KIconLoader *KIL;
	QLabel *label;
	QSize size;
	QPixmap pix;
	
	gotToolTips = false;

	label = new QLabel( i18n("&Mode"), this );
	label->setAlignment(AlignVCenter);
	
	mode = new QComboBox( false, this );
	mode->insertItem(i18n("Dolby Pro Logic"), 0);
	mode->insertItem(i18n("3D-Phonic"), 1);
	mode->insertItem(i18n("Through Stereo"), 2);
	mode->insertItem(i18n("Noise Generator"), 3);
	mode->adjustSize();
	size = label->sizeHint();
	label->setGeometry(10, 10, size.width(), mode->height());
	label->setBuddy(mode);
	mode->setGeometry(label->x()+label->width()+6, 10, mode->width()+20, mode->height());
	connect(mode, SIGNAL(activated(int)), SLOT(modeSlot(int)));

	volume = new QSlider( 0, 16, 1, 0, QSlider::Horizontal, this );
	volume->setTickmarks( QSlider::Right ); /* should be "Below" */
	volume->setTickInterval( 2 );
	size = volume->sizeHint();
	volume->setGeometry(10, label->y()+label->height()+10, label->width()+mode->width()+6, size.height());
	connect(volume, SIGNAL(valueChanged(int)), SLOT(volumeSlot(int)));

	bypass = new QCheckBox( i18n("&Bypass"), this );
	bypass->adjustSize();
	bypass->move(10, volume->y()+volume->height()+10);
	connect(bypass, SIGNAL(clicked()), SLOT(bypassSlot()));

	KIL = mykapp->getIconLoader();
	pix = KIL->loadIcon("dolbypro.xpm");
	label = new QLabel( this );
	label->setPixmap(pix);
	label->adjustSize();
	label->move(volume->x()+volume->width()-label->width(), bypass->y());

	adjustSize();
	setFixedSize(width(), height());
}


KSrndWidget::~KSrndWidget()
{
}


void KSrndWidget::addToolTips( bool on )
{
	if (on == gotToolTips)
		return;
	
	gotToolTips = on;

	if (gotToolTips) {
		QToolTip::add(mode, i18n("Surround Mode"));
		QToolTip::add(volume, i18n("Master Volume"));
		QToolTip::add(bypass, i18n("Bypass Sound"));
	}
	else {
		QToolTip::remove(mode);
		QToolTip::remove(volume);
		QToolTip::remove(bypass);
	}
}


void KSrndWidget::setMode( int mode )
{
	this->mode->setCurrentItem(mode);
}


void KSrndWidget::setVolume( int vol )
{
	volume->setValue(vol);
}


void KSrndWidget::setBypass( bool on )
{
	bypass->setChecked(on);
}


void KSrndWidget::modeSlot( int mode )
{
	emit set_mode(mode);
}


void KSrndWidget::volumeSlot( int vol )
{
	emit set_volume(vol);
}


void KSrndWidget::bypassSlot()
{
	emit set_bypass(bypass->isChecked());
}
