/*
    KSrnd
    
    A control panel for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/

#ifndef KSRNDWIDGET_H 
#define KSRNDWIDGET_H 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qcombo.h> // <qcombobox.h>
#include <qslider.h>
#include <qchkbox.h> // <qcheckbox.h>



class KSrndWidget : public QWidget
{
	Q_OBJECT

public:
	KSrndWidget( QWidget * parent, const char * name );
	virtual ~KSrndWidget();

	void addToolTips( bool on );

	void setMode( int mode );
	void setVolume( int vol );
	void setBypass( bool on );

private slots:
	void modeSlot( int mode );
	void volumeSlot( int vol );
	void bypassSlot();

signals:
	void set_mode( int );
	void set_volume( int );
	void set_bypass( bool );

private:
	bool gotToolTips;

	QComboBox * mode;
	QSlider * volume;
	QCheckBox * bypass;
};


#endif // KSRNDWIDGET_H 
