/*
    KSrnd
    
    A control panel for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/


#include "srnddev.h"

#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <srnd.h>


SrndDev::SrndDev()
{
	isOpen = false;
	devfd = -1;

	openDev("/dev/srnd");
}


SrndDev::SrndDev( char * devname )
{
	isOpen = false;
	devfd = -1;

	openDev(devname);
}


SrndDev::~SrndDev()
{
	if (isOpen)
		close(devfd);
}


bool SrndDev::openDev( char * devname )
{
	if (isOpen)
		close(devfd);

	isOpen = (devfd = open(devname, O_RDWR)) != -1;

	return isOpen;
}


int SrndDev::getVersion( int * ver )
{
	return ioctl(devfd, SRNDVERSION, ver);
}


int SrndDev::setVolume( int vol )
{
	return ioctl(devfd, SRNDDAC_VOL, vol);
}


int SrndDev::setBypass( bool on )
{
	return ioctl(devfd, SRNDBYPASS, (int)on);
}


int SrndDev::setMode( int mode )
{
	static const int mode_tab[4] = {
		SRNDDBPL_INIT,
		SRND3DPHON_INIT,
		SRNDTHROUGH_INIT,
		SRNDNOISE_INIT
	};

	return ((mode < 0) || (mode > 3)) ? -1 : ioctl(devfd, mode_tab[mode]);
}


int SrndDev::setDBPLMode( int mode )
{
	return ioctl(devfd, SRNDDBPL_MODE, mode);
}


int SrndDev::setDBPLVolLR( int vol )
{
	return ioctl(devfd, SRNDDBPL_VOL_LR, vol);
}


int SrndDev::setDBPLVolC( int vol )
{
	return ioctl(devfd, SRNDDBPL_VOL_C, vol);
}


int SrndDev::setDBPLVolS( int vol )
{
	return ioctl(devfd, SRNDDBPL_VOL_S, vol);
}


int SrndDev::setDBPLDelay( int delay )
{
	return ioctl(devfd, SRNDDBPL_DELAY, delay);
}


int SrndDev::set3DPhonMode( int mode )
{
	return ioctl(devfd, SRND3DPHON_MODE, mode);
}


int SrndDev::set3DPhonLevel( int level )
{
	return ioctl(devfd, SRND3DPHON_LEVEL, level);
}


int SrndDev::setNoiseMode( int mode )
{
	return ioctl(devfd, SRNDNOISE_MODE, mode);
}


int SrndDev::setNoiseLevel( int level )
{
	return ioctl(devfd, SRNDNOISE_LEVEL, level);
}


char * SrndDev::errorStr()
{
	return strerror(errno);
}
