/*
    KSrnd
    
    A control panel for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/

#ifndef SRNDDEV_H 
#define SRNDDEV_H 


class SrndDev
{
public:
	bool isOpen;

	SrndDev();
	SrndDev( char * devname );
	~SrndDev();

	bool openDev( char * devname );

	int getVersion( int * ver );
	int setVolume( int vol );
	int setBypass( bool on );
	int setMode( int mode );

	int setDBPLMode( int mode );
	int setDBPLVolLR( int vol );
	int setDBPLVolC( int vol );
	int setDBPLVolS( int vol );
	int setDBPLDelay( int delay );

	int set3DPhonMode( int mode );
	int set3DPhonLevel( int level );

	int setNoiseMode( int mode );
	int setNoiseLevel( int level );

	char *errorStr();

private:
	int devfd;
};

#endif // SRNDDEV_H
