/*
 *  @(#) obuffer_file.h 1.3, last edit: 13 Feb 1995 13:12:45
 *  @(#) Copyright (C) 1993, 1994 Tobias Bading (bading@cs.tu-berlin.de)
 *  @(#) Berlin University of Technology
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef OBUFFER_FILE_H
#define OBUFFER_FILE_H

// An audio output class for raw pcm output
// or if ULAW is defined:
// An audio output class for 8-bit ulaw output at 8 kHz:
class FileObuffer : public Obuffer
{
private:
#ifdef ULAW
  ulawsample	buffer[OBUFFERSIZE];
  ulawsample	*bufferp[MAXCHANNELS];
#else
  int16		buffer[OBUFFERSIZE];
  int16		*bufferp[MAXCHANNELS];
#endif
  uint32	channels;

public:
		FileObuffer (uint32 number_of_channels);
	       ~FileObuffer (void) {}
  void		append (uint32 channel, int16 value);
  void		write_buffer (int fd);
};

#endif
