#ifndef lint
static char *rcsid="@(#) $Id: dir.c,v 1.2 1997/11/13 21:06:30 rweber Exp $";
#endif /* not linted */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Written by Robert Weber
 * Email:  Robert.Weber@mch.sbs.de
 */


#include "defines.h"

extern int add_server(const char *buf);
static int scan_dir(char *, char sounds[MAX_SOUNDS][MAXPATHLEN]);
static int dotdot(char *);

extern char sounds[MAX_SOUNDS][MAXPATHLEN];
extern int nsounds;

int scan_config()
{
  FILE *fp;
 
  char cffile[MAXPATHLEN];
  char *home;
  char buf[BUFSIZ];
  int x;
  int nservers=0;
  char sounds[MAX_SOUNDS][MAXPATHLEN];
  int nsounds;
 
  if ( (home=getenv("HOME")) == NULL) {
    fprintf(stderr, "$HOME is not set.\n");
    return(1);
  }

  sprintf(cffile,"%s/%s", home, CFFILE);

  if ( (fp=fopen(cffile, "r")) == NULL) {
    perror(cffile);
    return(1);
  }
  
  while ( fgets(buf, sizeof(buf), fp)  ) {
    char *s=buf;
    
    buf[strlen(buf)-1]='\0';
    while( isspace(*s) && *s++!='\0')
      ;
    
    if( *s != '#' ) {
      if (  *s != '/' ) 
      	nservers=add_server(s);
      else 
	nsounds=scan_dir(s, sounds); 
    }	
    memset(&buf, 0, sizeof s);
  }
  
  if(nsounds == 0) {
    fprintf(stderr, "error: no sounds found\n");
    return(1);
  }

  if (nservers == 0) {
    fprintf(stderr,"error: no sound server defined.\n");
    return(1);
  }

  printf("sorting %d sounds... ", nsounds);
  qsort(&sounds, nsounds, sizeof(sounds[0]), (int (*)(const void *, const void *))strcmp);
  printf("done\nbuild list... ");
  
  for(x=0; x<nsounds; x++)
    xv_set(base->list, PANEL_LIST_STRING, x, sounds[x], NULL);

  printf("done\n");
 
  return(0);
}


static int scan_dir(char *path, char sounds[MAX_SOUNDS][MAXPATHLEN])
{
  DIR *dp;
  static int level=0;
  static int nsounds;
  struct dirent *dirp;
  struct stat stbuf;
  char fullname[MAXPATHLEN];

  if (nsounds == MAX_SOUNDS)
    return(nsounds);
  
  if ( (dp=opendir(path)) == NULL) {
    perror(path);
    return(nsounds);
  }
  
  if(level++ == 0)
    printf("reading: %s", path), fflush(stdout);
  
  while ( (dirp = readdir( dp )) != NULL ) {
    sprintf(fullname, "%s/%s", path, dirp->d_name);
    if ( stat(fullname, &stbuf ) == -1 ) {
      perror(fullname);
      return(nsounds);
    }
    else {
      
      if ( S_ISREG(stbuf.st_mode) ) {
	if(nsounds == MAX_SOUNDS) {
	  fprintf(stderr, "\nwarning: maximum number of sounds (%d) reached.\n", MAX_SOUNDS);
	  break;
	}
	else{
	  strcpy(sounds[nsounds++], fullname);
	}
      }
      if ( S_ISDIR(stbuf.st_mode) && !dotdot(fullname) &&
	   nsounds != MAX_SOUNDS && 
	   ( (nsounds=scan_dir(fullname, sounds)) == MAX_SOUNDS))
	       break;
    }
  }

  closedir(dp);

  if(nsounds == MAX_SOUNDS)
    return(MAX_SOUNDS);

  if(--level == 0)
    printf(" done\n");
  else
    putchar('.'), fflush(stdout);
  
  
  return(nsounds);
}

static int dotdot(char *path)
{
  char *p=path;
  char *last;
  
  while ( (p=strchr(p, '/')) != NULL){
    p++;
    last=p;
  }

  if(!strcmp(last, ".") || !strcmp(last, "..")){
    return 1;
  }
  return 0;  
}
