#ifndef lint
static char *rcsid="@(#) $Id: init_frame.c,v 1.6 1997/11/13 21:24:40 rweber Exp $";
#endif /* not linted */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Written by Robert Weber
 * Email:  Robert.Weber@mch.sbs.de
 */

#include "defines.h"

int add_server(const char *);
static int saved_vol[BUFSIZ];
static void base_done(Panel_item, Event *);
static void base_play(Panel_item, Event *);
static void base_stop(Panel_item, Event *);
static void base_pause(Panel_item, Event *);
static void base_resume(Panel_item, Event *);
static void base_random(Panel_item, Event *);
static void base_stopall(Panel_item, Event *);
static void change_server(Panel_item, Event *);

#ifdef HAVE_XVIEW_DBL_CLICK
static void base_list_selected(Panel_item, char *,  caddr_t, Panel_list_op, Event *, int);
#endif /* ! HAVE_XVIEW_DBL_CLICK */

void init_frame()
{  
  static unsigned short base_icon_bits[] = {
#include "icons/mmsp.icon"
  };

  base                   = (struct base *)malloc(sizeof(*base));
  base->button           = (struct button *)malloc(sizeof(*base->button));

  base->frame=(Frame)xv_create(XV_NULL,FRAME,
			       FRAME_LABEL, TITLE, 
                               FRAME_SHOW_FOOTER, TRUE,
                               FRAME_NO_CONFIRM, FALSE,
                               FRAME_DONE_PROC, base_done,			       
			       XV_SHOW, FALSE,
                               NULL);

  base->image=(Server_image)xv_create(XV_NULL,SERVER_IMAGE,
				      XV_WIDTH, 64,
				      XV_HEIGHT, 64 ,
				      SERVER_IMAGE_BITS, base_icon_bits,
				      NULL);

  base->icon=(Icon)xv_create(base->frame,ICON,
			     ICON_IMAGE, base->image,
			     NULL);

  xv_set(base->frame,FRAME_ICON,base->icon, NULL);

  base->panel=(Panel)xv_create(base->frame,PANEL, NULL);
				 
  base->button->done=xv_create(base->panel,PANEL_BUTTON,
                               PANEL_LABEL_STRING,      "Exit",
                               PANEL_NOTIFY_PROC,       base_done,
                               NULL);

  base->button->play=xv_create(base->panel,PANEL_BUTTON,
                               PANEL_LABEL_STRING,      "Play",
                               PANEL_NOTIFY_PROC,       base_play,
                               NULL);

  base->button->pause_resume=xv_create(base->panel,PANEL_BUTTON,
                               PANEL_LABEL_STRING,      "Pause ",
                               PANEL_NOTIFY_PROC,       base_pause,
                               NULL);
  
  base->button->stop=xv_create(base->panel,PANEL_BUTTON,
                               PANEL_LABEL_STRING,      "Stop",
			       PANEL_NOTIFY_PROC,       base_stop,
                               NULL);
  
  base->volume=xv_create(base->panel,PANEL_SLIDER,
			 PANEL_LABEL_STRING, "Volume: ",
			 PANEL_MIN_VALUE, 0,
			 PANEL_MAX_VALUE, 255,
			 PANEL_VALUE, 127,
			 PANEL_TICKS, 10,
			 NULL);
  base->button->random=xv_create(base->panel,PANEL_BUTTON,
                               PANEL_LABEL_STRING,      "Random!",
			       PANEL_NOTIFY_PROC,       base_random,
                               NULL);
  
  base->button->stopall=xv_create(base->panel,PANEL_BUTTON,
				  XV_X, 200,
				  XV_Y, 35,
                               PANEL_LABEL_STRING,      "Stop All Sounds",
                               PANEL_NOTIFY_PROC,       base_stopall,
                               NULL);
  
  base->choice=xv_create(base->panel, PANEL_CHOICE_STACK,
			 XV_X, 30,
			 XV_Y, 35,
			 PANEL_LABEL_STRING, "Server: ",
			 PANEL_NOTIFY_PROC, change_server,	   
			 NULL);


  base->list=(Panel_item)xv_create(base->panel,PANEL_LIST,
				   XV_X, 30,
				   XV_Y, 70,
				   PANEL_LAYOUT, PANEL_VERTICAL,
				   PANEL_LIST_DISPLAY_ROWS, 30,
#ifdef HAVE_XVIEW_DBL_CLICK
				   PANEL_LIST_DO_DBL_CLICK, TRUE,
				   PANEL_NOTIFY_PROC, base_list_selected,
#endif /* !HAVE_XVIEW_DBL_CLICK */
				   PANEL_CHOOSE_ONE, TRUE,
				   NULL);

  xv_set(base->frame, XV_SHOW, TRUE, NULL);

  window_fit(base->panel);
  window_fit(base->list);
  window_fit(base->frame);

}

/*ARGSUSED*/
static void base_done(Panel_item item, Event *event)
{
  xv_destroy_safe(base->frame);
}

/*ARGSUSED*/
static void base_play(Panel_item item, Event *event)
{
  int volume = (int)xv_get(base->volume, PANEL_VALUE);
  int nserver = (int)xv_get(base->choice, PANEL_VALUE);
  char *file = (char *)xv_get(base->list, PANEL_LIST_STRING,  (int)xv_get(base->list, PANEL_LIST_FIRST_SELECTED));
  char *server, buf[MAXPATHLEN];

  server=(char *)xv_get(base->choice, PANEL_CHOICE_STRING, nserver );
  sprintf(buf, "%s -h %s -v %d %s &", PATH_RPLAY, server, volume, file);
  system(buf);
}

/*ARGSUSED*/
static void base_stop(Panel_item item, Event *event)
{
	char syscall[BUFSIZ];
	char *server;
	int nserver = (int)xv_get(base->choice, PANEL_VALUE);

	server=(char *)xv_get(base->choice, PANEL_CHOICE_STRING, nserver );
	sprintf(syscall, "%s -h %s -s", PATH_RPLAY, server);
	system(syscall);
	base_resume(item, event);
}

/*ARGSUSED*/
static void base_pause(Panel_item item, Event *event)
{
	char syscall[BUFSIZ];
	char *server;
	int nserver = (int)xv_get(base->choice, PANEL_VALUE);

	server=(char *)xv_get(base->choice, PANEL_CHOICE_STRING, nserver );
	sprintf(syscall, "%s -h %s -p", PATH_RPLAY, server);
	system(syscall);
	xv_set(base->button->pause_resume, PANEL_LABEL_STRING,
	       "Resume", PANEL_NOTIFY_PROC, base_resume, NULL);
	
}

/*ARGSUSED*/
static void base_resume(Panel_item item, Event *event)
{
	char syscall[BUFSIZ];
	char *server;
	int nserver = (int)xv_get(base->choice, PANEL_VALUE);

	server=(char *)xv_get(base->choice, PANEL_CHOICE_STRING, nserver );
	sprintf(syscall, "%s -h %s -c", PATH_RPLAY, server);
	system(syscall);

	xv_set(base->button->pause_resume, PANEL_LABEL_STRING,
	       "Pause ", PANEL_NOTIFY_PROC, base_pause, NULL);
}


/*ARGSUSED*/
static void base_random(Panel_item item, Event *event)
{
  int sound;
  int volume = (int)xv_get(base->volume, PANEL_VALUE);
  int nserver = (int)xv_get(base->choice, PANEL_VALUE);
  char *file, *server, buf[MAXPATHLEN];

  server=(char *)xv_get(base->choice, PANEL_CHOICE_STRING, nserver );  
  sound=rand()%(int)xv_get(base->list, PANEL_LIST_NROWS);
  file=(char *)xv_get(base->list, PANEL_LIST_STRING,  sound);
  sprintf(buf, "%s -h %s -v %d %s &", PATH_RPLAY, server, volume, file);

  system(buf);
}


/*ARGSUSED*/
static void base_stopall(Panel_item item, Event *event)
{
  int x=0;
  char syscall[BUFSIZ], *server;
  
  while( (server=(char *)xv_get(base->choice, PANEL_CHOICE_STRING, x++ ))) {
    sprintf(syscall, "%s -h %s -s", PATH_RPLAY, server);
    system(syscall);
  }
}

int add_server(const char *buf)
{

  struct hostent *hp;
  static int count=0;

  if ( (hp=gethostbyname(buf)) == NULL) {
    fprintf(stderr,"%s: unknown host.\n", buf);
    return count;
  }
  saved_vol[count]=127; /* set default volume */
  xv_set(base->choice, PANEL_CHOICE_STRING, count++, hp->h_name, NULL);

  return count;
}

/*ARGSUSED1*/
static void change_server(Panel_item item, Event *event)
{
  int n=xv_get(item, PANEL_VALUE);
  int vol=xv_get(base->volume, PANEL_VALUE);
  static int prev=0;

  xv_set(base->volume, PANEL_VALUE, saved_vol[n], NULL);
  
  saved_vol[prev]=vol;
  prev=n;
}

#ifdef HAVE_XVIEW_DBL_CLICK
/*ARGSUSED*/
static void base_list_selected(Panel_item item, char *string,  caddr_t client_data, Panel_list_op op, Event *event, int row) {
  if(op == PANEL_LIST_OP_DBL_CLICK)
    base_play(item, event);
}
#endif /* ! HAVE_XVIEW_DBL_CLICK */

