#ifndef lint
static char *rcsid="@(#) $Id: main.c,v 1.5 1997/11/13 21:07:15 rweber Exp $";
#endif /* not linted */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Written by Robert Weber
 * Email:  Robert.Weber@mch.sbs.de
 */

#include "defines.h"

extern void init_frame(void);
extern int scan_config(void);
static int show_version(void);



int main(int argc, char *argv[])
{
  int ac;
  
  xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);

  for(ac=0; ac <argc; ac++){
    if( !strcmp(argv[ac], "-v") || !(strcmp(argv[ac], "--version")))
      return(show_version());
  }
  
  init_frame();

  if (scan_config())
    return(1);

  xv_main_loop(base->frame);

  return(0);
}

int show_version()
{
  printf("MMSP Version %s\nCopyright (C) 1997  Robert Weber\n\n", MMSP_VERSION);
  printf("This program is free software; you can redistribute it and/or\n\
modify it under the terms of the GNU General Public License\n\
as published by the Free Software Foundation; either version 2\n\
of the License, or (at your option) any later version.\n\n");
  printf("This program is distributed in the hope that it will be useful,\n\
but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
GNU General Public License for more details.\n\n");
  printf("You should have received a copy of the GNU General Public License\n\
along with this program; if not, write to the Free Software\n\
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n");

  return(0);
}
