/* eff_xbm.h
 * 
 * enthlt die Bitmaps aller Effekte 
 * 
 *                width, x-hot, y-hot ist gleich 
 *  Schriftart  : Helvetica-Roman-8pt 
 *  erstellt mit: Tgif 
 */

#ifndef eff_xbm_h
#define eff_xbm_h

#define xbm_width 16
#define xbm_x_hot 0
#define xbm_y_hot 0

/* Effects -Label */
char effekt_label[] = {
   0x00, 0x00, 0x00, 0x00, 0x40, 0x03, 0x40, 0x05, 0x80, 0x04, 0x40, 0x00, 
   0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 
   0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x50, 0x00, 0xe0, 0x07, 
   0x40, 0x00, 0x50, 0x00, 0xe0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x20, 0x04, 
   0xa0, 0x04, 0xa0, 0x04, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00};


/* Standardeffekte:
 *  0 Arpeggio
 *  1 Port. Up
 *  2 Port. Down
 *  3 Port. To Note
 *  4 Vibrato
 *  5 Port. + VolSld.
 *  6 Vibr. + VolSld.
 *  7 Tremolo
 *  8 Set Panning
 *  9 SampleOffset  
 * 10 Volumeslide 
 * 11 PatternJump  
 * 12 Set Volume
 * 13 PatternBreak
 * 14 enhanced
 * 15 Set Speed     
 */
	
static char s0[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 
   0x00, 0x00, 0xd0, 0x07, 0x00, 0x00, 0xc0, 0x07, 0x40, 0x0a, 0x40, 0x0a, 
   0x80, 0x01, 0x00, 0x00, 0xc0, 0x07, 0x40, 0x0a, 0x40, 0x0a, 0x80, 0x01, 
   0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0x80, 0x03, 
   0x40, 0x04, 0x40, 0x04, 0xc0, 0x0f, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 
   0x00, 0x00, 0x00, 0x06, 0x80, 0x01, 0x60, 0x01, 0x80, 0x01, 0x00, 0x06, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char s1[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0xc0, 0x0f, 
   0x00, 0x00, 0xe0, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xe0, 0x03, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x40, 0x00, 0xf0, 0x07, 
   0x40, 0x00, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x03, 
   0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 
   0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00};
static char s2[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 
   0x00, 0x00, 0xc0, 0x01, 0x00, 0x06, 0xc0, 0x01, 0x00, 0x06, 0xc0, 0x01, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 
   0xc0, 0x03, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0xe0, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 
   0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 
   0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 0x20, 0x01, 
   0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char s3[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x40, 0x00, 
   0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 
   0x80, 0x03, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x02, 0x80, 0x01, 0x40, 0x00, 
   0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 
   0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0x20, 0x00, 0xe0, 0x07, 0x20, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x40, 0x00, 0xf0, 0x07, 
   0x40, 0x00, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x03, 
   0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 
   0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00};
static char s4[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 
   0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x00, 0x04, 0x80, 0x03, 0x40, 0x05, 
   0x40, 0x07, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x03, 
   0x40, 0x04, 0x40, 0x04, 0xf0, 0x07, 0x00, 0x00, 0xd0, 0x07, 0x00, 0x00, 
   0xe0, 0x01, 0x00, 0x02, 0x00, 0x04, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char s5[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0xf0, 0x07, 0x40, 0x04, 
   0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x20, 0x03, 
   0xa0, 0x04, 0xa0, 0x04, 0xc0, 0x04, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 
   0xe0, 0x01, 0x00, 0x02, 0x00, 0x04, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0xc0, 0x07, 0x00, 0x01, 0x00, 0x01, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x40, 0x00, 0xf0, 0x07, 
   0x40, 0x00, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x03, 
   0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 
   0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00};
static char s6[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0xf0, 0x07, 0x40, 0x04, 
   0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x20, 0x03, 
   0xa0, 0x04, 0xa0, 0x04, 0xc0, 0x04, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 
   0xe0, 0x01, 0x00, 0x02, 0x00, 0x04, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0xc0, 0x07, 0x00, 0x01, 0x00, 0x01, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x40, 0x00, 0x80, 0x00, 
   0xc0, 0x07, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0xf0, 0x07, 
   0x00, 0x00, 0xd0, 0x07, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x02, 0x00, 0x04, 
   0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char s7[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 
   0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 
   0x80, 0x03, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0xc0, 0x07, 0x40, 0x00, 
   0xc0, 0x07, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0x20, 0x00, 0xe0, 0x07, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00};
static char s8[] = {
   0x00, 0x00, 0x00, 0x00, 0xc0, 0x07, 0x40, 0x0a, 0x40, 0x0a, 0x80, 0x01, 
   0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 
   0xd0, 0x07, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 
   0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x04, 
   0x80, 0x03, 0x40, 0x05, 0x40, 0x07, 0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 
   0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 
   0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 
   0x00, 0x00, 0x20, 0x03, 0xa0, 0x04, 0xa0, 0x04, 0xc0, 0x04, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char s9[] = {
   0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x80, 0x05, 
   0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0x40, 0x03, 0x40, 0x05, 0x80, 0x04, 
   0x50, 0x00, 0xe0, 0x07, 0x40, 0x00, 0x50, 0x00, 0xe0, 0x07, 0x40, 0x00, 
   0x00, 0x00, 0xc0, 0x03, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0xc0, 0x03, 
   0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0xf0, 0x07, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0xc0, 0x0f, 0x00, 0x00, 
   0x80, 0x07, 0x40, 0x00, 0xc0, 0x07, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x04, 
   0x80, 0x03, 0x40, 0x05, 0x40, 0x07, 0x00, 0x00, 0x20, 0x03, 0xa0, 0x04, 
   0xa0, 0x04, 0xc0, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00};
static char s10[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0xf0, 0x07, 0x40, 0x04, 
   0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0xd0, 0x07, 0x00, 0x00, 0xf0, 0x07, 
   0x00, 0x00, 0x20, 0x03, 0xa0, 0x04, 0xa0, 0x04, 0xc0, 0x04, 0x00, 0x00, 
   0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0x80, 0x07, 
   0x40, 0x00, 0xc0, 0x07, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xc0, 0x07, 
   0x00, 0x04, 0xc0, 0x03, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x80, 0x03, 
   0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x02, 
   0x00, 0x04, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00};
static char s11[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0xc0, 0x0f, 
   0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0xc0, 0x07, 0x40, 0x00, 0xc0, 0x07, 
   0x00, 0x00, 0xc0, 0x07, 0x00, 0x04, 0xc0, 0x03, 0x00, 0x00, 0xe0, 0x03, 
   0x00, 0x04, 0x00, 0x02, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 
   0xc0, 0x07, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x05, 
   0x40, 0x05, 0x80, 0x03, 0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x40, 0x00, 
   0xf0, 0x07, 0x40, 0x00, 0x00, 0x04, 0x80, 0x03, 0x40, 0x05, 0x40, 0x07, 
   0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char s12[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0x80, 0x07, 0x40, 0x00, 0xc0, 0x07, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 
   0xc0, 0x07, 0x00, 0x04, 0xc0, 0x03, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
   0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0xe0, 0x01, 
   0x00, 0x02, 0x00, 0x04, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 
   0x80, 0x03, 0x00, 0x00, 0x20, 0x03, 0xa0, 0x04, 0xa0, 0x04, 0xc0, 0x04, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char s13[] = {
   0x00, 0x00, 0x00, 0x00, 0x40, 0x06, 0x80, 0x01, 0xf0, 0x07, 0x00, 0x04, 
   0x80, 0x03, 0x40, 0x05, 0x40, 0x07, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 
   0x80, 0x03, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x40, 0x03, 
   0xa0, 0x04, 0xa0, 0x04, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x80, 0x07, 
   0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 
   0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x40, 0x00, 0xf0, 0x07, 
   0x40, 0x00, 0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x00, 0x04, 0x80, 0x03, 
   0x40, 0x05, 0x40, 0x07, 0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 0x20, 0x01, 
   0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char s14[] = {
   0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 
   0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0x40, 0x04, 
   0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 
   0xc0, 0x07, 0x00, 0x04, 0x80, 0x03, 0x40, 0x05, 0x40, 0x07, 0x00, 0x00, 
   0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x80, 0x07, 
   0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 
   0x80, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char s15[] = {
   0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 
   0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0x80, 0x05, 
   0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 
   0xc0, 0x0f, 0x00, 0x00, 0x20, 0x03, 0xa0, 0x04, 0xa0, 0x04, 0xc0, 0x04, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 
   0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0x20, 0x03, 
   0xa0, 0x04, 0xa0, 0x04, 0xc0, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00};




/* ProTracker-Effekte
 *  0 SetFilter
 *  1 Fine Prt. Up
 *  2 Fine Prt. Down
 *  3 Glissando
 *  4 Vibra-Wave
 *  5 SetFineTune 
 *  6 PatternLoop
 *  7 Trem-Wave
 *  8 Set Panning
 *  9 Retrig. Note
 * 10 Fine Vol. Up
 * 11 Fine Vol. Down
 * 12 Cut Note
 * 13 Note Delay
 * 14 Pattern Delay
 * 15 Invert Loop
 */

static char p0[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x05, 
   0x40, 0x05, 0x80, 0x03, 0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 
   0xf0, 0x07, 0x00, 0x00, 0xd0, 0x07, 0x20, 0x00, 0xa0, 0x00, 0xa0, 0x00, 
   0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0xf0, 0x07, 
   0x40, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0x20, 0x03, 0xa0, 0x04, 0xa0, 0x04, 0xc0, 0x04, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char p1[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0xc0, 0x0f, 
   0x00, 0x00, 0xe0, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xe0, 0x03, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x40, 0x00, 0xf0, 0x07, 
   0x40, 0x00, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xc0, 0x00, 
   0x20, 0x01, 0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0x80, 0x07, 
   0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xd0, 0x07, 0x20, 0x00, 
   0xa0, 0x00, 0xa0, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00};
static char p2[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 
   0x00, 0x00, 0xc0, 0x01, 0x00, 0x06, 0xc0, 0x01, 0x00, 0x06, 0xc0, 0x01, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 
   0xc0, 0x03, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0xe0, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 
   0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 
   0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 
   0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xd0, 0x07, 0x20, 0x00, 0xa0, 0x00, 
   0xa0, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00};
static char p3[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 
   0x00, 0x00, 0xf0, 0x07, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 
   0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x04, 0x80, 0x03, 
   0x40, 0x05, 0x40, 0x07, 0x00, 0x00, 0x40, 0x03, 0x40, 0x05, 0x80, 0x04, 
   0x00, 0x00, 0x40, 0x03, 0x40, 0x05, 0x80, 0x04, 0x00, 0x00, 0xd0, 0x07, 
   0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x80, 0x03, 0xa0, 0x04, 0x20, 0x04, 
   0x20, 0x04, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char p4[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0xc0, 0x01, 0x00, 0x02, 0x00, 0x04, 0xc0, 0x03, 0x00, 0x04, 0x80, 0x03, 
   0x40, 0x05, 0x40, 0x07, 0xe0, 0x00, 0x00, 0x01, 0x00, 0x07, 0xe0, 0x00, 
   0x00, 0x01, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 
   0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x80, 0x03, 0x40, 0x05, 
   0x40, 0x07, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x03, 
   0x40, 0x04, 0x40, 0x04, 0xf0, 0x07, 0x00, 0x00, 0xd0, 0x07, 0x00, 0x00, 
   0xe0, 0x01, 0x00, 0x02, 0x00, 0x04, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char p5[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xc0, 0x07, 
   0x00, 0x04, 0xc0, 0x03, 0x00, 0x00, 0x20, 0x00, 0xe0, 0x07, 0x20, 0x00, 
   0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0x80, 0x07, 
   0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xd0, 0x07, 0x20, 0x00, 
   0xa0, 0x00, 0xa0, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x40, 0x00, 0xf0, 0x07, 
   0x40, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0x20, 0x03, 0xa0, 0x04, 0xa0, 0x04, 0xc0, 0x04, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char p6[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0xc0, 0x0f, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 
   0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0x00, 0x04, 
   0x00, 0x04, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 
   0x40, 0x00, 0xc0, 0x07, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 
   0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 
   0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x00, 0x04, 0x80, 0x03, 0x40, 0x05, 
   0x40, 0x07, 0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 0x20, 0x01, 0xe0, 0x07, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char p7[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0xc0, 0x01, 0x00, 0x02, 0x00, 0x04, 0xc0, 0x03, 0x00, 0x04, 0x80, 0x03, 
   0x40, 0x05, 0x40, 0x07, 0xe0, 0x00, 0x00, 0x01, 0x00, 0x07, 0xe0, 0x00, 
   0x00, 0x01, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 
   0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 
   0xc0, 0x07, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 
   0x80, 0x03, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x20, 0x00, 
   0xe0, 0x07, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char p8[] = {
   0x00, 0x00, 0x00, 0x00, 0xc0, 0x07, 0x40, 0x0a, 0x40, 0x0a, 0x80, 0x01, 
   0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 
   0xd0, 0x07, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 
   0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x04, 
   0x80, 0x03, 0x40, 0x05, 0x40, 0x07, 0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 
   0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 
   0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 
   0x00, 0x00, 0x20, 0x03, 0xa0, 0x04, 0xa0, 0x04, 0xc0, 0x04, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char p9[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x40, 0x00, 
   0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 
   0x80, 0x03, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x02, 0x80, 0x01, 0x40, 0x00, 
   0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 
   0xc0, 0x07, 0x40, 0x0a, 0x40, 0x0a, 0x80, 0x01, 0x00, 0x00, 0xd0, 0x07, 
   0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 
   0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0xc0, 0x06, 
   0x20, 0x01, 0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00};
static char p10[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0xc0, 0x0f, 
   0x00, 0x00, 0xe0, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xe0, 0x03, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0xf0, 0x07, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 
   0xe0, 0x01, 0x00, 0x02, 0x00, 0x04, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xd0, 0x07, 
   0x20, 0x00, 0xa0, 0x00, 0xa0, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char p11[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 
   0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xc0, 0x03, 0x20, 0x04, 0x20, 0x04, 
   0x20, 0x04, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 
   0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 
   0x80, 0x03, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x02, 0x00, 0x04, 0xe0, 0x03, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 
   0x80, 0x03, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 
   0x00, 0x00, 0xd0, 0x07, 0x20, 0x00, 0xa0, 0x00, 0xa0, 0x00, 0xe0, 0x07, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char p12[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x40, 0x00, 
   0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 
   0x80, 0x03, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x02, 0x80, 0x01, 0x40, 0x00, 
   0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 
   0x00, 0x00, 0xc0, 0x07, 0x00, 0x04, 0xc0, 0x03, 0x00, 0x00, 0x40, 0x02, 
   0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00};
static char p13[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x06, 0xc0, 0x09, 0x00, 0x04, 
   0x80, 0x03, 0x40, 0x05, 0x40, 0x07, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
   0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0xc0, 0x03, 0x20, 0x04, 
   0x20, 0x04, 0x20, 0x04, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 
   0xe0, 0x07, 0x00, 0x02, 0x80, 0x01, 0x40, 0x00, 0xe0, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char p14[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x06, 0xc0, 0x09, 0x00, 0x04, 
   0x80, 0x03, 0x40, 0x05, 0x40, 0x07, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
   0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0xc0, 0x03, 0x20, 0x04, 
   0x20, 0x04, 0x20, 0x04, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x40, 0x00, 0x80, 0x00, 
   0xc0, 0x07, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x40, 0x00, 
   0xf0, 0x07, 0x40, 0x00, 0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x00, 0x04, 
   0x80, 0x03, 0x40, 0x05, 0x40, 0x07, 0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 
   0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00};
static char p15[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0xc0, 0x0f, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 
   0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0x00, 0x04, 
   0x00, 0x04, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 
   0xf0, 0x07, 0x40, 0x00, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 
   0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x02, 
   0x00, 0x04, 0xc0, 0x03, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 
   0xc0, 0x07, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00};



/* Extra-Effekte (Oktalyzer/Farandole)
 *  0 Arepeggio1 -> Oktalyzer
 *  1 Arepeggio2
 *  2 Tone Up
 *  3 Tone Down
 *  4 Tone Higher
 *  5 Tone Lower
 *  6 Old Volume
 *  7 FAR Spezial -> Farandole
 *  8 FinePitchUp
 *  9 FinePitchDn.
 * 10 Note Portam.
 * 11 Retrigger
 * 12 VibratoDepth
 * 13 VibratoNote
 * 14 Vol. Slide Up
 * 15 Vol. Slide Dn.
 */

static char x_0[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x07, 0x40, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 
   0xd0, 0x07, 0x00, 0x00, 0xc0, 0x07, 0x40, 0x0a, 0x40, 0x0a, 0x80, 0x01, 
   0x00, 0x00, 0xc0, 0x07, 0x40, 0x0a, 0x40, 0x0a, 0x80, 0x01, 0x00, 0x00, 
   0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 
   0x40, 0x04, 0xc0, 0x0f, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 
   0x00, 0x06, 0x80, 0x01, 0x60, 0x01, 0x80, 0x01, 0x00, 0x06, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x_1[] = {
   0x00, 0x00, 0x00, 0x00, 0xc0, 0x04, 0x20, 0x05, 0x20, 0x06, 0x40, 0x04, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 
   0xd0, 0x07, 0x00, 0x00, 0xc0, 0x07, 0x40, 0x0a, 0x40, 0x0a, 0x80, 0x01, 
   0x00, 0x00, 0xc0, 0x07, 0x40, 0x0a, 0x40, 0x0a, 0x80, 0x01, 0x00, 0x00, 
   0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 
   0x40, 0x04, 0xc0, 0x0f, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 
   0x00, 0x06, 0x80, 0x01, 0x60, 0x01, 0x80, 0x01, 0x00, 0x06, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x_2[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0xc0, 0x0f, 
   0x00, 0x00, 0xe0, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xe0, 0x03, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 
   0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 
   0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0x20, 0x00, 
   0xe0, 0x07, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x_3[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 
   0x00, 0x00, 0xc0, 0x01, 0x00, 0x06, 0xc0, 0x01, 0x00, 0x06, 0xc0, 0x01, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 
   0xc0, 0x03, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0xe0, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x03, 
   0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0x20, 0x00, 0xe0, 0x07, 
   0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x_4[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x05, 
   0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 
   0xf0, 0x07, 0x00, 0x00, 0xc0, 0x07, 0x40, 0x0a, 0x40, 0x0a, 0x80, 0x01, 
   0x00, 0x00, 0xd0, 0x07, 0x00, 0x00, 0xe0, 0x07, 0x80, 0x00, 0x80, 0x00, 
   0x80, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 
   0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 
   0xc0, 0x07, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 
   0x00, 0x00, 0x20, 0x00, 0xe0, 0x07, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00};
static char x_5[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x05, 
   0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x06, 0xc0, 0x01, 
   0x00, 0x06, 0xc0, 0x01, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 
   0x80, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0xe0, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 
   0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 
   0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0x20, 0x00, 
   0xe0, 0x07, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x_6[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0x80, 0x07, 0x40, 0x00, 0xc0, 0x07, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 
   0xc0, 0x07, 0x00, 0x04, 0xc0, 0x03, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
   0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0xe0, 0x01, 
   0x00, 0x02, 0x00, 0x04, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0xf0, 0x07, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 
   0xf0, 0x07, 0x00, 0x00, 0xc0, 0x03, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 
   0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x_7[] = {
   0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x04, 0x80, 0x03, 0x40, 0x05, 
   0x40, 0x07, 0x00, 0x00, 0xd0, 0x07, 0x00, 0x00, 0xc0, 0x04, 0x40, 0x05, 
   0x40, 0x06, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0xc0, 0x0f, 0x00, 0x00, 0x20, 0x03, 
   0xa0, 0x04, 0xa0, 0x04, 0xc0, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0xc0, 0x06, 0x20, 0x01, 0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x06, 0x80, 0x01, 0x60, 0x01, 0x80, 0x01, 0x00, 0x06, 
   0x20, 0x00, 0xa0, 0x00, 0xa0, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x_8[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0xc0, 0x0f, 
   0x00, 0x00, 0xe0, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xe0, 0x03, 
   0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xf0, 0x07, 0x00, 0x00, 
   0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 
   0x00, 0x00, 0xd0, 0x07, 0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 0x20, 0x01, 
   0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 
   0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 
   0xd0, 0x07, 0x20, 0x00, 0xa0, 0x00, 0xa0, 0x00, 0xe0, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x_9[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 
   0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xc0, 0x03, 0x20, 0x04, 0x20, 0x04, 
   0x20, 0x04, 0xe0, 0x07, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 
   0xf0, 0x07, 0x00, 0x00, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x40, 0x00, 
   0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 0xd0, 0x07, 0x00, 0x00, 0xc0, 0x00, 
   0x20, 0x01, 0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 
   0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 
   0xc0, 0x07, 0x00, 0x00, 0xd0, 0x07, 0x20, 0x00, 0xa0, 0x00, 0xa0, 0x00, 
   0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x_10[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 
   0xc0, 0x07, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x04, 0x80, 0x03, 0x40, 0x05, 
   0x40, 0x07, 0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x40, 0x00, 0x80, 0x00, 
   0xc0, 0x07, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 
   0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 
   0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 
   0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x02, 0x80, 0x01, 
   0x40, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x_11[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x05, 
   0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0xc0, 0x07, 0x40, 0x0a, 0x40, 0x0a, 
   0x80, 0x01, 0x00, 0x00, 0xc0, 0x07, 0x40, 0x0a, 0x40, 0x0a, 0x80, 0x01, 
   0x00, 0x00, 0xd0, 0x07, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x40, 0x00, 
   0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 
   0x00, 0x00, 0xc0, 0x06, 0x20, 0x01, 0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x_12[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xf0, 0x07, 
   0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 
   0x40, 0x04, 0xc0, 0x0f, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 
   0x00, 0x00, 0xc0, 0x03, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0xe0, 0x07, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x40, 0x00, 
   0xf0, 0x07, 0x40, 0x00, 0x00, 0x04, 0x80, 0x03, 0x40, 0x05, 0x40, 0x07, 
   0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 
   0x40, 0x04, 0xf0, 0x07, 0x00, 0x00, 0xd0, 0x07, 0x00, 0x00, 0xe0, 0x01, 
   0x00, 0x02, 0x00, 0x04, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00};
static char x_13[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x40, 0x00, 
   0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 
   0x80, 0x03, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x02, 0x80, 0x01, 0x40, 0x00, 
   0xe0, 0x07, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 
   0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x00, 0x04, 0x80, 0x03, 0x40, 0x05, 
   0x40, 0x07, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x03, 
   0x40, 0x04, 0x40, 0x04, 0xf0, 0x07, 0x00, 0x00, 0xd0, 0x07, 0x00, 0x00, 
   0xe0, 0x01, 0x00, 0x02, 0x00, 0x04, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x_14[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0xc0, 0x0f, 
   0x00, 0x00, 0xe0, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xe0, 0x03, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 
   0x00, 0x00, 0xf0, 0x07, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 
   0xd0, 0x07, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x20, 0x03, 0xa0, 0x04, 
   0xa0, 0x04, 0xc0, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x04, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 
   0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x02, 0x00, 0x04, 
   0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x_15[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 
   0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xc0, 0x03, 0x20, 0x04, 0x20, 0x04, 
   0x20, 0x04, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 
   0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0xf0, 0x07, 0x40, 0x04, 0x40, 0x04, 
   0x80, 0x03, 0x00, 0x00, 0xd0, 0x07, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
   0x20, 0x03, 0xa0, 0x04, 0xa0, 0x04, 0xc0, 0x04, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 
   0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0xe0, 0x01, 
   0x00, 0x02, 0x00, 0x04, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00};


/* Extra1-Effekte 
 *  0 Vibrato Sust.  -> Farandole (far)
 *  1 Vol. Portam.
 *  2 FineTempDn.
 *  3 FineTempUp
 *  4 Tremor         -> ScreamTracker (stm)
 *  5 Xfin Prt. Up
 *  6 Xfin Prt. Dn.
 *  7 Retrig. + VolSld.
 *  8 StereoControl
 *  9 SetGlobalVol
 * 10 Set BPM-Spd.
 * 11 FinePanLeft    -> 669/UNIS
 * 12 FinePanRight
 * 13 SlotRetrigger
 */
		 
static char x1_0[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 
   0x00, 0x00, 0x40, 0x03, 0x40, 0x05, 0x80, 0x04, 0x00, 0x00, 0xc0, 0x07, 
   0x00, 0x04, 0xc0, 0x03, 0x00, 0x00, 0x20, 0x03, 0xa0, 0x04, 0xa0, 0x04, 
   0xc0, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 
   0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 
   0x00, 0x04, 0x80, 0x03, 0x40, 0x05, 0x40, 0x07, 0x40, 0x00, 0x80, 0x00, 
   0xc0, 0x07, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0xf0, 0x07, 
   0x00, 0x00, 0xd0, 0x07, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x02, 0x00, 0x04, 
   0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x1_1[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 
   0xc0, 0x07, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x04, 0x80, 0x03, 0x40, 0x05, 
   0x40, 0x07, 0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x40, 0x00, 0x80, 0x00, 
   0xc0, 0x07, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 
   0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0xf0, 0x07, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 
   0xe0, 0x01, 0x00, 0x02, 0x00, 0x04, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x1_2[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 
   0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xc0, 0x03, 0x20, 0x04, 0x20, 0x04, 
   0x20, 0x04, 0xe0, 0x07, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 
   0xc0, 0x0f, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0xc0, 0x07, 0x40, 0x00, 
   0xc0, 0x07, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0x20, 0x00, 0xe0, 0x07, 0x20, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 
   0x80, 0x03, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 
   0x00, 0x00, 0xd0, 0x07, 0x20, 0x00, 0xa0, 0x00, 0xa0, 0x00, 0xe0, 0x07, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x1_3[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0xc0, 0x0f, 
   0x00, 0x00, 0xe0, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xe0, 0x03, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0xc0, 0x0f, 0x00, 0x00, 
   0x80, 0x07, 0x40, 0x00, 0xc0, 0x07, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 
   0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0x20, 0x00, 0xe0, 0x07, 
   0x20, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xd0, 0x07, 
   0x20, 0x00, 0xa0, 0x00, 0xa0, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x1_4[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x03, 
   0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 
   0xc0, 0x07, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 
   0x80, 0x03, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x20, 0x00, 
   0xe0, 0x07, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x1_5[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0xc0, 0x0f, 
   0x00, 0x00, 0xe0, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xe0, 0x03, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x40, 0x00, 0xf0, 0x07, 
   0x40, 0x00, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xc0, 0x00, 
   0x20, 0x01, 0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 
   0xd0, 0x07, 0x50, 0x00, 0xe0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x60, 0x06, 
   0x80, 0x01, 0x80, 0x01, 0x60, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00};
static char x1_6[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 
   0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xc0, 0x03, 0x20, 0x04, 0x20, 0x04, 
   0x20, 0x04, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 
   0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 
   0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 
   0xc0, 0x07, 0x00, 0x00, 0xd0, 0x07, 0x50, 0x00, 0xe0, 0x07, 0x40, 0x00, 
   0x00, 0x00, 0x60, 0x06, 0x80, 0x01, 0x80, 0x01, 0x60, 0x06, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x1_7[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0xf0, 0x07, 0x40, 0x04, 
   0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x20, 0x03, 
   0xa0, 0x04, 0xa0, 0x04, 0xc0, 0x04, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 
   0xe0, 0x01, 0x00, 0x02, 0x00, 0x04, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x01, 
   0x00, 0x01, 0xc0, 0x07, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 
   0x00, 0x00, 0xc0, 0x07, 0x40, 0x0a, 0x40, 0x0a, 0x80, 0x01, 0x00, 0x00, 
   0xd0, 0x07, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x40, 0x00, 0xf0, 0x07, 
   0x40, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0xc0, 0x06, 0x20, 0x01, 0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x1_8[] = {
   0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 
   0x40, 0x04, 0x80, 0x03, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x40, 0x00, 
   0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 
   0xc0, 0x07, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 
   0x00, 0x00, 0x40, 0x02, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0xc0, 0x03, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 
   0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 
   0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x40, 0x00, 0xf0, 0x07, 
   0x40, 0x00, 0x00, 0x00, 0x20, 0x03, 0xa0, 0x04, 0xa0, 0x04, 0xc0, 0x04, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x1_9[] = {
   0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 
   0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x02, 0x00, 0x04, 
   0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x04, 0x80, 0x03, 
   0x40, 0x05, 0x40, 0x07, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 
   0xf0, 0x07, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 
   0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x80, 0x03, 0xa0, 0x04, 0x20, 0x04, 
   0x20, 0x04, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0xf0, 0x07, 
   0x40, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0x20, 0x03, 0xa0, 0x04, 0xa0, 0x04, 0xc0, 0x04, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x1_10[] = {
   0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x40, 0x04, 0x40, 0x04, 0x80, 0x03, 
   0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 0x40, 0x04, 0xc0, 0x0f, 0x00, 0x00, 
   0x20, 0x03, 0xa0, 0x04, 0xa0, 0x04, 0xc0, 0x04, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 
   0xe0, 0x07, 0x40, 0x00, 0x80, 0x07, 0x40, 0x00, 0xe0, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0x40, 0x03, 0xa0, 0x04, 0xa0, 0x04, 0xe0, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 
   0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0x20, 0x03, 0xa0, 0x04, 
   0xa0, 0x04, 0xc0, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00};
static char x1_11[] = {
   0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x50, 0x00, 0xe0, 0x07, 
   0x40, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0x00, 0x04, 0x00, 0x04, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x80, 0x07, 
   0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x04, 0x80, 0x03, 0x40, 0x05, 
   0x40, 0x07, 0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 0x20, 0x01, 0xe0, 0x07, 
   0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xd0, 0x07, 
   0x20, 0x00, 0xa0, 0x00, 0xa0, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x1_12[] = {
   0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x80, 0x07, 
   0x40, 0x00, 0x40, 0x00, 0xf0, 0x07, 0x00, 0x00, 0xc0, 0x07, 0x40, 0x0a, 
   0x40, 0x0a, 0x80, 0x01, 0x00, 0x00, 0xd0, 0x07, 0x00, 0x00, 0xc0, 0x06, 
   0x20, 0x01, 0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x80, 0x07, 
   0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x04, 0x80, 0x03, 0x40, 0x05, 
   0x40, 0x07, 0x00, 0x00, 0xc0, 0x00, 0x20, 0x01, 0x20, 0x01, 0xe0, 0x07, 
   0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 
   0x80, 0x07, 0x40, 0x00, 0x40, 0x00, 0xc0, 0x07, 0x00, 0x00, 0xd0, 0x07, 
   0x20, 0x00, 0xa0, 0x00, 0xa0, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char x1_13[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x80, 0x05, 
   0x40, 0x05, 0x80, 0x03, 0x00, 0x00, 0xc0, 0x07, 0x40, 0x0a, 0x40, 0x0a, 
   0x80, 0x01, 0x00, 0x00, 0xc0, 0x07, 0x40, 0x0a, 0x40, 0x0a, 0x80, 0x01, 
   0x00, 0x00, 0xd0, 0x07, 0x40, 0x00, 0x80, 0x00, 0xc0, 0x07, 0x40, 0x00, 
   0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x80, 0x05, 0x40, 0x05, 0x80, 0x03, 
   0x00, 0x00, 0xc0, 0x06, 0x20, 0x01, 0x20, 0x01, 0xe0, 0x07, 0x00, 0x00, 
   0x40, 0x00, 0xf0, 0x07, 0x40, 0x00, 0x00, 0x00, 0x80, 0x03, 0x40, 0x04, 
   0x40, 0x04, 0x80, 0x03, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x20, 0x03, 
   0xa0, 0x04, 0xa0, 0x04, 0xc0, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00};
static char x1_14[] = { 0x00 };
static char x1_15[] = { 0x00 };



static char* eff_bitmap[4][16] = {
     { &s0[0]  , &s1[0]  , &s2[0]  , &s3[0]  , &s4[0]  , &s5[0]  , &s6[0]  , &s7[0], 
       &s8[0]  , &s9[0]  , &s10[0] , &s11[0] , &s12[0] , &s13[0] , &s14[0] , &s15[0] },
     { &p0[0]  , &p1[0]  , &p2[0]  , &p3[0]  , &p4[0]  , &p5[0]  , &p6[0]  , &p7[0], 
       &p8[0]  , &p9[0]  , &p10[0] , &p11[0] , &p12[0] , &p13[0] , &p14[0] , &p15[0] },
     { &x_0[0] , &x_1[0] , &x_2[0] , &x_3[0] , &x_4[0] , &x_5[0] , &x_6[0] , &x_7[0], 
       &x_8[0] , &x_9[0] , &x_10[0], &x_11[0], &x_12[0], &x_13[0], &x_14[0], &x_15[0] },
     { &x1_0[0], &x1_1[0], &x1_2[0], &x1_3[0], &x1_4[0], &x1_5[0], &x1_6[0], &x1_7[0],
       &x1_8[0], &x1_9[0], &x1_10[0],&x1_11[0],&x1_12[0],&x1_13[0],&x1_14[0],&x1_15[0]} };     

static int eff_bitmap_height[4][16] = {
     { 40, 37, 48, 55, 33, 61, 60, 31, 52, 55, 49, 52, 47, 54, 41, 44 },
     { 39, 50, 61, 42, 51, 51, 53, 48, 52, 50, 51, 53, 38, 45, 55, 49 },
     { 45, 45, 36, 47, 50, 48, 47, 51, 52, 54, 54, 40, 56, 51, 54, 56 },
     { 54, 51, 53, 51, 30, 50, 52, 63, 59, 57, 61, 51, 57, 56 , 1,  1 } };

#endif

