#include "forms.h"
#include <stdlib.h>
#include "effects.h"
#include "eff_xbm.h"


/* Levelmeter links und rechts */

FL_OBJECT *fl_create_meter_l(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label)
{
  FL_OBJECT *ob;
  ob=fl_make_object(FL_METER,type,x,y,w,h,label,handle_meter_l);
  ((SPEC*)ob->spec) 	   = fl_calloc(1, sizeof(SPEC));
  ((SPEC*)ob->spec)->value = MAXVAL;
  ((SPEC*)ob->spec)->x0    = x;
  return ob;
}


FL_OBJECT *fl_add_meter_l(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label)
{
  FL_OBJECT *ob=fl_create_meter_l(type,x,y,w,h,label);
  fl_add_object(fl_current_form,ob);
  return ob;
}

FL_OBJECT *fl_add_meter_r(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label)
{
  FL_OBJECT *ob=fl_create_meter_r(type,x,y,w,h,label);
  fl_add_object(fl_current_form,ob);
  return ob;
}

FL_OBJECT *fl_create_meter_r(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label)
{
  FL_OBJECT *ob;
  ob=fl_make_object(FL_METER,type,x,y,w,h,label,handle_meter_r);
  ((SPEC*)ob->spec) 	   = fl_calloc(1, sizeof(SPEC));
  ((SPEC*)ob->spec)->value = MAXVAL;
  ((SPEC*)ob->spec)->x0    = x;
  return ob;
}

void fl_set_meter_r(FL_OBJECT *ob,int val)
{
  val=abs(val);
  if (!ob || ob->objclass != FL_METER)
  {
    fprintf(stderr,"set_meter: Bad argument or wrong objtype");
    return;
  }
  if ( ((SPEC*)ob->spec)->value !=val)
  {
    ((SPEC*)ob->spec)->value=(val>MAXVAL) ? MAXVAL : val;
     fl_redraw_object(ob);
  }
}

void fl_set_meter_l(FL_OBJECT *ob,int val)
{
  val=abs(val);
  if (!ob || ob->objclass != FL_METER)
  {
    fprintf(stderr,"set_meter: Bad argument or wrong objtype");
    return;
  }
  if ( ((SPEC*)ob->spec)->value !=val)
  {
    ((SPEC*)ob->spec)->value=(val>MAXVAL) ? MAXVAL : val;
     fl_redraw_object(ob);
  }
}

static int 
handle_meter_r(FL_OBJECT *ob,int event,FL_Coord mx,FL_Coord my,int key,
	      void *xev)
{
  int n;
  int hel=LED_W;
  int val=MAXVAL-((SPEC*)ob->spec)->value;
  int offset=((SPEC*)ob->spec)->x0;
  
  switch( event)
  {
  case FL_DRAW:
    for (n=1;n<=((val*ELEMENTS)/MAXVAL);n++)
           fl_rectf((hel+GAP)*(ELEMENTS-n)+offset,ob->y,hel,ob->h,FL_INACTIVE_COL);
    for (n;n<=ELEMENTS;n++)
    {
       if( (n<=ELEMENTS) && (n>YELLOW_ON) )
            fl_rectf((hel+GAP)*(ELEMENTS-n)+offset,ob->y,hel,ob->h,FL_GREEN);
       else
           if(n<=RED_ON) 
              fl_rectf((hel+GAP)*(ELEMENTS-n)+offset,ob->y,hel,ob->h,FL_RED);
           else
              fl_rectf((hel+GAP)*(ELEMENTS-n)+offset,ob->y,hel,ob->h,FL_YELLOW);
    }
  break;   
  case FL_FREEMEM:
    fl_free(((SPEC *)ob->spec));
  break;    
  }
  return 0;
}

static int 
handle_meter_l(FL_OBJECT *ob,int event,FL_Coord mx,FL_Coord my,int key,
	      void *xev)
{
  int n;
  int hel=LED_W;
  int val=MAXVAL-((SPEC*)ob->spec)->value;
  int offset=((SPEC*)ob->spec)->x0;

  switch( event)
  {
  case FL_DRAW:
    for (n=1;n<=((val*ELEMENTS)/MAXVAL);n++)
           fl_rectf((hel+GAP)*(n-1)+offset,ob->y,hel,ob->h,FL_INACTIVE_COL);
    for (n;n<=ELEMENTS;n++)
    {
       if( (n<=ELEMENTS) && (n>YELLOW_ON) )
            fl_rectf((hel+GAP)*(n-1)+offset,ob->y,hel,ob->h,FL_GREEN);
       else
           if(n<=RED_ON) 
              fl_rectf((hel+GAP)*(n-1)+offset,ob->y,hel,ob->h,FL_RED);
           else
              fl_rectf((hel+GAP)*(n-1)+offset,ob->y,hel,ob->h,FL_YELLOW);
    }
  break;   
  case FL_FREEMEM:
    fl_free(((SPEC *)ob->spec));
  break;    
  }
  return 0;
}

/************** MAIN ****************************************/

extern int eff[4][16];

FD_Effect *create_form_Effect(int nr_channels, int nr_effects)
{
  int k,l,nr=0;
  char buf[3]; 
  FL_OBJECT *obj;
  FL_IOPT cntl;
  FD_Effect *fdui;
  
  cntl.borderWidth = -2;
  /* default ist -3 -> berlappung mit 1. u. letztem bitmap */
  fl_set_defaults(FL_PDBorderWidth, &cntl);
  fdui = (FD_Effect *) fl_calloc(1, sizeof(*fdui));

  if (eff[0][14]){
     fdui->Effect = fl_bgn_form(FL_NO_BOX, 240+20*(nr_effects-1), 120+nr_channels*10);
     obj = fl_add_box(FL_UP_BOX,0,0,240+20*(nr_effects-1),120+nr_channels*10,"");
     obj = fl_add_box(FL_DOWN_BOX,50,10,20*(nr_effects-1),90,"");
  } 
  else{
     fdui->Effect = fl_bgn_form(FL_NO_BOX, 240+20*nr_effects, 120+nr_channels*10);
     obj = fl_add_box(FL_UP_BOX,0,0,240+20*nr_effects,120+nr_channels*10,"");
     obj = fl_add_box(FL_DOWN_BOX,50,10,20*nr_effects,90,"");
  }

 for(k=0;k<4;k++){
    for(l=0;l<16;l++){
       if( eff[k][l]==1 ){
         if ( !((k==0) && (l==14)) ) /* ungleich enhanced */
	   {
            obj = fl_add_bitmap(FL_NORMAL_BITMAP,52+nr*20,90-eff_bitmap_height[k][l],16,eff_bitmap_height[k][l],"");
            fl_set_bitmap_data(obj,16,eff_bitmap_height[k][l],eff_bitmap[k][l]);
            nr++;
	   }
       }
    }
  }

  obj = fl_add_text(FL_NORMAL_TEXT,10,80,30,20,"Chn");
    fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,60+20*nr,80,170,20,\
  "Note               L     Volume       R              Instr.");    fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  obj = fl_add_box(FL_DOWN_BOX,10,10,30,60,"");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
  obj = fl_add_bitmap(FL_NORMAL_BITMAP,17,24,16,32,"");
    fl_set_bitmap_data(obj,16,32,effekt_label);
  obj = fl_add_box(FL_DOWN_BOX,60+nr*20,10,170,60,"");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
  obj = fl_add_text(FL_NORMAL_TEXT,85+nr*20,40,40,10,"Note");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,85+nr*20,50,40,10,"Time");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,85+nr*20,20,40,10,"Speed");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,85+nr*20,30,40,10,"BPM ");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
   obj = fl_add_text(FL_NORMAL_TEXT,140+nr*20,10,10,60,":\n:\n:\n:");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE); 

  fdui->disp_speed = obj = fl_add_text(FL_NORMAL_TEXT,155+nr*20,20,40,10,"5");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
  fdui->disp_bpm = obj = fl_add_text(FL_NORMAL_TEXT,155+nr*20,30,40,10,"78");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
  fdui->disp_note = obj = fl_add_text(FL_NORMAL_TEXT,155+nr*20,40,40,10,"17");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
  fdui->disp_time = obj = fl_add_text(FL_NORMAL_TEXT,155+nr*20,50,40,10,"1:44");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
  /* channels rahmen */
  obj = fl_add_box(FL_DOWN_BOX,10,110,30,10*nr_channels,"");
  /* note rahmen */
  obj = fl_add_box(FL_FRAME_BOX,60+nr*20,110-1,30,10*nr_channels+2,"");
  /* inst rahmen */
  obj = fl_add_box(FL_FRAME_BOX,200+nr*20,110-1,30,10*nr_channels+2,"");
 /* volmeter rahmen */
 //  obj = fl_add_box(FL_FRAME_BOX,100+nr*20,110-1,90,10*nr_channels+2,"");
 //  note und instr rahmen wegen textdarstellung 1 punkt zu gro
  /* channels spalte */
  for(k=0;k<nr_channels;k++)
  {
    sprintf(buf,"%2d",k+1);
    obj = fl_add_text(FL_NORMAL_TEXT,10,110+k*10,30,10,buf);
      fl_set_object_boxtype(obj,FL_NO_BOX);
      fl_set_object_lsize(obj,FL_TINY_SIZE);
      fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  }
  
  for(k=0;k<nr_channels;k++)
  {
   /* note spalte */
   fdui->note[k]= obj = fl_add_text(FL_NORMAL_TEXT,60+nr*20+2,110+k*10,30-4,10,"- -");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);  
   // fl_set_object_lstyle(obj,FL_FIXED_STYLE);
   /* vol_l spalte */
   obj = fl_add_box(FL_FRAME_BOX,100+nr*20,110+k*10,45,10,"");
    fl_set_object_color(obj,FL_BLACK,FL_COL1);
    fl_set_object_lsize(obj,FL_TINY_SIZE);
   fdui->vol_l[k] = obj = fl_add_meter_l(FL_LIN_METER,103+nr*20,110+k*10+2,40,10-4,""); 
  /* vol_r spalte */
   obj = fl_add_box(FL_FRAME_BOX,145+nr*20,110+k*10,45,10,"");
    fl_set_object_color(obj,FL_BLACK,FL_COL1);
    fl_set_object_lsize(obj,FL_TINY_SIZE);
  fdui->vol_r[k]= obj = fl_add_meter_r(FL_LIN_METER,148+nr*20,110+k*10+2,40,10-4,""); 
  /* instr spalte */
  fdui->instr[k]=  obj = fl_add_text(FL_NORMAL_TEXT,200+nr*20+2,110+k*10,30-4,10,"- -");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
 //   fl_set_object_lstyle(obj,FL_FIXED_STYLE);
  }   

   
  for(k=0;k<nr_channels;k++)
    for(l=0;l<nr;l++)
    { 
      fdui->set_led[l][k]= obj = fl_add_box(FL_DOWN_BOX,50+l*20,110+k*10,20,10,"");
            fl_set_object_color(obj,FL_PALEGREEN,FL_COL1);   
            fl_set_object_lsize(obj,FL_TINY_SIZE);
    }
  
  fl_end_form();

  return fdui;
}















