/* EFFECTS.H
 *
 * by EB 20.04.97
 *
 *
 */

#ifndef effects_h
#define effects_h


#define FL_METER     1001
#define FL_LIN_METER 1

#define GAP       (1)		 /* Gap zwischen LEDs 	*/
#define LED_W     (3)		 /* LED Breite  	*/
#define ELEMENTS  (10)		 /* Anzahl LEDs		*/
#define MAXVAL 	  (1000)         /* Maximalpegel (Vollaussteuerung)  */
#define YELLOW_ON ELEMENTS-(0.5*ELEMENTS) /* erste gelbe LED	*/
#define RED_ON    ELEMENTS-(0.8*ELEMENTS) /* erste rote LED	*/

extern FL_OBJECT *
fl_create_meter_r(int type, FL_Coord x,FL_Coord y,\
        	           FL_Coord w,FL_Coord h, const char *label); 
extern FL_OBJECT *
fl_create_meter_l(int type, FL_Coord x,FL_Coord y,\
        	           FL_Coord w,FL_Coord h, const char *label); 
extern FL_OBJECT *
fl_add_meter_r(int type, FL_Coord x,FL_Coord y,\
                       FL_Coord w, FL_Coord h, const char *label);
extern FL_OBJECT *
fl_add_meter_l(int type, FL_Coord x,FL_Coord y,\
                       FL_Coord w, FL_Coord h, const char *label);

extern void fl_set_meter_r(FL_OBJECT*,int);
extern void fl_set_meter_l(FL_OBJECT*,int);

static int 
handle_meter_r(FL_OBJECT *ob,int event,FL_Coord mx,FL_Coord my,int key,
	      void *xev);
static int 
handle_meter_l(FL_OBJECT *ob,int event,FL_Coord mx,FL_Coord my,int key,
	      void *xev);


/* einige Typdefinitionen */

typedef struct {
  int value;      /* der anzuzeigende Wert */
  int x0;         /* x0 Koordinate    */
} SPEC;


typedef unsigned char byte;
typedef unsigned short int word;
typedef int int32;

typedef struct {
	FL_FORM *Effect;
	FL_OBJECT *disp_speed;
	FL_OBJECT *disp_bpm;
	FL_OBJECT *disp_note;
	FL_OBJECT *disp_time;
	FL_OBJECT *set_led[64][32];
        FL_OBJECT *note[32];
        FL_OBJECT *vol_l[32];
        FL_OBJECT *vol_r[32];
        FL_OBJECT *instr[32];
	void *vdata;
	long ldata;
} FD_Effect;

typedef struct {
	byte  disp_speed;
	byte  disp_bpm;
	byte  disp_note;
	int32 disp_time;
	byte  eff_led[64][32];
        byte  note[32];
        word  vol_l[32];
        word  vol_r[32];
        byte  instr[32];
} teffectsettings;

extern FD_Effect * create_form_Effect(int nr_channels,int nr_effects);

#endif /* effects_h_ */
