#include "forms.h"
#include "meter.h"

FL_OBJECT *fl_create_meter_l(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label)
{
  FL_OBJECT *ob;
  ob=fl_make_object(FL_METER,type,x,y,w,h,label,handle_meter_l);
  ((SPEC*)ob->spec) 	   = fl_calloc(1, sizeof(SPEC));
  ((SPEC*)ob->spec)->value = MAXVAL;
  ((SPEC*)ob->spec)->x0    = x;
  return ob;
}


FL_OBJECT *fl_add_meter_l(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label)
{
  FL_OBJECT *ob=fl_create_meter_l(type,x,y,w,h,label);
  fl_add_object(fl_current_form,ob);
  return ob;
}

FL_OBJECT *fl_add_meter_r(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label)
{
  FL_OBJECT *ob=fl_create_meter_r(type,x,y,w,h,label);
  fl_add_object(fl_current_form,ob);
  return ob;
}

FL_OBJECT *fl_create_meter_r(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label)
{
  FL_OBJECT *ob;
  ob=fl_make_object(FL_METER,type,x,y,w,h,label,handle_meter_r);
  ((SPEC*)ob->spec) 	   = fl_calloc(1, sizeof(SPEC));
  ((SPEC*)ob->spec)->value = MAXVAL;
  ((SPEC*)ob->spec)->x0    = x;
  return ob;
}

void fl_set_meter_r(FL_OBJECT *ob,int val)
{
  val=abs(val);
  if (!ob || ob->objclass != FL_METER)
  {
    fprintf(stderr,"set_meter: Bad argument or wrong objtype");
    return;
  }
  if ( ((SPEC*)ob->spec)->value !=val)
  {
    ((SPEC*)ob->spec)->value=(val>MAXVAL) ? MAXVAL : val;
     fl_redraw_object(ob);
  }
}

void fl_set_meter_l(FL_OBJECT *ob,int val)
{
  val=abs(val);
  if (!ob || ob->objclass != FL_METER)
  {
    fprintf(stderr,"set_meter: Bad argument or wrong objtype");
    return;
  }
  if ( ((SPEC*)ob->spec)->value !=val)
  {
    ((SPEC*)ob->spec)->value=(val>MAXVAL) ? MAXVAL : val;
     fl_redraw_object(ob);
  }
}

static int 
handle_meter_r(FL_OBJECT *ob,int event,FL_Coord mx,FL_Coord my,int key,
	      void *xev)
{
  int n;
  int hel=LED_W;
  int val=MAXVAL-((SPEC*)ob->spec)->value;
  int offset=((SPEC*)ob->spec)->x0;
  
  switch( event)
  {
  case FL_DRAW:
    for (n=1;n<=((val*ELEMENTS)/MAXVAL);n++)
           fl_rectf((hel+GAP)*(ELEMENTS-n)+offset,ob->y,hel,ob->h,FL_INACTIVE_COL);
    for (n;n<=ELEMENTS;n++)
    {
       if( (n<=ELEMENTS) && (n>YELLOW_ON) )
            fl_rectf((hel+GAP)*(ELEMENTS-n)+offset,ob->y,hel,ob->h,FL_GREEN);
       else
           if(n<=RED_ON) 
              fl_rectf((hel+GAP)*(ELEMENTS-n)+offset,ob->y,hel,ob->h,FL_RED);
           else
              fl_rectf((hel+GAP)*(ELEMENTS-n)+offset,ob->y,hel,ob->h,FL_YELLOW);
    }
  break;   
  case FL_FREEMEM:
    fl_free(((SPEC *)ob->spec));
  break;    
  }
  return 0;
}

static int 
handle_meter_l(FL_OBJECT *ob,int event,FL_Coord mx,FL_Coord my,int key,
	      void *xev)
{
  int n;
  int hel=LED_W;
  int val=MAXVAL-((SPEC*)ob->spec)->value;
  int offset=((SPEC*)ob->spec)->x0;

  switch( event)
  {
  case FL_DRAW:
    for (n=1;n<=((val*ELEMENTS)/MAXVAL);n++)
           fl_rectf((hel+GAP)*(n-1)+offset,ob->y,hel,ob->h,FL_INACTIVE_COL);
    for (n;n<=ELEMENTS;n++)
    {
       if( (n<=ELEMENTS) && (n>YELLOW_ON) )
            fl_rectf((hel+GAP)*(n-1)+offset,ob->y,hel,ob->h,FL_GREEN);
       else
           if(n<=RED_ON) 
              fl_rectf((hel+GAP)*(n-1)+offset,ob->y,hel,ob->h,FL_RED);
           else
              fl_rectf((hel+GAP)*(n-1)+offset,ob->y,hel,ob->h,FL_YELLOW);
    }
  break;   
  case FL_FREEMEM:
    fl_free(((SPEC *)ob->spec));
  break;    
  }
  return 0;
}

