#ifndef _METER_H
#define _METER_H

#include "forms.h"

#define FL_METER     1001
#define FL_LIN_METER 1

#define GAP       (1)		 /* Gap zwischen LEDs 	*/
#define LED_W     (3)		 /* LED Breite  	*/
#define ELEMENTS  (10)		 /* Anzahl LEDs		*/
#define MAXVAL 	  (1000)         /* Maximalpegel (Vollaussteuerung)  */
#define YELLOW_ON ELEMENTS-(0.5*ELEMENTS) /* erste gelbe LED	*/
#define RED_ON    ELEMENTS-(0.8*ELEMENTS) /* erste rote LED	*/

extern FL_OBJECT *
fl_create_meter_r(int type, FL_Coord x,FL_Coord y,\
        	           FL_Coord w,FL_Coord h, const char *label); 
extern FL_OBJECT *
fl_create_meter_l(int type, FL_Coord x,FL_Coord y,\
        	           FL_Coord w,FL_Coord h, const char *label); 
extern FL_OBJECT *
fl_add_meter_r(int type, FL_Coord x,FL_Coord y,\
                       FL_Coord w, FL_Coord h, const char *label);
extern FL_OBJECT *
fl_add_meter_l(int type, FL_Coord x,FL_Coord y,\
                       FL_Coord w, FL_Coord h, const char *label);

extern void fl_set_meter_r(FL_OBJECT*,int);
extern void fl_set_meter_l(FL_OBJECT*,int);

static int 
handle_meter_r(FL_OBJECT *ob,int event,FL_Coord mx,FL_Coord my,int key,
	      void *xev);
static int 
handle_meter_l(FL_OBJECT *ob,int event,FL_Coord mx,FL_Coord my,int key,
	      void *xev);

typedef struct {
  int value;      /* der anzuzeigende Wert */
  int x0;         /* x0 Koordinate    */
} SPEC;

#endif
