#ifndef _METER_H
#define _METER_H

#include "forms.h"

#define FL_METER     1001
#define FL_LIN_METER 1
#define FL_LOG_METER 2

#define GAP       (2)		 /* Gap zwischen LEDs 	*/
#define ELEMENTS  (10)		 /* Anzahl LEDs		*/
#define MAXVAL 	  (1000)         /* Maximalpegel (Vollaussteuerung)  */
#define YELLOW_ON ELEMENTS-(0.5*ELEMENTS) /* erste gelbe LED	*/
#define RED_ON    ELEMENTS-(0.8*ELEMENTS) /* erste rote LED	*/
        	  /* unterste LED (Nr.0) ist Nr. ELEMENTS */

extern FL_OBJECT *
fl_create_meter(int type, FL_Coord x,FL_Coord y,\
        	           FL_Coord w,FL_Coord h, const char *label); 

extern FL_OBJECT *
fl_add_meter(int type, FL_Coord x,FL_Coord y,\
                       FL_Coord w, FL_Coord h, const char *label);


extern void fl_set_meter(FL_OBJECT*,int);

typedef struct {
  int value; /* der anzuzeigende Wert */
  int hel;   /* die Hhe einer LED    */
} SPEC;


#endif
