/*
 *       mod4xgui.c
 */

#include "forms.h"
#include <stdlib.h>
#include "mod4xgui.h"
#include "../modlib/player.h"
#include "eff_xbm.h"

#define PIXMAPBUTTONS /*use nice PIXMAPS for the Buttons*/ 


#ifdef PIXMAPBUTTONS
#include "./bitmaps/buttonpix.h"
#endif

 
extern tsettings ssettings;


/* Shortkeys */

/* Main */
static char* shortkey_main []={
      "sS","pP","bB","&A","&D","&C","&B",\
      "^O^o","^S^s","^I^i","^E^e","^H^h","^R^r","^C^c","^T^t", NULL};
   
/*  main                       /i-o butt.!\
 *     Stop Play Pause SkipRew Rew.  Forw. SkipForw. 
 *      s    p    b      /\      <-    ->     \/       
 *     Open Setup Info Effects Shuffle Repeat Scan Time
 *      ^O   ^S    ^I   ^E      ^H      ^R     ^C   ^T
 */   

/* Open */
static char* shortkey_open []={
      "^O^o","^C^c","^S^s","^L^l","^A^a","^D^d","^R^r","^E^e", NULL};
   
/*  open  
 *        Ok    Cancel   Save   Load    
 *        ^O    ^C       ^S     ^L
 *        Add   Add All  Remove Remove All
 *        ^A    ^D       ^R     ^E
 */   

/* Setup */
static char* shortkey_setup []={"^O^o","^S^s","^Q^q","^H^h", NULL};
   
/*  setup  
 *        Ok   Save  Quit  Help
 *        ^O   ^S    ^Q    ^H
 */   




/* Vol_meter 
    
   Abstnde zwischen den LEDs und Zentrierung fest eingestellt
   (dynamisch geht schlecht, da alles n bichen zu klein ist 
*/

#define FL_VOL_METER	1001
#define FL_LIN_METER	1
#define FL_LOG_METER	2

#define GAP  	     	(1)		 /* Gap zwischen LEDs 	        */
#define LED_H		(3)		 /* LED Hhe - Levelmeter   	*/
#define LED_W           (3)		 /* LED Breite - Effects 	*/
#define ELEMENTS	(10)		 /* Anzahl LEDs		*/
#define MAXVAL 	  	(32000)          /* Maximalpegel (Vollaussteuerung) */
#define MAXVAL_EFF      (255)            /* Maxpegel (effects) */  
#define YELLOW_ON 	ELEMENTS-(0.5*ELEMENTS) /* erste gelbe LED	*/
#define RED_ON    	ELEMENTS-(0.8*ELEMENTS) /* erste rote LED	*/
                     	/* unterste LED (Nr.0) ist Nr. ELEMENTS */

typedef struct {
  int y0;		/* startposition y */
  int value; 		/* der anzuzeigende Wert */
  int hel;   		/* die Hhe einer LED    */
} SPEC;

FL_OBJECT *fl_create_meter(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label)
{
  FL_OBJECT *ob;
  ob=fl_make_object(FL_VOL_METER,type,x,y,w,h,label,handle_meter);
  /* berechne Hhe eines Elements */
  ((SPEC*)ob->spec) 	   = fl_calloc(1, sizeof(SPEC));
  ((SPEC*)ob->spec)->value = MAXVAL;
  ((SPEC*)ob->spec)->hel   = LED_H;
  ((SPEC*)ob->spec)->y0    = y;
  return ob;
}

FL_OBJECT *fl_add_meter(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label)
{
  FL_OBJECT *ob=fl_create_meter(type,x,y,w,h,label);
  fl_add_object(fl_current_form,ob);
  return ob;
}

void fl_set_meter(FL_OBJECT *ob,int val)
{
  val=abs(val);
  if (!ob || ob->objclass != FL_VOL_METER)
  {
    fprintf(stderr,"set_meter: Bad argument or wrong objtype");
    return;
  }
  if ( ((SPEC*)ob->spec)->value !=val)
  {
    ((SPEC*)ob->spec)->value=(val>MAXVAL) ? MAXVAL : val;
     fl_redraw_object(ob);
  }
}

static int 
handle_meter(FL_OBJECT *ob,int event,FL_Coord mx,FL_Coord my,int key,
	      void *xev)
{
  int n;
  int hel=((SPEC*)ob->spec)->hel;
  int val=MAXVAL-((SPEC*)ob->spec)->value;
  int offset=((SPEC*)ob->spec)->y0;
  
  switch( event)
  {
  case FL_DRAW:
    for (n=1;n<=((val*ELEMENTS)/MAXVAL);n++)
           fl_rectf(ob->x,(hel+GAP)*(n-1)+offset,ob->w,hel,FL_INACTIVE_COL);
    for (n;n<=ELEMENTS;n++)
    {
       if( (n<=ELEMENTS) && (n>YELLOW_ON) )
            fl_rectf(ob->x,(hel+GAP)*(n-1)+offset,ob->w,hel,FL_GREEN);
       else
           if(n<=RED_ON) 
              fl_rectf(ob->x,(hel+GAP)*(n-1)+offset,ob->w,hel,FL_RED);
           else
              fl_rectf(ob->x,(hel+GAP)*(n-1)+offset,ob->w,hel,FL_YELLOW);
    }
  break;   
  case FL_FREEMEM:
    fl_free(((SPEC *)ob->spec));
  break;    
  }
  return 0;
}


/* Levelmeter rechts/links -> effects by Eb 28.4. */


FL_OBJECT *fl_create_meter_l(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label)
{
  FL_OBJECT *ob;
  ob=fl_make_object(FL_VOL_METER,type,x,y,w,h,label,handle_meter_l);
  ((SPEC_lr*)ob->spec) 	   = fl_calloc(1, sizeof(SPEC_lr));
  ((SPEC_lr*)ob->spec)->value = 0;
  ((SPEC_lr*)ob->spec)->x0    = x;
  return ob;
}


FL_OBJECT *fl_add_meter_l(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label)
{
  FL_OBJECT *ob=fl_create_meter_l(type,x,y,w,h,label);
  fl_add_object(fl_current_form,ob);
  return ob;
}

FL_OBJECT *fl_add_meter_r(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label)
{
  FL_OBJECT *ob=fl_create_meter_r(type,x,y,w,h,label);
  fl_add_object(fl_current_form,ob);
  return ob;
}

FL_OBJECT *fl_create_meter_r(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label)
{
  FL_OBJECT *ob;
  ob=fl_make_object(FL_VOL_METER,type,x,y,w,h,label,handle_meter_r);
  ((SPEC_lr*)ob->spec) 	   = fl_calloc(1, sizeof(SPEC_lr));
  ((SPEC_lr*)ob->spec)->value = 0;
  ((SPEC_lr*)ob->spec)->x0    = x;
  return ob;
}

void fl_set_meter_r(FL_OBJECT *ob,int val)
{
  val=abs(val);
  if (!ob || ob->objclass != FL_VOL_METER)
  {
    fprintf(stderr,"set_meter: Bad argument or wrong objtype");
    return;
  }
  if ( ((SPEC_lr*)ob->spec)->value !=val)
  {
    ((SPEC_lr*)ob->spec)->value=(val>MAXVAL_EFF) ? MAXVAL_EFF : val;
     fl_redraw_object(ob);
  }
}

void fl_set_meter_l(FL_OBJECT *ob,int val)
{
  val=abs(val);
  if (!ob || ob->objclass != FL_VOL_METER)
  {
    fprintf(stderr,"set_meter: Bad argument or wrong objtype");
    return;
  }
  if ( ((SPEC_lr*)ob->spec)->value !=val)
  {
    ((SPEC_lr*)ob->spec)->value=(val>MAXVAL_EFF) ? MAXVAL_EFF : val;
     fl_redraw_object(ob);
  }
}

static int 
handle_meter_r(FL_OBJECT *ob,int event,FL_Coord mx,FL_Coord my,int key,
	      void *xev)
{
  int n;
  int hel=LED_W;
  int val=MAXVAL_EFF-((SPEC_lr*)ob->spec)->value;
  int offset=((SPEC_lr*)ob->spec)->x0;
  
  switch( event)
  {
  case FL_DRAW:
    for (n=1;n<=((val*ELEMENTS)/MAXVAL_EFF);n++)
           fl_rectf((hel+GAP)*(ELEMENTS-n)+offset,ob->y,hel,ob->h,FL_INACTIVE_COL);
    for (n;n<=ELEMENTS;n++)
    {
       if( (n<=ELEMENTS) && (n>YELLOW_ON) )
            fl_rectf((hel+GAP)*(ELEMENTS-n)+offset,ob->y,hel,ob->h,FL_GREEN);
       else
           if(n<=RED_ON) 
              fl_rectf((hel+GAP)*(ELEMENTS-n)+offset,ob->y,hel,ob->h,FL_RED);
           else
              fl_rectf((hel+GAP)*(ELEMENTS-n)+offset,ob->y,hel,ob->h,FL_YELLOW);
    }
  break;   
  case FL_FREEMEM:
    fl_free(((SPEC_lr *)ob->spec));
  break;    
  }
  return 0;
}

static int 
handle_meter_l(FL_OBJECT *ob,int event,FL_Coord mx,FL_Coord my,int key,
	      void *xev)
{
  int n;
  int hel=LED_W;
  int val=MAXVAL_EFF-((SPEC_lr*)ob->spec)->value;
  int offset=((SPEC_lr*)ob->spec)->x0;

  switch( event)
  {
  case FL_DRAW:
    for (n=1;n<=((val*ELEMENTS)/MAXVAL_EFF);n++)
           fl_rectf((hel+GAP)*(n-1)+offset,ob->y,hel,ob->h,FL_INACTIVE_COL);
    for (n;n<=ELEMENTS;n++)
    {
       if( (n<=ELEMENTS) && (n>YELLOW_ON) )
            fl_rectf((hel+GAP)*(n-1)+offset,ob->y,hel,ob->h,FL_GREEN);
       else
           if(n<=RED_ON) 
              fl_rectf((hel+GAP)*(n-1)+offset,ob->y,hel,ob->h,FL_RED);
           else
              fl_rectf((hel+GAP)*(n-1)+offset,ob->y,hel,ob->h,FL_YELLOW);
    }
  break;   
  case FL_FREEMEM:
    fl_free(((SPEC_lr *)ob->spec));
  break;    
  }
  return 0;
}


/******************** MAIN *********************/

FD_Main *create_form_Main(void)
{
  FL_OBJECT *obj;
  FD_Main *fdui = (FD_Main *) fl_calloc(1, sizeof(*fdui));

  fdui->Main = fl_bgn_form(FL_NO_BOX, 550, 120);
  fdui->main_panel = obj = fl_add_box(FL_UP_BOX,0,0,550,120,"");
  obj = fl_add_frame(FL_ENGRAVED_FRAME,7,87,350,27,"");
  obj = fl_add_frame(FL_DOWN_FRAME,371,70,138,41,"");
  obj = fl_add_box(FL_FLAT_BOX,10,40,205,44,"");
    fl_set_object_color(obj,FL_BLACK,FL_COL1);
  obj = fl_add_box(FL_DOWN_BOX,224,37,132,48,"");
    fl_set_object_color(obj,FL_BLACK,FL_COL1);
  obj = fl_add_frame(FL_DOWN_FRAME,10,41,206,41,"");
    fl_set_object_color(obj,FL_DARKTOMATO,FL_SPRINGGREEN);
  fdui->Shuffle_button = obj = fl_add_button(FL_NORMAL_BUTTON,369,70,35,21,"Shuffle");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_callback(obj,shuffle_mode,0);
    fl_set_object_shortcut(obj,shortkey_main[11],1);
  fdui->Repeat_button = obj = fl_add_button(FL_NORMAL_BUTTON,404,70,35,21,"Repeat");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_callback(obj,Repeat_mode,0);
    fl_set_object_shortcut(obj,shortkey_main[12],1);
  fdui->Scan_button = obj = fl_add_button(FL_NORMAL_BUTTON,439,70,35,21,"Scan");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_callback(obj,Scan_mode,0);
    fl_set_object_shortcut(obj,shortkey_main[13],1);
  fdui->Open_button = obj = fl_add_button(FL_NORMAL_BUTTON,369,91,35,21,"Open");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_callback(obj,open_file,0);
    fl_set_object_shortcut(obj,shortkey_main[7],1);
  fdui->Setup_button = obj = fl_add_button(FL_NORMAL_BUTTON,404,91,35,21,"Setup");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_callback(obj,open_setup,0);
    fl_set_object_shortcut(obj,shortkey_main[8],1);
  fdui->Info_button = obj = fl_add_button(FL_NORMAL_BUTTON,439,91,35,21,"Info");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_callback(obj,show_info,0);
    fl_set_object_shortcut(obj,shortkey_main[9],1);
  fdui->time_button = obj = fl_add_button(FL_NORMAL_BUTTON,474,70,35,21,"Time");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_callback(obj,Time_mode,0);
    fl_set_object_shortcut(obj,shortkey_main[14],1);
  fdui->Effects_button = obj = fl_add_button(FL_NORMAL_BUTTON,474,91,35,21,"Effects");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_callback(obj,show_effects,0);
    fl_set_object_shortcut(obj,shortkey_main[10],1);
#ifndef PIXMAPBUTTONS
  obj = fl_add_button(FL_NORMAL_BUTTON,305,87,52,27,"@->|");
   obj->wantkey=FL_KEY_TAB; // normal plus up/down/tab/return
    fl_set_object_lcol(obj,FL_PALEGREEN);
    fl_set_object_callback(obj,Skip_Fw,0);
    fl_set_object_shortcut(obj,shortkey_main[6],1);
  obj = fl_add_button(FL_INOUT_BUTTON,256,87,49,27,"@>>");
    fl_set_object_lcol(obj,FL_PALEGREEN);
    fl_set_object_callback(obj,Fast_Forward,0);
   fl_set_object_shortcut(obj,shortkey_main[5],0);
  obj = fl_add_button(FL_NORMAL_BUTTON,156,87,49,27,"@4->|");
    obj->wantkey=FL_KEY_TAB; // normal plus up/down/tab/return
    fl_set_object_lcol(obj,FL_PALEGREEN);
    fl_set_object_callback(obj,Skip_Rew,0);
    fl_set_object_shortcut(obj,shortkey_main[3],1);
  fdui->pause_button = obj = fl_add_button(FL_NORMAL_BUTTON,105,87,51,27,"@Pause");
    fl_set_object_lcol(obj,FL_PALEGREEN);
    fl_set_object_callback(obj,Pause,0);
   fl_set_object_shortcut(obj,shortkey_main[2],1);
  fdui->Play_button = obj = fl_add_button(FL_NORMAL_BUTTON,55,87,50,27,"@>");
    fl_set_object_lcol(obj,FL_PALEGREEN);
    fl_set_object_callback(obj,Play,0);
    fl_set_object_shortcut(obj,shortkey_main[1],1);
  fdui->stop_button = obj = fl_add_button(FL_NORMAL_BUTTON,6,87,49,27,"@#square");
    fl_set_object_lcol(obj,FL_PALEGREEN);
    fl_set_object_callback(obj,Stop,0);
    fl_set_object_shortcut(obj,shortkey_main[0],1);
  obj = fl_add_button(FL_INOUT_BUTTON,205,87,51,27,"@<<");
    fl_set_object_shortcut(obj,shortkey_main[4],0);
    fl_set_object_lcol(obj,FL_PALEGREEN);
    fl_set_object_callback(obj,Fast_Rew,0);
#else
    /*this is for the nicer pixmap buttons*/
  obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,305,87,52,27,"");
    fl_set_object_lcol(obj,FL_PALEGREEN);
    fl_set_object_callback(obj,Skip_Fw,0);
    fl_set_pixmapbutton_data(obj,bnext_nor_xpm);
    fl_set_object_shortcut(obj,shortkey_main[6],1);
  obj = fl_add_pixmapbutton(FL_INOUT_BUTTON,256,87,49,27,"");
    fl_set_object_lcol(obj,FL_PALEGREEN);
    fl_set_object_callback(obj,Fast_Forward,0);
    fl_set_pixmapbutton_data(obj,bff_nor_xpm);
    fl_set_object_shortcut(obj,shortkey_main[5],1);
  obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,156,87,49,27,"");
    fl_set_object_lcol(obj,FL_PALEGREEN);
    fl_set_object_callback(obj,Skip_Rew,0);
    fl_set_pixmapbutton_data(obj,bprev_nor_xpm);
    fl_set_object_shortcut(obj,shortkey_main[3],1);
  fdui->pause_button = obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,105,87,51,27,"");
    fl_set_object_lcol(obj,FL_PALEGREEN);
    fl_set_object_callback(obj,Pause,0);
    fl_set_pixmapbutton_data(obj,bpause_nor_xpm);
    fl_set_object_shortcut(obj,shortkey_main[2],1);
  fdui->Play_button = obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,55,87,50,27,"");
    fl_set_object_lcol(obj,FL_PALEGREEN);
    fl_set_object_callback(obj,Play,0);
    fl_set_pixmapbutton_data(obj,bplay_nor_xpm);
    fl_set_object_shortcut(obj,shortkey_main[1],1);
  fdui->stop_button = obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,6,87,49,27,"");
    fl_set_object_lcol(obj,FL_PALEGREEN);
    fl_set_object_callback(obj,Stop,0);
    fl_set_pixmapbutton_data(obj,bstop_nor_xpm);
    fl_set_object_shortcut(obj,shortkey_main[0],1);
  obj = fl_add_pixmapbutton(FL_INOUT_BUTTON,205,87,51,27,"");
    fl_set_object_lcol(obj,FL_PALEGREEN);
    fl_set_object_callback(obj,Fast_Rew,0);
    fl_set_pixmapbutton_data(obj,bfr_nor_xpm);
    fl_set_object_shortcut(obj,shortkey_main[4],1);
#endif
  obj = fl_add_text(FL_NORMAL_TEXT,16,41,29,15,"MIN");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,53,41,38,15,"SEC");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,172,41,35,15,"Total");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,154,58,18,16,"of");
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,254,42,46,12,"Pattern");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  fdui->shuffle_dsp=obj = fl_add_text(FL_NORMAL_TEXT,314,41,40,13,"");
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  fdui-> repeat_dsp=obj =fl_add_text(FL_NORMAL_TEXT,314,54,40,13,"");
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  fdui->intro_dsp=obj = fl_add_text(FL_NORMAL_TEXT,314,67,40,13,"");
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_button(FL_NORMAL_BUTTON,334,5,20,15,"@8>");
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_color(obj,FL_MCOL,FL_COL1);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_callback(obj,main_chg_dsp,1);
  obj = fl_add_button(FL_NORMAL_BUTTON,334,20,20,15,"@2>");
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_color(obj,FL_MCOL,FL_COL1);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_callback(obj,main_chg_dsp,0);
  fdui->title_dsp = obj = fl_add_text(FL_NORMAL_TEXT,9,9,322,24,"++++ Mod4Xwin ++++");
    fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  obj = fl_add_box(FL_DOWN_BOX,369,9,141,54,"");
    fl_set_object_color(obj,FL_BLACK,FL_COL1);
  obj = fl_add_text(FL_NORMAL_TEXT,42,56,19,21,":");
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  fdui->sec_dsp = obj = fl_add_text(FL_NORMAL_TEXT,56,54,31,24,"00");
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,15);
  fdui->min_dsp = obj = fl_add_text(FL_NORMAL_TEXT,18,54,30,24,"00");
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,15);
  fdui->song_dsp = obj = fl_add_text(FL_NORMAL_TEXT,111,51,41,30,"000");
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,15);
  fdui->total_dsp = obj = fl_add_text(FL_NORMAL_TEXT,174,53,40,26,"000");
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,15);
  fdui->hz_dsp = obj = fl_add_text(FL_NORMAL_TEXT,382,13,45,17,"00000");
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,15);
  fdui->channels_dsp = obj = fl_add_text(FL_NORMAL_TEXT,382,30,20,16,"00");
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,15);
  fdui->cpu_dsp = obj = fl_add_text(FL_NORMAL_TEXT,382,44,27,16,"000");
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,15);
  obj = fl_add_text(FL_NORMAL_TEXT,423,15,19,15,"Hz");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
  fdui->bits_dsp = obj = fl_add_text(FL_NORMAL_TEXT,440,14,22,18,"00");
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,15);
  obj = fl_add_text(FL_NORMAL_TEXT,458,15,20,16,"Bit");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,403,31,43,15,"Channels");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,405,47,35,13,"%CPU");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
  fdui->vol_meter = obj = fl_add_meter(FL_LIN_METER,374,17,7,40,"");
    // by EB 23.3 
  obj = fl_add_text(FL_NORMAL_TEXT,264,55,20,23,"of");
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,113,39,40,15,"Song");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  fdui->pattern_dsp = obj = fl_add_text(FL_NORMAL_TEXT,226,53,42,25,"000");
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,15);
  fdui->maxpattern_dsp = obj = fl_add_text(FL_NORMAL_TEXT,279,52,41,28,"000");
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,15);
  fdui->pre_amp= obj = fl_add_slider(FL_VERT_NICE_SLIDER,518,9,20,86,"PreAmp");
    fl_set_object_color(obj,FL_MCOL,FL_GREEN);
    fl_set_object_callback(obj,preamp,0);
    fl_set_slider_precision(obj,0);
    fl_set_slider_bounds(obj,20,0);
    fl_set_slider_value(obj,(double) ssettings.preamp );
    fl_set_slider_return(obj,FL_RETURN_CHANGED);
  fl_end_form();

  return fdui;
}

/************************* OPEN **************/

FD_OPEN *create_form_OPEN(void)
{
  FL_OBJECT *obj;
  FD_OPEN *fdui = (FD_OPEN *) fl_calloc(1, sizeof(*fdui));

  fdui->OPEN = fl_bgn_form(FL_NO_BOX, 593, 393);
  fdui->open_panel = obj = fl_add_box(FL_UP_BOX,0,0,593,393,"");
  obj = fl_add_frame(FL_ENGRAVED_FRAME,20,10,560,320,"");
  obj = fl_add_frame(FL_ENGRAVED_FRAME,19,330,560,55,"");
  fdui->file_ok = obj = fl_add_button(FL_NORMAL_BUTTON,76,337,80,40,"OK");
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_SHADOW_STYLE);
    fl_set_object_callback(obj,OK_button,0);
    fl_set_object_shortcut(obj,shortkey_open[0],1);
  fdui->file_cancel = obj = fl_add_button(FL_NORMAL_BUTTON,156,337,80,40,"Cancel");
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_SHADOW_STYLE);
    fl_set_object_callback(obj,Cancel_button,0);
    fl_set_object_shortcut(obj,shortkey_open[1],1);
  obj = fl_add_text(FL_NORMAL_TEXT,32,17,217,18,"File to play");
    fl_set_object_boxtype(obj,FL_SHADOW_BOX);
    fl_set_object_color(obj,FL_RIGHT_BCOL,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  fdui->file_browser_left = obj = fl_add_browser(FL_MULTI_BROWSER,30,40,220,280,"");
    fl_set_object_color(obj,FL_RIGHT_BCOL,FL_INDIANRED);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_callback(obj,file_browser_left,0);
  obj = fl_add_text(FL_NORMAL_TEXT,352,17,217,18,"Playlist");
    fl_set_object_boxtype(obj,FL_SHADOW_BOX);
    fl_set_object_color(obj,FL_RIGHT_BCOL,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  fdui->file_browser_right = obj = fl_add_browser(FL_MULTI_BROWSER,350,40,220,280,"");
    fl_set_object_color(obj,FL_RIGHT_BCOL,FL_INDIANRED);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_callback(obj,file_browser_right,1);
  fdui->setup_add = obj = fl_add_button(FL_NORMAL_BUTTON,270,75,60,30,"Add");
    fl_set_object_callback(obj,setup_add,0);
    fl_set_object_shortcut(obj,shortkey_open[4],1);
  fdui->setup_add_all = obj = fl_add_button(FL_NORMAL_BUTTON,270,135,60,30,"Add All");
    fl_set_object_callback(obj,setup_add_all,0);
    fl_set_object_shortcut(obj,shortkey_open[5],1);
  fdui->setup_rem = obj = fl_add_button(FL_NORMAL_BUTTON,270,210,60,30,"Remove");
    fl_set_object_callback(obj,setup_rem,0);
    fl_set_object_shortcut(obj,shortkey_open[6],1);
  fdui->file_rem_all = obj = fl_add_button(FL_NORMAL_BUTTON,270,270,60,30,"Rem. All");
    fl_set_object_callback(obj,file_rem_all,0);
    fl_set_object_shortcut(obj,shortkey_open[7],1);
  obj = fl_add_text(FL_NORMAL_TEXT,270,105,60,30,"@->");
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,270,240,60,30,"@4->");
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,252,347,105,25,"MOD 4 X");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_lcol(obj,FL_BLUE);
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_TIMESBOLD_STYLE+FL_SHADOW_STYLE);
  fdui->save = obj = fl_add_button(FL_NORMAL_BUTTON,373,337,80,40,"Save");
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_SHADOW_STYLE);
    fl_set_object_callback(obj,save_playlist,0);
    fl_set_object_shortcut(obj,shortkey_open[2],1);
  fdui->load = obj = fl_add_button(FL_NORMAL_BUTTON,453,337,80,40,"Load");
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_SHADOW_STYLE);
    fl_set_object_callback(obj,load_playlist,0);
    fl_set_object_shortcut(obj,shortkey_open[3],1);
  fl_end_form();

  return fdui;
}

/******** SETUP *********************/

FD_SETUP *create_form_SETUP(void)
{
  FL_OBJECT *obj;
  FD_SETUP *fdui = (FD_SETUP *) fl_calloc(1, sizeof(*fdui));

  fdui->SETUP = fl_bgn_form(FL_NO_BOX, 500, 280);
  fdui->setup_panel = obj = fl_add_box(FL_UP_BOX,0,0,500,280,"");
  obj = fl_add_frame(FL_ENGRAVED_FRAME,20,35,230,55,"");
  obj = fl_add_text(FL_NORMAL_TEXT,50,30,60,15,"Sampling");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  fdui->hz_slider = obj = fl_add_valslider(FL_HOR_NICE_SLIDER,30,45,75,30,"");
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj,setup_khz,0);
    fl_set_slider_value(obj, (double)(ssettings.samplerate/1000));
    fl_set_slider_return(obj, FL_RETURN_CHANGED);
  obj = fl_add_frame(FL_ENGRAVED_FRAME,260,35,65,55,"");
  obj = fl_add_text(FL_NORMAL_TEXT,271,30,42,14,"Buffers");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_frame(FL_ENGRAVED_FRAME,335,35,140,55,"");

  fdui->chnsett_grp = fl_bgn_group();
  obj = fl_add_checkbutton(FL_RADIO_BUTTON,190,45,20,20,"Mono");
    fl_set_object_callback(obj,setup_channel,1);
    if (ssettings.stereo == 1)	fl_set_button(obj,1);
  obj = fl_add_checkbutton(FL_RADIO_BUTTON,190,60,20,20,"Stereo");
    fl_set_object_callback(obj,setup_channel,2);
    if (ssettings.stereo == 2)	fl_set_button(obj,1);
  fl_end_group();


  fdui->depthsett_grp = fl_bgn_group();
  obj = fl_add_checkbutton(FL_RADIO_BUTTON,130,45,20,20,"16Bit");
    fl_set_object_callback(obj,setup_bit,2);
    if (ssettings.bits==16)	fl_set_button(obj,1);
  obj = fl_add_checkbutton(FL_RADIO_BUTTON,130,60,20,20,"8Bit");
    fl_set_object_callback(obj,setup_bit,1);
    if (ssettings.bits==8)	fl_set_button(obj,1);
  fl_end_group();

  obj = fl_add_text(FL_NORMAL_TEXT,345,28,30,18,"(())");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,380,29,45,15,"Q-Mix");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,430,29,30,15,"BPM");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,462,44,23,17,"On");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,459,64,30,15,"Off");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);

  fdui->BPMsett_grp = fl_bgn_group();
  obj = fl_add_checkbutton(FL_RADIO_BUTTON,435,45,20,20,"");
    fl_set_object_callback(obj,setup_bpm,1);
    if (ssettings.nobpm==1)	fl_set_button(obj,1);
  obj = fl_add_checkbutton(FL_RADIO_BUTTON,435,60,20,20,"");
    fl_set_object_callback(obj,setup_bpm,0);
    if (ssettings.nobpm==0)	fl_set_button(obj,1);
  fl_end_group();


  fdui->Q_mixsett_grp = fl_bgn_group();
  obj = fl_add_checkbutton(FL_RADIO_BUTTON,390,45,20,20,"");
    fl_set_object_callback(obj,setup_qmix,1);
    if (ssettings.quality==1)	fl_set_button(obj,1);
  obj = fl_add_checkbutton(FL_RADIO_BUTTON,390,60,20,20,"");
    fl_set_object_callback(obj,setup_qmix,0);
    if (ssettings.quality==0)	fl_set_button(obj,1);
  fl_end_group();


  fdui->surrsett_grp = fl_bgn_group();
  obj = fl_add_checkbutton(FL_RADIO_BUTTON,350,45,20,20,"");
    fl_set_object_callback(obj,setup_surr,1);
    if (ssettings.surround==1)	fl_set_button(obj,1);
  obj = fl_add_checkbutton(FL_RADIO_BUTTON,350,60,20,20,"");
    fl_set_object_callback(obj,setup_surr,0);
    if (ssettings.surround==0)	fl_set_button(obj,1);
  fl_end_group();

  obj = fl_add_frame(FL_UP_FRAME,20,110,460,125,"");
  obj = fl_add_frame(FL_DOWN_FRAME,25,125,450,27,"");
  obj = fl_add_frame(FL_DOWN_FRAME,25,160,330,25,"");
  obj = fl_add_frame(FL_DOWN_FRAME,25,195,330,25,"");
  obj = fl_add_text(FL_NORMAL_TEXT,25,102,53,15,"Mod4Xwin");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_button(FL_NORMAL_BUTTON,300,250,45,25,"OK");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj,setup_ok,0);
    fl_set_object_shortcut(obj,shortkey_setup[0],1);
  obj = fl_add_button(FL_NORMAL_BUTTON,345,250,45,25,"Save");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj,setup_save,0);
    fl_set_object_shortcut(obj,shortkey_setup[1],1);
  obj = fl_add_button(FL_NORMAL_BUTTON,390,250,45,25,"Quit");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj,setup_quit,0);
    fl_set_object_shortcut(obj,shortkey_setup[2],1);
  obj = fl_add_button(FL_NORMAL_BUTTON,435,250,45,25,"Help");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj,setup_help,0);
    fl_set_object_shortcut(obj,shortkey_setup[3],1);
  obj = fl_add_text(FL_NORMAL_TEXT,185,250,105,25,"MOD 4 X");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_lcol(obj,FL_BLUE);
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_TIMESBOLD_STYLE+FL_SHADOW_STYLE);
  obj = fl_add_text(FL_NORMAL_TEXT,30,165,320,20,"Automatische Wiedergabe nach OPEN      :");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  obj = fl_add_text(FL_NORMAL_TEXT,30,200,320,20,"Wiedergabe im Setup pausieren                :");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  fdui->switch_auto=obj = fl_add_slider(FL_HOR_NICE_SLIDER,445,160,30,25,"");
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_object_color(obj,FL_COL1,FL_GREEN);
    fl_set_object_callback(obj,setup_after_open,0);
    fl_set_slider_precision(obj,1);
    fl_set_slider_step(obj,1.0);
    fl_set_slider_return(obj, FL_RETURN_CHANGED);
    fl_set_slider_value(obj, (double)ssettings.switch_auto);
   fdui->switch_pause=obj = fl_add_slider(FL_HOR_NICE_SLIDER,445,195,30,25,"");
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_object_color(obj,FL_COL1,FL_GREEN);
    fl_set_object_callback(obj,setup_pause_after,0);
    fl_set_slider_precision(obj,1);
    fl_set_slider_step(obj,1.0);
    fl_set_slider_return(obj, FL_RETURN_CHANGED);
    fl_set_slider_value(obj, (double)ssettings.switch_pause);
  obj = fl_add_button(FL_NORMAL_BUTTON,305,50,20,15,"@8>");
    fl_set_object_color(obj,FL_TOP_BCOL,FL_COL1);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_callback(obj,setup_buff,1);
  obj = fl_add_button(FL_NORMAL_BUTTON,305,65,20,15,"@2>");
    fl_set_object_color(obj,FL_TOP_BCOL,FL_COL1);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_callback(obj,setup_buff,0);
  fdui->num_buff_dsp = obj = fl_add_text(FL_NORMAL_TEXT,267,48,33,33,"10");
    fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_label(obj,(char*)itoasc(ssettings.nbuffers,2)); // by EB 21.3.97
  if (!ssettings.switch_auto) 
    fdui->auto_play_dsp = obj = fl_add_text(FL_NORMAL_TEXT,369,159,66,27,"-AUS-");
  else
    fdui->auto_play_dsp = obj = fl_add_text(FL_NORMAL_TEXT,369,159,66,27,"-EIN-");
    fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  if (!ssettings.switch_pause) 
    fdui->pause_after_dsp = obj = fl_add_text(FL_NORMAL_TEXT,369,195,66,27,"-AUS-");
  else
    fdui->pause_after_dsp = obj = fl_add_text(FL_NORMAL_TEXT,369,195,66,27,"-EIN-");
    fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  fdui->Setup_pl = obj = fl_add_input(FL_NORMAL_INPUT,164,126,310,24,"Pfad fr ext. Playlist:");
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_input_maxchars(obj,39);		  // by EB 21.3.97 (tsettings)
    fl_set_object_return(obj,FL_RETURN_END_CHANGED);      // by EB 21.3.97
    fl_set_input(obj,ssettings.name);
    fl_set_object_callback(obj,setup_playl,0);
  fl_end_form();
  return fdui;
}

/******************** INFO *********************/


FD_info *create_form_info(void)
{
  FL_OBJECT *obj;
  FD_info *fdui = (FD_info *) fl_calloc(1, sizeof(*fdui));

  fdui->info = fl_bgn_form(FL_NO_BOX, 451, 358);
  obj = fl_add_box(FL_UP_BOX,0,0,451,358,"");
  fdui->info_title = obj = fl_add_text(FL_NORMAL_TEXT,12,8,430,30,"Mod4Xwin");
    fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_MCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  fdui->browser_left = obj = fl_add_browser(FL_NORMAL_BROWSER,11,43,213,226,"");
    fl_set_object_color(obj,FL_BLACK,FL_YELLOW);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  fdui->browser_right = obj = fl_add_browser(FL_NORMAL_BROWSER,234,43,207,226,"");
    fl_set_object_color(obj,FL_BLACK,FL_YELLOW);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  fdui->browser_bottom = obj = fl_add_browser(FL_NORMAL_BROWSER,12,275,429,74,"");
    fl_set_object_color(obj,FL_BLACK,FL_YELLOW);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  fl_end_form();

  return fdui;
}


/************** EFFECT *************************/

extern word eff[4][16];

FD_Effect *create_form_Effect(int nr_channels, int nr_effects)
{
  int k,l,i,n,nr=0;
  char buf[3]; 
  FL_OBJECT *obj;
  FL_IOPT cntl;
  FD_Effect *fdui;
  int zaehl[64];
  
  cntl.borderWidth = -2;
  /* default ist -3 -> berlappung mit 1. u. letztem bitmap */
  fl_set_defaults(FL_PDBorderWidth, &cntl);
  fdui = (FD_Effect *) fl_calloc(1, sizeof(*fdui));

  if (eff[0][14]){
     fdui->Effect = fl_bgn_form(FL_NO_BOX, 240+20*(nr_effects-1), 120+nr_channels*10);
     obj = fl_add_box(FL_UP_BOX,0,0,240+20*(nr_effects-1),120+nr_channels*10,"");
     obj = fl_add_box(FL_DOWN_BOX,50,10,20*(nr_effects-1),90,"");
  } 
  else{
     fdui->Effect = fl_bgn_form(FL_NO_BOX, 240+20*nr_effects, 120+nr_channels*10);
     obj = fl_add_box(FL_UP_BOX,0,0,240+20*nr_effects,120+nr_channels*10,"");
     obj = fl_add_box(FL_DOWN_BOX,50,10,20*nr_effects,90,"");
  }
 i=0;
 for(k=0;k<4;k++){
    for(l=0;l<16;l++){
       if( eff[k][l]==1 ){
         if ( !((k==0) && (l==14)) ) /* ungleich enhanced */
	   {
            obj = fl_add_bitmap(FL_NORMAL_BITMAP,52+nr*20,90-eff_bitmap_height[k][l],16,eff_bitmap_height[k][l],"");
            fl_set_bitmap_data(obj,16,eff_bitmap_height[k][l],eff_bitmap[k][l]);
            nr++;
            zaehl[i++]=k*16+l;
	   }
       }
    }
  }

  obj = fl_add_text(FL_NORMAL_TEXT,10,80,30,20,"Chn");
    fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,60+20*nr,80,170,20,\
  "Note               L     Volume       R              Instr.");    fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  obj = fl_add_box(FL_DOWN_BOX,10,10,30,60,"");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
  obj = fl_add_bitmap(FL_NORMAL_BITMAP,17,24,16,32,"");
    fl_set_bitmap_data(obj,16,32,effekt_label);
  obj = fl_add_box(FL_DOWN_BOX,60+nr*20,10,170,60,"");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
  obj = fl_add_text(FL_NORMAL_TEXT,85+nr*20,40,40,10,"Note");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,85+nr*20,50,40,10,"Time");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,85+nr*20,20,40,10,"Speed");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,85+nr*20,30,40,10,"BPM ");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
   obj = fl_add_text(FL_NORMAL_TEXT,140+nr*20,10,10,60,":\n:\n:\n:");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE); 

  fdui->disp_speed = obj = fl_add_text(FL_NORMAL_TEXT,155+nr*20,20,40,10,"5");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
  fdui->disp_bpm = obj = fl_add_text(FL_NORMAL_TEXT,155+nr*20,30,40,10,"78");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
  fdui->disp_note = obj = fl_add_text(FL_NORMAL_TEXT,155+nr*20,40,40,10,"17");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
  fdui->disp_time = obj = fl_add_text(FL_NORMAL_TEXT,155+nr*20,50,40,10,"00:00");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
  /* channels rahmen */
  obj = fl_add_box(FL_DOWN_BOX,10,110,30,10*nr_channels,"");
  /* note rahmen */
  obj = fl_add_box(FL_FRAME_BOX,60+nr*20,110-1,30,10*nr_channels+2,"");
  /* inst rahmen */
  obj = fl_add_box(FL_FRAME_BOX,200+nr*20,110-1,30,10*nr_channels+2,"");
 /* volmeter rahmen */
 //  obj = fl_add_box(FL_FRAME_BOX,100+nr*20,110-1,90,10*nr_channels+2,"");
 //  note und instr rahmen wegen textdarstellung 1 punkt zu gro
  /* channels spalte */
  for(k=0;k<nr_channels;k++)
  {
    sprintf(buf,"%2d",k+1);
    obj = fl_add_text(FL_NORMAL_TEXT,10,110+k*10,30,10,buf);
      fl_set_object_boxtype(obj,FL_NO_BOX);
      fl_set_object_lsize(obj,FL_TINY_SIZE);
      fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  }
  
  for(k=0;k<nr_channels;k++)
  {
   /* note spalte */
   fdui->note[k]= obj = fl_add_text(FL_NORMAL_TEXT,60+nr*20+2,110+k*10,30-4,10,"---");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);  
   // fl_set_object_lstyle(obj,FL_FIXED_STYLE);
   /* vol_l spalte */
   obj = fl_add_box(FL_FRAME_BOX,100+nr*20,110+k*10,45,10,"");
    fl_set_object_color(obj,FL_BLACK,FL_COL1);
    fl_set_object_lsize(obj,FL_TINY_SIZE);
   fdui->vol_l[k] = obj = fl_add_meter_l(FL_LIN_METER,103+nr*20,110+k*10+2,40,10-4,""); 
  /* vol_r spalte */
   obj = fl_add_box(FL_FRAME_BOX,145+nr*20,110+k*10,45,10,"");
    fl_set_object_color(obj,FL_BLACK,FL_COL1);
    fl_set_object_lsize(obj,FL_TINY_SIZE);
  fdui->vol_r[k]= obj = fl_add_meter_r(FL_LIN_METER,148+nr*20,110+k*10+2,40,10-4,""); 
  /* instr spalte */
  fdui->instr[k]=  obj = fl_add_text(FL_NORMAL_TEXT,200+nr*20+2,110+k*10,30-4,10,"---");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
 //   fl_set_object_lstyle(obj,FL_FIXED_STYLE);
  }   

  i=0;
  for(k=0;k<nr_channels;k++)
  {
    for(l=0;l<nr;l++)
    { 
      
      fdui->set_led[zaehl[i++]][k]= obj = fl_add_box(FL_DOWN_BOX,50+l*20,110+k*10,20,10,"");
            fl_set_object_color(obj,FL_PALEGREEN,FL_COL1);   
            fl_set_object_lsize(obj,FL_TINY_SIZE);
    }
    i=0;
  }
  
  fl_end_form();

  return fdui;
}

