#ifndef mod4xgui_h_
#define mod4xgui_h_

#include "forms.h"
#include "../modlib/player.h"



/* Volmeter */

FL_OBJECT *fl_create_meter(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label);

FL_OBJECT *fl_add_meter(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label);

void fl_set_meter(FL_OBJECT *ob,int val);

static int 
handle_meter(FL_OBJECT *ob,int event,FL_Coord mx,FL_Coord my,int key,
	      void *xev);
              
/* Levelmeter rechts/links -> effects by EB 28.4.*/

extern FL_OBJECT *
fl_create_meter_r(int type, FL_Coord x,FL_Coord y,\
        	           FL_Coord w,FL_Coord h, const char *label); 
extern FL_OBJECT *
fl_create_meter_l(int type, FL_Coord x,FL_Coord y,\
        	           FL_Coord w,FL_Coord h, const char *label); 
extern FL_OBJECT *
fl_add_meter_r(int type, FL_Coord x,FL_Coord y,\
                       FL_Coord w, FL_Coord h, const char *label);
extern FL_OBJECT *
fl_add_meter_l(int type, FL_Coord x,FL_Coord y,\
                       FL_Coord w, FL_Coord h, const char *label);

extern void fl_set_meter_r(FL_OBJECT*,int);
extern void fl_set_meter_l(FL_OBJECT*,int);

static int 
handle_meter_r(FL_OBJECT *ob,int event,FL_Coord mx,FL_Coord my,int key,
	      void *xev);
static int 
handle_meter_l(FL_OBJECT *ob,int event,FL_Coord mx,FL_Coord my,int key,
	      void *xev);

typedef struct {
  int value;      /* der anzuzeigende Wert */
  int x0;         /* x0 Koordinate    */
} SPEC_lr;

/* effect fenster struct */
typedef struct {
	byte  disp_speed;
	byte  disp_bpm;
	byte  disp_note;
	word  eff_led[64][32];
        byte  note[32];
        byte  vol_l[32];
        byte  vol_r[32];
        byte  instr[32];
} teffectsettings;


/**** Callback routines ****/

extern void shuffle_mode(FL_OBJECT *, long);
extern void Repeat_mode(FL_OBJECT *, long);
extern void Scan_mode(FL_OBJECT *, long);
extern void open_file(FL_OBJECT *, long);
extern void open_setup(FL_OBJECT *, long);
extern void show_info(FL_OBJECT *, long);
extern void Time_mode(FL_OBJECT *, long);
extern void show_effects(FL_OBJECT *, long);
extern void Skip_Fw(FL_OBJECT *, long);
extern void Fast_Forward(FL_OBJECT *, long);
extern void Skip_Rew(FL_OBJECT *, long);
extern void Pause(FL_OBJECT *, long);
extern void Play(FL_OBJECT *, long);
extern void Stop(FL_OBJECT *, long);
extern void Fast_Rew(FL_OBJECT *, long);
extern void main_chg_dsp(FL_OBJECT *, long);
extern void preamp(FL_OBJECT *,long);                  // Vorverst. 3.4.97

extern void OK_button(FL_OBJECT *, long);
extern void Cancel_button(FL_OBJECT *, long);
extern void file_browser_left(FL_OBJECT *, long);
extern void file_browser_right(FL_OBJECT *, long);
extern void setup_add(FL_OBJECT *, long);
extern void setup_add_all(FL_OBJECT *, long);
extern void setup_rem(FL_OBJECT *, long);
extern void file_rem_all(FL_OBJECT *, long);
extern void save_playlist(FL_OBJECT *, long);
extern void load_playlist(FL_OBJECT *, long);

extern void setup_khz(FL_OBJECT *, long);
extern void setup_channel(FL_OBJECT *, long);
extern void setup_bit(FL_OBJECT *, long);
extern void setup_bpm(FL_OBJECT *, long);
extern void setup_qmix(FL_OBJECT *, long);
extern void setup_surr(FL_OBJECT *, long);
extern void setup_ok(FL_OBJECT *, long);
extern void setup_save(FL_OBJECT *, long);
extern void setup_quit(FL_OBJECT *, long);
extern void setup_help(FL_OBJECT *, long);
extern void setup_after_open(FL_OBJECT *, long);
extern void setup_pause_after(FL_OBJECT *, long);
extern void setup_buff(FL_OBJECT *, long);
extern void setup_playl(FL_OBJECT *, long);



/**** Forms and Objects ****/

typedef struct {
	FL_FORM *Main;
	FL_OBJECT *main_panel;
	FL_OBJECT *Shuffle_button;
	FL_OBJECT *Repeat_button;
	FL_OBJECT *Scan_button;
	FL_OBJECT *Open_button;
	FL_OBJECT *Setup_button;
	FL_OBJECT *Info_button;
	FL_OBJECT *time_button;
	FL_OBJECT *Effects_button;
	FL_OBJECT *pause_button;
	FL_OBJECT *Play_button;
	FL_OBJECT *stop_button;
	FL_OBJECT *title_dsp;
	FL_OBJECT *sec_dsp;
	FL_OBJECT *min_dsp;
	FL_OBJECT *song_dsp;
	FL_OBJECT *total_dsp;
	FL_OBJECT *hz_dsp;
	FL_OBJECT *channels_dsp;
	FL_OBJECT *cpu_dsp;
	FL_OBJECT *bits_dsp;
	FL_OBJECT *vol_meter;
	FL_OBJECT *pattern_dsp;
	FL_OBJECT *maxpattern_dsp;
        FL_OBJECT *pre_amp;                      // Vorverst. 3.4.97
	FL_OBJECT *shuffle_dsp;
        FL_OBJECT *intro_dsp;
        FL_OBJECT *repeat_dsp;
	void *vdata;
	long ldata;
} FD_Main;

extern FD_Main * create_form_Main(void);
typedef struct {
	FL_FORM *OPEN;
	FL_OBJECT *open_panel;
	FL_OBJECT *file_ok;
	FL_OBJECT *file_cancel;
	FL_OBJECT *file_browser_left;
	FL_OBJECT *file_browser_right;
	FL_OBJECT *setup_add;
	FL_OBJECT *setup_add_all;
	FL_OBJECT *setup_rem;
	FL_OBJECT *file_rem_all;
	FL_OBJECT *save;
	FL_OBJECT *load;
	void *vdata;
	long ldata;
} FD_OPEN;
extern FD_OPEN * create_form_OPEN(void);

typedef struct {
	FL_FORM *SETUP;
	FL_OBJECT *setup_panel;
	FL_OBJECT *hz_slider;
	FL_OBJECT *chnsett_grp;
	FL_OBJECT *depthsett_grp;
	FL_OBJECT *BPMsett_grp;
	FL_OBJECT *Q_mixsett_grp;
	FL_OBJECT *surrsett_grp;
	FL_OBJECT *num_buff_dsp;
        FL_OBJECT *switch_auto;  	// new 21.3. by EB      
	FL_OBJECT *auto_play_dsp;
        FL_OBJECT *switch_pause;	// new 21.3. by EB
	FL_OBJECT *pause_after_dsp;
	FL_OBJECT *Setup_pl;
	void *vdata;
	long ldata;
} FD_SETUP;
extern FD_SETUP * create_form_SETUP(void);

typedef struct {
	FL_FORM *info;
	FL_OBJECT *info_title;
	FL_OBJECT *browser_left;
	FL_OBJECT *browser_right;
	FL_OBJECT *browser_bottom;
	void *vdata;
	long ldata;
} FD_info;
extern FD_info * create_form_info(void);

typedef struct {
	FL_FORM *Effect;
	FL_OBJECT *disp_speed;
	FL_OBJECT *disp_bpm;
	FL_OBJECT *disp_note;
	FL_OBJECT *disp_time;
	FL_OBJECT *set_led[64][32];
        FL_OBJECT *note[32];
        FL_OBJECT *vol_l[32];
        FL_OBJECT *vol_r[32];
        FL_OBJECT *instr[32];
	void *vdata;
	long ldata;
} FD_Effect;
extern FD_Effect * create_form_Effect(int nr_channels,int nr_effects);



/**** last Windows position ****/

typedef struct {
	FL_Coord  mod_x;	// int
	FL_Coord  mod_y;
	FL_Coord  inf_x;
        FL_Coord  inf_y;
        FL_Coord  eff_x;
        FL_Coord  eff_y;
	Window	  mod_id; 	// unsigned long 
        Window	  inf_id; 
        Window	  eff_id; 
} win_pos;

#endif 
