#include "forms.h"
#include "mod4xgui.h"
#include "mod4xgui_my.h"
#include "../modlib/player.h"
//#include "../modlib/test_file.h"
#include "playlist.h"

#define PIXMAPBUTTONS

#ifdef PIXMAPBUTTONS
#include "bitmaps/buttonpix.h"
#endif

#include <sys/types.h>
#include <sys/stat.h>
 
extern   FD_Main *fd_Main;
extern   FD_OPEN *fd_OPEN;
extern   FD_SETUP *fd_SETUP;
extern   FD_info *fd_info;
extern   FD_Effect *fd_Effect;

extern word numpatterns;
extern word numinstruments;
extern int currfile,time;
extern tsettings soundsettings;
extern word numtracks;


extern char* Mount_Path;
extern char* Home_Dir;

extern char   eff_stat;
extern int    new_song;
extern win_pos	win_position;



int total_files ;
tsettings ssettings;
char titlemode,info_stat;

char SearchMode;
int searchdir;
int PlayMode;




/* callbacks for form Main */
void shuffle_mode(FL_OBJECT *ob, long data)
{
  PlayMode= (PlayMode==SHUFFLE_MODE) ? NORMAL_MODE : SHUFFLE_MODE;
  if (PlayMode==SHUFFLE_MODE)
     fl_set_object_label(fd_Main->shuffle_dsp,"Shuffle");
  else
    fl_set_object_label(fd_Main->shuffle_dsp,"");
    
}

void Repeat_mode(FL_OBJECT *ob, long data)
{
  PlayMode= (PlayMode==REPEAT_MODE) ? NORMAL_MODE : REPEAT_MODE;
   if (PlayMode==REPEAT_MODE)
     fl_set_object_label(fd_Main->repeat_dsp,"Repeat");
   else
     fl_set_object_label(fd_Main->repeat_dsp,"");
}

void Scan_mode(FL_OBJECT *ob, long data)
{
  PlayMode= (PlayMode==INTROSCAN_MODE) ? NORMAL_MODE : INTROSCAN_MODE;
   if (PlayMode==INTROSCAN_MODE)
     fl_set_object_label(fd_Main->intro_dsp,"Intro");
   else
     fl_set_object_label(fd_Main->intro_dsp,"");
}

void open_file(FL_OBJECT *ob, long data)
{
  save_tmp_playlist();
  fl_show_form(fd_OPEN->OPEN,FL_PLACE_CENTER,FL_FULLBORDER,"Playlist");
}

void open_setup(FL_OBJECT *ob, long data)
{
  fl_show_form(fd_SETUP->SETUP,FL_PLACE_CENTER,FL_FULLBORDER,"Setup");
}

void show_info(FL_OBJECT *ob, long data)
{
  FL_Coord w,h;

  info_stat^=1;
  if (info_stat){
     fl_set_form_position(fd_info->info,win_position.inf_x-5,win_position.inf_y-22);
     win_position.inf_id=fl_show_form(fd_info->info,FL_PLACE_POSITION,FL_FULLBORDER,"ModInfo");
  }
  else {
     if(fl_winisvalid(win_position.inf_id))
          fl_get_wingeometry(win_position.inf_id, &win_position.inf_x,&win_position.inf_y,&w,&h); 
    fl_hide_form(fd_info->info);
  }
}

void Time_mode(FL_OBJECT *ob, long data)
{
  dispmode^=1;
}

void show_effects(FL_OBJECT *ob, long data)
{
 FL_Coord w,h;

 if (eff_stat==1){    
      eff_stat=0;
      if(fl_winisvalid(win_position.eff_id))
          fl_get_wingeometry(win_position.eff_id, &win_position.eff_x,&win_position.eff_y,&w,&h); 
      fl_hide_form(fd_Effect->Effect);
 }
 else 
      if (eff_stat==0){
	 fl_set_form_position(fd_Effect->Effect,win_position.eff_x-5,win_position.eff_y-22);
         win_position.eff_id=fl_show_form(fd_Effect->Effect,FL_PLACE_POSITION,FL_FULLBORDER,"Effects");     
         eff_stat=1;
      }

}

void Skip_Fw(FL_OBJECT *ob, long data)
{
  FL_OBJECT *brow=fd_OPEN->file_browser_right;

  if (currfile<total_files){
    currfile++;
    if (!titlemode)
      fl_set_object_label(fd_Main->title_dsp,fl_get_browser_line(brow,currfile));
    else
      fl_set_object_label(fd_Main->title_dsp,modname);
    fl_set_object_label(fd_Main->song_dsp,itoasc(currfile,3));
  }
  if (playing) {
    stop();
    Play(NULL,0);
    /*play(fl_get_browser_line(brow,currfile),soundsettings,0);*/
  }
  new_song=1;
}

void Fast_Forward(FL_OBJECT *ob, long data)
{
  /*Spielen im Search Modus*/
  searchdir=1;
  SearchMode^=1;
  if (SearchMode){
#ifdef PIXMAPBUTTONS
     fl_set_pixmapbutton_data(ob,bff_pres_xpm);
#endif
     deactivatesound();
  }else{
#ifdef PIXMAPBUTTONS
    fl_set_pixmapbutton_data(ob,bff_nor_xpm);
#endif
     if (!activatesound()) search_time(time*1000);
    else 
      stop();
  }
}

void Fast_Rew(FL_OBJECT *ob, long data)
{
   /*Spielen im Search Modus*/
  searchdir=-1;
  SearchMode^=1;
  if (SearchMode){
    /*show the pressed button*/
#ifdef PIXMAPBUTTONS
     fl_set_pixmapbutton_data(ob,bfr_pres_xpm);
#endif
     deactivatesound();
  }else{
    /*show the normal button*/
#ifdef PIXMAPBUTTONS
     fl_set_pixmapbutton_data(ob,bfr_nor_xpm);
#endif     
     if (!activatesound()) search_time(time*1000);
    else 
      stop();
  }
}

void Skip_Rew(FL_OBJECT *ob, long data)
{
  FL_OBJECT *brow=fd_OPEN->file_browser_right;
  if (currfile>1){
    currfile--;
    if (!titlemode)
      fl_set_object_label(fd_Main->title_dsp,fl_get_browser_line(brow,currfile));
    else
      fl_set_object_label(fd_Main->title_dsp,modname);
    fl_set_object_label(fd_Main->song_dsp,itoasc(currfile,3));
  }
  if (playing) {
    stop();
    Play(NULL,0);
    /*play(fl_get_browser_line(brow,currfile),soundsettings,0);*/
  }
  new_song=1;
}

void Pause(FL_OBJECT *ob, long data)
{
  if (!playing) return;
#ifdef PIXMAPBUTTONS
  fl_set_pixmapbutton_data(ob,bpause_pres_xpm);
  /*turn off play button*/
  fl_set_pixmapbutton_data(fd_Main->Play_button,bplay_nor_xpm);
#endif
   Pause_=1;playing=0;
  deactivatesound();
}





void Play(FL_OBJECT *ob, long data)
{
  char *tmp;
  int i;
  char buf[256];

  FL_OBJECT *brow=fd_OPEN->file_browser_right;
  FL_OBJECT *browl=fd_info->browser_left;
  FL_OBJECT *browr=fd_info->browser_right;
  FL_OBJECT *browb=fd_info->browser_bottom;

  /*return if no valid file to play*/
  fl_call_object_callback(fd_SETUP->Setup_pl);         

  if (!fl_get_browser_line(brow,currfile)) return;
  
  if (Pause_){
    /*we are in "pause" state*/
    if (ob){
#ifdef PIXMAPBUTTONS
      /*turn on play button*/
      fl_set_pixmapbutton_data(ob,bplay_pres_xpm);
      /*turn off pause button*/
      fl_set_pixmapbutton_data(fd_Main->pause_button,bpause_nor_xpm);
#endif
    }
    Pause_=0;
    playing=1;
    activatesound();
    return;
  }
#ifdef PIXMAPBUTTONS     
 if (ob)  fl_set_pixmapbutton_data(ob,bplay_pres_xpm);
#endif

  if (currfile && (currfile<=total_files)){
        play(tmp=complete_file((char*)fl_get_browser_line(brow,currfile)),
	  soundsettings,0);
        free(tmp);
	fl_set_object_label(fd_Main->maxpattern_dsp,itoasc(numpatterns,3));
  }else 
    currfile=1;
  if (!titlemode)
      fl_set_object_label(fd_Main->title_dsp,fl_get_browser_line(brow,currfile));
    else
      fl_set_object_label(fd_Main->title_dsp,modname);
  fl_set_object_label(fd_Main->song_dsp,itoasc(currfile,3));
  fl_set_object_label(fd_Main->channels_dsp,itoasc(numtracks,2));
  
  fl_freeze_form(fd_info->info);
  fl_clear_browser(browl);
  fl_clear_browser(browr);
  fl_clear_browser(browb);

  for(i=0;i<(numinstruments/2);i++){
    fl_add_browser_line(browl,instruments[i].name);
    /*fl_add_browser_line(browl,"@-");*/
  }
  for(i=numinstruments/2;i<numinstruments;i++)
    fl_add_browser_line(browr,instruments[i].name);
  sprintf(buf,"@c%d Kanal Module mit %d Instrumenten",numtracks,numinstruments);
  fl_add_browser_line(browb,buf);
  sprintf(buf,"@cFile: %dkB",filesiz);
  fl_add_browser_line(browb,buf);
  sprintf(buf,"@c%d von %d Pattern sind verschieden.",diffpatterns,numpatterns);
  fl_add_browser_line(browb,buf);
  
  fl_set_object_label(fd_info->info_title,modname);
    
  fl_unfreeze_form(fd_info->info);

  new_song=1;
}

void Stop(FL_OBJECT *ob, long data)
{
#ifdef PIXMAPBUTTONS
   fl_set_pixmapbutton_data(fd_Main->Play_button,bplay_nor_xpm);
#endif
   /* stop playing */
 stop();
 new_song=1;
}



void main_chg_dsp(FL_OBJECT *ob, long data)
{
  titlemode=data;
  if (!titlemode)
      fl_set_object_label(fd_Main->title_dsp,fl_get_browser_line(fd_OPEN->file_browser_right
								 ,currfile));
    else
      fl_set_object_label(fd_Main->title_dsp,modname);
}

void preamp(FL_OBJECT *ob,long data)
{
   ssettings.preamp=20-(byte) fl_get_slider_value(fd_Main->pre_amp);   
   if (playing)
     settingschanged(ssettings);
   else
     soundsettings=ssettings;

}




/****************** callbacks for form OPEN *********************************/

void file_browser_left_dc(FL_OBJECT *ob, long data)
{
  int ln,i;
  char *str1;
  char str[256];
  
  struct stat status;
  FL_OBJECT *browl=fd_OPEN->file_browser_left;
  FL_OBJECT *browr=fd_OPEN->file_browser_right;
  /* return if mouse is not released yet */
  /*fl_print_xevent_name("test:",fl_last_event());*/
  /*if (fl_last_event()->type!=ButtonPress) return;*/
  
  ln=abs(fl_get_browser(browl));
  str1=(char*)fl_get_browser_line(browl,ln);

  
  strcpy(str,str1+4);
//  printf("%s %s %s \n",str,str1,str2);
  stat(str,&status);
  fl_freeze_form(fd_OPEN->OPEN);

  if ((status.st_mode & S_IFDIR) == S_IFDIR){
    /* ist ein Directory */
    fl_clear_browser(browl);
    if (chdir(str) == -1) perror(str);
    disp_dir(".","*");
        fl_deselect_browser(browl);
  }
  fl_unfreeze_form(fd_OPEN->OPEN);

  /* else{
     ist es eine playlist 
    if ( strstr(str,".mol")){
      get_play_dirs(str);
      get_play_files(str); 
      fl_clear_browser(browr);
      for(i=0;dir_list[i]!=NULL;i++) fl_add_browser_line(browr,file_list[i]);
      fl_deselect_browser(browl);
     }
  }*/  
}

void OK_button(FL_OBJECT *ob, long data)
{
  FL_OBJECT *browr=fd_OPEN->file_browser_right;
  fl_hide_form(fd_OPEN->OPEN);
  fl_set_object_label(fd_Main->title_dsp,fl_get_browser_line(browr,1));
  currfile=1;/*mit File Nr 1 anfangen*/
  total_files=fl_get_browser_maxline(browr);
  fl_set_object_label(fd_Main->total_dsp,itoasc(total_files,3));
  free_tmp_playlist();
}

void Cancel_button(FL_OBJECT *ob, long data)
{
  int k=0;
  FL_OBJECT *browr=fd_OPEN->file_browser_right;


  int total_lines = fl_get_browser_maxline(browr);
 
  fl_freeze_form(fd_OPEN->OPEN);
  for(k=1;k<=total_lines;k++){
    fl_delete_browser_line(browr,k);
    total_lines--;k--;
  }
  k=0; 
  clear_all_lists();
  restore_tmp_playlist();
  while ( file_list[k] != NULL )
            fl_add_browser_line(browr,file_list[k++]);
  fl_set_object_label(fd_Main->title_dsp,fl_get_browser_line(browr,1));
  currfile=1;
  total_files=fl_get_browser_maxline(browr);
  fl_set_object_label(fd_Main->total_dsp,itoasc(total_files,3));
  fl_unfreeze_form(fd_OPEN->OPEN);
  fl_clear_browser(fd_OPEN->file_browser_left);
  disp_dir(".","*");
  fl_hide_form(fd_OPEN->OPEN);
}

void load_playlist(FL_OBJECT *ob, long data)
{
  // changed by EB 8.2.97
  char *file;
  int k=0;
  FL_OBJECT *browr=fd_OPEN->file_browser_right;

  if (file=(char*)fl_show_fselector("Load Playlist",".","*.mol",""))
  {
    if( load_pl(file) != 0 )
       	printf("\nError: Load playlist!\n ");
    else
    {
      /* get_play_dirs(file); get_play_files(file); */
      fl_clear_browser(browr); 
      while ( file_list[k] != NULL )
            fl_add_browser_line(browr,file_list[k++]);
    }
  }
}

void save_playlist(FL_OBJECT *ob, long data)
{
  char* file_name;
  
  if (file_name=(char*)fl_show_fselector("Save Playlist",".","*.mol","playlist.mol"))
      if (save_pl_to_file(file_name)!=0)
       fl_show_alert("Warning !","Error while saving playlist to file !",\
                     "(Do you have write permission on this directory ?)",0);
}


void file_browser_left(FL_OBJECT *ob, long data)
{

}

void file_browser_right(FL_OBJECT *ob, long data)
{

}

void setup_add(FL_OBJECT *ob, long data)
{
  /* add all selected (regular) file to playlist - EB 6.2.97 */
  const char* brow_line;
  char str[256];

  FL_OBJECT *browl=fd_OPEN->file_browser_left;
  FL_OBJECT *browr=fd_OPEN->file_browser_right;
  int total_lines = fl_get_browser_maxline(browl);
  int i;
  fl_freeze_form(fd_OPEN->OPEN);
  for(i=1;i<=total_lines;i++)
    if (fl_isselected_browser_line(browl,i))
    {
      brow_line=fl_get_browser_line(browl,i);
      strcpy(str,brow_line+4);
      if ( test_file(str) != 1 )
          fl_deselect_browser_line(browl,i);
      else
      { 
        add_file_to_pl(str);
        fl_add_browser_line(browr,str);
        fl_delete_browser_line(browl,i);        
        total_lines--; i--;
      }
    }  
  fl_unfreeze_form(fd_OPEN->OPEN);
}

void setup_add_all(FL_OBJECT *ob, long data)
{
  /* add all (regular) files to playlist - EB 6.2.97 */
  const char* brow_line;
  char str[255];
  FL_OBJECT *browl=fd_OPEN->file_browser_left;
  FL_OBJECT *browr=fd_OPEN->file_browser_right;
  int total_lines = fl_get_browser_maxline(browl);
  int i;
    
  fl_freeze_form(fd_OPEN->OPEN);
  for(i=1;i<=total_lines;i++)
  {
    brow_line=fl_get_browser_line(browl,i);
    strcpy(str,brow_line+4);
    if ( test_file(str) != 1 )
      fl_deselect_browser_line(browl,i);
    else
    { 
     add_file_to_pl(str);
     fl_add_browser_line(browr,str);
     fl_delete_browser_line(browl,i);
     total_lines--; i--;
    }    
  }
  fl_unfreeze_form(fd_OPEN->OPEN);
}

void setup_rem(FL_OBJECT *ob, long data)
{
  // changed by EB 8.2.97
  
  FL_OBJECT *browl=fd_OPEN->file_browser_left;
  FL_OBJECT *browr=fd_OPEN->file_browser_right;
  int total_lines = fl_get_browser_maxline(browr);
  int i;

  fl_freeze_form(fd_OPEN->OPEN);
  for(i=1;i<=total_lines;i++)
    if (fl_isselected_browser_line(browr,i))
    {
      fl_add_browser_line(browl,fl_get_browser_line(browr,i));
      del_file_from_pl((char*)fl_get_browser_line(browr,i));
      fl_delete_browser_line(browr,i);
      total_lines--;i--;
    }
  fl_unfreeze_form(fd_OPEN->OPEN);
  fl_clear_browser(fd_OPEN->file_browser_left);
  disp_dir(".","*");
}

void file_rem_all(FL_OBJECT *ob, long data)
{
  // changed by EB 8.2.97
  
  FL_OBJECT *browl=fd_OPEN->file_browser_left;
  FL_OBJECT *browr=fd_OPEN->file_browser_right;
  int total_lines = fl_get_browser_maxline(browr);
  int i;
  fl_freeze_form(fd_OPEN->OPEN);
  for(i=1;i<=total_lines;i++){
    fl_add_browser_line(browl,fl_get_browser_line(browr,i));
    del_file_from_pl((char*)fl_get_browser_line(browr,i));
    fl_delete_browser_line(browr,i);
    total_lines--;i--;
  }
  fl_unfreeze_form(fd_OPEN->OPEN);
  fl_clear_browser(fd_OPEN->file_browser_left);
  disp_dir(".","*");
}


/************** callbacks for form SETUP ***********************************/
void setup_khz(FL_OBJECT *ob, long data)
{
  ssettings.samplerate=(word)fl_get_slider_value(fd_SETUP->hz_slider)*1000;
}

void setup_channel(FL_OBJECT *ob, long data)
{
  ssettings.stereo=data;
}

void setup_bit(FL_OBJECT *ob, long data)
{
  ssettings.bits=data*8;
}

void setup_bpm(FL_OBJECT *ob, long data)
{
  ssettings.nobpm=data;
}

void setup_qmix(FL_OBJECT *ob, long data)
{
  ssettings.quality=data;
}

void setup_surr(FL_OBJECT *ob, long data)
{
  ssettings.surround=data;
}

void setup_ok(FL_OBJECT *ob, long data)
{
  fl_call_object_callback(fd_SETUP->Setup_pl);         
  if (playing)
     settingschanged(ssettings);
  else
     soundsettings=ssettings;
  fl_set_object_label(fd_Main->hz_dsp,itoasc(soundsettings.samplerate,5));
  fl_set_object_label(fd_Main->bits_dsp,itoasc(soundsettings.bits,2));
  fl_set_object_label(fd_SETUP->num_buff_dsp,itoasc(soundsettings.nbuffers,2));
}

void setup_save(FL_OBJECT *ob, long data)
{
  /* save settings from setup-menue */
   char 	file_name[255];
   FILE* 	file_ptr;
   FL_Coord	w,h;

   /* hol aktuelle fensterpositionen */
   if (fl_winisvalid(win_position.mod_id))
     fl_get_wingeometry(win_position.mod_id, &win_position.mod_x,&win_position.mod_y,&w,&h); 
   if (fl_winisvalid(win_position.inf_id))
     fl_get_wingeometry(win_position.inf_id, &win_position.inf_x,&win_position.inf_y,&w,&h); 
   if(fl_winisvalid(win_position.eff_id))
     fl_get_wingeometry(win_position.eff_id, &win_position.eff_x,&win_position.eff_y,&w,&h); 


   strcpy(file_name,Home_Dir);
   strcat(file_name,"/.mod4Xwin"); 		
   if ( (file_ptr=fopen(file_name,"w+")) == NULL)
         fprintf(stderr,"\nWarning: Couldn't write settings to ~/.mod4Xwin ! \n");
   else
   {
         fl_call_object_callback(fd_SETUP->Setup_pl); 
         fprintf(file_ptr,"[State]\n");
         fprintf(file_ptr,"LastPlaylistDir= %s\n",ssettings.name);
         fprintf(file_ptr,"PauseWhileSetup= %d\n",(int)fl_get_slider_value(fd_SETUP->switch_pause) );
         fprintf(file_ptr,"PlayOnLoad= %d\n",(int)fl_get_slider_value(fd_SETUP->switch_auto) ); 
   
         fprintf(file_ptr,"[Sampling]\n");
         fprintf(file_ptr,"PreAmplification= %d\n",(int) ssettings.preamp);
         fprintf(file_ptr,"SampleRate= %d\n",(int)ssettings.samplerate  );
         fprintf(file_ptr,"BitsPerSample= %d\n",(int)ssettings.bits  );
         fprintf(file_ptr,"Channels= %d\n",ssettings.stereo  );
         fprintf(file_ptr,"OutputBuffers= %d\n",ssettings.nbuffers  );
         fprintf(file_ptr,"Surround= %d\n",ssettings.surround  );
         fprintf(file_ptr,"Q_Mix= %d\n",ssettings.quality  );
         fprintf(file_ptr,"BPM= %d\n",ssettings.nobpm  );
         fprintf(file_ptr,"[Position]\n");
         fprintf(file_ptr,"mod_x= %d\n", win_position.mod_x);      
         fprintf(file_ptr,"mod_y= %d\n", win_position.mod_y);      
         fprintf(file_ptr,"inf_x= %d\n", win_position.inf_x);      
         fprintf(file_ptr,"inf_y= %d\n", win_position.inf_y);      
         fprintf(file_ptr,"eff_x= %d\n", win_position.eff_x);      
         fprintf(file_ptr,"eff_y= %d\n", win_position.eff_y);                        
   	 fclose(file_ptr);
   }
}

void setup_quit(FL_OBJECT *ob, long data)
{
  fl_hide_form(fd_SETUP->SETUP);
  fl_set_object_label(fd_Main->hz_dsp,itoasc(soundsettings.samplerate,5));
  fl_set_object_label(fd_Main->bits_dsp,itoasc(soundsettings.bits,2));
  fl_set_object_label(fd_SETUP->num_buff_dsp,itoasc(soundsettings.nbuffers,2));
}

void setup_help(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
}

void setup_playl(FL_OBJECT *ob, long data)
{
  Mount_Path=(char*)fl_get_input(fd_SETUP->Setup_pl);
  strncpy(ssettings.name,Mount_Path,39);	// by EB 20.3.97
}

void setup_after_open(FL_OBJECT *ob, long data)
{
   /* changed 5.2.97 by EB */
   double akt_pos;
   akt_pos=fl_get_slider_value(ob);
   if (akt_pos > 0.5)
   {	
     fl_set_slider_value(ob,1.0);
     fl_set_object_label(fd_SETUP->auto_play_dsp,"-EIN-");
     /* set var=ON */
   }  
   else
   {
     fl_set_object_label(fd_SETUP->auto_play_dsp,"-AUS-");
     fl_set_slider_value(ob,0.0);
     /* set var=OFF */
   }  
}

void setup_pause_after(FL_OBJECT *ob, long data)
{
    /* changed 5.2.97 by EB */
   double akt_pos;
   akt_pos=fl_get_slider_value(ob);
   if (akt_pos > 0.5)
   {	
     fl_set_slider_value(ob,1.0);
     fl_set_object_label(fd_SETUP->pause_after_dsp,"-EIN-");
     /* set var=ON */
   }  
   else
   {
     fl_set_object_label(fd_SETUP->pause_after_dsp,"-AUS-");
     fl_set_slider_value(ob,0.0);
     /* set var=OFF */
   }
}

void setup_buff(FL_OBJECT *ob, long data)
{
  if (data) ssettings.nbuffers++;else ssettings.nbuffers--;
   fl_set_object_label(fd_SETUP->num_buff_dsp,itoasc(ssettings.nbuffers,2));
}

























