#include "forms.h"
#include "mod4xgui.h"
#include "../modlib/player.h"

#include <sys/types.h>
#include <stdio.h>
#include <stddef.h>
#include <dirent.h>

#include "./bitmaps/ModPlayer.xpm"

#include <string.h> 
#include <stdlib.h> 

#define VERSION "mod4Xwin alpha 0.4"
#define	MAX_NAME_LEN	(255)

FD_Main   *fd_Main;
FD_OPEN   *fd_OPEN;
FD_SETUP  *fd_SETUP;
FD_info   *fd_info;
FD_Effect *fd_Effect;

word eff[4][16];           /* korrospondiert mit stand./pro/extra/extra1 */
int nr_ch,nr_eff;
teffectsettings eff_new,eff_old;
Pixmap pixid;
int new_song;
char eff_stat;

win_pos	win_position;

byte  pttrn_old;
unsigned int time_old;
unsigned int time;

extern tsettings soundsettings,ssettings;
extern char SearchMode;
extern word numtracks;
extern int searchdir;

extern byte speed;
extern byte currnote;
extern byte currbpm;
extern int  currlevel;

extern word proeffectsused;
extern word effectsused;
extern word extraeffused;
extern word extraeffused1;

static char* note_table[]={"C-","C#","D-","D#","E-","F-","F#","G-","G#","A-","A#","B-"}; 
/* Notenzuordnung anhand Demofile generiert mittels screamtracker (scream30)
 0 0 
 1 C-1 
 2 C#1 
 3 D-1
 4 D#1
 5 E-1
 6 F-1
 7 F#1
 8 G-1
 9 G#1
10 A-1
11 A#1
12 B-1
13 C-2  2.Oktave
 :
1 -12   1.Oktave
13-24   2.Oktave
 ...    ... 
85-96   8.Oktave  
 */



Pixmap pixid;          // effect fenster wird in idle fkt generiert 


void  file_browser_left_dc(FL_OBJECT *ob, long data);
char  dispmode;
char* Mount_Path; 
char* Home_Dir;

int currfile; /* die nummer in der playlist des zu spielenden files*/



/*convertiert zahlen von cptr Stellen in AsciiString*/
char * itoasc(register unsigned int n,register unsigned char cptr)
{
static char Hstr[30];

  Hstr[cptr]=0;
  while (cptr) {
    Hstr[--cptr]='0'+(n%10);
    n/=10;
  }
  return Hstr;
}

extern string filename;
extern int filetype;
static byte *pbuffer;

void disp_dir(const char* dir,const char* filter)
{
  DIR *dirstream;
  struct dirent *entry;
  char str[1024];
 
 
  dirstream=opendir(dir);
 
  entry=readdir(dirstream);
  fl_freeze_form(fd_OPEN->OPEN);
  while ((entry!=NULL) && (1))
  {
     switch (test_file(entry->d_name)){
     	   case 0:{	
                	//printf("\n Fehler 0: Datei existiert nicht !\n");
                  } 
                  break;
	   case 1:{     /* ist modfile */
                        sprintf(str,"@C2 %s",entry->d_name);            
                        fl_add_browser_line(fd_OPEN->file_browser_left,str);
                  } 
                  break;
	   case 2:{
                  	/* ist ein Directory */
                        sprintf(str,"@C1 %s",entry->d_name);
                        fl_add_browser_line(fd_OPEN->file_browser_left,str);       
                   }
                   break;      
	   case 3:{     /* sonstiges file */
                         sprintf(str,"@C4 %s",entry->d_name);            
                         fl_add_browser_line(fd_OPEN->file_browser_left,str);
                   }
                   break;
           case 4:{
	                 //printf("Keine Read Permission in %s ! \n",entry->d_name);
	           }
	           break;
           default:{ 	
	                // printf("\n sonstiger Fehler bei disp_dir()!\n");
	           }
	           break;
     }         
     entry=readdir(dirstream);
  }
  fl_unfreeze_form(fd_OPEN->OPEN);
  closedir(dirstream);
}

void play_a_buffer(XEvent* xev,void* dta){
  /*itimerval Tval;*/
  int val=0,k,i;
  int	z=0;
  int 	sp=0;
  int   n,l;  
  char 	cbuf[20];
  int   note,oktave;  
  FL_Coord w,h;

  if (!playing || Pause_) return;
  if (SearchMode){
    /*gettimeofday(&Tval);*/
    if (time<(totaltime/1000)&&(time>0)) time+=searchdir;
  }else{
    time=dispmode ? (totaltime-currtime)/1000:currtime/1000; /* in sec */
    playone();
  }
  if(mod_end) {currfile++;fl_call_object_callback(fd_Main->Play_button);}
  if (currpttrn!=pttrn_old){
    fl_set_object_label(fd_Main->pattern_dsp,itoasc(currpttrn,3));
    pttrn_old=currpttrn;
  }
  if (time!=time_old){
    time_old=time;
    fl_set_object_label(fd_Main->min_dsp,itoasc(time/60,2));
    fl_set_object_label(fd_Main->sec_dsp,itoasc(time%60,2));
 }
  fl_set_meter(fd_Main->vol_meter, soundsettings.bits==8 ? currlevel : currlevel );


 /* effekte  */

 if (new_song == 1)
 {
  if(eff_stat == 1)
  {
     if(fl_winisvalid(win_position.eff_id))
          fl_get_wingeometry(win_position.eff_id, &win_position.eff_x,&win_position.eff_y,&w,&h); 
     fl_hide_form(fd_Effect->Effect);
  }
  if(eff_stat != 2)
     fl_free_form(fd_Effect->Effect);
  
  nr_eff=0;
  for(l=0;l<16;l++)
  {
     eff[0][l]=(effectsused >> l) & 0x1;
     eff[1][l]=(proeffectsused >> l) & 0x1;
     eff[2][l]=(extraeffused >> l) & 0x1;
     eff[3][l]=(extraeffused1 >> l) & 0x1;
  }
  for (i=0;i<4;i++){
    for(l=0;l<16;l++){
        nr_eff+=eff[i][l];
    }
  }

  nr_ch=numtracks;
  fd_Effect = create_form_Effect(nr_ch,nr_eff);
  fl_set_form_icon(fd_Effect->Effect,pixid,0);
  fl_set_form_position(fd_Effect->Effect,win_position.eff_x-5,win_position.eff_y-22);
  sprintf(cbuf,"%d:%02d ",(totaltime/1000)/60,(totaltime/1000)%60 );
  fl_set_object_label(fd_Effect->disp_time,cbuf);
 
  if (eff_stat==1)
     win_position.eff_id=fl_show_form(fd_Effect->Effect,FL_PLACE_POSITION,FL_FULLBORDER,"Effects");
  if (eff_stat==2) 
     eff_stat=0;
  new_song=0;
 }
 if (eff_stat==1)
 {  
    fl_freeze_form(fd_Effect->Effect);                                       
    eff_new.disp_speed= speed;
    eff_new.disp_bpm  = currbpm;
    eff_new.disp_note = currnote;
   
// printf("bpmspd:  %c  %d spd: %c  %d  \n",bpmspeed,bpmspeed,speed,speed);

    for(l=0;l<nr_ch;l++) {
        eff_new.note[l] =currnotes[l];
        eff_new.vol_l[l]=currvols[l];
        eff_new.vol_r[l]=currvols[l];
        eff_new.instr[l]=currinstr[l];

        for(k=0;k<16;k++)
        {
          eff_new.eff_led[k][l]   =(curreffects[l]    >> k) & 0x1;
          eff_new.eff_led[k+16][l]=(currproeffects[l] >> k) & 0x1;
          eff_new.eff_led[k+32][l]=(currextraeff[l]   >> k) & 0x1;
          eff_new.eff_led[k+48][l]=(currextraeff1[l]  >> k) & 0x1;
	}
    }


   // neu malen wenn neuer Effekt != alter Effekt 

    if ( eff_new.disp_speed != eff_old.disp_speed){
      sprintf(cbuf,"%u",eff_new.disp_speed);
      fl_set_object_label(fd_Effect->disp_speed,cbuf);
    } 
    if ( eff_new.disp_bpm != eff_old.disp_bpm ){
      sprintf(cbuf,"%u",eff_new.disp_bpm);
      fl_set_object_label(fd_Effect->disp_bpm,cbuf);
    } 
    if ( eff_new.disp_note != eff_old.disp_note ){
      sprintf(cbuf,"%u",eff_new.disp_note);
      fl_set_object_label(fd_Effect->disp_note,cbuf); 
    }
 
    for(l=0;l<nr_ch;l++){
       if( eff_new.note[l] != eff_old.note[l] ){
          if(eff_new.note[l]!= 0) 
          {
          	oktave= (eff_new.note[l]/12)+1; // 1 ... 8
                note  = (eff_new.note[l]%12);   
                if (!note) {
                   oktave--;
                   note=11;
                }
                else
                   note--; // 0 ... 11
            
                sprintf(cbuf,"%s%d",note_table[note],oktave);
          }
          else
             	sprintf(cbuf,"---");
          fl_set_object_label(fd_Effect->note[l],cbuf);
       }
       if( eff_new.instr[l] != eff_old.instr[l] ){
          if ( eff_new.instr[l] != 0)
             sprintf(cbuf,"%3d",eff_new.instr[l]);
          else
             sprintf(cbuf,"---");
       fl_set_object_label(fd_Effect->instr[l],cbuf);
       }
       if( eff_new.vol_l[l] != eff_old.vol_l[l] )
          fl_set_meter_l(fd_Effect->vol_l[l],(int)eff_new.vol_l[l]);
       if( eff_new.vol_r[l] != eff_old.vol_r[l] )
          fl_set_meter_r(fd_Effect->vol_r[l],(int)eff_new.vol_r[l]);
    }

    for(sp=0; sp < 64; sp++)
    {
      for(z=0;z<nr_ch;z++){
         if( eff_new.eff_led[sp][z] !=  eff_old.eff_led[sp][z]){
            if ( eff_new.eff_led[sp][z] && (fd_Effect->set_led[sp][z] != NULL) )
                      fl_set_object_color(fd_Effect->set_led[sp][z],FL_GREEN,FL_COL1);   // 64 x 32  
            else{
               if (fd_Effect->set_led[sp][z] != NULL)
                  fl_set_object_color(fd_Effect->set_led[sp][z],FL_PALEGREEN,FL_COL1); 
            // else
                 // printf(" error sp: %d  z: %d\n ",sp,z);
            }
         }
      }
    }
    fl_unfreeze_form(fd_Effect->Effect);      
    memcpy(&eff_old,&eff_new,sizeof(eff_new));
    //memset(&eff_new,0,sizeof(eff_new));
  }
}


static void* 
play_a_buff(void *arg)
{
  for(;;)
    if (!(!playing || Pause_)) playone();
}

void drawsymbol(FL_Coord x, FL_Coord y, FL_Coord w, FL_Coord h,
               int angle, FL_COLOR col)
{
  int bw=w/2-1;
  w=4;
  y+=5;h-=10;

  fl_rectbound( x+bw-4, y, w, h, col);
  fl_rectbound( x+bw+4, y, w, h, col);
  
}



void load_setup( void )
{
   /* load settings from mod4Xwin.ini */
  FILE	 *fp;
  char	 line_buf[MAX_NAME_LEN];
  char	 dummy[17];
  char*  cwd=(char*)getcwd(NULL,0);
  char*  datei_name;
  int	 saved_val;
  int	 error=0;

  Home_Dir=getenv("HOME");
  strcpy(line_buf,Home_Dir);
  strcat(line_buf,"/.mod4Xwin"); 		
  datei_name=&line_buf[0];  
  if ( (fp=fopen(datei_name,"r")) == NULL) 
  {
      fprintf(stderr,"\nWarning: Couldn open .mod4Xwin !\n");
      error=1;
  }
  else
  {
    fgets(line_buf,MAX_NAME_LEN,fp);
    if ( strncmp("[State]",line_buf,7) != 0 )
    {
         fprintf(stderr,"\nKeyword [State] not found ! \n");
         error=1;
    }
    else
    {
        fscanf(fp,"%16s %s",dummy,line_buf);   strncpy(ssettings.name,line_buf,39);
        fscanf(fp,"%16s %d",dummy,&saved_val); ssettings.switch_pause=(boolean)saved_val;
        fscanf(fp,"%11s %d",dummy,&saved_val); ssettings.switch_auto=(boolean)saved_val;
   	fscanf(fp,"%10s",line_buf);
        if ( strncmp("[Sampling]",line_buf,10) != 0 )
        {
              fprintf(stderr,"\nKeyword [Sampling] not found ! \n");
              error=1;
        }
        else
        {          
          fscanf(fp,"%17s %d" ,dummy,&saved_val);  ssettings.preamp=(byte) saved_val;
	  fscanf(fp,"%11s %d",dummy,&saved_val);  ssettings.samplerate=(word) saved_val;
          fscanf(fp,"%14s %d",dummy,&saved_val);  ssettings.bits=(byte)saved_val;
          fscanf(fp,"%9s %d" ,dummy,&saved_val);  ssettings.stereo=(byte)saved_val;
          fscanf(fp,"%14s %d",dummy,&saved_val);  ssettings.nbuffers=(byte)saved_val;
          fscanf(fp,"%9s %d" ,dummy,&saved_val);  ssettings.surround=(boolean)saved_val;
          fscanf(fp,"%6s %d" ,dummy,&saved_val);  ssettings.quality=(boolean)saved_val;
          fscanf(fp,"%4s %d" ,dummy,&saved_val);  ssettings.nobpm=(boolean)saved_val;
          fscanf(fp,"%10s",line_buf);
          if ( strncmp("[Position]",line_buf,10) != 0 )
          {
              fprintf(stderr,"\nKeyword [Position] not found ! \n");
              error=1;
          }
          else
          {          
             fscanf(fp,"%6s %d" ,dummy,&saved_val);  win_position.mod_x=(FL_Coord) saved_val;
             fscanf(fp,"%6s %d" ,dummy,&saved_val);  win_position.mod_y=(FL_Coord) saved_val;
             fscanf(fp,"%6s %d" ,dummy,&saved_val);  win_position.inf_x=(FL_Coord) saved_val;
             fscanf(fp,"%6s %d" ,dummy,&saved_val);  win_position.inf_y=(FL_Coord) saved_val;
             fscanf(fp,"%6s %d" ,dummy,&saved_val);  win_position.eff_x=(FL_Coord) saved_val;
             fscanf(fp,"%6s %d" ,dummy,&saved_val);  win_position.eff_y=(FL_Coord) saved_val;
          }
        }         
    }
    fclose(fp);
  }
  if ( error==1 )
  {
       printf("\nInitialize with default settings ! \n");
       strncpy(ssettings.name,cwd,39);
       ssettings.switch_pause=0;
       ssettings.switch_auto=0;
       ssettings.preamp=10;
       ssettings.samplerate=48000;
       ssettings.bits=16;
       ssettings.stereo=2;
       ssettings.nbuffers=50;
       ssettings.surround=0;
       ssettings.quality=1;
       ssettings.nobpm=1;
       win_position.mod_x=50;      
       win_position.mod_y=50;      
       win_position.inf_x=150;      
       win_position.inf_y=150;      
       win_position.eff_x=100;      
       win_position.eff_y=200;      
  }
}


int main(int argc, char *argv[])
{
  int policy;
  int tmp;

  Mount_Path=NULL;
  load_setup();
  eff_stat=2;
  memset(&eff_old,0,sizeof(eff_old));
  memset(&eff_new,0,sizeof(eff_new));

  fl_initialize(&argc,argv, "mod4Xwin", 0, 0);
  fd_Main = create_form_Main();
  fd_OPEN = create_form_OPEN();
  fd_SETUP = create_form_SETUP();
  fd_info  = create_form_info();  
 
  
  /* fill-in form initialization code */
  pixid=fl_create_from_pixmapdata(fl_default_window(),image_name,&tmp,&tmp,NULL,&tmp,&tmp,0);
  
   /* add the new symbol */
  fl_add_symbol("Pause",drawsymbol,0);

  fl_set_form_icon(fd_Main->Main,pixid,0);
  fl_set_form_icon(fd_OPEN->OPEN,pixid,0);
  fl_set_form_icon(fd_SETUP->SETUP,pixid,0);
  fl_set_form_icon(fd_info->info,pixid,0);
  
  fl_set_browser_fontsize(fd_info->browser_bottom,FL_MEDIUM_SIZE);

  init_player();
  memcpy(&soundsettings,&ssettings,sizeof(tsettings));  // by EB 21.3.97
  fl_set_browser_dblclick_callback(fd_OPEN->file_browser_left,file_browser_left_dc,0);
  fl_set_slider_bounds(fd_SETUP->hz_slider,0,48);
  fl_set_slider_precision(fd_SETUP->hz_slider,1);

		      
  disp_dir(".","*");
  
  fl_set_object_label(fd_Main->hz_dsp,itoasc(soundsettings.samplerate,5));
  fl_set_object_label(fd_Main->bits_dsp,itoasc(soundsettings.bits,2));

  /* show the first form */
  fl_set_form_position(fd_info->info,win_position.inf_x-5,win_position.inf_y-22);  // 22 pixel border high
  fl_set_form_position(fd_Main->Main,win_position.mod_x-5,win_position.mod_y-22);  
  win_position.mod_id=fl_show_form(fd_Main->Main,FL_PLACE_POSITION,FL_FULLBORDER,VERSION);
  fl_set_idle_callback(play_a_buffer,NULL);
  fl_call_object_callback(fd_SETUP->Setup_pl);         

  fl_do_forms();
  exit_player();
  return 0;
}

