/* 
 * playlist.c
 *
 * signature:	Carsten Kroll
 *		Enrico Blatt
 *
 * update:	19.3.97
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h> 	/* filestatus-struct EB 7.2.97 */
 
#define MAX_FILES 	(0xFF-0x20)
#define MAX_DIRS  	(0xFF-0x20)
#define MAX_NAME_LEN	(256)

static char* supported_format_list[]={"669","mtm","mod","s3m","far","stm","xm",NULL}; 
extern char* Mount_Path;

char* dir_list[MAX_DIRS];
char* file_list[MAX_FILES];
int   ref_list[MAX_DIRS];	// file_list[y] gehoert zu dir_nr: ref_list[y]

static int dir_list_length=0;
static int next_file_nr=0;
int currfile;		


char* tmp_dlist[MAX_DIRS];
char* tmp_flist[MAX_FILES];
int   tmp_rlist[MAX_DIRS];	
static int   tmp_dlist_length;
static int   tmp_nextfile_nr;
static int   tmp_currfile;		





char *complete_file(char* file)
{
  FILE *fp;
  int i,mark;
  char *comp_str;
  mark=0;

  comp_str=malloc(sizeof(dir_list[i])+256);
  /*zuerst im normalen pfad suchen*/
  for(i=0;dir_list[i]!=0;i++){
    strcpy(comp_str,"");
    strcat(comp_str,dir_list[i]);
    strcat(comp_str,"/");
    strcat(comp_str,file);
    fp=fopen(comp_str,"r");
    if (fp != NULL) {mark=1;break;}
  }
  if (Mount_Path&&(!mark))
    for(i=0;dir_list[i]!=0;i++){
      strcpy(comp_str,Mount_Path);
      if ( Mount_Path[strlen(Mount_Path)] != '/') 
	 strcat(comp_str,"/");
      strcat(comp_str,dir_list[i]);
      strcat(comp_str,"/");
      strcat(comp_str,file);
      fp=fopen(comp_str,"r");
      if (fp != NULL) {mark=1;break;}
    }
  
  fclose(fp);
  if ( !mark ) free(comp_str);
  return mark ? comp_str : NULL;
}

void add_file_to_pl(char *file)
{
/* file kann beliebig oft addiert werden */
  int i;
  int dir_in_list =0;
  char *cwd=getcwd(NULL,0);

  for(i=0;dir_list[i]!=NULL;i++)
      if (!strcmp(dir_list[i],cwd))
      { 
        dir_in_list=1;
        break;		// in liste -> pos. i
      }
  if (!dir_in_list)
  { 
      /*ist nicht in liste also addiere*/
      dir_list[i]=(char *)(malloc(strlen(cwd)+1)); // sonst fehlt "\0" 
      strcpy(dir_list[i],cwd); 			   
      dir_list_length++;
      dir_list[i+1]=NULL;
  }  
  file_list[next_file_nr]=(char *)(malloc(strlen(file)+1)); 
  ref_list[next_file_nr] =i; 			//pos i
  strcpy(file_list[next_file_nr++],file);
  file_list[next_file_nr]=NULL;
  currfile= next_file_nr-1;       		// ?? or not ?
}

int del_file_from_pl(char *file)
{
  int n,k;
  int count=0;
  int dir_nr;
  char* dir_list_new[MAX_DIRS];
  char* file_list_new[MAX_FILES];

  for(k=0;file_list[k]!=NULL;k++)
      if (!strcmp(file_list[k],file))	break;
  /* k = matching file_nr */
  dir_nr=ref_list[k];  			// zugeh. dir_nr (mehrere files -> erstes dir)
  
  for(n=k;n < (next_file_nr-1);n++)		// nachruecken
  {
      file_list_new[n-k]=malloc(strlen(file_list[n+1])+1);
      strcpy(file_list_new[n-k],file_list[n+1]);
      ref_list[n]=ref_list[n+1];
  }
  next_file_nr--;
  currfile=next_file_nr-1;		
  for(n=k;n< next_file_nr ;n++)		
  {
    file_list[n]=realloc(file_list[n],strlen(file_list_new[n-k])+1);
    strcpy(file_list[n],file_list_new[n-k]);
    free(file_list_new[n-k]);
  }
  free(file_list[next_file_nr]);
  file_list[next_file_nr]=NULL;
   
  // noch ein verweis auf dieses dir ?
  for(k=0;k< next_file_nr;k++)
      if ( ref_list[k] == dir_nr)	     
        count++;

  if ( !count )			                // kein Verweis aufs dir
  {                                     	// -> dir loeschen
     for(n=dir_nr;n<(dir_list_length-1);n++) 
     {
     	dir_list_new[n-dir_nr]=malloc(strlen(dir_list[n+1])+1);  // + \0     
        strcpy(dir_list_new[n-dir_nr],dir_list[n+1]); 
     }
     dir_list_length--;  
     for(n=dir_nr;n<dir_list_length;n++)    // alle anderen nachruecken
     {
       dir_list[n]=realloc(dir_list[n],strlen(dir_list_new[n-dir_nr])+1);
       strcpy(dir_list[n],dir_list_new[n-dir_nr]);
       free(dir_list_new[n-dir_nr]);
     }
     for(k=0;k<next_file_nr;k++)
        if ( ref_list[k] >= dir_nr)	    // referenz decrementieren
            ref_list[k]--;
     free(dir_list[dir_list_length]);
     dir_list[dir_list_length]=NULL;
   }
   return(0);
}


int save_pl_to_file(char* datei_name)     
{
   FILE* 	file_ptr;
   /* char* 	datei_name="~/mod4x/playlist.mol"; */
   char  	endg[5];
   char  	line[256];
   size_t	len;
   int 		k=0;
   char		count=0x20;	//beispiel.mol
   
   if ( (file_ptr=fopen(datei_name,"w+")) == NULL)
         return(-1);
   fprintf(file_ptr,"[DIRECTORIES]\n");
   // 1 Byte ab 0x20 hochzaehlen -> mod4win
   while(dir_list[k]!=NULL)
       fprintf(file_ptr,"%c%s\n",count++,dir_list[k++]);
   k=0;
   count=0x20;

   // not connect -> later
   fprintf(file_ptr,"[ARCHIVES]\n");
   fprintf(file_ptr,"[ARCHIVDIRECTORIES]\n");
  
   fprintf(file_ptr,"[FILES]\n");
   // 1.Byte=MOD-Format,2.Byte ref_list+0x20,3.Byte=".",4.Byte=" "
   while(file_list[k]!=NULL)
   {
      len=strlen(file_list[k]);
      strcpy(endg,file_list[k]+len-4);	     // endung z.B. ".mod"
      strcpy(line,"  . ");                   // 4 Bytes zur Identifizierung
      strncat(line,file_list[k],len-4);    // + Filename ohne Endung
      if ( !strcmp(endg,".mod") ) line[0]=0x24; //"$"
      if ( !strcmp(endg,".669") ) line[0]=0x27; //""
      if ( !strcmp(endg,".mtm") ) line[0]=0x2A; //"*"
      if ( !strcmp(endg,".s3m") ) line[0]=0x2D; //"-"     
      line[1]=(char)(ref_list[k++]+0x20);
      fprintf(file_ptr,"%s\n",line);
   }     
   fclose(file_ptr);
   return(0);
}


void clear_all_lists( void )
{
 int k=0;
 
 for(k=0;file_list[k]!=NULL;k++)
    	free(file_list[k]);
 for(k=0;dir_list[k]!=NULL;k++)
    	free(dir_list[k]);
 for(k=0;ref_list[k]!=0;k++)
    	ref_list[k]=0;
 dir_list[0]=NULL;
 file_list[0]=NULL;
}


int load_pl(const char* file)
{
  FILE	 *fp;
  char	 line_buf[MAX_NAME_LEN];
  int	 i=0;
  int	 total;
  int    dos_pl=0;
  char	 *pos;
   
  fp=fopen(file,"r");
  if(fp == NULL)  {
    fprintf(stderr,"\nError: Kann Datei nicht oeffnen !\n");
    return (-1);
  }
  else  { 
    clear_all_lists();
    fgets(line_buf,MAX_NAME_LEN,fp);
    // erste Zeile muss [DIRECTORIES] enthalten 
    if ( strncmp("[DIRECTORIES]",line_buf,13) != 0 )    {
      fprintf(stderr,"\nKeyword [DIRECTORIES] not found ! \n");
      return (-1);
    }   
    while ((fgets(line_buf,MAX_NAME_LEN,fp) != NULL) && (!strchr(line_buf,'[')) )
    { 
 	dir_list[i]=malloc(strlen(line_buf));  		// CR       
        line_buf[strlen(line_buf)-1]='\0';
        strcpy(dir_list[i++],line_buf);	
    } 
    dir_list[i]=NULL;
    dir_list_length=i;
   
    // aktuelle Zeile sollte [ARCHIVES] enthalten 
    if (strncmp("[ARCHIVES]",line_buf,10) != 0)
       fprintf(stderr,"\nError: Keyword [ARCHIVES] not found ! \n");
    else {
         while ((fgets(line_buf,MAX_NAME_LEN,fp) != NULL) && (!strchr(line_buf,'[')) )
	 { 
	  /* was auch immer mit den Archiven zutun ist */  
	 } 
    }     
    // aktuelle Zeile sollte [ARCHIVDIRECTORIES] enthalten 
    if (strncmp("[ARCHIVDIRECTORIES]",line_buf,19) != 0)
       fprintf(stderr,"\nError: Keyword [ARCHIVDIRECTORIES] not found ! \n");
    else {
         while ((fgets(line_buf,MAX_NAME_LEN,fp) != NULL) && (!strchr(line_buf,'[')) )
	 { 
	  /* was auch immer mit den Archivdirectories zu tun ist */  
	 } 
    }    
    // aktuelle Zeile muss [FILES] enthalten 
    if (strncmp("[FILES]",line_buf,7) != 0)
    {
       fprintf(stderr,"\nError: Keyword [FILES] not found ! \n");
       return (-1);
    }   
    i=0;
    while ( fgets(line_buf,MAX_NAME_LEN,fp) != NULL )
    {
       file_list[i]=malloc(strlen(line_buf)); 
       line_buf[strlen(line_buf)-1]='\0';
       strcpy(file_list[i++],line_buf);
    }
    file_list[i]=NULL;
    next_file_nr=i;	// eigentlich next_file_nr
  } 
  fclose(fp);
  total=i;

  /* CHECK:  Dos - Playlist ? ( d: ) */
  if ( strchr( dir_list[0],':') != NULL)  {
     printf("\nconvert dos playlist ... \n");
     dos_pl=1;
  }
  i=0;
  /* dirlist */
  while( dir_list[i]!= NULL)  {
     if (dos_pl) {
	strcpy(line_buf,dir_list[i]+3);/*abschneiden ersten 3 Byte  z.B. $d: */
        while (pos=strchr(line_buf,'\\'))   (*pos)='/';
        if(pos=strchr(line_buf,'\r'))       (*pos)=0;
     }
     else
       strcpy(line_buf,dir_list[i]+1);/* sonst erstes */
     strcpy(dir_list[i++],line_buf);
  }
  /* filelist */
  for(i=0;i<total;i++) {
    strcpy(line_buf,file_list[i]+4);	/*abschneiden erste 4 Bytes*/
    if (dos_pl) {
       if ( (pos=strchr(line_buf,'\r')) != NULL)  (*pos)='\0';	
       if ( (pos=strchr(line_buf,0x20)) != NULL ) (*pos)='\0';
    }
    switch (file_list[i][0]) {
        case 0x24: strcat(line_buf,".mod");break; // anhaengen 4 Byte 
        case 0x27: strcat(line_buf,".669");break; // (alloc size ok)
        case 0x2A: strcat(line_buf,".mtm");break;
        case 0x2D: strcat(line_buf,".s3m");break;
    }
    ref_list[i]=(int)(file_list[i][1])-0x20;
    strcpy(file_list[i],line_buf);
  }
 
  return(0);
}


/***** save old playlist -> Open_Cancel *********************/


void save_tmp_playlist( void )
{
   int i=0;

   while( dir_list[i]!=NULL ){
       tmp_dlist[i]=malloc(strlen(dir_list[i])+1);
       strcpy(tmp_dlist[i++],dir_list[i]);  // rechts nach links
   }
   tmp_dlist[i]=NULL;
   i=0;
   while( file_list[i]!=NULL ) {      
       tmp_flist[i]=malloc(strlen(file_list[i])+1);
       strcpy(tmp_flist[i++],file_list[i]); 
   }
   tmp_flist[i]=NULL;
   i=0;
   while( ref_list[i]!=0 )  
     tmp_rlist[i]=ref_list[i++];
   
   tmp_rlist[i]=0;
   tmp_dlist_length=dir_list_length;
   tmp_nextfile_nr=next_file_nr;
   tmp_currfile=currfile;
}

void restore_tmp_playlist( void)
{
   int i=0;
   while( tmp_dlist[i]!=NULL ){
      dir_list[i]=(char *)(malloc(strlen(tmp_dlist[i])+1));
      strcpy(dir_list[i],tmp_dlist[i]);
      free(tmp_dlist[i++]);
   }
   dir_list[i]=NULL;   
   i=0;
   while( tmp_flist[i]!=NULL ){
      file_list[i]=(char *)(malloc(strlen(tmp_flist[i])+1));
      strcpy(file_list[i],tmp_flist[i]);
      free(tmp_flist[i++]);
   }
   file_list[i]=NULL;
   i=0;
   while( tmp_rlist[i]!=0 ){
      ref_list[i]=tmp_rlist[i];
      tmp_rlist[i++]=0;
   }
   ref_list[i]=0;
   dir_list_length=tmp_dlist_length;
   next_file_nr=tmp_nextfile_nr;
   currfile=tmp_currfile;
   
   tmp_flist[0]=NULL;
   tmp_dlist[0]=NULL; 
}

void free_tmp_playlist( void)
{
   int i=0;
   while( tmp_dlist[i]!=NULL )
        free(tmp_dlist[i++]);
   i=0;
   while( tmp_flist[i]!=NULL )
      free(tmp_flist[i++]);
   i=0;
   while( tmp_rlist[i]!=0 )
      tmp_rlist[i++]=0;
   
   tmp_dlist_length=0;
   tmp_nextfile_nr=0;
   tmp_currfile=0;
   tmp_flist[0]=NULL;       
   tmp_dlist[0]=NULL;
}

