#include "modc.h"
#include "far.h"
#include "misc.h"
#include "effects.h"
#include <stdlib.h>
#include <fstream.h>

extern ifstream f;
static byte *pbuffer;
static unsigned int bufsize,unilong,offset;
static byte reached;

tfarsamplemap farsamplemap ;
word headerlength;
tchannelmap farchannelmap ;

/*============================================================== far loader routine by jensi ==============================================================*/
void far_getfiledata()
{
  pfarpatterndata farpatterndata; 
  pfarheader2 farheader2; 
  word patternlength;

  for( i=0 ;i<= numpatterns-1 ;i++)
    for( j=1;j<= numtracks ;j++)
      (*tracks)[i][j]=numtracks*parrangement[i]+j;
  /* read pattern data */
  f.seekg (sizeof(tfarheader)+commentlen);
  if ( f.bad() ) { error=id_nomodfile; return; }
  farheader2=malloc(sizeof(tfarheader2));
  f.read(farheader2,sizeof(tfarheader2));
  if ( f.gcount()!=sizeof(tfarheader2) ) { error=id_nomodfile; free(farheader2); return; }
  /* skip extra data */
  f.seekg (headerlength); if ( f.bad() ) { error=id_nomodfile; free(farheader2); return; }
  /* convert patterns */
  farpatterndata=malloc(sizeof(tfarpatterndata));
  for( i=0 ;i<= lastpattern;i++)
  {
    patternlength=farheader2->patlength[i];
    if ( (patternlength>0) )
    {
      if ( patternlength>sizeof(tfarpatterndata))
      { error=id_nomodfile; free(farheader2); free(farpatterndata); return; }
      f.read(farpatterndata,patternlength);
      if ( f.gcount()!=patternlength )
      { error=id_nomodfile; free(farheader2); free(farpatterndata); return; }
      /* convert single pattern */
      for( j=0 ;j<= numpatterns-1;j++ ) if ( parrangement[j]==i ) ptrnbreaks[j]=farpatterndata->breakloc;
      if ( alreadyplayed[i])
      {
        for( k=1 ;k<= numtracks;k++ ) if ( !((1<<k) & farchannelmap)) trackwrite(1,0);
	else
        {
          reached=false;
          for( j=0 ;j<= (patternlength-2)/ 64;j++){
	    //do with pattern^[1,j],farpatterndata^.ptrndata[j,k] do
	    byte b1=(farpatterndata->ptrndata[j][k]).b1;
	    byte b2=(farpatterndata->ptrndata[j][k]).b2;
	    byte b3=(farpatterndata->ptrndata[j][k]).b3;
	    byte b4=(farpatterndata->ptrndata[j][k]).b4;

	    byte& instrument=(*pattern)[0][j].instrument;
	    word& ton=(*pattern)[0][j].ton;
	    byte& effekt=(*pattern)[0][j].effekt;
	    byte& operands=(*pattern)[0][j].operands;
	    char& chnvol=(*pattern)[0][j].chnvol;
	    
            if ( b3!=0 ) chnvol=b3 << 2+b3>> 2+b3 >> 3; else chnvol=-1;
            if ( b1==0 ) { ton=0; instrument=0; }
            else { ton=pitchtable[b1+12]; instrument=b2; }
            /* process effects */
            switch (b4 >> 4){
	      case 0x00: switch ( b4 & 0x0f){
	                   case 0x00: { effekt=noeffekt;   operands=0; };break;
                           default: { effekt=farspecial; operands=0; };break; /* ! supported */
	      };break;
              case 0x01: { effekt=farsldup;      operands=b4 & 0x0f; };break;
              case 0x02: { effekt=farslddwn;     operands=b4 & 0x0f; };break;
              case 0x03: { effekt=farportamento; operands=b4 & 0x0f; };break;
              case 0x04: { effekt=farretrig;     operands=b4 & 0x0f; };break;
              case 0x05: { effekt=vibratodepth;  operands=b4 & 0x0f; };break;
              case 0x06: { effekt=farvibrato;    operands=b4 & 0x0f; };break;
              case 0x07: { effekt=farvolup;      operands=b4 & 0x0f; };break;
              case 0x08: { effekt=farvoldwn;     operands=b4 & 0x0f; };break;
              case 0x09: { effekt=vibratosust;   operands=b4 & 0x0f; };break;
              case 0x0a: { effekt=volumeport;    operands=b4 & 0x0f; };break;
              case 0x0b: { effekt=enhanced;      operands=epanning   << 4 + b4 & 0x0f; };break;
              case 0x0c: { effekt=enhanced;      operands=notedelay  << 4 + b4 & 0x0f; };break;
              case 0x0d: { effekt=finetempodwn;  operands=b4 & 0x0f; };break;
              case 0x0e: { effekt=finetempoup;   operands=b4 & 0x0f; };break;
              case 0x0f: { effekt=setspeed;      operands=b4 & 0x0f; };break;
              default:   { effekt=noeffekt;      operands=0;         };break;
            }
            if ( (chnvol!=-1)||(effekt!=noeffekt)||(operands!=0)||(ton!=0)||(instrument!=0)) reached=true;
          }
          if ( reached ) 
	    trackwrite(1,(patternlength-2)/ 64); 
	  else trackwrite(1,0);
	}	   
      } else trackwrite (numtracks, 0);
    } else trackwrite (numtracks, 0);
  }
  free (farpatterndata);
  /* skip dummies after lastpattern */
  unilong=0; for( i=lastpattern;i<= 255;i++ ) unilong+=farheader2->patlength[i];
  free (farheader2);
  /* skip sample map */
  f.seekg (unilong+sizeof(tfarsamplemap),ios::cur);
  if ( f.bad() ) { error=id_nomodfile; return; }
  /* convert instruments */

  /****instrumente in speicher einlesen****/
  for( i=1 ;i<= 64 ;i++) if ( instruments[i].iend>0 ) {
    //with instruments[i]
    char *const& name=instruments[i].name;
    int32& offset    =instruments[i].offset;
    int32& iend      =instruments[i].iend;
    int32& loopstart =instruments[i].loopstart;
    int32& loopend   =instruments[i].loopend;
    byte& volume     =instruments[i].volume;
    byte& finetune   =instruments[i].finetune;
    byte& bits       =instruments[i].bits;
    word& tuning     =instruments[i].tuning;
    /* discard header */
    pbuffer=malloc(iend + sizeof (tfarinstrument));if ( pbuffer==NULL ) { error=id_nomem;return;}
    f.read(pbuffer,sizeof (tfarinstrument));
    offset=songmemofs;
    f.read(pbuffer,iend);
    if ( !f.bad() ) songmemwrite(pbuffer,iend, 5*((bits & 0x10)>> 4));
    free(pbuffer);/*zwischenpuffer hat seine schuldigkeit getan!*/
    if ( iend>0 ){
      if ( volume>64 ) volume=64;
      if ( loopend>iend ) loopend=iend;
      if ( loopstart>iend ) loopstart=0;
      if ( loopend-loopstart<4 ) { loopstart=0;loopend=0; }
      iend+=offset;
      if ( loopend>0 )
      {
        loopend+=offset;
        loopstart+=offset;
      }
    } else offset=0;
  }
  
}
