#include "modc.h"
#include "getinfo.h"
#include "misc.h"

#include "mod.h"
#include "669.h"
#include "far.h"
#include "oktalyzer.h"
#include "s3m.h"
#include "stm.h"
#include "mtm.h"
#include "xm.h"
#include <string.h>
#include <stdlib.h>
#include <fstream.h>

extern ifstream f;

extern string filename;
extern tchannelmap farchannelmap;
tchannelmap s3mchannelmap;
extern word headerlength;
extern tfarsamplemap farsamplemap;
extern int mastervol;

ps3msample s3msample;

static byte *pbuffer;
static int32 unilong,result;

void getinfo(boolean uniload){
	char *ext;
	char *pstr;
	::commentlen=0;
	filesiz=filesize() / 1024;
	//pstr=strcpy(ext,filename+strlen(filename)-4);
	ext=strrchr(filename,'.');
	if (!ext) {
          error=id_invmodfile ;
          return;
	}
	filetype=noisetr;
	if ( uniload ) {
		f.seekg(0,ios::beg);
		pbuffer=(byte*)(malloc(2048));
		f.read(pbuffer,2048);
		if ( !strncmp(pmodheader(pbuffer)->modsign,"M.K.",4 )) filetype=noisetr ;else
		if ( !strncmp(pmodheader(pbuffer)->modsign,"M!K!",4 )) filetype=noisetr ;else
		if ( !strncmp(pmodheader(pbuffer)->modsign,"M&K!",4 )) filetype=noisetr ;else
		if ( !strncmp(pmodheader(pbuffer)->modsign,"M.K!",4 )) filetype=noisetr ;else
		if ( !strncmp(pmodheader(pbuffer)->modsign,"FLT4",4 )) filetype=noisetr ;else
		if ( !strncmp(pmodheader(pbuffer)->modsign,"FLT8",4 )) filetype=noisetr ;else
		if ( !strncmp(pmodheader(pbuffer)->modsign,"EX04",4 )) filetype=noisetr ;else
		if ( !strncmp(pmodheader(pbuffer)->modsign,"EX08",4 )) filetype=noisetr ;else
		if ( !strncmp(pmodheader(pbuffer)->modsign,"OCTA",4 )) filetype=noisetr ;else
		if ( !strncmp(pmodheader(pbuffer)->modsign,"ED81",4 )) filetype=noisetr ;else
		if ( !strncmp(pmodheader(pbuffer)->modsign+2,"CHN",3 )) filetype=noisetr ;else
		if ( !strncmp(pmodheader(pbuffer)->modsign+3,"CH",2  )) filetype=noisetr ;else
		if ( !strncmp(pstmheader(pbuffer)->stmsign,"!Scream!",8 )) filetype=stm     ;else
		if ( !strncmp(pstmheader(pbuffer)->stmsign,"BMOD2STM",8 )) filetype=stm     ;else
		if ( p669header(pbuffer)->f669sign==0x6669             ) filetype=f669    ;else
		if ( p669header(pbuffer)->f669sign==0x4e4a             ) filetype=f669    ;else /*'jn'*/
		if ( !strncmp(pmtmheader(pbuffer)->sign,"mtm",3        )) filetype=mtm     ;else
		if ( !strncmp(pfarheader(pbuffer)->farsign,"FAR\0xfe",4 )) filetype=ffar    ;else
		if ( !strncmp(ps3mheader(pbuffer)->s3msign2,"SCRM",4    )) filetype=s3m     ;else
		if ( !strncmp(((XM_Header*)pbuffer)->id_text,"Extended Module:",16)) filetype=xm     ;else
		if ( !strncmp(poktsign(pbuffer)->fullsign,"OKTASONG",8  )) filetype=oktalyz;
		free(pbuffer);
		f.seekg(0,ios::beg);
	}else{
		if ((!strcmp(ext,".NST"))||(!strcmp(ext,".nst"))) filetype=noisetr ;else
		if ((!strcmp(ext,".MOD"))||(!strcmp(ext,".mod"))) filetype=noisetr ;else
		if ((!strcmp(ext,".WOW"))||(!strcmp(ext,".wow"))) filetype=wow     ;else
		if ((!strcmp(ext,".MTM"))||(!strcmp(ext,".mtm"))) filetype=mtm     ;else
		if  ((!strcmp(ext,".STM"))||(!strcmp(ext,".stm")))filetype=stm     ;else
		if  ((!strcmp(ext,".669"))			)filetype=f669     ;else
		if  ((!strcmp(ext,".FAR"))||(!strcmp(ext,".far")))filetype=ffar    ;else
		if  ((!strcmp(ext,".S3M"))||(!strcmp(ext,".s3m")))filetype=s3m     ;else
	        if  ((!strcmp(ext,".XM"))||(!strcmp(ext,".xm")))filetype=xm     ;else
		if  ((!strcmp(ext,".OKT"))||(!strcmp(ext,".okt")))filetype=oktalyz ;
			else{ 
				error=id_invmodfile;return; 
			}
	}
	switch  (filetype){
		case oktalyz :{
		/*------------------------------------oktalyzer-------------------------------------------*/
			pbuffer=(byte*)(malloc(8192));
			f.read(pbuffer,sizeof(toktsign));
			if ( (f.gcount()!=sizeof(toktsign))||(poktsign(pbuffer)->fullsign!="oktasong")){ 
				error=id_nomodfile; return; 
			}
			pstr=strncpy(::modname,filename,int(filename)-int(rindex(filename,'.')));
			do{
				f.read(pbuffer,sizeof(toktsign));
				//with poktsign(pbuffer)^ do
				poktsign(pbuffer)->structsize=swaplong(poktsign(pbuffer)->structsize);
				if ( poktsign(pbuffer)->b4sign=="cmod" ) { if ( !(getchannels   (poktsign(pbuffer)->structsize))) goto okterr;}
				else if ( poktsign(pbuffer)->b4sign=="samp" ) { if (!(getinstrdata  (poktsign(pbuffer)->structsize))) goto okterr;}
				else if ( poktsign(pbuffer)->b4sign=="spee" ) { if ( !(getinitspeed  (poktsign(pbuffer)->structsize))) goto okterr;}
				else if ( poktsign(pbuffer)->b4sign=="slen" ) { if ( !(getslen       (poktsign(pbuffer)->structsize))) goto okterr;}
				else if ( poktsign(pbuffer)->b4sign=="plen" ) { if ( !(getarrangesize(poktsign(pbuffer)->structsize))) goto okterr;}
				else if ( poktsign(pbuffer)->b4sign=="patt" ) { if ( !(getarrangement(poktsign(pbuffer)->structsize))) goto okterr;}
				else if ( poktsign(pbuffer)->b4sign!="pbod" ) goto okterr;
			//----endwhile
			}
			while(poktsign(pbuffer)->b4sign!="pbod");
			free(pbuffer);
			forcerange = true;
			return;
		okterr:
			free(pbuffer);
			error=id_nomodfile;
		};break;
		case f669 :{
		/*-----------------------------------------669------------------------------------------------------------*/
		   int S_669h = 497;
		   pbuffer=(byte*)(malloc(S_669h));
			f.read(pbuffer,S_669h);result=f.gcount();
			if ((result!=S_669h)) { 
				error=id_nomodfile;
				free(pbuffer); return; 
			}
			numtracks=8;
			//with p669header(pbuffer)^ do
			{
				word f669sign        =p669header(pbuffer)->f669sign;
				//char comment[3][36]  =p669header(pbuffer)->comment; 
				char (*comment)[36]    =p669header(pbuffer)->comment; 
				byte ninstruments    =p669header(pbuffer)->ninstruments;
				byte numpatts        =p669header(pbuffer)->numpatts;
				byte repstart         =p669header(pbuffer)->repstart;
				byte *arrangement     =p669header(pbuffer)->arrangement;
				byte *tempos         =p669header(pbuffer)->tempos;
				byte *lengths         =p669header(pbuffer)->lengths;

				/*fehlercheck...*/
				if ( !((numpatts >= 1)&&(numpatts<= 127))
				    ||(f669sign!=0x6669)
				    &&(f669sign!=0x4e4a)
				    ||(ninstruments>64)
				    ||(ninstruments==0)) { 
					error=id_nomodfile;
					free(pbuffer); return; 
				}
				if (f669sign == 0x4e4a ) filetype = unis;
				memmove(parrangement,arrangement,128);
				/*hoechste patternnummer finden*/
				lastpattern = numpatts-1;
				diffpatterns=0;
				memset(alreadyplayed,0,sizeof(alreadyplayed));
				numpatterns=0;
				for( i=0;i<=127;i++){
					if ( arrangement[i]<127 ) numpatterns=i+1; else break;
					if ( arrangement[i]>lastpattern ) lastpattern=arrangement[i];
					if (!(alreadyplayed[arrangement[i]])){
						alreadyplayed[arrangement[i]]=true;
						diffpatterns++;
					}
				}
				/* find dummy patterns */
				if ( diffpatterns < (lastpattern+1)) dummypatterns = (lastpattern+1) - diffpatterns;//succ
				if ((numpatterns==0)||(lastpattern>127)){ 
					error=id_nomodfile; free(pbuffer); return; 
				}
				difftracks=diffpatterns*numtracks;
				lasttrack=word(lastpattern)*numtracks;
				trackmemsize = int32 (lastpattern + 1) * numtracks * (64 * (sizeof (tnote)+1) + 2);
				/*speed,tempi,patternbreaks*/
				initbpmspeed=78;
				initspeed=tempos[arrangement[0]];
				numinstruments=ninstruments;
				for( i=0;i<numpatterns ;i++){
					ptrntempi[i] =tempos [arrangement[i]];
					ptrnbreaks[i]=lengths[arrangement[i]];
				}
				/*modname,comment...*/
				//sconvert(::modname,comment,36);
				reducestring(::modname);
				loopto=repstart+1;
				loopfrom=-1;
				if ( loopto>numpatterns ) loopto=-1 ;else loopfrom=numpatterns;
			}
			commentlen=108;
			comment=pcommentbuf(malloc(108));
			memmove(comment,tcommentbuf(*comment),108);
			free(pbuffer);
			/********instrumente************/
			pbuffer=(byte*)(malloc(sizeof(t669instrument)*numinstruments));
			f.read(pbuffer,sizeof(t669instrument)*(numinstruments));
			instrmemsize=0;
			for (i=numinstruments;i>=1;i--){
//				with p669insarray(pbuffer)^.instr[i],instruments[i] do
				char *const& sampname =p669insarray(pbuffer)->instr[i-1].sampname;
				int32 samplen	 =*(int32*)((p669insarray(pbuffer)->instr[i-1].samplen));
				int32 sampreps   =*(int32*)((p669insarray(pbuffer)->instr[i-1].sampreps));
				int32 samprepend =*(int32*)((p669insarray(pbuffer)->instr[i-1].samprepend));
				char *const& name =instruments[i].name;
				int32& offset     =instruments[i].offset;
				int32& iend       =instruments[i].iend;
				int32& loopstart  =instruments[i].loopstart;
				int32& loopend    =instruments[i].loopend;
				byte& volume      =instruments[i].volume;
				byte& finetune    =instruments[i].finetune;
				byte& bits        =instruments[i].bits;
				word& tuning      =instruments[i].tuning;

				if ( samplen==0 ) numinstruments--; 
				else{
					offset=0;
					iend=samplen;
					if ( samprepend<=samplen ){
						loopstart = sampreps;
						loopend   = samprepend;
					}
					volume=0x40;/*vol + finetune gibts nicht*/
					finetune=0;
					bits=8;
					instrmemsize+=iend;
					tuning=8363/*8740*/;
				}
				//sconvert(name,sampname,13);
			}//und endwith
			if ( filetype==unis ){
				for( i=1 ;i<=(numtracks / 2);i++){
					defpanning[2*i-1]=34;
					defpanning[2*i]=95;
				}
			}else{
				for (i=1;i<=(numtracks / 2);i++){
					defpanning[2*i-1]=0;
					defpanning[2*i]=128;
				}
			}
			free(pbuffer);
		};break;
		case ffar:{
/*================================================================ far info routine by jensi ================================================================*/
			/* read first chunk */
			pbuffer=(byte*)(malloc(sizeof(tfarheader)));
			f.read(pbuffer,sizeof(tfarheader));
			if ((f.gcount()!=sizeof(tfarheader))){
				error=id_nomodfile;
				free(pbuffer); return; 
			}
			//with pfarheader(pbuffer)^ do 
			{
				char *farsign      =pfarheader(pbuffer)->farsign;
				char *farname     =pfarheader(pbuffer)->farname;
				char *farsign2      =pfarheader(pbuffer)->farsign2;
				word headerlen       =pfarheader(pbuffer)->headerlen;
				byte version         =pfarheader(pbuffer)->version;
				boolean *channelmap  =pfarheader(pbuffer)->channelmap;
				byte *editdata1      =pfarheader(pbuffer)->editdata1;
				byte deftempo        =pfarheader(pbuffer)->deftempo;
				byte *panningmap     =pfarheader(pbuffer)->panningmap;
				byte *editdata2      =pfarheader(pbuffer)->editdata2;
				word commentlen      =pfarheader(pbuffer)->commentlen;

				/* error check */
				if ( (farsign!="far\0xfe")||(farsign2!="\13\10\26")){ 
					error=id_nomodfile;
					free(pbuffer); return; 
				}
				if ( version != 0x10 ) { 
					error=id_invmodfile;
					free(pbuffer); return; 
				}
				/* get name */
				sconvert(::modname,farname,40);
				reducestring(::modname);
				/* get channel info */
				numtracks=16;
				farchannelmap=0;//leere Menge
				for ( i=1 ;i<=16;i++) if ( channelmap[i] ) farchannelmap+=i;
				for ( i=1 ;i<=16;i++) defpanning[i]=panningmap[i]<< 3+panningmap[i]>> 1+panningmap[i]>>3;
				/* set speeds */
				initspeed=deftempo;
				initbpmspeed=80;
				/* get comment */
				::commentlen=commentlen;
				if ( commentlen>0 ){
					comment=pcommentbuf(malloc(commentlen));
					f.read(comment,commentlen);
					if ( f.gcount()!=commentlen ) { 
						error=id_nomodfile;
						free(pbuffer);return;
					}
				}
				unilong=headerlen;
				headerlength=headerlen;
			}//--endwith
			free(pbuffer);
			/* read second chunk */
			pbuffer=(byte*)(malloc(sizeof(tfarheader2)));
			f.read(pbuffer,sizeof(tfarheader2));
			if ((f.gcount()!=sizeof(tfarheader2))) { 
				error=id_nomodfile;
				free(pbuffer); return; 
			}
			//with pfarheader2(pbuffer)^ do
			{
				byte *orders       =pfarheader2(pbuffer)->orders;
				byte numpatts      =pfarheader2(pbuffer)->numpatts;
				byte ordlength     =pfarheader2(pbuffer)->ordlength;
				byte looptoloc     =pfarheader2(pbuffer)->looptoloc;
				word *patlength    =pfarheader2(pbuffer)->patlength;
				
				/* get pattern/order info */
				memmove (orders,parrangement,ordlength);
				numpatterns=ordlength;
				lastpattern=numpatts-1;
				diffpatterns=0;
				memset(alreadyplayed,0,sizeof(alreadyplayed));
				for( i=1;i<=numpatterns;i++){
					if ( orders[i]>lastpattern ) lastpattern=orders[i];
					if ( !(alreadyplayed[orders[i]])){
						alreadyplayed[orders[i]]=true;
						diffpatterns--;
					}
				}
				/* find dummy patterns */
				if ( diffpatterns<(lastpattern+1)) dummypatterns=(lastpattern+1)-diffpatterns;//succ
				/* find loop in module */
				loopto=looptoloc+1;
				loopfrom=-1;
				if ( loopto>numpatterns ) loopto=-1 ; else loopfrom=numpatterns;
				/* skip pattern data and calculate trackmemsize */
				trackmemsize=0;
				for( i=0;i<=255;i++){
					unilong+=patlength[i];
					trackmemsize+=patlength[i] / 64;
				}
				trackmemsize=trackmemsize*numtracks*(sizeof(tnote)+1);//succ
			}//--endwith
			free(pbuffer);
			f.seekg (unilong,ios::beg);
			if ( f.fail() ) { error=id_nomodfile; return; }
			/* get instrument info */
			f.read (&farsamplemap,sizeof(tfarsamplemap));
			if ((f.gcount()!=sizeof(tfarsamplemap))) { error=id_nomodfile; return; }
			unilong+=sizeof(tfarsamplemap);
			pbuffer=(byte*)(malloc(sizeof(tfarinstrument)));
			instrmemsize=0;
			for( i=1;i<=64;i++){
				//with instruments[i] do 
				if ( (i>=1) && (i<= farsamplemap )){
					f.seekg (unilong,ios::beg);
					if ( f.fail()!=0 ) { error=id_nomodfile; free(pbuffer); return; }
					f.read (pbuffer,sizeof(tfarinstrument));
					if ((f.gcount()!=sizeof(tfarinstrument))) { 
						error=id_nomodfile;
						free(pbuffer); return; 
					}
					//with pfarinstrument (pbuffer)^ do
					{
						char *name   =pfarinstrument (pbuffer)->name;
						int32 length =pfarinstrument (pbuffer)->length;
						byte finetune=pfarinstrument (pbuffer)->finetune;
						byte volume=pfarinstrument (pbuffer)->volume;
						int32 repeatstart=pfarinstrument (pbuffer)->repeatstart;
						int32 repeatend=pfarinstrument (pbuffer)->repeatend;
						byte sampletype=pfarinstrument (pbuffer)->sampletype;
						byte loopmode=pfarinstrument (pbuffer)->loopmode;

						sconvert(instruments[i].name,name,32);
						if ( length>0 ){
							instruments[i].iend=length;
							if ( loopmode &&(1 << 3)==(1 << 3) ) {
								instruments[i].loopstart=repeatstart;instruments[i].loopend=repeatend;
							}
						instruments[i].finetune= finetune;
						instruments[i].volume  = volume;
						if ( sampletype && 1==1 ) instruments[i].bits=16 ;else instruments[i].bits=8;
						instruments[i].tuning=8363;
						instrmemsize+=instruments[i].iend;
						numinstruments++;
						}
						unilong+=sizeof(tfarinstrument)+length;
					}//--endwith
				}//und endwith
			}
			free(pbuffer);
			/* set player engine variables */
			difftracks=diffpatterns*numtracks;
			lasttrack=word(lastpattern)*numtracks;
			memset(ptrntempi,0,sizeof(ptrntempi));    // pattern tempi shall not be supported 
			memset(ptrnbreaks,0,sizeof(ptrnbreaks));  // gets overridden later 
		};break;
		case s3m :{
/*================================================================ s3m info routine by jensi ==========================*/
			/* read first chunk */
			pbuffer=(byte*)(malloc(sizeof(ts3mheader)));
			f.read(pbuffer,sizeof(ts3mheader));
			if ( (f.gcount()!=sizeof(ts3mheader)) ) { 
				error=id_nomodfile; 
				free(pbuffer); return; 
			}
			//with ps3mheader(pbuffer) do
			{
				char *s3mname=ps3mheader(pbuffer)->s3mname;
				char s3msign1=ps3mheader(pbuffer)->s3msign1;
				byte filetype=ps3mheader(pbuffer)->filetype;
			//	byte unused1[2]=ps3mheader(pbuffer)->unused1;
				word ordnum=ps3mheader(pbuffer)->ordnum;
				word insnum=ps3mheader(pbuffer)->insnum;
				word patnum=ps3mheader(pbuffer)->patnum;
				word flags=ps3mheader(pbuffer)->flags;
				word cwt_v=ps3mheader(pbuffer)->cwt_v;
				word ffv=ps3mheader(pbuffer)->ffv;
				char *s3msign2=ps3mheader(pbuffer)->s3msign2;
				byte glob_vol=ps3mheader(pbuffer)->glob_vol;
				byte init_speed=ps3mheader(pbuffer)->init_speed;
				byte init_tempo=ps3mheader(pbuffer)->init_tempo;
				byte mast_vol=ps3mheader(pbuffer)->mast_vol;
			//	byte unused2[10]=ps3mheader(pbuffer)->unused2;
				word special=ps3mheader(pbuffer)->special;
				byte *channels=ps3mheader(pbuffer)->channels;

				/* error check */
				if ( !((s3msign1>=0)&&(s3msign1<=0x1a))||
				     strncmp(s3msign2,"SCRM",4) ){ 
				  error=id_nomodfile;
				  free(pbuffer);return; 
				}
				if ((filetype != 16)) { error=id_invmodfile; free(pbuffer); return; }
				/* get name */
				sconvert(::modname,s3mname,28);
				reducestring(::modname);
				/* get info data */
				numtracks=0;
				s3mchannelmap=0;//empty
				for( i=0;i<=31;i++){
					if ( ((channels[i] && 0x7f)>=0) && ((channels[i] && 0x7f)<=31)){
					  //numtracks++;
						switch (channels[i]){
						   case 0:
						   case 1:
						   case 2:
						   case 3:
						   case 4:
						   case 5:
						   case 6:
						   case 7:defpanning[i]=  0;break;
						 case 8:
						 case 9:
						 case 10:
						 case 11:
						 case 12:
						 case 13:
						 case 14:
						 case 15:defpanning[i]=128;break;
						 case 16:case 17:case 18:case 19:
						 case 20:case 21:case 22:case 23:
						 case 24:case 25:case 26:case 27:
						 case 28:case 29:case 30:
						 case 31:defpanning[i]= 64;break;
						}
						if ( (channels[i] & 0x80) == 0 ) s3mchannelmap|=1<<i;
					} else break;
				}
				/*correct the number of tracks*/
				for (i=0;i<31;i++){
				  if (s3mchannelmap & (1<<i)) numtracks++;
				}
				numpatterns=ordnum;
				dummypatterns=patnum;
				numinstruments=insnum;
				if ( (flags & 0x10) != 0 ) forcerange=true;
				/* ====> take care of flags, cwt_v, and ffv here <==== */
				initglobvol =glob_vol; if ( initglobvol>40 ) initglobvol=40;
				initspeed   =init_speed;
				initbpmspeed=init_tempo;
				mastervol   =mast_vol & 0x7f;
			}//--endwith
			free(pbuffer);
			/* read second chunk */
			pbuffer=(byte*)(malloc(numpatterns));
			f.read(pbuffer,numpatterns);
			if ( f.gcount()!=numpatterns ) { 
				error=id_nomodfile; 
				free(pbuffer); return; 
			}
			/* get real pattern number/arrangement */
			memset(alreadyplayed,0,sizeof(alreadyplayed));
			lastpattern  =0;
			diffpatterns =0;
			j=0;
			for( i=0;i<numpatterns ;i++){ 
				if ( (*porders(pbuffer)[i]==0xfe)||(*porders(pbuffer)[i]==0xff) ) numpatterns--;
				else{
					parrangement[j]=*porders(pbuffer)[i];
					j++;
					if ( *porders(pbuffer)[i]>lastpattern ) lastpattern=*porders(pbuffer)[i];
					if ( ! alreadyplayed[*porders(pbuffer)[i]] ){
						alreadyplayed[*porders(pbuffer)[i]]=true;
						diffpatterns++;
					}
				}
			}
			if (lastpattern>=dummypatterns) { error=id_nomodfile; free(pbuffer); return; }
			dummypatterns-=diffpatterns;
			free(pbuffer);
			/* read third chunk */
			pbuffer=(byte*)(malloc(numinstruments*2));
			f.read(pbuffer,numinstruments*2);
			if ( f.gcount()!=numinstruments*2 ) { error=id_nomodfile; free(pbuffer); return; }
			
			/* get instrument info */
			instrmemsize=0;
			s3msample=ps3msample(malloc(sizeof(ts3msample)));
			/*reset the instruments */
			memset((void*)instruments,0,sizeof(tinstrument)*numinstruments);
			for( i=0;i<numinstruments;i++) {
				//with instruments[i]
				char *const &name	=instruments[i+1].name;
				int32 &offset    =instruments[i+1].offset;
				int32 &iend      =instruments[i+1].iend;
				int32 &loopstart =instruments[i+1].loopstart;
				int32 &loopend   =instruments[i+1].loopend;
				byte &volume	=instruments[i+1].volume;
				byte &finetune	=instruments[i+1].finetune;
				byte &bits	=instruments[i+1].bits;
				word &tuning     =instruments[i+1].tuning;  
				f.seekg (*pinstruments(pbuffer)[i]*16,ios::beg);
				if ( f.fail() ){ 
					free(s3msample); 
					error=id_nomodfile; free(pbuffer); return; 
				}
				f.read(s3msample,sizeof(ts3msample));
				if ( f.gcount()!=sizeof(ts3msample) ) { 
					free(s3msample); error=id_nomodfile; free(pbuffer); return; 
				}
				//with ps3msample(s3msample)^
				{
					tsampletype sampletype	=ps3msample(s3msample)->sampletype;
					char *dosname    	=ps3msample(s3msample)->dosname;
					tmemseq memseq		=ps3msample(s3msample)->memseq;
					int32 length		=ps3msample(s3msample)->length;
					int32 loopbeg		=ps3msample(s3msample)->loopbeg;
					int32 loopend		=ps3msample(s3msample)->loopend;
					byte volume		=ps3msample(s3msample)->volume;
				//	byte unused1,
					byte pack		=ps3msample(s3msample)->pack;
					byte flags		=ps3msample(s3msample)->flags;
					int32 c2_speed		=ps3msample(s3msample)->c2_speed;
					char *samplename	=ps3msample(s3msample)->samplename;
					char *samplesign	=ps3msample(s3msample)->samplesign;
     
					/* get name/comment */
					sconvert(instruments[i+1].name,samplename,28);
					/* get other data */
					switch ( sampletype) {
						case unused:{
							numinstruments--;
						}break;
						case sample:{
							if ( strncmp(samplesign,"SCRS",4 )){ 
								free (s3msample);
								error=id_nomodfile; free(pbuffer); return; 
							}
							offset=0;
							iend=length;
							if ( flags && 0x01!=0 ) { 
								loopstart=loopbeg; 
								instruments[i+1].loopend=loopend; 
							}
							instruments[i+1].volume=volume;
							bits=8+2*(flags & 0x04)+(flags & 0x02) >> 4+(pack & 0x01)>> 6;
							/*      16 bit         stereo            gepackt          */
							tuning=c2_speed;
							instrmemsize+=iend;
						};break;
						case amel:
					        case abd:  
					        case asnare: 
					        case atom: 
					        case acym: 
					        case ahihat:{
							if ( strncmp(samplesign,"SCRI",4 )){
							  /*indicates adlib instrument, which cannont be played*/
								free (s3msample); 
								error=id_nomodfile; 
								free(pbuffer); return; 
							}
							/* pack adlib data into unused variables */
							iend=swaplong(length);
							loopstart=swaplong(loopbeg);
							instruments[i+1].loopend=swaplong(loopend);
							instruments[i+1].volume =volume;
							bits=128+sampletype;//ord weg
							tuning=c2_speed;
						};break;
						default: { 
							free (s3msample);error=id_nomodfile;
							free(pbuffer); return; 
						}break;
					}
				}
			}
			free(s3msample);
			free(pbuffer);
			/* set player engine variables */
			trackmemsize=int32(diffpatterns)*numtracks*(64*(sizeof(tnote))+2);//succ
			difftracks=diffpatterns*numtracks;
			lasttrack=word(lastpattern)*numtracks;
			memset(ptrntempi,0,sizeof(ptrntempi));
			memset(ptrnbreaks,63,sizeof(ptrnbreaks));
		};break;
	case stm:{
/*------------------------------------------stm------------------------------------------------------------*/
	  pbuffer=(byte*)(malloc(sizeof(tstmheader)));
	  f.read(pbuffer,sizeof(tstmheader));
	  if ( (f.gcount()!=sizeof(tstmheader))){ 
	    error=id_nomodfile;free(pbuffer); return; 
	  }
	  numtracks=4;
	  //with pstmheader(pbuffer)^ do
	  {
	    char *stmname   =pstmheader(pbuffer)->stmname;
	    char *stmsign   =pstmheader(pbuffer)->stmsign;
	    int32 fill1     =pstmheader(pbuffer)->fill1;
	    byte songtempo  =pstmheader(pbuffer)->songtempo;
	    byte numpatts   =pstmheader(pbuffer)->numpatts;
	    byte songvol    =pstmheader(pbuffer)->songvol;
	    byte *fill2     =pstmheader(pbuffer)->fill2;
	    stminstrument *const &instrbank=pstmheader(pbuffer)->instrbank;
	    stmarrangement& arrangement=pstmheader(pbuffer)->arrangement;
	    
	    if ((numpatts>127)||(numpatts==0)||(strncmp(stmsign,"!Scream!",8)&&strncmp(stmsign,"BMOD2STM",8))){ 
	      error=id_nomodfile;free(pbuffer); return; 
	    }
	    memmove(parrangement,arrangement,128);
	    /*hoechste patternnummer finden*/
	    numpatterns=0;
	    lastpattern = numpatts-1;
	    diffpatterns=0;
	    memset(alreadyplayed,0,sizeof(alreadyplayed));
	    for( i=0;i<=127;i++){
	      if ( arrangement[i]<99 ) numpatterns=i+1 ;else break;
	      if ( arrangement[i]>lastpattern ) lastpattern=arrangement[i];
					if ( !(alreadyplayed[arrangement[i]])){
					  alreadyplayed[arrangement[i]]=true;
					  diffpatterns++;
					}
	    }
	    if ( (lastpattern>127)||(numpatterns==0)){ 
	      error=id_nomodfile; free(pbuffer); return; 
	    }
	    difftracks=diffpatterns*numtracks;
	    lasttrack=word(lastpattern)*numtracks;
	    sconvert(::modname,stmname,20);
	    reducestring (::modname);
	    trackmemsize=int32(lastpattern+1)*numtracks*(64*(sizeof(tnote)+1)+2);//succ
	    initspeed=songtempo >> 4;
				initbpmspeed=125;
				/*instrumentendaten auswerten*/
				memset(stmsamplememofs,0,sizeof(stmsamplememofs));
				instrmemsize=0;
				numinstruments=0;
				for( i= 0 ;i<31;i++){
				  //with instrbank[i] do with instruments[i]
				  char *sampname   =instrbank[i].sampname;
				  word smemofs     =instrbank[i].smemofs; 
				  word samplen     =instrbank[i].samplen;
				  word sampreps    =instrbank[i].sampreps;
				  word samprepend  =instrbank[i].samprepend;
				  word sampvol     =instrbank[i].sampvol;
				  word nadjust     =instrbank[i].nadjust;
				  byte *fill2      =instrbank[i].fill2;
				  char *const &name=instruments[i+1].name;
				  int32 &offset    =instruments[i+1].offset;
				  int32 &iend      =instruments[i+1].iend;
				  int32 &loopstart =instruments[i+1].loopstart;
				  int32 &loopend   =instruments[i+1].loopend;
				  byte &volume	   =instruments[i+1].volume;
				  byte &finetune   =instruments[i+1].finetune;
				  byte &bits	   =instruments[i+1].bits;
				  word &tuning     =instruments[i+1].tuning;

				  sconvert(name,sampname,14);
				  if ( samplen>0 ){
				    stmsamplememofs[i]=smemofs;
				    offset=0;
				    iend=samplen;
				    if ( (sampreps != 0)||(samprepend != 65535) ){
				      loopstart=sampreps;
				      loopend=samprepend;
				    }
				    volume=sampvol;
				    finetune=0;
				    bits=8;
				    tuning=nadjust;
				    numinstruments++;
				    instrmemsize+=iend;
				  }
				}
	  }
	  /*panning setzen*/
	  for( i=numtracks;i>=1;i--) defpanning[i-1]=128*((i % 4)/ 2);
	  free(pbuffer);
	  memset(ptrntempi,0,sizeof(ptrntempi));
	  memset(ptrnbreaks,63,sizeof(ptrnbreaks));
	};break;
	case wow:;
	case noisetr:{
	  /*------------------------------------------mod------------------------------------------------------------*/
	  pbuffer=(byte*)(malloc(sizeof(tmodheader)));
	  f.read(pbuffer,sizeof(tmodheader));
	  if ( f.gcount()!=sizeof(tmodheader) ) { error=id_nomodfile;free(pbuffer); return; }
	  result=0;
	  if ( filetype==noisetr ){
	    //with pmodheader(pbuffer)^ do
	    char *modsign=pmodheader(pbuffer)->modsign;
	    if ( !strncmp(modsign,"FLT4",4) ) { filetype=startr; numtracks=4; } else
	      if ( !strncmp(modsign,"FLT8",4 )) { filetype=startr; numtracks=8; } else
		if ( !strncmp(modsign,"M.K.",4 )) { filetype=protr; numtracks=4; } else
		  if ( !strncmp(modsign,"M!K!",4 )) { filetype=protr; numtracks=4; } else
		    if ( !strncmp(modsign,"M&K!",4 )) { filetype=protr; numtracks=4; } else
		      if ( !strncmp(modsign,"M.K!",4 )) { filetype=protr; numtracks=4; } else
			if ( !strncmp(modsign,"EX04" ,4)) { filetype=protr; numtracks=4; } else
			  if ( !strncmp(modsign,"EX08" ,4)) { filetype=protr; numtracks=8; } else
			    if ( !strncmp(modsign,"OCTA" ,4)) { filetype=protr; numtracks=8; } else
			      if ( !strncmp(modsign,"CD81" ,4)) { filetype=protr; numtracks=8; } else
				if ( !strncmp(modsign+2,"CHN",3 )){ 
				  filetype=ftrk; numtracks=modsign[1]; // geandert
				}else
				  if ( !strncmp(modsign+3,"CH",2 )){ 
				    filetype=ftrk; numtracks=modsign[1];// hier auch val 
				  }else
				    numtracks=4;
	  }else numtracks=8;
	  if ( (result!=0)||(numtracks<4)||(numtracks>32))
	    { error=id_nomodfile;free(pbuffer); return; }
	  if ( filetype==noisetr ){  /* 15 instrumente file */   
	    /*15 samples file ====> header in 31-instr. file header konvertieren!*/
	    f.seekg(0,ios::beg);f.read(pbuffer,sizeof(t15modheader));
	    pmodheader(pbuffer)->arrangesize=p15modheader(pbuffer)->arrangesize;
	    pmodheader(pbuffer)->ciaaspeed  =p15modheader(pbuffer)->ciaaspeed;
	    pmodheader(pbuffer)->arrangement=p15modheader(pbuffer)->arrangement;
	    for( i=15;i<=30;i++){
	      //with pmodheader(pbuffer)^.instrbank[i] do
	      pmodheader(pbuffer)->instrbank[i].samplen=0;
	      pmodheader(pbuffer)->instrbank[i].samptune=0;
	      pmodheader(pbuffer)->instrbank[i].sampvol=0;
	      pmodheader(pbuffer)->instrbank[i].sampreps=0;
	      pmodheader(pbuffer)->instrbank[i].samprepl=0;
	      pmodheader(pbuffer)->instrbank[i].sampname[0]=0;
	    }
	  }
	  if ((filetype==noisetr)||(filetype==protr)||(filetype==startr)) forcerange = true;
	  //with pmodheader(pbuffer)^ do
	  {
	    char *const & modname=pmodheader(pbuffer)->modname;
	    tfileinstrument *const& instrbank=pmodheader(pbuffer)->instrbank;
	    byte& arrangesize=pmodheader(pbuffer)->arrangesize;
	    byte& ciaaspeed=pmodheader(pbuffer)->ciaaspeed;
	    tarrangement& arrangement=pmodheader(pbuffer)->arrangement;
	    char *const & modsign=pmodheader(pbuffer)->modsign;
	    
	    if ((arrangesize>127)||(arrangesize==0)) { error=id_nomodfile;free(pbuffer); return; }
	    memmove(parrangement,arrangement,128);
	    initbpmspeed=125;
	    initspeed=6;
	    numpatterns=arrangesize;
	    /*find max patternnumber*/
	    lastpattern=0;
	    diffpatterns=0;
	    memset(alreadyplayed,0,sizeof(alreadyplayed));
	    for( i=0;i<arrangesize;i++){
	      if ( arrangement[i]>lastpattern ) lastpattern=arrangement[i];
	      if ( !(alreadyplayed[arrangement[i]])){
		alreadyplayed[arrangement[i]]=true;
		diffpatterns++;
	      }
	    }
	    /* find dummy patterns */
	    for( i = arrangesize;i<= 127;i++)
	      if ( arrangement[i] > dummypatterns ) dummypatterns = arrangement[i];
	    if ( dummypatterns > lastpattern ) dummypatterns-=lastpattern; else dummypatterns = 0;
	    if ( (lastpattern>127)) { error=id_nomodfile; free(pbuffer); return; }
	    difftracks=diffpatterns*numtracks;
	    lasttrack=word(lastpattern)*numtracks;
	    sconvert(::modname,modname,20);
	    reducestring (::modname);
	    trackmemsize = int32 (lastpattern + 1) * numtracks * (64 * (sizeof (tnote)+1) + 2);//succ
	    /*instrumentendaten auswerten*/
	    instrmemsize=0;
	    numinstruments=0;
	    for( i= 0;i<=30;i++){
	      //with instrbank[i] do with instruments[i] do
	      char *const & sampname=instrbank[i].sampname;
	      char& samptune        =instrbank[i].samptune;
	      word& samplen         =instrbank[i].samplen;
	      word& sampreps        =instrbank[i].sampreps;
	      word& samprepl        =instrbank[i].samprepl;
	      byte& sampvol         =instrbank[i].sampvol;
	      char *const & name    =instruments[i+1].name;
	      int32& offset         =instruments[i+1].offset;
	      int32& iend           =instruments[i+1].iend;
	      int32& loopstart      =instruments[i+1].loopstart;
	      int32& loopend        =instruments[i+1].loopend;
	      byte& volume	      =instruments[i+1].volume;
	      byte& finetune	      =instruments[i+1].finetune;
	      byte& bits	      =instruments[i+1].bits;
	      word& tuning          =instruments[i+1].tuning;
	      if ( samplen>0 ){	
		offset=0;
		iend=int32( (word(lo(samplen))<< 8) + hi(samplen) ) << 1;
		loopstart=int32( (word(lo(sampreps))<< 8) + hi(sampreps) )<< 1;
		loopend  =int32( (word(lo(samprepl))<< 8) + hi(samprepl) )<< 1;
						loopend+=loopstart;
					        volume=sampvol;
						finetune=samptune & 0x0f;
						numinstruments++;
						instrmemsize+=iend;
						bits=8;
						tuning=8363;
						if ( !(uniload)
						     &&(filetype==noisetr)
						     &&((samptune>0xf)
							||(sampvol>64)
							||(iend>65535)
							||(loopstart>iend))
						     ) { free(pbuffer);error=id_nomodfile;return; 
						}
	      }
	      sconvert(name,sampname,22);
	    }
	  }
	  /*panning setzen*/
	  for( i=numtracks-1 ;i>= 0;i--) defpanning[i]=128*((i % 4)/ 2);
	  free(pbuffer);
	  memset(ptrntempi,0,sizeof(ptrntempi));
	  memset(ptrnbreaks,63,sizeof(ptrnbreaks));
	};break;
	case xm  :{
	  /*------------------------XM by Carsten -----------------------------------*/
	  unsigned int size=0,pos=0;
	  instrmemsize=0;
	  XM_Header *pHeader;
	  pHeader=new XM_Header;
	  f.read((char*)pHeader,sizeof(XM_Header));
	  if ( f.fail() ) { 
	    error=id_nomodfile;
	    delete pHeader; 
	    return; 
	  }
	  size=pHeader->header_size;
	  //set global player engine variables
	  numpatterns=pHeader->numpatterns; 
	  numinstruments=pHeader->numinstr;
	  numtracks=pHeader->numchannels;   
	  initbpmspeed=pHeader->tempo;
	  initspeed=pHeader->BPM;
	  initglobvol =32;
	  mastervol   =64;
	  memset(ptrntempi,0,sizeof(ptrntempi));
	  memset(ptrnbreaks,63,sizeof(ptrnbreaks));
	  for(int i=0;i<numtracks;i++) defpanning[i]=64;
	  //read the arrangement
	  for (int i=0; i<numpatterns;i++) parrangement[i]=pHeader->pattorder[i];

	  strncpy(::modname,pHeader->modulename,20);
	  delete pHeader;

	  // -- read the pattern header
	  //f.seekg(pos = size<sizeof(XM_Header) ? pos+=size);
	  pos = sizeof(XM_Header);
	  XM_Pattern_header *pPattern=new XM_Pattern_header;

	  //search for instruments position in file
	  for (int i=0;i<numpatterns;i++){
	    f.read((char*)pPattern,sizeof(XM_Pattern_header));
	    f.seekg(pPattern->datasize,ios::cur);
	  }
	  delete pPattern;

	  // -- read the Intruments
	  //????????????????? How to handle intruments with more then 1 sample ???????
	  XM_Instrument_header* pInst=new XM_Instrument_header;
	  XM_Instrument_header2* pInst2=new XM_Instrument_header2;
	  XM_Sample_header* pSample=new XM_Sample_header;
	  
	  for (int i=0;i<numinstruments;i++){
	    long pos=f.tellg();//for later use
	    f.read((char*)pInst,sizeof(XM_Instrument_header));
	    char *const &name=instruments[i+1].name;
	    int32 &offset    =instruments[i+1].offset;
	    int32 &iend      =instruments[i+1].iend;
	    int32 &loopstart =instruments[i+1].loopstart;
	    int32 &loopend   =instruments[i+1].loopend;
	    byte &volume     =instruments[i+1].volume;
	    byte &finetune   =instruments[i+1].finetune;
	    byte &bits	     =instruments[i+1].bits;
	    word &tuning     =instruments[i+1].tuning;
	    
	    strncpy(name,pInst->name,22);
	    
	    //move to next header
	    if (!pInst->numsamples){
	      f.seekg(pInst->size-sizeof(XM_Instrument_header),ios::cur);
	    }else{
	      /*there are samples*/
	      f.read((char*)pInst2,sizeof(XM_Instrument_header2));
	      f.seekg(pos+pInst->size);
	      //read the sample headers
	      int Samplelength=0;
	      for(int i=0;i < pInst->numsamples;i++){
		f.read((char*)pSample,sizeof(XM_Sample_header));
		Samplelength+=pSample->length;
		offset=0;
		//iend=pSample->length;
		//instrmemsize+=iend;
		volume=pSample->vol;
		loopstart=pSample->loop_start;
		loopend=loopstart+pSample->loop_length;
		finetune=pSample->finetune;
		bits=(pSample->type & 0x10) ? 16 :8;
		tuning=8363;
	      }
	      iend=Samplelength;
	      instrmemsize+=Samplelength;
	      f.seekg(Samplelength,ios::cur);
	    }
	    
	  }
	  delete pInst;
	  delete pInst2;
	  delete pSample;
	  lastpattern=numpatterns-1;
	  //calculate the memory needed for the patterns
	  trackmemsize = int32 (numpatterns) * numtracks * (64 * (sizeof (tnote)+1) + 2);
	};break;
	case mtm :{
	  /*------------------------------------------mtm------------------------------------------------------------*/
	  initbpmspeed=125;
	  initspeed=6;
	  pbuffer=(byte*)(malloc(sizeof(tmtmheader)));
	  f.read(pbuffer,sizeof(tmtmheader));
	  if ( f.gcount()!=sizeof(tmtmheader) ) { error=id_nomodfile;free(pbuffer); return; }
	  
	  //with pmtmheader(pbuffer)^ do
	  {
	    char *const& sign =pmtmheader(pbuffer)->sign;
	    byte& version     =pmtmheader(pbuffer)->version;
	    char *const& mtmname=pmtmheader(pbuffer)->mtmname;
	    word& savedtracks =pmtmheader(pbuffer)->savedtracks;
	    byte& lastpattern =pmtmheader(pbuffer)->lastpattern;
	    byte& lasttoplay  =pmtmheader(pbuffer)->lasttoplay;
	    word& commentlen  =pmtmheader(pbuffer)->commentlen;
	    byte& numsamples  =pmtmheader(pbuffer)->numsamples;
	    byte& attribute   =pmtmheader(pbuffer)->attribute;
	    byte& beatpertrck =pmtmheader(pbuffer)->beatpertrck;
	    byte& ntracks     =pmtmheader(pbuffer)->ntracks;
	    tpanarray& panpostns=pmtmheader(pbuffer)->panpostns;
	    
	    /*filetype testen*/
	    if (// (!memcmp(sign,"MTM" ,3))||
		(attribute!=0)
		||( ! ((ntracks>=1)
		       &&(ntracks<=32)))){ 
	      error=id_nomodfile;free(pbuffer); return; 
	    }
	    for( i=0;i<=31;i++)// evt 0..31 
	      if ( panpostns[i]>0xf ){ 
		error=id_nomodfile;
		free(pbuffer); 
		return; 
	      };
	    sconvert(modname,mtmname,20);
	    reducestring (::modname);
	    ::lasttrack      =savedtracks-1;
	    ::difftracks     =savedtracks;
	    ::lastpattern    =lastpattern;
	    ::numpatterns    =lasttoplay+1;
	    ::numinstruments =numsamples;
	    ::numtracks      =ntracks;
	    trackmemsize            =int32 (savedtracks) * (beatpertrck *  (sizeof(tnote)+1) + 2);
	    ::commentlen   =commentlen;
	    if ( commentlen>0 ) {
	      comment=pcommentbuf(malloc(commentlen));
	      unilong=f.tellg();
	      f.seekg(194+(numsamples*37)+(savedtracks*int32(192))+(lastpattern+1)*32*2,ios::beg);
	      if ( f.fail() ) { error=id_nomodfile;free(pbuffer); return; }
	      f.read(comment,commentlen);
	      if ( f.gcount()!=commentlen ) { error=id_nomodfile;free(pbuffer); return; }
	      f.seekg(unilong,ios::beg);
	    }
	    for( i=0 ;i<=31;i++) defpanning[i]=panpostns[i]<< 3+panpostns[i]>> 1+panpostns[i]>> 3;
	    if ( (lastpattern>127)) { error=id_nomodfile; free(pbuffer); return; }
	    memset(ptrnbreaks,beatpertrck-1,sizeof(ptrnbreaks));
	  }//-endwith
	  free(pbuffer);
	  pbuffer=(byte*)(malloc(numinstruments*sizeof(tmtminstrument)));
	  f.read(pbuffer,numinstruments*sizeof(tmtminstrument));
	  if ( f.gcount()!=numinstruments*sizeof(tmtminstrument) )
	    { error=id_nomodfile;free(pbuffer); return; }
	  instrmemsize=0;
	  for( i=numinstruments;i>= 1;i--){
	    //with pmtminstrbank(pbuffer)^[i],instruments[i] do
	    char *const & name  =instruments[i].name;
	    int32& offset    =instruments[i].offset;
	    int32& iend      =instruments[i].iend;
	    int32& loopstart =instruments[i].loopstart;
	    int32& loopend   =instruments[i].loopend;
	    byte& volume	=instruments[i].volume;
	    byte& finetune	=instruments[i].finetune;
	    byte& bits	=instruments[i].bits;
	    word& tuning     =instruments[i].tuning;
	    char *const& sampname=(*(pmtminstrbank)pbuffer)[i-1].sampname;
	    int32 samplen = *(int32*)((*pmtminstrbank(pbuffer))[i-1].samplen);
	    int32 sampreps =*(int32*)((*pmtminstrbank(pbuffer))[i-1].sampreps);
	    int32 samprepe =*(int32*)((*pmtminstrbank(pbuffer))[i-1].samprepe);
	    char& samptune =(*(pmtminstrbank)pbuffer)[i-1].samptune;
	    byte& sampvol  =(*(pmtminstrbank)pbuffer)[i-1].sampvol;
	    byte& sampattr =(*(pmtminstrbank)pbuffer)[i-1].sampattr;
	    
	    sconvert(name,sampname,22);
	    if ( samplen==0 ) numinstruments--; 
	    else{
	      iend      =samplen;
	      loopstart =sampreps;
	      loopend   =samprepe;
	      finetune  =samptune & 0x0f;
	      volume	=sampvol;
	      bits      =8*(sampattr & 0x1)+8;
	      tuning    =8363;
	      instrmemsize+=iend;
	    }
	  }//und -endwith
	  /*****arrangement einlesen*******/
	  f.read(parrangement,sizeof(tmtmarrangement));
	  if ( f.gcount()!=sizeof(tmtmarrangement) ) { error=id_nomodfile;free(pbuffer); return; }
	  memset(alreadyplayed,0,sizeof(alreadyplayed));
	  diffpatterns=0;
	  for( i=0 ;i<=numpatterns-1;i++)
	    if ( !(alreadyplayed[parrangement[i]])){
	      alreadyplayed[parrangement[i]]=true;
	      diffpatterns++;
	    }
	  free(pbuffer);
	  memset(ptrntempi,0,sizeof(ptrntempi));
	};break;
	default: error=id_nomodfile;
	}
}
