#include "modc.h"
#include "misc.h"
#include "effects.h"
#include "oktalyzer.h"
#include <stdlib.h>
#include <string.h>
#include <fstream.h>
#include <sys/shm.h>


extern ifstream f;

typedef byte tbyte[65521];
typedef tbyte *pbyte;
static byte *pbuffer;
void *Wavebeg;
extern int sid;

boolean getplaymem(int32 mem)
{
  if (soundsettings.quality) mem += 16384;
  //playmemhandle=malloc(mem+surrbufferlen);
  // playmem ist im shared mem Bereich
  sid=shmget(IPC_PRIVATE,mem+surrbufferlen,IPC_CREAT | SHM_R| SHM_W);
  if (sid==-1) cerr<<"Shared Memory Error\n";
  playmemhandle=shmat(sid,NULL,0);

  playmemtop= int (playmemhandle)+mem+surrbufferlen;
  if (playmemhandle==NULL) return(false);//nicht genug speicher
  
  waveofs=surrbufferlen+int32(playmemhandle);
  if (soundsettings.quality) waveofs +=16384;
  Wavebeg=waveofs-(int)playmemhandle;
  waveend=waveofs;
  wavestrt=waveofs;
  return(true);
}

void freeplaymem(void)
{
  if (songmemhandle>NULL){
  }
  //free(playmemhandle);
  //delete shared memory segment
  //printf("freeplaymem");
  shmdt(playmemhandle);
  shmctl(sid,IPC_RMID,NULL);
  
  playmemhandle=0;
  playmemtop=0;
  wavestrt=0;
  waveend=0;
  waveofs=0;
}

void songmemwrite(void *src,int32 count,byte args)
{

/*args:
6...16 bit unsigned to 8 bit signed
5...16 bit signed to 8 bit signed
4... 7 bit signed
3...16 bit unsigned
2...16 bit signed
1... 8 bit unsigned
0... 8 bit signed 
*/

#if 1
  int i;
  switch(args){
  case 0:{
    memcpy(songmemofs,src,count);
    songmemofs+=count;
  }; break;
  case 1:{
    for ( i=0;i<count;i++ ){
       *((byte*)songmemofs)++ = *((byte*)src)++ - 0x80;
    }
  }; break;
  case 2:{
    memcpy(songmemofs,src,count*2);
    songmemofs+=count;
    songmemofs+=count;
  } ; break;
  case 3:{
    for ( i=0;i<count;i++ )
    *((word*)songmemofs)++ = *((word*)src)++ - 0x8000;
  }; break;
  default: printf("%s","songmemwrite: args out of range"); break;
   
  }
#else
asm("
#  les 8(%ebp),%esi
   mov %ebx,%esi
#  mov songmemsel,%ax
#  mov  %ax,%fs
  mov songmemofs,%edi
  mov 12(%ebp),%ecx  #count
#  mov 16(%ebp),%al   #args //die sind schon in %al
  cmpb $6,%al
  je  lstrt16bitu0
  cmpb $5,%al
  je  lstrt16bits0
  cmpb $4,%al
  je  lstrt7bit
  cmpb $3,%al
  je  lstrtuw
  cmpb $2,%al
  je  lstrtsw
  cmpb $1,%al
  je  lstrtub

lstrtsb:
 movb (%esi),%al
 movb %al,(%edi)
 inc %edi
 inc %esi
 aword;loop lstrtsb
 jmp lend

lstrt7bit:
  movb (%esi),%al
  shlb $1,%al
  movb %al,(%edi)
  inc %edi
  inc %esi
  aword;loop lstrt7bit
  jmp lend

lstrtub:
  movb (%esi),%al
 subb $0x80,%al
  movb %al,(%edi)
  incl %edi
  incl %esi
  aword;loop lstrtub
  jmp lend

lstrtsw:
  movw (%esi),%ax
  movw %ax,(%edi) 
  addl $2,%edi
  addl $2,%esi
  loop lstrtsw
  jmp lend

lstrtuw:
  movw (%esi),%ax
  subw $0x8000,%ax
  movw %ax,(%edi)
  add $2,%edi
  add $2,%esi
  aword;loop lstrtuw
  jmp lend
lstrt16bitu0:
  shrw $1,%cx
lstrt16bitu:
  movw (%esi),%ax
  subw $0x8000,%ax
  movb %ah,(%edi)
  inc %edi
  add $2,%esi
  aword;loop lstrt16bitu
  jmp lend

lstrt16bits0:
  shrw $1,%cx
lstrt16bits:
  movw (%esi),%ax
  movw %ax,(%edi)
  inc %edi
  add $2,%esi
  aword;loop lstrt16bits

lend:
  mov %edi,songmemofs
");
#endif
}

/* num = number of tracks to be written
   max = number of notes in track
*/

void trackwrite(byte num,byte max)
{
	int twi,twj;
    	word ofs0,ofs1,oldofs;
    	byte flgs,emptyrows;
    	pbyte bbuf;

/* gepacktes trackformat:
* word ...laenge des tracks in byte einschliesslich dieses words
*   +beliebig oft
*     byte ...flags:
*                bit0...instr.   != 00h
*                bit1...ton      != 00h
*                bit2...effekt   != ffh (noeffekt)
*                bit3...operands != 00h
*                bit4...chnvol   != ffh
*                [bit 5-7 anzahl der folgenden leerzeilen]
*       +byte ...falls (flags and 01h)>0 instrument
*       +word ...falls (flags and 02h)>0 ton
*       +byte ...falls (flags and 04h)>0 effekt
*       +byte ...falls (flags and 08h)>0 operands
*       +byte ...falls (flags and 10h)>0 chnvol
*/
 	 bbuf=pbyte(malloc(2+max*7));
 	 for (twi=0;twi<num;twi++){
		ofs1=2;
		oldofs=ofs1;
		emptyrows=0;
		if ( max>0 ){ 
			for( twj=0;twj<max ;twj++){
				//with pattern^[twi][twj] do
				/*note packen!*/
				ofs0=ofs1;
				flgs=0;
				ofs1++;
				if ((*pattern)[twi][twj].instrument!=0){ 
					flgs=flgs | 0x01;
					(*bbuf)[ofs1]=(*pattern)[twi][twj].instrument;
					ofs1++;  
				}
				if ( (*pattern)[twi][twj].ton!=0 ) { 
					flgs=flgs | 0x02;
					*(word*)(*bbuf+ofs1)=(*pattern)[twi][twj].ton;
					ofs1+=2;
				}
				if ( (*pattern)[twi][twj].effekt!=noeffekt ) { 
					flgs=flgs | 0x04;
					(*bbuf)[ofs1]=(*pattern)[twi][twj].effekt;
					ofs1++;  
				}
				if ( (*pattern)[twi][twj].operands!=0  ) { 
					flgs=flgs | 0x08;
					(*bbuf)[ofs1]=(*pattern)[twi][twj].operands;
					ofs1++;
				}
				if ( (*pattern)[twi][twj].chnvol!=-1) { 
					flgs=flgs | 0x10;
					(*bbuf)[ofs1]=(*pattern)[twi][twj].chnvol;
					ofs1++;
				}
				if ( (flgs==0) && (emptyrows<7) && (twj!=0) ){
					emptyrows++;
					ofs1--;
				}else{
					(*bbuf)[oldofs]=(*bbuf)[oldofs] | (emptyrows << 5);
					(*bbuf)[ofs0]=flgs;
					emptyrows=0;
					oldofs=ofs0;
				}
			}
		}
		*((word*)bbuf)=ofs1;
		songmemwrite(bbuf,ofs1,0);
	 }
	free(bbuf);
}


void sconvert(string s,char pc[],byte nmax)
{
//konvertiert einen pchar(ohne abschliessende null) in einen string unter
// ausschluss von steuerzeichen 
#if 0
__asm__("
    cld 
    #ds:si--->pc[0]
    mov %ecx,%esi #pc
    #ecx -->anzahl der Zeichen nmax
    mov %eax,%ecx
    xor %ch,%ch
    #es:di--->s[1]
    mov 8(%ebp),%edi #s
lscstart:
    lodsb
    or  %al,%al   # was it 0  
    jz  lscstop   # stop it   
    cmp $0x20,%al # ' '
    #pc[i]>==#32?
    jae lsc1
    #nein--->s[i+1]=32
    mov $0x20,%al
lsc1: #ja --->s[i+1]=pc[i]
    stosb
    loop lscstart
lscstop:
     mov $0,%al
     stosb
	");
#else
int n,i;
for ( i=0,n=0;(n<nmax);n++){
  if ( pc[i]>=32 ) 
    s[i++]=pc[i];
  else
    if ( pc[i]==0 ) break;
}
s[i]=0;
#endif
}
	
void reducestring (string astring){
   
   //char* pst;
	//string hst;
	//while ((strlen(astring)>0) && (astring[strlen(astring)]==32)) byte(astring[strlen(astring)])=0;
	//while ((strlen(astring)>0) && (astring[0]==32)){ pst=strcpy(hst,astring+1);
	//						 pst=strcpy(astring,hst);
							 //	}
}

boolean one_8;//fuer oktalyzer!!!!!!!!

int32 swaplong(int32 l){
	word tmp;
	union wowo{
		int32 LONG;
		word WORD[2];
	} hilo;
	hilo.LONG=l;
	tmp=hilo.WORD[0];
	hilo.WORD[0]=hilo.WORD[1];
	hilo.WORD[1]=tmp;
	return hilo.LONG;
}

boolean getchannels(int32 asize){
		boolean help;
		struct tbytearray{
			byte dummy,tbyte;
		}bytearray;
		typedef tbytearray *pbytearray;

		help=false;
		if ( asize!=8 ) return(help);
		f.read(pbuffer,asize);
		if ( f.gcount()!=asize ) return(help);
		numtracks=0;
		for( i=0;i<=3;i++){
			//with pbytearray(pbuffer)^[i] do 
			switch ((pbytearray(*pbuffer))[i].tbyte){
				case 0:{
					numtracks++;
					switch (i){ 
					 case 0:
					 case 3: defpanning[numtracks]=0;break;
					 case 1:
					 case 2:defpanning[numtracks]=128;break;
					}
					relatedchn[numtracks]=numtracks;
				};break;
				case 1:{
					numtracks+=2;
					switch (i){
					 case 0:
					 case 3:{ defpanning[numtracks]=0;  defpanning[numtracks-1]=0;};break;
					 case 1:
					 case 2:{ defpanning[numtracks]=128;defpanning[numtracks-1]=128;};break;
					}
					relatedchn[numtracks-1]=numtracks  ;
					relatedchn[numtracks  ]=numtracks-1;
				};break;
				default: return(help);
			}
		}
		return(true);
	}

	boolean getinstrdata(int32 asize){
		boolean help;
		one_8=false;
		help=false;
		if ( (asize % (sizeof(toktinstrument))) !=0 ) return(help);
		i=0;
		instrmemsize=0;
		numinstruments=0;
		do{
			f.read(pbuffer,sizeof(toktinstrument));
			if ( f.gcount()!=sizeof(toktinstrument) ) return(help);
			//with poktinstrument(pbuffer)^,instruments[i] do
			(poktinstrument(pbuffer))->samplen=swaplong((poktinstrument(pbuffer))->samplen);
			if ( (poktinstrument(pbuffer))->samplen>0 ){
				instruments[i].offset=0;
				instruments[i].iend=(poktinstrument(pbuffer))->samplen;
				(poktinstrument(pbuffer))->sampreps=swap((poktinstrument(pbuffer))->sampreps) << 1;
				(poktinstrument(pbuffer))->samprepl=swap((poktinstrument(pbuffer))->samprepl) << 1;
				if ( (poktinstrument(pbuffer))->samprepl <= (poktinstrument(pbuffer))->samplen ){
					instruments[i].loopstart = (poktinstrument(pbuffer))->sampreps;
					instruments[i].loopend   = (poktinstrument(pbuffer))->sampreps+(poktinstrument(pbuffer))->samprepl;
				}
				if ( instruments[i].loopend>(poktinstrument(pbuffer))->samplen ) instruments[i].loopend=(poktinstrument(pbuffer))->samplen-instruments[i].loopstart;
				instruments[i].volume=(poktinstrument(pbuffer))->defvol;
				instruments[i].finetune=0;
				if ( hi((poktinstrument(pbuffer))->sampres)==1 ) { instruments[i].bits=8;one_8=true;} else instruments[i].bits=7;
				numinstruments++;
				instrmemsize+=instruments[i].iend;
				instruments[i].tuning=8363;
			}
			sconvert(instruments[i].name,(poktinstrument(pbuffer))->sampname,20);
			//--endwith
			i++;
			asize-=sizeof(toktinstrument);
		}
		while (asize>0);
		return(true);
	}

boolean getinitspeed(int32 asize){
	boolean help;
	struct tbytearray{
		byte dummy,tbyte;
	}bytearray;
	typedef tbytearray *pbytearray;

	help=false;
	if ( asize!=2 ) return(help); 
	f.read(pbuffer,asize);
	if ( f.gcount()!=asize ) return(help);
	initspeed=pbytearray(pbuffer)->tbyte; 
	if ( initspeed==0 ) initspeed=6;
	initbpmspeed=125;
	return(true);
}
boolean getslen(int32 asize){
	int help;
	help=false;
	if ( asize!=2 ) return(help);
	f.read(&lastpattern,asize);
	if ( f.gcount()!=asize ) return(help);
	lastpattern=swap(lastpattern);
	return(true);
}
boolean getarrangesize(int32 asize){
	int help;
	help=false;
	if ( asize!=2 ) return(help);
	f.read(&numpatterns,asize);
	if ( f.gcount()!=asize ) return(help);
	numpatterns=swap(numpatterns);
	return(true);
}

boolean getarrangement(int32 asize){
	int help;
	help=false;
	if ( asize>256 ) return(help);
	f.read(parrangement,asize);
	if ( f.gcount()!=asize ) return(help);
	memset(ptrntempi,0,sizeof(ptrntempi));
	memset(ptrnbreaks,63,sizeof(ptrnbreaks));
	diffpatterns=0;
	memset(alreadyplayed,0,sizeof(alreadyplayed));
	for( i=0;i< numpatterns ;i++){
		if ( parrangement[i]>lastpattern ) lastpattern=parrangement[i];
		if ( !(alreadyplayed[parrangement[i]])){
			alreadyplayed[parrangement[i]]=true;
			diffpatterns++;
		}
	}
	difftracks=diffpatterns*numtracks;
	lasttrack=lastpattern*numtracks;
	trackmemsize = int32 ((lastpattern + 1) * numtracks * (256 * (sizeof(tnote)+1) + 2));//succ ersetzt
	return(true);
}
byte hi(word p1){
	return byte(p1 >> 8);
}

byte lo(word p1){
	return byte (p1);
}
word loword(int32 p1){
	return word(p1);
}
word swap(word p1){
	byte tmp;
	union wowo{
		word WORD;
		byte BYTE[2];
	} hilo;
	hilo.WORD=p1;
	tmp=hilo.BYTE[0];
	hilo.BYTE[0]=hilo.BYTE[1];
	hilo.BYTE[1]=tmp;
	return hilo.WORD;
}

int32 filesize(void){
	// is not nice but it works for one file
	int32 end,curr;
	curr=f.tellg();
	f.seekg(0,ios::end);end=f.tellg();
	f.seekg(curr,ios::beg);
	return end;
}

