#ifndef MODC_H
#define MODC_H
#include "player.h"


typedef struct   {
       int filetype ;              
       byte dummy         ;
       word filesiz       ;             
       string modname     ; 
       word numtracks     ;             
       word difftracks    ;             //anzahl der voneinander verschiedenen gespielten tracks
       word numinstruments;
       tinstrument instruments[256];
       word dummypatterns ;              //anzahl der gespeicherten aber nicht gespielten patterns
       int32 extrabytes   ;              //ueberlaenge des files
       int32 missingbytes ;              //fehlende bytezahl
       word effectsused   ;              //bit gesetzt=effekt benutzt
       word proeffectsused;              //bit gesetzt=effekt benutzt
       word extraeffused  ;              //bit gesetzt=effekt benutzt
       word extraeffused1 ;              //bit gesetzt=effekt benutzt
       word panningoff;              //panning wird nicht benutzt
       int32 songmem     ;               //speichergroesse fuer pattern und samples
       int32 playmemtop  ;               //speichergroesse fuer playbuffers
       int loopfrom      ;               //pattern, von dem aus geloopt wird
       int loopto        ;               //pattern, zu welchem geloopt wird
       word playing    ;             //modul spielt
       int32 cpuusage      ;             //aktuelle cpu-auslastung
       int32 totaltime     ;             //gesamtspielzeit [ms]
       int32 currtime      ;             //aktuell zu hoerende zeit [ms]
       int32 buftimelen    ;             //samplepufferlaenge [ms]
       word currpttrn     ;              //aktuell zu hoerendes pattern
       word numpatterns   ;              //groesse des patternarrangements
       word diffpatterns  ;              //anzahl der voneinander verschiedenen gespielten pattern
       word currline      ;
       effectstate curreffects   ;       //zu hoerende effekte
       effectstate currproeffects;       //zu hoerende protracker-effekte
       effectstate currextraeff  ;       //zu hoerende stm/okt...-effekte
       effectstate currextraeff1 ;       //zu hoerende stm/okt...-effekte
       tbytestate currinstr     ;
       tbytestate currvols      ;
       tbytestate currnotes     ;
       byte currspd       ;
       byte currbpm       ;
       word commentlen    ;
       pcommentbuf comment;
       }tmodulinfo;

typedef struct  {
  int32 time ;
  byte pattrn;
  effectstate effects   ;   //zu hoerende effekte
  effectstate proeffects;   //zu hoerende protracker-effekte
  effectstate extraeff ;
  effectstate extraeff1;
  tbytestate volumes ;
  tbytestate notes   ;
  tbytestate playinstr;
  byte bpm        ;
  byte spd        ;
  byte playline   ;
} tplaytime;

typedef  tplaytime tplaytimes[98];
typedef  tplaytimes *pplaytimes;


#ifndef SOUND_H

#endif


typedef boolean waveflags[100];/*zur kennzeichnung fuer playbuffer*/


asm("
	noisetr=0
	startr=1
	protr=2
	ftrk=3
	wow=4
	mtm=5
	oktalyz=7
	f669=8
	stm=9
	ffar=10
	ult=11
	s3m=12
	unis=13
        xm=14
");





asm("
       deviceid  =0
       name =4
       samplerate=44
       stereo    =46
       bits      =47
       nbuffers  =48
       surround=49
       nobpm   =50
       tmode     =51
       preamp    =52
       quality =53
       oversamp=54
");

/*filetype id's*/

#define    id_noisetrack    600
#define    id_4chn_startrek 601
#define    id_protrack      602
#define    id_6chn_mod      603
#define    id_8chn_mod      604
#define    id_8chn_startrek 605
#define    id_nomodfile     606
#define    id_invmodfile    607
#define    id_nomem         608
#define    id_filenotfound  609

/****************typen zum abspielen von mod-files***************************/

union  tvoltable{
	short int word[65][256];//fuer 16bit/8bit-quality
	char byte[65][256];//fuer 8bit
};

extern int32 tunetable[16];

typedef   byte tpanarray[32];

struct tnote {
  byte instrument;
  word ton;
  byte effekt;
  byte operands;
  char chnvol;//8 bit int
} ;

typedef   tnote   ttrack[256] ;
typedef   ttrack  *ptrack;

typedef   word      torderdata[32];

typedef   torderdata ttrackseq[256];
typedef   ttrackseq *ptrackseq;

typedef   ttrack    tpattern[32];
typedef   tpattern  *ppattern;

struct tchannel {
  int32       note;// aktueller sampleoffset                     
  int32       iend;// laenge der instrumente in bytes             
  int32       lst ;// loopstart der instrumente in bytes         
  int32       lend;// looplaenge der instrumente in bytes         
  word        rest;// uebertrag der nachkommastellen              
  int32    oldsmp;
  int32      plo   ;// Phi,Plo vorkommastellen fuer sampleincrement        
  word       phi    ;   // frueer plo nachkommastellen fuer sampleincrement       
  byte       lvol   ;   // linke lautstaerke der instrumente           
  byte       rvol   ;   // rechte lautstaerke der instrumente          
  byte       avgvol ;   // mittlere lautstaerke der instrumente        
  
  byte       vol    ;   // lautstaerke der instrumente                 
  byte       panval ;
  word       tonh   ;
  byte       effkt  ;
  byte       opnd   ;
  byte       inst   ;
  byte       nxtinst;
  word       tpton  ;
  byte       volsld ;
  byte       vtini  ;
  byte       acnt   ;
  
  byte       vops   ;//merker fuer vibrato
  byte       tops   ;//merker fuer tremolo
  byte       prtops ;//merker fuer portamento to note
  byte       ofsops ;//merker fuer setoffset
  byte       arpops ;//merker fuer arpeggio
  byte       arp1ops;//merker fuer oktalyzer arpeggio 1
  byte       arp2ops;//merker fuer oktalyzer arpeggio 2
  byte       pdelops;//merker fuer pattern delay
  byte       vsldops;//merker fuer volume slide
  //pro...
  byte       fvuops ;//merker fuer fine volume up
  byte       fvdops ;//merker fuer fine volume down
  byte       retrops;//merker fuer retrigger note
  //oktalyzer
  byte       oktsuops;//merker fuer oktalyzer slide up
  byte       oktsu1ops;//merker fuer oktalyzer slide up once
  byte       oktsdops ;//merker fuer oktalyzer slide down
  byte       oktsd1ops;//merker fuer oktalyzer slide down once
  byte       oldvolume;
  //tremor
  byte       tvol     ;
  //volumeportamento
  byte       volprt   ;
  byte       vpvblanc ;
  //farportamento
  byte       fpvblanc ;
  word       fptonh   ;
} ;

typedef   tchannel tchannels[32] ;
asm("
tch.note	=  0                     
tch.iend    =  4               
tch.lst     =  8
tch.lend    =  12           
tch.rest	=  16                 
tch.oldsmp	= 20  
tch.phi 	= 24            
tch.plo	= 28              
tch.lvol   =  30                 
tch.rvol   =   31                
tch.avgvol =   32          
tch.vol    =     33                       
tch.panval=	  34
tch.tonh   =    36
tch.effkt  =   38
tch.opnd   =  39
tch.inst   =  40
tch.nxtinst=  41
tch.tpton  =  42
tch.volsld =   44
tch.vtini  =   45
tch.acnt   =   46

tch.vops  =     47
tch.tops  =     48
tch.prtops=    49
tch.ofsops=   50
tch.arpops=   51
tch.arp1ops=  52
tch.arp2ops=  53
tch.pdelops=  54
tch.vsldops=  55
          #pro...
tch.fvops=    56
tch.fvdops=    57
tch.retrops=  58
           #oktalyzer
tch.oktsuops=   59
tch.oktsu1ops=   60
tch.oktsdops=    61
tch.oktsd1ops=   62
tch.oldvolume=   63
            #tremor
tch.tvol=          64   
            #volumeportamento
tch.volprt=        65
tch.vpvblanc=    66
            #farportamento
tch.fpvblanc=    67
tch.fptonh=      68
");



typedef  unsigned int tchannelmap; //set of1..32


const word   halfnote       =0xf1a2;      // 65536*2^(-1/12);zur berechnung von halbtonschritten  
const int32  halfnote1      =0x10f39;
const byte   mono8          =1;
const byte   stereo8        =2;
const byte   mono16         =3;
const byte   stereo16       =4;

extern  int initglobvol;
/****************globale variablen***************************************
 * Diese sind player32.cc und vars.cc definiert
 ************************************************************************/
extern byte relatedchn[8];// in vars.cc
extern tmodulinfo *pmodulinfo;
extern tsettings defsettings;
extern word pitchtable[146];
extern tvoltable voltable;


// Zeitnahme
   
//sigaction Sig_Action={sig_handle,SA_NOMASK,SA_RESTART,NULL};

extern   int32 i,j,k;   //allgemein zum zaehlen

   //speicherhandling
extern   void *songmemhandle;
extern   void *songmemsel;
extern   int32 songmemofs;
/*aufbau songmem:
 *    tracks     ...[1..32][0..numpatterns-1]of word
 *    pattern    ...statisches pattern zum spielen [1..numtracks][0..maxpattlen-1(63)]of tnote
 *    trackdata  ...[0..lasttrack]of ttrack
 *    samples
*/
extern   void *playmemhandle; 
extern   void *playmemsel;
extern   void *songmemtop;
extern   int32 instrmemsize;
extern   int32 trackmemsize;
extern   int32 firsttrack;
   //waveout-var's
extern   tsettings soundsettings ;
extern   byte playmode;                  //8bit mono...16bit stereo
extern   int32 notestretch;
extern   int32 wavestrt;
extern   int32 waveofs;
extern   int32 waveend;
extern   byte *currbuffer;
extern   byte *lastbuffer;
extern   word buffersize;
extern   int *distance;


   //zeitgeber-var's
extern   word amplaying;
extern   boolean ende;
extern   boolean notplay;

   //spielstatus
extern   ptrackseq     tracks;
extern   word          lasttrack;             //letzte gespielte tracknummer
extern   ppattern      pattern;               //enthaelt aktuelle daten zum abspielen
extern   char ptrntempi[256];
extern   byte ptrnbreaks[256];
extern   byte lastpattern;                  //letzte gespielte patternnummer
extern   boolean alreadyplayed[256];//pattern wurde schon gespielt

extern   byte currpattern;                  //aktuelle patternnummer
extern   byte currnote;                  //notenzeile im pattern
extern   byte currvblanc;                  //vblanc-takt

extern   byte speed;
extern   byte bpmspeed;
extern   word numsamples;                  //anzahl der samples fuer 1/50 sec

extern   boolean pm_is_working;
extern   boolean mod_end;
extern   boolean repeatsong;

extern   int32 playtime;               //zeit des aktuellen songs in ms
extern   int32 loopfromtime;               //zeit fr looping
extern   int32 looptotime;
extern   int32 timestep;
extern   word timesteprest;
extern   pplaytimes playtimes     ;
extern   int32 searchtime;               //zu suchende position beim spulen
extern   boolean search;               //nicht spielen, sondern spulen
extern   int32 starttime;               //systemzeit bei eintritt in play_the_module
extern   boolean _Pause;               //pause aktiv
extern   boolean amrepeating;
extern   byte repeatbuffer;

extern   int32 patterntimes[256];
extern   boolean searchpattern ;
extern   byte searchp       ;
extern   byte searchl       ;


  //kanaele
extern   char sintable[256],ramptable[256],rndtable[256],sqrtable[256];    //sinustabelle fuer vibrato,tremolo
extern   void *vtable,*ttable;
extern   boolean glissandoon;

extern   boolean delaypattern;
extern   byte patterndelay;
extern   byte patternloopst;
extern   byte patternloops;
extern   byte patternloopend;
extern   tpanarray defpanning;
extern   tchannel asmchn        ;
extern   tchannels channels     ;
extern   byte initspeed;
extern   byte initbpmspeed;
extern   word stmsamplememofs[32];
extern   int bufstart,bufend;
extern   int error;
extern   boolean forcerange;


extern byte parrangement[256];
extern int32 surrbufferlen;
extern byte surrlength;
extern boolean forcebpm;

#endif
