#include "modc.h"
#include "misc.h"
#include "effects.h"
#include <stdlib.h>
#include <string.h>
#include "sound.h"
#include <sys/time.h>
//#include <pthread.h>

int  mastervol=0;
int  globvol=64;
int  initglobvol=64;     
int32 oldlevel;
boolean forcebpm=false;

void voladjust(byte n)
{
word br,bl,hb;
  if (channels[n].vol>64) channels[n].vol=64;
  br=channels[n].vol;
  channels[n].avgvol=br*globvol/64;
  if (br!=0)
  {
    if ( channels[n].panval>128) channels[n].panval=64;
    /*if ( ! soundsettings.panning ){
	if ( (hb >= 59) && (hb <= 69) ) hb=defpanning[n];
	if ( (hb >= 59) && (hb <= 69) ) hb=128*( (n+1) % 2);// succ
	if ( hb>64 ) hb=128; else hb=0;
    }*/
    hb=channels[n].panval;
    bl=(br*(128-hb));
    br=br*hb;
    channels[n].lvol=(bl >> 7)*globvol / 64;
    channels[n].rvol=(br >> 7)*globvol / 64;
  } else
{
    channels[n].lvol=0;
    channels[n].rvol=0;
}
  if (filetype==oktalyz)
  {
    channels[relatedchn[n]].vol   =channels[n].vol;
    channels[relatedchn[n]].panval=channels[n].panval;
    channels[relatedchn[n]].lvol  =channels[n].lvol;
    channels[relatedchn[n]].rvol  =channels[n].rvol;
  }
}

byte notetoval(word note,word tune)
{
asm("
   movw 8(%ebp),%ax
   cmpb $s3m,filetype# $11 =s3m
   jne l0
   shrw $2,%ax
l0:
   movw 12(%ebp),%cx
   mulw %cx
   movw $8363,%cx
   divw %cx
   movw %ax,%dx
   orw %dx,%dx
   jnz lnonull
   xorb %al,%al
   jmp lntvexit
lnonull:
   mov $145,%ecx
   mov $pitchtable,%esi 
   add %ecx,%esi
   add %ecx,%esi
lloop:
   movw (%esi),%ax
   cmpw %ax,%dx
   jbe lgotit
   sub $2,%esi
   aword;loop lloop
lgotit:
   movw %cx,%ax
lntvexit:
  ");
}

void inctime(void)
{
asm("
  movw timestep+2,%bx
  movw timestep,%ax
  addw %ax,timesteprest
  adcw %bx,playtime
  adcw $0,playtime+2
  ");
}
void gettrack(word NumTrack,void* PatternTrackOfs );

void getpattern(byte n){
byte i;
word hp;

/*gepacktes trackformat:
 word ...laenge des tracks in byte einschliesslich dieses words
   +beliebig oft
     byte ...flags:
                bit0...instr.   <> 00h
                bit1...ton      <> 00h
                bit2...effekt   <> ffh (noeffekt)
                bit3...operands <> 00h
                bit4...chnvol   <> ffh
                (bit 5-7 anzahl der folgenden leerzeilen)
       +byte ...falls (flags and 01h)>0 instrument
       +word ...falls (flags and 02h)>0 ton
       +byte ...falls (flags and 04h)>0 effekt
       +byte ...falls (flags and 08h)>0 operands
       +byte ...falls (flags and 10h)>0 chnvol
speicher:
     tracks     ...(1..32)(0..numpatterns-1)of word
     pattern    ...statisches pattern zum spielen (1..numtracks)(0..maxpattlen-1(63))of tnote
     trackdata  ...(0..lasttrack)of ttrack
     samples
*/
asm("
#fuellen *pattern mit normalwerten
  movl pattern,%edi
  xor %eax,%eax
  xor %ecx,%ecx
  movb numtracks,%al
  movw $0x100,%cx
  mulw %cx
  movw %ax,%cx
  mov $0x00ff00ff,%eax
  #movw $0xff,%bx
  xor %ebx,%ebx
lfill1:
  movl %ebx,(%edi)
  movl %eax,4(%edi)
  addl $8,%edi
  aword;loop lfill1
");     
	for (i=0;i<numtracks;i++){ 
		hp=(*tracks)[n][i];
		if ( hp ) gettrack(hp,&(*pattern)[i][0]);
         }
/*(*pattern)[0][0].instrument=4;
(*pattern)[1][2].instrument=12;
(*pattern)[0][0].ton=9400;
(*pattern)[1][2].ton=9400;*/
}

void gettrack(word NumTrack,void* PatternTrackOfs){
asm("
  mov 12(%ebp),%edi  # PatternTrackOfs
  mov firsttrack,%esi
  #cx:=num of track...
  movw 8(%ebp),%cx # n tracknumber
  decw %cx
  jz lhavetraddr
  xor %edx,%edx
lgettraddr:
  #durch tracks durchhangeln...
  es;movw (%esi),%dx
  add %edx,%esi
  aword;loop lgettraddr
lhavetraddr:
  xor %ecx,%ecx
  #tracklaenge holen
  movw (%esi),%cx
  add %esi,%ecx
  add $2,%esi
  #track kopieren
  cmp %esi,%ecx
  je lgpexit
ltrackmove:
  xor %eax,%eax
  #note von (esi) nach (edi) entpacken...
  movb (%esi),%al
  inc %esi
  #instrument
  shrb $1,%al
  jnc lnoinst
  movb (%esi),%dl
  #decb %dl  Indexverschiebung Instrumentennummern
  movb %dl,(%edi)
  inc %esi
lnoinst:
  add $2,%edi
  #note
  shrb $1,%al
  jnc lnonote
  es;movw (%esi),%dx
  add $2,%esi
  movw %dx,(%edi)
lnonote:
  add $2,%edi
  #effekt
  shrb $1,%al
  jnc lnoeffect
  movb (%esi),%dl
  inc %esi
  movb %dl,(%edi)
lnoeffect:
  inc %edi
  #operands
  shrb $1,%al
  jnc lnoops
  movb (%esi),%dl
  inc %esi
  movb %dl,(%edi)
lnoops:
  inc %edi
  #volume
  shrb $1,%al
  jnc lnovol
  movb (%esi),%dl
  inc %esi
  movb %dl,(%edi)
lnovol:
  add $2,%edi
  #dummynotenincrement
  movb $8,%dl
  mulb %dl
  add %eax,%edi
  #note entpackt...
  cmp %ecx,%esi
  jb ltrackmove
lgpexit:
  ");
}


byte	ii, qmmode;
int32   smpend, qmstart;
word    startchn;
boolean noteplayed[256];
boolean pjump, pbreak;
byte    jumpto, breakto;
byte    farvibdepth;
int32   incr, incr1;

void play_the_module(void){
	char i;
	if (pm_is_working) {
		pm_is_working=false;
		for (int ii=0; ii < numtracks ;ii++){ 
		        //printf("effect %i\n",channels[ii].effkt);
			if (channels[ii].effkt==enhanced) 
			(*playtimes)[*currbuffer].proeffects[ii]=(*playtimes)[*currbuffer].proeffects[ii] | (1 << (channels[ii].opnd >> 4));
			if (channels[ii].effkt<16) 
			(*playtimes)[*currbuffer].effects[ii]=((*playtimes)[*currbuffer].effects[ii] | (1 << channels[ii].effkt));
			else if (channels[ii].effkt<32) 
			(*playtimes)[*currbuffer].extraeff[ii]=(*playtimes)[*currbuffer].extraeff[ii] | (1 << (channels[ii].effkt-16));
			else if (channels[ii].effkt<48) 
			(*playtimes)[*currbuffer].extraeff1[ii]=(*playtimes)[*currbuffer].extraeff1[ii] | (1 << (channels[ii].effkt-32));
		}// endfor
		goto kernel;
	}
//******************naechstes pattern bearbeiten*************************************
	breakto=0;
	farvibdepth=0;
	memset(noteplayed,0,256);

	do{ //#1
		//naechstes pattern laden
		getpattern(currpattern);
		currnote=breakto;
		patternloopst=0;
		breakto=0;
		if ( ptrntempi[currpattern]>0) speed=ptrntempi[currpattern];
               //******************naechste notenzeile bearbeiten**********************************
    do{ //#2
      if ( !delaypattern)
      {
      //naechste notenzeile holen
	 
        for (ii=0; ii < numtracks;ii++){
	// printf("note %i instr %i |",(*pattern)[ii][currnote].ton,(*pattern)[ii][currnote].instrument);  
        if (ii==numtracks-1) ;
	   //neue effekte auswerten und evtl. auf werte der alten effekte setzen...
          if ((channels[ii].effkt==vibratosust)&&(
             ((*pattern)[ii][currnote].effekt!=vibratosust)||(
              (*pattern)[ii][currnote].effekt!=vibrato)))
          {
            (*pattern)[ii][currnote].effekt=vibratosust;
            (*pattern)[ii][currnote].operands=channels[ii].opnd;
	  } else
    
          if ( ((filetype==f669)||(filetype==unis))
	      &&( ((*pattern)[ii][currnote].ton==0)||((*pattern)[ii][currnote].instrument==0) )
	      &&( (channels[ii].effkt == noeffekt) 
		 ||(channels[ii].effkt == portamento_up)
		 ||(channels[ii].effkt == portamento_down)
		 ||(tone_portamento == vibrato)
		 ) )
	  {
		if ((*pattern)[ii][currnote].effekt==noeffekt){ 
			(*pattern)[ii][currnote].effekt=channels[ii].effkt;
			(*pattern)[ii][currnote].operands=channels[ii].opnd;
		}
		else if((*pattern)[ii][currnote].operands==0) (*pattern)[ii][currnote].effekt=noeffekt;

	  }
	  //printf("effect %i\n",(*pattern)[ii][currnote].effekt);
          //(*pattern)[ii][currnote].effekt=noeffekt;
	  switch ((*pattern)[ii][currnote].effekt)
	  {
	     case   noeffekt:  {
		
		if (channels[ii].effkt!=noeffekt)
		if (channels[ii].effkt==farportamento){
			(*pattern)[ii][currnote].effekt=farportamento;(*pattern)[ii][currnote].operands=channels[ii].opnd;
		}else{
			if ((channels[ii].effkt==volumeport)&&(
			channels[ii].vol!=channels[ii].volprt)&&(
			(*pattern)[ii][currnote].chnvol== -1)){ 
				(*pattern)[ii][currnote].effekt=volumeport;
				(*pattern)[ii][currnote].operands=channels[ii].opnd;
			}
			else
				if (channels[ii].effkt==slotretrigger){
					(*pattern)[ii][currnote].effekt=slotretrigger;
					(*pattern)[ii][currnote].operands=channels[ii].opnd;
				}
		}
	    };break;
            case setglobvol: {
                              globvol=(*pattern)[ii][currnote].operands;if (globvol>64) globvol=64;
                              for (i=0; i < numtracks; i++) voladjust(i);
	    } break;
            case   portamento_up: {
                              if ((*pattern)[ii][currnote].operands==0)
                              { (*pattern)[ii][currnote].operands=channels[ii].prtops;if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt;
			      } else channels[ii].prtops=(*pattern)[ii][currnote].operands;
                              if ((filetype==s3m)||(filetype==stm))
                              {
                                if ((*pattern)[ii][currnote].operands < 0xe0) (*pattern)[ii][currnote].effekt = portamento_up; 
                                else
                                if ((*pattern)[ii][currnote].operands < 0xf0 )
                                {
                                  (*pattern)[ii][currnote].effekt = xtrafsldup;
                                  (*pattern)[ii][currnote].operands = (*pattern)[ii][currnote].operands & 0x0f;
				} else
                                {
                                  (*pattern)[ii][currnote].effekt = enhanced;
                                  (*pattern)[ii][currnote].operands = fsldup << 4 + (*pattern)[ii][currnote].operands & 0x0f;
				}
			      }
	    };break;
            case portamento_down:{
                              if ((*pattern)[ii][currnote].operands==0 )
                              { (*pattern)[ii][currnote].operands=channels[ii].prtops; if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt;
                              } else channels[ii].prtops=(*pattern)[ii][currnote].operands;
                              if ((filetype==s3m)||(filetype==stm))
                              {
                                if ((*pattern)[ii][currnote].operands < 0xe0 ) (*pattern)[ii][currnote].effekt=portamento_down; else
                                if ((*pattern)[ii][currnote].operands < 0xf0 )
                                {
                                  (*pattern)[ii][currnote].effekt = xtrafslddwn;
                                  (*pattern)[ii][currnote].operands = (*pattern)[ii][currnote].operands & 0x0f;
				}else
                                {
                                  (*pattern)[ii][currnote].effekt = enhanced;
                                  (*pattern)[ii][currnote].operands = fslddwn << 4 + (*pattern)[ii][currnote].operands & 0x0f;
				}
			      }
	    };break;
            case volumeslide: {
                              if ( (*pattern)[ii][currnote].operands==0 )
                              { (*pattern)[ii][currnote].operands=channels[ii].vsldops;if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt;
                              } else channels[ii].vsldops=(*pattern)[ii][currnote].operands;
                              if ( (filetype==s3m)||(filetype==stm))
                              {
                                if (((*pattern)[ii][currnote].operands & 0x0f == 0x0f)&&((*pattern)[ii][currnote].operands & 0xf0 != 0))
                                {
                                  (*pattern)[ii][currnote].effekt = enhanced;
                                  (*pattern)[ii][currnote].operands = finevolup << 4 + (*pattern)[ii][currnote].operands >> 4;
				}else if (((*pattern)[ii][currnote].operands & 0xf0 ==0xf0)&&((*pattern)[ii][currnote].operands & 0x0f!=0))
                                {
                                  (*pattern)[ii][currnote].effekt = enhanced;
                                  (*pattern)[ii][currnote].operands = finevoldwn << 4 + (*pattern)[ii][currnote].operands & 0x0f;
				}
                              }
	    };break;
            case  arpeggio:   {
                              if ( channels[ii].effkt!=arpeggio ) channels[ii].acnt=2;
                              if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].operands=channels[ii].arpops;
                              if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt;
                              channels[ii].arpops=(*pattern)[ii][currnote].operands;
	    };break;
           case  setspeed:  dosetspeed((*pattern)[ii][currnote].operands);break;
           case  setbpmspeed:{
                              forcebpm=true;
                              dosetspeed((*pattern)[ii][currnote].operands);
                              forcebpm=false;
	   };break;
           case tone_portamento:{
			      if ((*pattern)[ii][currnote].ton!=0 ) channels[ii].tpton=8363*(*pattern)[ii][currnote].ton
									 / instruments[channels[ii].inst].tuning;
				else if ((channels[ii].effkt!=portvolslide)&&(channels[ii].effkt!=tone_portamento)) 
					(*pattern)[ii][currnote].effekt=noeffekt;
			      //falls kein operand angegeben ist, alten benutzen
                              if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].operands=channels[ii].prtops;
                              if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt; else channels[ii].prtops=(*pattern)[ii][currnote].operands;
	   };break;
           case farportamento:{ if ( (*pattern)[ii][currnote].ton!=0 )
                            { channels[ii].tpton=(*pattern)[ii][currnote].ton;
                              channels[ii].fptonh=channels[ii].tonh;
                              if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt; else channels[ii].fpvblanc=1;
                            }else if ( channels[ii].effkt!=farportamento ) (*pattern)[ii][currnote].effekt=noeffekt;
	  };break;
          case volumeport:{
			    if ( ((*pattern)[ii][currnote].chnvol!=-1)&&((*pattern)[ii][currnote].operands!=0) )
                            {
                              channels[ii].volprt=(*pattern)[ii][currnote].chnvol;
                              (*pattern)[ii][currnote].chnvol=-1;
                              channels[ii].volsld=channels[ii].vol;
                              channels[ii].vpvblanc=1;
                            } else if ( channels[ii].effkt!=volumeport ) (*pattern)[ii][currnote].effekt=noeffekt;
	  };break;
          case portvolslide:{ if ( (*pattern)[ii][currnote].ton!=0 )
                              {
                                channels[ii].tpton=8363*channels[ii].tpton / instruments[channels[ii].inst].tuning;
			      }
	  };break;
          case    vibrato:  {
                            //pointer auf sinustable eventuell zuruecksetzen
                              if ( channels[ii].effkt!=vibrato ) channels[ii].vtini=0;
                            //falls (*pattern)[ii][currnote].operands (teilweise) nicht angegeben, sind alte zu benutzen
                              if (((*pattern)[ii][currnote].operands & 0xf0)==0 ) (*pattern)[ii][currnote].operands=(*pattern)[ii][currnote].operands |(channels[ii].vops & 0xf0);
                              if (((*pattern)[ii][currnote].operands & 0x0f)==0 ) (*pattern)[ii][currnote].operands=(*pattern)[ii][currnote].operands |(channels[ii].vops & 0x0f);
                             //fehlerbehandlung
                              if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt ; else channels[ii].vops=(*pattern)[ii][currnote].operands;
	  };break;
          case vibratodepth: farvibdepth=(*pattern)[ii][currnote].operands & 0x0f;break;
          case vibratosust :{
                              if ( (channels[ii].effkt!=vibratosust)&&(channels[ii].effkt!=farvibrato) )
                              {
                                channels[ii].vtini=0;
                                if ( (*pattern)[ii][currnote].ton!=0 ) channels[ii].fptonh=(*pattern)[ii][currnote].ton ; else channels[ii].fptonh=channels[ii].tonh;
                              }
                              if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt;
	  };break;
          case farvibrato   :{
                              if ( (channels[ii].effkt!=vibratosust)&&(channels[ii].effkt!=farvibrato) )
                              {
                                channels[ii].vtini=0;
                                if ( (*pattern)[ii][currnote].ton!=0 ) channels[ii].fptonh=(*pattern)[ii][currnote].ton; else channels[ii].fptonh=channels[ii].tonh;
                              }
                              if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt;
	  };break;
          case tremolo      :{
                             //pointer auf sinustable eventuell zuruecksetzen
                              if ( channels[ii].effkt!=tremolo ) channels[ii].vtini=64;
                             //falls (*pattern)[ii][currnote].operands (teilweise) nicht angegeben, sind alte zu benutzen
                              if (((*pattern)[ii][currnote].operands & 0xf0)==0 ) (*pattern)[ii][currnote].operands=(*pattern)[ii][currnote].operands |(channels[ii].tops & 0xf0);
                              if (((*pattern)[ii][currnote].operands & 0x0f)==0 ) (*pattern)[ii][currnote].operands=(*pattern)[ii][currnote].operands |(channels[ii].tops & 0x0f);
                             //fehlerbehandlung
                              if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt ; else channels[ii].tops=(*pattern)[ii][currnote].operands;
	  };break;
          case oktarpg1    :{
                              if ( channels[ii].effkt!=oktarpg1 ) channels[ii].acnt=0;
                              if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].operands=channels[ii].arp1ops;
                              if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt;
                              channels[ii].arp1ops=(*pattern)[ii][currnote].operands;
	  };break;
          case  oktarpg2   :{
                              if ( channels[ii].effkt!=oktarpg2 ) channels[ii].acnt=0;
                              if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].operands=channels[ii].arp2ops;
                              if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt;
                              channels[ii].arp2ops=(*pattern)[ii][currnote].operands;
	  };break;
         case  oktsldup   :if ( (*pattern)[ii][currnote].operands==0 )
                            { (*pattern)[ii][currnote].operands=channels[ii].oktsuops;if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt;
                            } else channels[ii].oktsuops=(*pattern)[ii][currnote].operands;break;
         case  oktslddwn  :if ( (*pattern)[ii][currnote].operands==0 )
                            { (*pattern)[ii][currnote].operands=channels[ii].oktsdops;if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt;
                            } else channels[ii].oktsdops=(*pattern)[ii][currnote].operands;break;
         case  oktsld1up  :if ( (*pattern)[ii][currnote].operands==0 )
                            { (*pattern)[ii][currnote].operands=channels[ii].oktsu1ops;if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt;
                            } else channels[ii].oktsu1ops=(*pattern)[ii][currnote].operands;break;
         case  oktsld1dwn :if ( (*pattern)[ii][currnote].operands==0 )
                            { (*pattern)[ii][currnote].operands=channels[ii].oktsd1ops;if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt;
                            } else channels[ii].oktsd1ops=(*pattern)[ii][currnote].operands;break;
         case finetempoup:  dofinefartempo ((*pattern)[ii][currnote].operands);break;
         case finetempodwn: dofinefartempo (-(*pattern)[ii][currnote].operands);break;
         case farretrig:    if ( (*pattern)[ii][currnote].operands & 0x0f>0 ) (*pattern)[ii][currnote].operands=1+speed /((*pattern)[ii][currnote].operands & 0x0f);break;
         case retrigvolslide:if ( ((*pattern)[ii][currnote].operands & 0x0f)==0 )
                              { (*pattern)[ii][currnote].operands=channels[ii].retrops;if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt;
                              } else channels[ii].retrops=(*pattern)[ii][currnote].operands;break;
         case slotretrigger:{
                           if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt;else
                           if ( channels[ii].oldvolume==0 )
                           {
                             (*pattern)[ii][currnote].operands=(*pattern)[ii][currnote].operands / 2;
                             channels[ii].retrops=0;
                             channels[ii].oldvolume=4;
			   }
	 }; break;
	 case enhanced:{
                        switch ((*pattern)[ii][currnote].operands >> 4){
				case vibrawave:{
					switch ((*pattern)[ii][currnote].operands & 0xf0){
						case 0:{ vtable=&sintable;  for (i=0; i < numtracks; i++) channels[i].vtini=0;};break;
						case 1:{ vtable=&ramptable; for (i=0; i < numtracks; i++) channels[i].vtini=0;};break;
						case 2:{ vtable=&sqrtable;  for (i=0; i <numtracks; i++) channels[i].vtini=0;};break;
						case 3:{ vtable=&rndtable;  for (i=0; i <numtracks; i++) channels[i].vtini=0;};break;
						case 4:{ vtable=&sintable;  };break;
						case 5:{ vtable=&ramptable; };break;
						case 6:{ vtable=&sqrtable;  };break;
						case 7:{ vtable=&rndtable;  };break;
					}
				};break;
				case tremwave:{
					switch ((*pattern)[ii][currnote].operands & 0xf0){
						case 0:{ ttable=&sintable;  for (i=0;i <numtracks;i++) channels[i].vtini=64;};break;
						case 1:{ ttable=&ramptable; for (i=0;i < numtracks;i++) channels[i].vtini=64;};break;
						case 2:{ ttable=&sqrtable;  for (i=0;i <numtracks;i++) channels[i].vtini=64;};break;
						case 3:{ ttable=&rndtable;  for (i=0;i <numtracks;i++) channels[i].vtini=64;};break;
						case 4:{ ttable=&sintable;  };break;
						case 5:{ ttable=&ramptable; };break;
						case 6:{ ttable=&sqrtable;  };break;
						case 7:{ ttable=&rndtable;  };break;
					}
				};break;
				case pattrndelay:{
					if ( ((*pattern)[ii][currnote].operands & 0x0f)==0 ) (*pattern)[ii][currnote].operands=channels[ii].pdelops;
					if ( ((*pattern)[ii][currnote].operands & 0x0f)==0 ) (*pattern)[ii][currnote].effekt=noeffekt; 
					else
						{
							delaypattern=true; patterndelay=(*pattern)[ii][currnote].operands & 0x0f;
							channels[ii].pdelops=(*pattern)[ii][currnote].operands;
						}
				};break;
				case pattrnloop :{ 
					if ( ((*pattern)[ii][currnote].operands & 0x0f)==0 ) patternloopst=currnote;
					else
					{ patternloops=((*pattern)[ii][currnote].operands & 0x0f);patternloopend=currnote;(*pattern)[ii][currnote].operands=0;
					}
				};break;
				case retrignote :{
					if ( ((*pattern)[ii][currnote].operands & 0x0f)==0 )
					{ (*pattern)[ii][currnote].operands=channels[ii].retrops;if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt;
					}else channels[ii].retrops=(*pattern)[ii][currnote].operands;
				}break;
				case  finevolup  :{
					if ( ((*pattern)[ii][currnote].operands & 0x0f)==0 )
					{ (*pattern)[ii][currnote].operands=channels[ii].fvuops;if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt;
					}else channels[ii].fvuops=(*pattern)[ii][currnote].operands;
				}break;
				case  finevoldwn :{
					if ( ((*pattern)[ii][currnote].operands & 0x0f)==0 ){
					(*pattern)[ii][currnote].operands=channels[ii].fvdops;
						if ( (*pattern)[ii][currnote].operands==0 ) (*pattern)[ii][currnote].effekt=noeffekt;
					} else channels[ii].fvdops=(*pattern)[ii][currnote].operands;
				}break; 
				case notecut:;
				case notedelay:;
				case invloop:{
					if ( ((*pattern)[ii][currnote].operands & 0x0f)==0 ) 
					(*pattern)[ii][currnote].effekt=noeffekt;
				}break;
				case glissdctrl:{ 
					glissandoon=((*pattern)[ii][currnote].operands!=0);
				};break;
			}//switch
	 };break;//enhanced
	  }//switch
          //spielende effekte fuer anzeige merken...
         // with playtimes^[currbuffer] do
         // {
            if ( (*pattern)[ii][currnote].effekt==enhanced ) {
		(*playtimes)[*currbuffer].proeffects[ii]=(*playtimes)[*currbuffer].proeffects[ii] 
		| (1 << ((*pattern)[ii][currnote].operands >> 4));
	    }
            if ( (*pattern)[ii][currnote].effekt<16 ) (*playtimes)[*currbuffer].effects[ii]=(*playtimes)[*currbuffer].effects[ii] | (1 << (*pattern)[ii][currnote].effekt);
            else if ( (*pattern)[ii][currnote].effekt<32 ) (*playtimes)[*currbuffer].extraeff[ii]=(*playtimes)[*currbuffer].extraeff[ii] | (1 << ((*pattern)[ii][currnote].effekt-16));
            else if ( (*pattern)[ii][currnote].effekt<48 ) (*playtimes)[*currbuffer].extraeff1[ii]=(*playtimes)[*currbuffer].extraeff1[ii] | (1 << ((*pattern)[ii][currnote].effekt-32));
         // }
          channels[ii].effkt=(*pattern)[ii][currnote].effekt;
          channels[ii].opnd=(*pattern)[ii][currnote].operands;
          if ( (*pattern)[ii][currnote].instrument>0){
		channels[ii].vol=instruments[(*pattern)[ii][currnote].instrument].volume;//lautstaerke des kanals hart setzen
		voladjust(ii);
		//instrument-nr. nur merken! und evtl. altes noch weiterspielen
		channels[ii].nxtinst=(*pattern)[ii][currnote].instrument;
	  }
	  if ( (*pattern)[ii][currnote].chnvol>-1 ) { channels[ii].vol=(*pattern)[ii][currnote].chnvol;voladjust(ii);
	  }
          if ( ((*pattern)[ii][currnote].ton>0)&& !(((*pattern)[ii][currnote].effekt==enhanced)&&(((*pattern)[ii][currnote].operands >> 4)==notedelay)) ){
            if ( ((*pattern)[ii][currnote].effekt!=farportamento)&&((*pattern)[ii][currnote].effekt!=tone_portamento)&&((*pattern)[ii][currnote].effekt!=portvolslide) ){
		//instrument neu anspielen
		channels[ii].inst =channels[ii].nxtinst;
		channels[ii].note =instruments[channels[ii].inst].offset;
		channels[ii].iend =instruments[channels[ii].inst].iend;
		channels[ii].lst =instruments[channels[ii].inst].loopstart;
		channels[ii].lend =instruments[channels[ii].inst].loopend;
		channels[ii].oldsmp=0;
		if ( channels[ii].lend!=0 ) channels[ii].iend=channels[ii].lend;
		if ( instruments[channels[ii].inst].bits & 0x10){
			channels[ii].iend=((channels[ii].iend-channels[ii].note) >> 1)+channels[ii].note-1;
			if ( channels[ii].lend>0 ){
				channels[ii].lend=((channels[ii].lend-channels[ii].note)>> 1)+channels[ii].note-1;
				channels[ii].lst= ((channels[ii].lst -channels[ii].note)>> 1)+channels[ii].note;
			}
		}else
		{
			channels[ii].iend--;
			if ( channels[ii].lend>0 ) channels[ii].lend--;
		}
		channels[ii].rest =0;
		channels[ii].tonh=8363*(*pattern)[ii][currnote].ton /instruments[channels[ii].inst].tuning;
	    }
	  }
		if ( channels[ii].tonh>0 ) dophiplo(channels[ii].tonh,&channels[ii].plo,instruments[channels[ii].inst].finetune);
		switch ( channels[ii].effkt ){
			case noeffekt       :;;break;
			//bei volume_slide-effekten originallautstaerke merken
			case volumeslide:;
                        case portvolslide:;
			case vibravolslid:;
			case tremolo: channels[ii].volsld=channels[ii].vol;break;
			case panning        :{ channels[ii].panval=channels[ii].opnd;voladjust(ii);};break;
			case finepanleft    :{ channels[ii].panval-=8; if (channels[ii].panval > 128) channels[ii].panval =   0; voladjust(ii);};break;
			case finepanright   :{ channels[ii].panval+=8; if (channels[ii].panval > 128) channels[ii].panval = 128; voladjust(ii);};break;
			case setvolume      :{ channels[ii].vol=channels[ii].opnd;voladjust(ii);channels[ii].oldvolume=channels[ii].vol;};break;
			case oktoldvol      :{ channels[ii].vol=channels[ii].oldvolume;voladjust(ii);};break;
			//zur aktuellen position im sample noch xx00 hex dazuaddieren
			case playoffset     :{
				if ( channels[ii].note>0 ) { 
					if ( channels[ii].opnd==0 ) channels[ii].opnd=channels[ii].ofsops;
					doplayoffset(channels[ii]);
					channels[ii].ofsops=channels[ii].opnd;
				}
			};break;
			case oktsld1up      :dooktsldup(channels[ii].opnd,&channels[ii].tonh,&channels[ii].plo,
							instruments[channels[ii].inst].finetune);break;
			case oktsld1dwn     :dooktslddwn(channels[ii].opnd,&channels[ii].tonh,&channels[ii].plo,
							 instruments[channels[ii].inst].finetune);break;
			case enhanced       :{
				switch (channels[ii].opnd >> 4){
					case finetune   :dophiplo(channels[ii].tonh,&channels[ii].plo,
							instruments[channels[ii].opnd & 0x0f].finetune);break;
					case finevolup  :{ channels[ii].vol+=channels[ii].opnd & 0x0f;voladjust(ii);};break;
					case finevoldwn :{ channels[ii].vol-=channels[ii].opnd & 0x0f;if ( channels[ii].vol>64 ) channels[ii].vol=0;voladjust(ii);};break;
					case fsldup     :{
						if (channels[ii].tonh>0)
						if ( channels[ii].tonh>(134+32*(channels[ii].opnd & 0x0f))) channels[ii].tonh-=32*channels[ii].opnd & 0x0f;else channels[ii].tonh=134;
						dophiplo(channels[ii].tonh,&channels[ii].plo,instruments[channels[ii].inst].finetune);
					};break;
					case fslddwn    :{ 
						if (channels[ii].tonh>0)
						if ( channels[ii].tonh<(54784-(channels[ii].opnd & 0x0f))) channels[ii].tonh+=32*channels[ii].opnd & 0x0f; else channels[ii].tonh=54784;
						dophiplo(channels[ii].tonh,&channels[ii].plo,instruments[channels[ii].inst].finetune);
					};break;
					case epanning   : { 
						channels[ii].panval=(channels[ii].opnd & 0x0f)<< 3+(channels[ii].opnd & 0x0f) >> 1+(channels[ii].opnd & 0x0f) >> 3;
						voladjust(ii);
					};break;
				}//switch
			};break;//enhanced
			
			case xtrafsldup     : {
				if ( (channels[ii].tonh>0)) 
				if ( channels[ii].tonh>(134+8*channels[ii].opnd)) channels[ii].tonh-=8*channels[ii].opnd;else channels[ii].tonh=134;
				dophiplo(channels[ii].tonh,&channels[ii].plo,instruments[channels[ii].inst].finetune);
			};break;
			case xtrafslddwn    :{ 
				if (channels[ii].tonh>0) 
				if ( channels[ii].tonh<(54784-8*channels[ii].opnd)) channels[ii].tonh+=8*channels[ii].opnd;else channels[ii].tonh=54784;
				dophiplo(channels[ii].tonh,&channels[ii].plo,instruments[channels[ii].inst].finetune);
			};break;
			case farvolup  :{ channels[ii].vol+=4*(channels[ii].opnd & 0x0f);voladjust(ii);};break;
			case farvoldwn :{ channels[ii].vol-=4*(channels[ii].opnd & 0x0f);if ( channels[ii].vol>64 ) channels[ii].vol=0;voladjust(ii);};break;
			case farsldup:{ 
				if (channels[ii].tonh>0) 
				if ( channels[ii].tonh>(134+192*channels[ii].opnd)) channels[ii].tonh-=word(192*channels[ii].opnd);else channels[ii].tonh=134;
				dophiplo(channels[ii].tonh,&channels[ii].plo,instruments[channels[ii].inst].finetune);
			};break;
			case farslddwn:{ 
				if (channels[ii].tonh>0)  
				if ( channels[ii].tonh<(54784-192*channels[ii].opnd)) channels[ii].tonh+=192*channels[ii].opnd; else channels[ii].tonh=54784;
				dophiplo(channels[ii].tonh,&channels[ii].plo,instruments[channels[ii].inst].finetune);
			};break;
		}//switch
	}//ende der for-schleife
      }else{
	patterndelay--;
	if ( patterndelay==0 ) delaypattern=false;
      }
	currvblanc=0;
	//******************naechsten speed-takt bearbeiten***********************************
	if ( search ){ //nur position suchen, nicht spielen!
		if ( (playtime>=searchtime)||(amrepeating) ) return;
        asm(" 
          xorb %ch,%ch 
          movb speed,%cl 
lstartloop: 
          call inctime__Fv 
          aword;loop lstartloop 
        ");
	}else{ 
	  do{ //#3
		if ( amrepeating && !(repeatsong) ) { mod_end=true; return; };
		if ((waveofs>(waveend-numsamples)) 
		    ||(amrepeating &&(repeatbuffer==((*currbuffer+1) % soundsettings.nbuffers)))) return;
kernel: 
		//effekte  
		for (ii=0 ;ii< numtracks ;ii++){  
		switch (channels[ii].effkt){ 
			case noeffekt       :;break;
			case arpeggio       : doarpeggio(channels[ii].opnd,&channels[ii].acnt,&channels[ii].tonh,
							 &channels[ii].plo,instruments[channels[ii].inst].finetune);break;
			case oktarpg1       : doarpeggio1(channels[ii].opnd,&channels[ii].acnt,&channels[ii].tonh,
							  &channels[ii].plo,instruments[channels[ii].inst].finetune);break;
			case oktarpg2       : doarpeggio2(channels[ii].opnd,&channels[ii].acnt,&channels[ii].tonh,
							  &channels[ii].plo,instruments[channels[ii].inst].finetune);break;
			case portamento_up  : if ((filetype==f669)
						||(filetype==unis))
                            {
                              if(channels[ii].tonh>0){
                                adjustfrequencyup(channels[ii].tonh, channels[ii].opnd);
                                if (channels[ii].tonh < 134) { channels[ii].tonh = 134; channels[ii].effkt=noeffekt;}
                                dophiplo (channels[ii].tonh, &channels[ii].plo,instruments[channels[ii].inst].finetune);
			      }
			    }else doportamento_up(channels[ii].opnd,&channels[ii].tonh,
							      &channels[ii].plo,instruments[channels[ii].inst].finetune)
			;break;
			case portamento_down:if ((filetype==f669)
                                                ||(filetype==unis))
                            {
                              if(channels[ii].tonh>0){
                                adjustfrequencydown(channels[ii].tonh,channels[ii].opnd);
                                if (channels[ii].tonh > 54784) { channels[ii].tonh = 54784; channels[ii].effkt=noeffekt; }
                                dophiplo (channels[ii].tonh, &channels[ii].plo,instruments[channels[ii].inst].finetune);
			      }
			    }else doportamento_down(channels[ii].opnd,&channels[ii].tonh,&channels[ii].plo,
						    instruments[channels[ii].inst].finetune) 
			;break;
			case tone_portamento:if ((filetype==f669)
                                                ||(filetype==unis)){ 
							if(channels[ii].tonh>0){
								if (channels[ii].tonh < channels[ii].tpton){
									adjustfrequencydown(channels[ii].tonh,channels[ii].opnd);
									if (channels[ii].tonh > channels[ii].tpton){
										channels[ii].tonh = channels[ii].tpton; 
										channels[ii].effkt=noeffekt; 
									}
									dophiplo (channels[ii].tonh, &channels[ii].plo,
										  instruments[channels[ii].inst].finetune);
								}else if (channels[ii].tonh > channels[ii].tpton ){
									adjustfrequencyup(channels[ii].tonh,channels[ii].opnd);
									if (channels[ii].tonh < channels[ii].tpton ){ 
										channels[ii].tonh = channels[ii].tpton; channels[ii].effkt=noeffekt; 
									}
									dophiplo(channels[ii].tonh,&channels[ii].plo,
										 instruments[channels[ii].inst].finetune);
								}
							}
						}else dotone_portamento(channels[ii].opnd,&channels[ii].tonh,&channels[ii].tpton,&channels[ii].plo
                                                          ,instruments[channels[ii].inst].finetune)
			;break;
			case vibrato        :if (!((filetype==f669)
                                                ||(filetype==unis)))
						dovibrato(channels[ii].opnd,&channels[ii].tonh,&channels[ii].vtini,
							  &channels[ii].plo,instruments[channels[ii].inst].finetune);break;
			case volumeslide    : { dovolumeslide(channels[ii].opnd,&channels[ii].vol,&channels[ii].volsld);voladjust(ii);};break;
			case portvolslide   : { 
				dotone_portamento(channels[ii].prtops,&channels[ii].tonh,&channels[ii].tpton,
						  &channels[ii].plo,instruments[channels[ii].inst].finetune);
				dovolumeslide(channels[ii].opnd,&channels[ii].vol,&channels[ii].volsld);voladjust(ii);
			};break;
			case vibravolslid   : { 
				dovibrato(channels[ii].vops,&channels[ii].tonh,&channels[ii].vtini,
					  &channels[ii].plo,instruments[channels[ii].inst].finetune);
				dovolumeslide(channels[ii].opnd,&channels[ii].vol,&channels[ii].volsld);voladjust(ii);
			};break;
			case tremolo        : { dotremolo(channels[ii].opnd,&channels[ii].vol,&channels[ii].volsld,&channels[ii].vtini);voladjust(ii);};break;
			case oktsldup       :dooktsldup(channels[ii].opnd,&channels[ii].tonh,
							&channels[ii].plo,instruments[channels[ii].inst].finetune);break;
			case oktslddwn      :dooktslddwn(channels[ii].opnd,&channels[ii].tonh,
							 &channels[ii].plo,instruments[channels[ii].inst].finetune);break;
			case tremor         :{ 
				if ( currvblanc==(channels[ii].opnd & 0x0f) ) 
				if ( channels[ii].vol>0 ) { 
					channels[ii].tvol=channels[ii].vol;channels[ii].vol=0;
				}else{
					channels[ii].vol=channels[ii].tvol; channels[ii].opnd=channels[ii].opnd >> 4;
				}
			};break;
			case farportamento  : { 
				if ( channels[ii].fptonh>channels[ii].tonh ) { 
					channels[ii].tonh=channels[ii].fptonh-channels[ii].fpvblanc*channels[ii].fptonh-channels[ii].tpton / (channels[ii].opnd & 0x0f) / speed;
					if ( channels[ii].tonh<channels[ii].tpton ) { channels[ii].effkt=noeffekt;channels[ii].tonh=channels[ii].tpton;};
				}else{ 
					channels[ii].tonh=channels[ii].fptonh+channels[ii].fpvblanc*channels[ii].tpton-channels[ii].fptonh / (channels[ii].opnd & 0x0f) / speed;
					if ( channels[ii].tonh>channels[ii].tpton ) { channels[ii].effkt=noeffekt;channels[ii].tonh=channels[ii].tpton;};
				}
				channels[ii].fpvblanc++;
				dophiplo(channels[ii].tonh,&channels[ii].plo,instruments[channels[ii].inst].finetune);
			};break;
			case volumeport:{
				if ( channels[ii].vol==channels[ii].volprt ) channels[ii].effkt=noeffekt ;
				else{ 
					if ( channels[ii].volprt>channels[ii].volsld ) 
					channels[ii].vol=channels[ii].volsld+(channels[ii].vpvblanc*channels[ii].volprt-channels[ii].volsld / speed / (channels[ii].opnd & 0x0f));
					else 
					channels[ii].vol=channels[ii].volsld-(channels[ii].vpvblanc*channels[ii].volsld-channels[ii].volprt / (speed) /(channels[ii].opnd & 0x0f));
					voladjust(ii);
					channels[ii].vpvblanc++;
				}
			};break;
			case farretrig      :{ 
				if ( currvblanc==channels[ii].opnd ) { 
					channels[ii].note=instruments[channels[ii].inst].offset;
					channels[ii].oldsmp=0;
					channels[ii].opnd+=(*pattern)[ii][currnote].operands;
				}
			};break;
			case vibratosust    :
		        case farvibrato     :{ 
				if ( farvibdepth!=0 ) { 
					channels[ii].tonh=channels[ii].fptonh-channels[ii].fptonh*sintable[channels[ii].vtini]*farvibdepth / 32768;
					dophiplo(channels[ii].tonh,&channels[ii].plo,instruments[channels[ii].inst].finetune);
					channels[ii].vtini+=12*(channels[ii].opnd & 0x0f);
				}
			};break;
			case retrigvolslide :{ 
				if ( currvblanc==(channels[ii].opnd & 0x0f) ) { 
					channels[ii].note=instruments[channels[ii].inst].offset;
					channels[ii].oldsmp=0;
					channels[ii].opnd=channels[ii].opnd & 0xf0+(channels[ii].retrops+(channels[ii].opnd & 0x0f)) & 0x0f;
					switch (channels[ii].opnd >> 4){
						case 0 :;break;
						case 1 :if ( channels[ii].vol>0  ) channels[ii].vol=channels[ii].vol-1;break;
						case 2 :if ( channels[ii].vol>1  ) channels[ii].vol=channels[ii].vol-2;break;
						case 3 :if ( channels[ii].vol>3  ) channels[ii].vol=channels[ii].vol-4;break;
						case 4 :if ( channels[ii].vol>7  ) channels[ii].vol=channels[ii].vol-8;break;
						case 5 :if ( channels[ii].vol>15 ) channels[ii].vol=channels[ii].vol-16;break;
						case 6 :channels[ii].vol=channels[ii].vol << 1 / 3;break;
						case 7 :channels[ii].vol=channels[ii].vol >> 1;break;
						case 8 :;break;
						case 9 :channels[ii].vol=channels[ii].vol+1;break;
						case 10:channels[ii].vol=channels[ii].vol+2;break;
						case 11:channels[ii].vol=channels[ii].vol+4;break;
						case 12:channels[ii].vol=channels[ii].vol+8;break;
						case 13:channels[ii].vol=channels[ii].vol+16;break;
						case 14:channels[ii].vol=3*channels[ii].vol >> 1;break;
						case 15:channels[ii].vol=channels[ii].vol << 1;break;
					}
					voladjust(ii);
				}
			};break;
			case  slotretrigger  :{ 
				if ( currvblanc==channels[ii].retrops ) { 
					channels[ii].note=instruments[channels[ii].inst].offset;
					channels[ii].oldsmp=0;
					channels[ii].retrops=(channels[ii].retrops+channels[ii].opnd) % speed;
					channels[ii].oldvolume--;
					if ( channels[ii].oldvolume==0 ) channels[ii].effkt=noeffekt;
				}
			};break;
			case enhanced:{ 
				switch (channels[ii].opnd >> 4){ 
					case  retrignote :{ 
						if ( currvblanc==(channels[ii].opnd & 0x0f) ) { 
							channels[ii].note=instruments[channels[ii].inst].offset;
							channels[ii].oldsmp=0;
							channels[ii].opnd=(channels[ii].retrops+(channels[ii].opnd & 0x0f)) & 0x0f+retrignote << 4;
						}
					};break;
					case  notecut    :if ( currvblanc==(channels[ii].opnd & 0x0f) ) channels[ii].vol=0;break;
					case  notedelay  : {
						if ( currvblanc==(channels[ii].opnd & 0x0f) ) { 
							channels[ii].inst =channels[ii].nxtinst;
							channels[ii].note =instruments[channels[ii].inst].offset;
							channels[ii].iend =instruments[channels[ii].inst].iend;
							channels[ii].lst  =instruments[channels[ii].inst].loopstart;
							channels[ii].lend =instruments[channels[ii].inst].loopend;
							channels[ii].oldsmp=0;
							if ( channels[ii].lend!=0 ) channels[ii].iend=channels[ii].lend;
							if ( instruments[channels[ii].inst].bits & 0x10) { 
								channels[ii].iend=(channels[ii].iend-channels[ii].note) >> 1+channels[ii].note-1;
								if ( channels[ii].lend>0 ){ 
									channels[ii].lend=(channels[ii].lend-channels[ii].note) >> 1+channels[ii].note-1;
									channels[ii].lst= (channels[ii].lst -channels[ii].note) >> 1+channels[ii].note;
								}
							}else{ 
								channels[ii].iend--;
								if ( channels[ii].lend>0 ) channels[ii].lend--;
							}
							if ( (*pattern)[ii][currnote].ton>0 ) 
								channels[ii].tonh=8363* (*pattern)[ii][currnote].ton / instruments[channels[ii].inst].tuning;
							if ( channels[ii].tonh>0 ) dophiplo(channels[ii].tonh,&channels[ii].plo,
											    instruments[channels[ii].inst].finetune);
						}
					};break;
				}//switch
			};break;
		} //for-schleife
		}//switch
asm("
call asmplay
");
	  }//zu do #3
          while (!(currvblanc>=speed)); //bis naechste notenzeile erreicht ist
	}//else
	// ****************** naechsten speed-takt bearbeitet *********************************** 
	noteplayed[currnote]=true;
	if ( (patternloops>0)&&(currnote==patternloopend) ) { 
		currnote=patternloopst;patternloops--;
	}else{
		if ( ! delaypattern ){ 
			pjump=false;
			pbreak=false;
			for (ii=0 ;ii < numtracks;ii++){
				switch (channels[ii].effkt){
					case noeffekt:;break;
					case positionjump:{
						if ( (channels[ii].opnd<numpatterns) && (!(alreadyplayed[channels[ii].opnd]) || repeatsong) ){ 
							pjump=true;
							jumpto=channels[ii].opnd;
						}
					};break;
					case patternbreak:{ 
						pbreak=true;
						breakto=10*(channels[ii].opnd >> 4)+(channels[ii].opnd & 0x0f);
					};break;
				}//switch
			}
			if ( pjump ) { 
				if ( jumpto!=currpattern ) { 
					alreadyplayed[currpattern]=true;
					currpattern=jumpto;
					memset(noteplayed,0,256);
				}
				goto epjmp;
			}else{
				if ( pbreak ) goto epbrk ; else currnote++;
			}
		}//if
	}//else
    }//zu do #2
    while (currnote <= ptrnbreaks[currpattern]);
//******************naechste notenzeile bearbeitet**********************************
epbrk: 
	alreadyplayed[currpattern]=true; //pattern als schon gespielt markieren
	currpattern++;
	if( (filetype ==ffar)
	   ||(filetype==unis)
	   ||(filetype==f669)
	   &&(currpattern==loopfrom)) currpattern=loopto-1;
	memset(noteplayed,0,256);
	if ( currpattern>=numpatterns ){ 
		currpattern=0;
		memset(channels,0,sizeof(channels));
		for (i=numtracks-1; i >= 0;i--) channels[i].panval=defpanning[i];
	}
epjmp: 
    //song-loops rausfinden und evtl unterbinden
	if ( ptrnbreaks[currpattern]<breakto ) breakto=0;
	if ( alreadyplayed[currpattern] || noteplayed[breakto] ) { 
		amrepeating=true;
		repeatbuffer=(*currbuffer+1) % soundsettings.nbuffers;
		memset(alreadyplayed,0,sizeof(alreadyplayed));
		memset(noteplayed,0,256);
		if ( currpattern==0 ) playtime=0; else playtime=looptotime;
	}
	}//zu do #1
        while ( currpattern <numpatterns );
//******************naechstes pattern bearbeitet*************************************
}


char ti;
int32 currusage;
int currlevel;
/* play one buffer app. 200ms */

void playone(void){
  if (amplaying||(*distance==5)) return;
  amplaying=true;
  buftimelen=0;
  waveend=wavestrt+ buffersize;
  buftimelen*=1000;
  buftimelen/= soundsettings.samplerate;
  if (!playtimes) return;
  currpttrn=(*playtimes)[*lastbuffer].pattrn+1;
  if ( !(mod_end)||(currtime<(*playtimes)[*lastbuffer].time) ) currtime=(*playtimes)[*lastbuffer].time;
  curreffects=(*playtimes)[*lastbuffer].effects;
  currproeffects=(*playtimes)[*lastbuffer].proeffects;
  currextraeff=(*playtimes)[*lastbuffer].extraeff;
  currextraeff1=(*playtimes)[*lastbuffer].extraeff1;
  currinstr=(*playtimes)[*lastbuffer].playinstr;
  currvols=(*playtimes)[*lastbuffer].volumes;
  currnotes=(*playtimes)[*lastbuffer].notes;
  currbpm=(*playtimes)[*lastbuffer].bpm;
  currspd=(*playtimes)[*lastbuffer].spd;
  currline=(*playtimes)[*lastbuffer].playline+1;
  currlevel=abs(*(short int*)(surrbufferlen+int32(playmemhandle)+(buffersize*(*lastbuffer))));
  currlevel*=currlevel;
  currlevel/=3500;
//currlevel+=abs(*(short int*)(2+surrbufferlen+int32(playmemhandle)+(buffersize*(*lastbuffer))));

  if ( mod_end ) { 
    //wenn player nich mehr spielt, aber noch puffer ausgelesen werden...
    if ( *lastbuffer==repeatbuffer ){
      pm_is_working=false;
      ende=true;
      playing=false;
      
    }
    *lastbuffer=(*lastbuffer+1) % soundsettings.nbuffers;
    currusage=0;
  }else{
    if ( *lastbuffer==repeatbuffer )  amrepeating=false;
    waveend=wavestrt+ buffersize;
    if ( waveend>playmemtop ) { 
      wavestrt=surrbufferlen+int32(playmemhandle);
      if ( soundsettings.quality ) wavestrt+=16384;
      waveofs=wavestrt;
      waveend=wavestrt+ buffersize;
    }
    memset(&(*playtimes)[*currbuffer],0,sizeof(tplaytime));
    play_the_module(); //neuen block berechnen
    
    for (i=0 ;i < numtracks;i++) {
      if ( channels[i].note>0 ) { 
	(*playtimes)[*currbuffer].playinstr[i]=channels[i].inst;
	(*playtimes)[*currbuffer].notes[i]=notetoval(channels[i].tonh,instruments[channels[i].inst].tuning);
      }
      (*playtimes)[*currbuffer].volumes[i]=(channels[i].lvol >> 3)+(channels[i].rvol << 1) & 0xf0;
    }
    (*playtimes)[*currbuffer].pattrn  =currpattern;
    (*playtimes)[*currbuffer].time    =playtime;
    (*playtimes)[*currbuffer].bpm     =bpmspeed;
    (*playtimes)[*lastbuffer].spd     =speed;
    (*playtimes)[*lastbuffer].playline=currnote;	
#ifndef CLEAN
    printf("last: %d curr: %d repeat: %d \n",*lastbuffer,*currbuffer,repeatbuffer);
#endif
    //berechneten block dem treiber uebergeben 
    //WaveWrite((char*)wavestrt,waveofs-wavestrt);
    /* Die eigentliche Ausgabe erfolgt im HINTERGRUND */
    wavestrt+=buffersize;
    waveofs=wavestrt;
    waveend+=buffersize;
    //wavestrt=waveofs;
    /* nchster Puffer ist dran */
    *currbuffer=(*currbuffer+1)% soundsettings.nbuffers;
    (*distance)--; // die Zahl der freien Puffer erniedrigt sich
    pm_is_working=true;              //playmodule arbeitet noch!
  }
  
  // cpuusage=(4*cpuusage+currusage)/ 5;
  amplaying = 0;
}

 
//*************************sounddevice aktivieren************************************
extern int sid,sid1;

word activatesound(void)
{ 
  Sound_Init();
  Set_Sound(soundsettings);//veraendert gegebenenfalls die werte
  playtimes=pplaytimes(malloc(soundsettings.nbuffers*sizeof(tplaytime)));
  if (playtimes==NULL) perror("activate sound");
  notestretch=(65536*32*428 /soundsettings.samplerate)*8363;//grundwert fuer tonhhe festlegen
  playmode=(soundsettings.bits / 9 << 1)+soundsettings.stereo;
  //calculate volumetable...
  if ( soundsettings.preamp>20 ) soundsettings.preamp=20;
  if  (filetype!=s3m)
    mastervol=word(256.0/(1+1.253*(numtracks-1)*(numtracks-1)*(soundsettings.preamp/20.0))+(20.0-soundsettings.preamp)/20.0*numtracks);
  if ( (soundsettings.bits==8) && (! soundsettings.quality) ){
    for (i=0 ;i<=64;i++){
      for( j=-128;j<=127;j++) {
	voltable.byte[i][byte(j)]=hi(i*j*mastervol / 64);
      }
    }
  }else{ 
    for (i=0;i<=64;i++){
      for (j=-128 ;j<=127;j++) voltable.word[i][byte (j)]=i*j*mastervol / 64;
    }
  }
  buffersize=(soundsettings.samplerate*soundsettings.stereo*soundsettings.bits / 8)/ 5; //blockgroesse fuer 200 millisec. 
  if(!(getplaymem(soundsettings.nbuffers * buffersize)) ) return(1);
  *distance=soundsettings.nbuffers;
  do_play_background(sid,sid1);
  return 0;
}

//*************************sounddevice deaktivieren**********************************

void deactivatesound(void)
{ 
#ifndef CLEAN
  printf("deactivate_sound\n");
#endif
  pm_is_working=false;
  //playing=false;
  Sound_Off();
  free(playtimes);
  playtimes=NULL;
  freeplaymem();
}
 
void kanalinit(void)
{
 void *p;
  pm_is_working=false;
  globvol=initglobvol;
  wavestrt=surrbufferlen+int32(playmemhandle);
  if ( soundsettings.quality ) wavestrt += 16384 ;
  waveofs=wavestrt;
  waveend=wavestrt;
  *currbuffer=0;
  *lastbuffer=0;
  currpattern=0;
  cpuusage=0;
  buftimelen=0;
  playtime=0;
  currpttrn=0;
  memset(curreffects,0,sizeof(effectstate));
  memset(currproeffects,0,sizeof(effectstate));
  memset(currextraeff,0,sizeof(effectstate));
  memset(currextraeff1,0,sizeof(effectstate));
  memset(currvols,0,sizeof(tbytestate));
  memset(currnotes,0,sizeof(tbytestate));
  vtable=&sintable;
  ttable=&sintable;
  glissandoon=false;
  amrepeating=false;
  forcebpm=true;
  dosetspeed(initbpmspeed);
  forcebpm=false;
  dosetspeed(initspeed);
  if ( filetype==ffar ) dofinefartempo(0);
  delaypattern=false;
  patternloopst=0;
  patternloops=0;
  patternloopend=0;
  memset(alreadyplayed,0,sizeof(alreadyplayed));
  memset(playtimes,0,soundsettings.nbuffers*sizeof(tplaytime));
  memset(channels  ,0,sizeof(channels));
  for ( i=numtracks-1; i>=0; i--) channels[i].panval=defpanning[i];
  p=(void*)wavestrt;
  if ( (soundsettings.bits==8)&& !(soundsettings.quality))
	memset(p,0x80,surrbufferlen);
  else 
	memset(p,0,surrbufferlen);
  bufend=NULL;
  bufstart=(soundsettings.samplerate / 1000)*surrlength;
}






