/* alles was zur Bedienung der libplayer.a Library notwendig ist */

#ifndef _PLAYER_H
#define _PLAYER_H

typedef unsigned char byte;
typedef unsigned short int word;
typedef byte boolean;
typedef int int32;

typedef struct  {
                   char name[41];
                   int32 offset    ;
                   int32 iend      ;
                   int32 loopstart ;
                   int32 loopend   ;
                   byte volume    ;
                   byte finetune  ;
                   byte bits      ;/*bit 5..stereo; bit6..gepackt; bit7..s3m-adlib-instrument;*/
                   word tuning    ;
                   } tinstrument;

#ifdef __cplusplus
enum  tmodtype{noisetr,startr,protr,ftrk,wow,mtm,oktalyz,f669,stm,ffar,ult,s3m,unis,xm};
#else
typedef int tmodtype;
#define noisetr 1
#define startr  2
#define protr   3
#define ftrk    4
#define wow     5
#define mtm     6
#define oktalyz 7
#define f669    8
#define stm     9
#define ffar    10
#define ult     11
#define s3m     12
#define unis    13
#define xm      14
#endif

typedef char string[256];
 
extern   boolean mod_end;
extern   byte *currbuffer;
extern   boolean playing;
extern   tinstrument instruments[256];
extern   word dummypatterns;                  /*anzahl der gespeicherten aber nicht gespielten patterns*/

extern boolean Pause_;

typedef struct {
       int deviceid  ;
       char name[40] ;
       word samplerate;
       byte stereo    ;
       byte bits      ;
       byte nbuffers  ;
       boolean surround;
       boolean nobpm   ;
       byte tmode     ;
       byte preamp    ;
       boolean quality ;
       boolean oversamp;
       boolean switch_pause;		// by EB 21.3.97
       boolean switch_auto;		// by EB 21.3.97
       }tsettings;

typedef   word effectstate[32];
typedef   byte tbytestate[32];

typedef   char tcommentbuf[65520];
typedef   tcommentbuf *pcommentbuf;

/*modul-infos*/
extern   tmodtype filetype ;              /*fileformat*/
extern   word filesiz;                   /*dateigroesse in kbyte*/
extern   string modname;
extern   word numtracks;                 /*anzahl der kanaele pro notenzeile*/
extern   word difftracks;                /*anzahl der voneinander verschiedenen gespielten tracks*/
extern   word numinstruments;
/*extern   tinstrument instruments[256];*/
extern   word dummypatterns;             /*anzahl der gespeicherten aber nicht gespielten patterns*/
extern   int32 extrabytes;               /*ueberlaenge des files*/
extern   int32 missingbytes;             /*fehlende bytezahl*/
extern   word effectsused;               /*bit gesetzt=effekt benutzt*/
extern   word proeffectsused;            /*bit gesetzt=effekt benutzt*/
extern   word extraeffused;              /*bit gesetzt=effekt benutzt*/
extern   word extraeffused1;             /*bit gesetzt=effekt benutzt*/
extern   word panningoff;                /*panning wird nicht benutzt*/
extern   int32 songmem;                  /*speichergroesse fuer pattern und samples*/
extern   int32 playmemtop;               /*speichergroesse fuer playbuffers*/
extern   int loopfrom;                   /*pattern, von dem aus geloopt wird*/
extern   int loopto;                     /*pattern, zu welchem geloopt wird*/
extern   byte playing;                   /*modul spielt*/
extern   int32 cpuusage;                 /*aktuelle cpu-auslastung*/
extern   int32 totaltime;                /*gesamtspielzeit [ms]*/
extern   int32 currtime;                 /*aktuell zu hrende zeit [ms]*/
extern   int32 buftimelen;               /*samplepufferlnge [ms]*/
extern   word currpttrn;                 /*aktuell zu hrendes pattern*/
extern   word numpatterns;               /*gre des patternarrangements*/
extern   word diffpatterns;              /*anzahl der voneinander verschiedenen gespielten pattern*/
extern   word currline;
extern   effectstate curreffects;        /*zu hrende effekte*/
extern   effectstate currproeffects;     /*zu hrende protracker-effekte*/
extern   effectstate currextraeff;       /*zu hrende stm/okt...-effekte*/
extern   effectstate currextraeff1;      /*zu hrende stm/okt...-effekte*/
extern   tbytestate currinstr ;
extern   tbytestate currvols;
extern   tbytestate currnotes;
extern   byte currspd;
extern   byte currbpm;
extern   word commentlen;
extern   pcommentbuf comment;
extern   int currlevel;                  /* aktuelle Aussteuerung */
/*ende der info.............*/

#ifdef __cplusplus
extern "C"
{
#endif
  
extern int play(const char* Filename,tsettings settings,boolean repeats); 
extern void init_player(void);
extern void exit_player(void);
extern void playone(void);
extern void stop(void);
extern void settingschanged(tsettings settings);
extern void search_time(int time);
extern void deactivatesound(void);
extern word activatesound(void);

extern int test_file(const char* Filename); // new
#ifdef __cplusplus
}
#endif

#endif






