                                                                   
/*library player32;
* ***mod-player utilities library used by mod4X based on mod4win (c)1993,94 
* kay bruns
* ***porting to linux and c++ (c)1994,95,96 carsten kroll**** 
*/

#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdio.h>
#include "sound.h"
#include "modc.h"
#include "play.h"
#include "misc.h"
#include "effects.h"
#include "getinfo.h"
// the file formats 

#include "mod.h"
#include "mtm.h"
#include "669.h"
#include "s3m.h"
#include "stm.h"
#include "far.h"
#include "xm.h"

#define TIMER_INT (int)100 //alle 100ms puffer berechnen 
extern ifstream f;

//*******************Prototypes***********************
void sig_handle(int);
//****************************************************

word dwbufferlength;
int  surrbufferlen=0xfff;//Achtung ebenfalls in asmplay.s (SurrBufferLen)
byte surrlength=15;

//********************Fileobject fuer Modfiles**************************
ifstream f;	
string filename;

//****************globale variablen*************************************************


   //modul-infos
   tmodtype filetype ;              //fileformat
   word filesiz;                  //dateigroesse in kbyte
   string modname;
   word numtracks;                  //anzahl der kanaele pro notenzeile
   word difftracks;                  //anzahl der voneinander verschiedenen gespielten tracks
   word numinstruments;
   tinstrument instruments[256];
   word dummypatterns;                  //anzahl der gespeicherten aber nicht gespielten patterns
   int32 extrabytes;               //ueberlaenge des files
   int32 missingbytes;               //fehlende bytezahl
   word effectsused;                  //bit gesetzt=effekt benutzt
   word proeffectsused;               //bit gesetzt=effekt benutzt
   word extraeffused;                  //bit gesetzt=effekt benutzt
   word extraeffused1;                  //bit gesetzt=effekt benutzt
   word panningoff;              //panning wird nicht benutzt
   int32 songmem;               //speichergroesse fuer pattern und samples
   int32 playmemtop;               //speichergroesse fuer playbuffers
   int loopfrom;               //pattern, von dem aus geloopt wird
   int loopto;               //pattern, zu welchem geloopt wird
   boolean playing;              //modul spielt
   int32 cpuusage;               //aktuelle cpu-auslastung
   int32 totaltime;               //gesamtspielzeit [ms]
   int32 currtime;               //aktuell zu hrende zeit [ms]
   int32 buftimelen;               //samplepufferlnge [ms]
   word currpttrn;                  //aktuell zu hrendes pattern
   word numpatterns;                  //gre des patternarrangements
   word diffpatterns;                  //anzahl der voneinander verschiedenen gespielten pattern
   word currline;
   effectstate curreffects;           //zu hrende effekte
   effectstate currproeffects;           //zu hrende protracker-effekte
   effectstate currextraeff;           //zu hrende stm/okt...-effekte
   effectstate currextraeff1;           //zu hrende stm/okt...-effekte
   tbytestate currinstr ;
   tbytestate currvols;
   tbytestate currnotes;
   byte currspd;
   byte currbpm;
   word commentlen;
   pcommentbuf comment;

   //ende der info.............

// Zeitnahme
itimerval timertime;
struct sigaction Sig_Action={sig_handle,0,SA_NOMASK,0};

   int32 i,j,k;   //allgemein zum zaehlen

   //speicherhandling
   void *songmemhandle;
   void *songmemsel;
   int32 songmemofs;

/*aufbau songmem:
     tracks     ...[1..32][0..numpatterns-1]of word
     pattern    ...statisches pattern zum spielen [1..numtracks][0..maxpattlen-1(63)]of tnote
     trackdata  ...[0..lasttrack]of ttrack
     samples
*/
   void *playmemhandle;
   void *songmemtop;
   int32 instrmemsize;
   int32 trackmemsize;
   int32 firsttrack;
   //waveout-var's
   tsettings soundsettings ;
   byte playmode;                  //8bit mono...16bit stereo
   int32 notestretch;
   int32 wavestrt;
   int32 waveofs;
   int32 waveend;
   byte *currbuffer;
   byte *lastbuffer;
   word buffersize;

   //zeitgeber-var's
   word amplaying;
   boolean ende;
   boolean notplay;

   //spielstatus
   ptrackseq     tracks;
   word          lasttrack;             //letzte gespielte tracknummer
   ppattern      pattern;               //enthaelt aktuelle daten zum abspielen
   char ptrntempi[256];
   byte ptrnbreaks[256];
   byte lastpattern;                  //letzte gespielte patternnummer
   boolean alreadyplayed[256];//pattern wurde schon gespielt

   byte currpattern;                  //aktuelle patternnummer
   byte currnote;                  //notenzeile im pattern
   byte currvblanc;                  //vblanc-takt

   byte speed;
   byte bpmspeed;
   word numsamples;                  //anzahl der samples fuer 1/50 sec

   boolean pm_is_working;
   boolean mod_end;
   boolean repeatsong;

   int32 playtime;               //zeit des aktuellen songs in ms
   int32 loopfromtime;               //zeit fr looping
   int32 looptotime;
   int32 timestep;
   word timesteprest;
   pplaytimes playtimes     ;
   int32 searchtime;               //zu suchende position beim spulen
   boolean search;               //nicht spielen, sondern spulen
   int32 starttime;               //systemzeit bei eintritt in play_the_module
   boolean Pause_;               //pause aktiv
   boolean amrepeating;
   byte repeatbuffer;

   int32 patterntimes[256];
   boolean searchpattern ;
   byte searchp       ;
   byte searchl       ;


  //kanaele
   char sintable[256],ramptable[256],rndtable[256],sqrtable[256];    //sinustabelle fuer vibrato,tremolo
   void *vtable,*ttable;
   boolean glissandoon;

   boolean delaypattern;
   byte patterndelay;
   byte patternloopst;
   byte patternloops;
   byte patternloopend;
   tpanarray defpanning;
   tchannel asmchn        ;
   tchannels channels     ;
   byte initspeed;
   byte initbpmspeed;
   word stmsamplememofs[32];
   int bufstart,bufend;

   int error;
   boolean forcerange;
// ------------ende der datendefinitionen ----------------------


boolean getsongmem(long int mem)
{
  mem=mem+int32(numpatterns*sizeof(torderdata)+numtracks*sizeof(ttrack));
  songmemhandle=malloc(mem);
  songmemtop=(void*)(mem+int32(songmemhandle)); if (songmemhandle==NULL) return(false);
  tracks=ptrackseq(songmemhandle);
  songmemsel= (void*)songmemhandle;
  pattern=ppattern(tracks);
  pattern = ppattern(int32(pattern)+numpatterns*sizeof(torderdata));
  songmemofs=int32(songmemhandle)+(numpatterns*sizeof(torderdata)+numtracks*sizeof(ttrack));
  firsttrack=songmemofs;
  return(true);
}

// noch nich getestet ??
boolean fitsongmem(void)
{ 
  int32 help=int32(songmemofs)-int32(songmemhandle);
  songmemhandle=realloc(songmemhandle,help);
  songmemtop=(void*)(int32(songmemhandle)+help);
  if (songmemhandle == NULL) return(false);
  tracks=ptrackseq(songmemhandle);
  pattern=ppattern(tracks);
  pattern = ppattern(int32(pattern)+numpatterns*sizeof(torderdata));
  songmem=int32 (songmemtop-firsttrack);
  return(true);
}

void freesongmem(void)
{
  if (songmemhandle>NULL) free(songmemhandle);
  songmemhandle=0;
  songmemsel=0;
  songmem=0;
  songmemtop=0;
  songmemofs=0;
  tracks=NULL;
  pattern=NULL;
}

void stop(void)
{
  ende          =true;
  playing       =false;
  deactivatesound();
  freesongmem();
  memset(curreffects,0,sizeof(effectstate));
  memset(currproeffects,0,sizeof(effectstate));
  memset(currextraeff,0,sizeof(effectstate));
  memset(currextraeff1,0,sizeof(effectstate));
  memset(currinstr,0,sizeof(tbytestate));
  memset(currvols,0,sizeof(tbytestate));
  memset(currnotes,0,sizeof(tbytestate));
  currbpm       =0;
  currspd       =0;
  cpuusage      =0;
  currtime      =0;
  buftimelen    =0;
  currpttrn     =0;
  currline      =0;
  instrmemsize  =0;
  trackmemsize  =0;
  firsttrack    =0;
}
//################################# spielzeit berechnen##############################

static word result;
static boolean reached;
static word bufsize;
static byte *pbuffer;
static int32 unilong;

byte parrangement[256];

void gettotaltime(void){
boolean pjump, pbreak;
byte jumpto, breakto;
boolean forcebpm=false;
boolean noteplayed[256];

	//tatsaechlich hoechstes, erreichbares pattern ermitteln
        memset(patterntimes,0,sizeof(patterntimes));
	memset(alreadyplayed,0,sizeof(alreadyplayed));
	i=0;
	panningoff=true;
	forcebpm=true;
	dosetspeed(initbpmspeed);
	forcebpm=false;
	dosetspeed(initspeed);
  playtime=0;
  if ( (filetype!=f669)&&(filetype!=unis)&&(filetype!=ffar)){
    loopto=-1;
    loopfrom=-1;
  };
  loopfromtime=-1;
  patterndelay=0;
  patternloops=0;
  breakto=0;
  memset(noteplayed,0,256);
  do{
    getpattern(i);
    unilong=playtime;
    patterntimes[i]=playtime;
    if ( ptrntempi[i]>0 ) dosetspeed(ptrntempi[i]);
    for (j=breakto; j<=ptrnbreaks[i];j++)
    {
      breakto=0;
      for (k=0;k<numtracks;k++){
     // with pattern^[k][j] do
  	   byte& instrument= (*pattern)[k][j].instrument;
           word& ton= (*pattern)[k][j].ton;
           byte& effekt= (*pattern)[k][j].effekt;
           byte& operands= (*pattern)[k][j].operands;
           char& chnvol= (*pattern)[k][j].chnvol;
        switch ( effekt ){
		case setspeed : dosetspeed(operands);break;
		case setbpmspeed    :{ forcebpm=true; dosetspeed(operands); forcebpm=false; } break;
		case finetempoup    :dofinefartempo (operands);break;
		case finetempodwn   :dofinefartempo (-operands);break;
		case panning        :if ((operands!=0)&&(operands!=128)) panningoff=false;break;
		case portamento_up  :if ((filetype==s3m)||(filetype==stm)){
			if (operands < 0xe0) effekt = portamento_up ;else
			if (operands < 0xf0) effekt = xtrafsldup    ;else{
				effekt = enhanced;
				operands = fsldup << 4;
				goto enh;
			}
		}break;
		case portamento_down:if ((filetype==s3m)||(filetype==stm)){
			if (operands < 0xe0 ) effekt = portamento_down ;else
			if (operands < 0xf0 ) effekt = xtrafslddwn     ;else{
				effekt = enhanced;
				operands = fslddwn << 4;
				goto enh;
			}
		};break;
		case volumeslide: if ((filetype==s3m)||(filetype==stm)){
			if ((operands & 0x0f == 0x0f)&&(operands & 0xf0 != 0)){
				effekt = enhanced;
				operands = finevolup << 4;
				goto enh;
			}else if ((operands & 0xf0==0xf0)&&(operands & 0x0f!=0)){
				effekt = enhanced;
				operands = finevoldwn << 4;
				goto enh;
			}
		}break;
                case noeffekt : break;  //? EB
     		case enhanced :{
			switch (operands >> 4){ 
				case pattrndelay: patterndelay=operands & 0x0f;break;
				case pattrnloop : if ( (operands & 0x0f) ==0 ) unilong=playtime; 
							else patternloops=(operands & 0x0f)
				;break;
		case epanning   : if ( !( ((operands & 0x0f) >=0) && ((operands & 0x0f)<= 15 )) ) panningoff=false;
				;break;
			}

		enh:
			proeffectsused |= (1 << (operands >> 4));
		}break;
	}
	if ( effekt<16 ) effectsused |= (1 << effekt) ;else
        if ( effekt<32 ) extraeffused |= (1 << (effekt-16)) ;else
        if ( effekt<48 ) extraeffused1 |= (1 << (effekt-32));      
      }
 asm("
        xorw %ax,%ax
        xorl %ecx,%ecx
        movb patterndelay,%al
        incw %ax
        mulb speed
        movw %ax,%cx
      lls:
        call inctime__Fv
        aword;loop lls
        movb $0,patterndelay
      ");
	if (patternloops>0){
		unilong=playtime-unilong;
		playtime += unilong*patternloops;
		patternloops=0;
	}
	noteplayed[j]=true;
	pjump=false;
	pbreak=false;
	for (k=0;k < numtracks;k++){
   //   with pattern^[k][j] do  (*pattern)[k][j]
		byte& instrument= (*pattern)[k][j].instrument;
		word& ton= (*pattern)[k][j].ton;
		byte& effekt= (*pattern)[k][j].effekt;
		byte& operands= (*pattern)[k][j].operands;
		char& chnvol= (*pattern)[k][j].chnvol;
		
		switch (effekt){
			case noeffekt:;break;
			case positionjump   :if (operands<numpatterns){
				pjump=true;
				jumpto=operands;
			};break;
			case patternbreak   :{
				pbreak=true;
				breakto=10*(operands >> 4)+(operands & 0x0f);
			};break;
		}
	}
	if (pjump){
		if (  ptrnbreaks[jumpto]<breakto ) breakto=0;
		if (  i!=jumpto ){
			alreadyplayed[i]=true;
			memset(noteplayed,0,256);
		}
		if ((alreadyplayed[jumpto])||(noteplayed[breakto])){
			if ( (loopfrom=-1) ){
				loopfrom=i+1;
				loopto=jumpto+1;
				loopfromtime=playtime;
			}
		}else{
			i=jumpto;
			goto jmp;
		}
	}else if (  pbreak ) break;
    }
    memset(noteplayed,0,256);
    alreadyplayed[i]=true;
    i++;
    if (  i>=numpatterns ) i=0;
  jmp:
    if (  ptrnbreaks[i]<breakto ) breakto=0;
  }while (!alreadyplayed[i]);
  totaltime=playtime;
    if (  loopfromtime==-1 ) loopfromtime=totaltime;
    if (loopto > -1) looptotime=patterntimes[loopto-1]; else looptotime=0;
    if (initglobvol<64) initglobvol=64;
    for (i=0;i < numtracks;i++) if ( (defpanning[i] !=0)&&(defpanning[i]!=128)) panningoff=false;
}

//----------------------------------------------play routine ------------------------------------------------------------------

int play(const char* Filename,tsettings settings,boolean repeats)
{
  char *pstr;
  int exit_status= 0;
  if ( Filename==NULL) { error=id_nomodfile; return(error); };
  error=0;
  if (  playing ) stop();
  //memset(&filetype,0,sizeof(tmodulinfo));//die modulinfo auf 0 setzen
  pstr=strcpy(filename,Filename);
  for (int i=1; i <= 256 ;i++) instruments[i].tuning=8363;
  initglobvol=64;
  forcerange=false;
  //************************modfile in speicher einlesen******************************
  //testen, ob modfile vorhanden
  f.open(Filename,ios::in);
  if ( f.good() ){
    if (  comment!=NULL ){
      free(comment);
      comment=NULL;
    }
    getinfo(false);
    if (  error != 0 ) { error=0; getinfo(true);};
    if (  error != 0 ) goto outclose;
    soundsettings=settings;
    if (  error>0 ) goto outclose;
    if (  !(getsongmem(trackmemsize+instrmemsize))){ 
      error=id_nomem; goto outclose; 
    }
    switch (filetype){
    case noisetr:
    case startr:
    case protr:
    case ftrk:
    case wow:     mod_getfiledata();break;
    case mtm:     mtm_getfiledata();break;
    case f669:
    case unis:    f669_getfiledata();break;
    case stm:     stm_getfiledata();break;
      //		case oktalyz  :okt_getfiledata();break;
    case ffar:     far_getfiledata();break;
    case s3m:      s3m_getfiledata();break;
    case xm:       xm_getfiledata();break;
    default       : { stop();error=id_nomodfile;goto outclose; };break;
    }
    if (  (error==0) && (! fitsongmem()) ) error=id_nomem;
    if (  error>0 ) { stop();goto outclose; };
    gettotaltime();
    if ( activatesound() > 0 ){
      stop();goto outclose;
    }
    kanalinit();
    repeatsong=repeats;
    mod_end=false;
    Pause_=false;
    playing=true;
    f.close();
    return(0);
  outclose:
    stop();
    f.close();
  }else error=id_filenotfound;
  return(error);
}

/*
 FUNCTION GetTimePattern(Time:Longint):Byte;EXPORT;ASSEMBLER;
 {Liefert das Pattern zur Zeit...}
 ASM
   mov cx,256
   mov si,offset PatternTimes
   DB 66h; xor dx,dx
   xor bx,bx
 @Loop:
   DB 66h; mov ax,word ptr [si]
   DB 66h; cmp ax,word ptr Time
   ja @Above
   je @GotIt
   DB 66h; cmp ax,dx
   jbe @Above
   mov bx,cx
   DB 66h; mov dx,ax
 @Above:
   add si,4
   loop @Loop
   mov cx,bx
 @GotIt:
   mov ax,256
   sub ax,cx
   inc ax
 END;
 */

void search_time(int time)//sucht nach einer spielposition im mod-file
{
  boolean reps;
  if (  playing )
  {
    if (  time<totaltime )
    {
      searchtime=time;
     // printf("search_time");
      kanalinit();
      reps=repeatsong;
      repeatsong=false;
      search=true;
      play_the_module();//spielen im search-modus
      repeatsong=reps;
      search=false;
      for (i=0;i<=soundsettings.nbuffers-1;i++)// do with playtimes^[i] do
	{
	  (*playtimes)[i].pattrn    =currpattern;
	  (*playtimes)[i].time      =playtime;
	  effectstate &effects = (*playtimes)[i].effects;
	  effectstate &proeffects= (*playtimes)[i].proeffects;
	  effectstate &extraeff  =(*playtimes)[i].extraeff;
	  effectstate &extraeff1 =(*playtimes)[i].extraeff1;
	   tbytestate &playinstr =(*playtimes)[i].playinstr;

	  memset(&effects,sizeof(effects),0);
	  memset(&proeffects,sizeof(proeffects),0);
	  memset(&extraeff,sizeof(extraeff),0);
	  memset(&extraeff1,sizeof(extraeff1),0);
	  memset(&playinstr,sizeof(playinstr),0);
	};
      mod_end=false;
      pm_is_working=true;
      //if (  !pause ) timeron();
    }else stop();
  }
}


void settingschanged(tsettings settings)
{
  boolean oldpause;
  error=0;
  if (  (pm_is_working) &&
    ((settings.samplerate != soundsettings.samplerate) ||
     (settings.bits       != soundsettings.bits)       ||
     (settings.name       != soundsettings.name)       ||
     (settings.nbuffers   != soundsettings.nbuffers)   ||
     (settings.deviceid   != soundsettings.deviceid)   ||
     (settings.surround   != soundsettings.surround)   ||
     (settings.nobpm      != soundsettings.nobpm)      ||
     (settings.quality    != soundsettings.quality)    ||
     (settings.oversamp   != soundsettings.oversamp)   ||
     (settings.stereo     != soundsettings.stereo)))
  {
    if ( (settings.samplerate == soundsettings.samplerate)&&
      (settings.bits       == soundsettings.bits      )&&
      (settings.nbuffers   == soundsettings.nbuffers  )&&
      (settings.deviceid   == soundsettings.deviceid  )&&
      (settings.quality    == soundsettings.quality   )&&
      (settings.nobpm      == soundsettings.nobpm     )&&
      (settings.stereo     == soundsettings.stereo    )&&
      (settings.nbuffers   < 6                       )) soundsettings=settings; 
    else
    {
      searchtime=(*playtimes)[*lastbuffer].time;
      deactivatesound();
      if (  (settings.nobpm!=soundsettings.nobpm) ) { soundsettings=settings; gettotaltime();}
      else 
	soundsettings=settings;
      
      if (!activatesound()) search_time(searchtime);
      else stop();
    }
  }
}


void handlerepeat(boolean rep)
{
  repeatsong=rep;
  if (rep) mod_end=false; else if (amrepeating) mod_end=true;
}

void *getdataptr(void)
{
  return &filetype;
}

int rnd(){
int i,j ;
int my_range = 256;
i = RAND_MAX / my_range;
            i *= my_range;
            while ((j = rand()) >= i) continue;
            return j % i;
}

int sid1,sid;
void init_player(void)
{
  // setting up the signalhandler
  sigaction(SIGSEGV,&Sig_Action,NULL);
  // sigaction(SIGCHLD,&Sig_Action,NULL);

  //fuer currbuffer und lastbuffer 
  sid1=shmget(IPC_PRIVATE,10,IPC_CREAT|SHM_R|SHM_W);
  if (sid1==-1) cerr<<"Shared Memory Error\n";
  lastbuffer=shmat(sid1,NULL,0);
  currbuffer=lastbuffer+sizeof(*lastbuffer);
  distance=(int*)(currbuffer+sizeof(*currbuffer));

  for (i=0;i<=145;i++) pitchtable[i]=word (54784.0*exp(log(2)*((0.0-i)/12)));

  amplaying     =0;
  comment       =NULL;
  ende          =true;
  notplay       =true;
  playmemhandle =0;
  songmemhandle =0;
  initspeed     =6;
  initbpmspeed  =125;
  //const float PI = 3.1415;
  for (i=0;  i <= 255;i++ ) sintable[i] =char(128*(sin(PI*i/128)-0.5));
  for (i=0 ; i <= 255 ;i++ ) ramptable[i]=127-i;
  for (i=0 ;  i <= 127 ;i++) sqrtable[i]=-128;
  for (i=128; i <=255 ;i++) sqrtable[i] =127;
  for (i=0  ; i <= 255 ;i++) rndtable[i] =rnd()-128;
  
  //memcpy(&soundsettings,&defsettings,sizeof(tsettings));
  // startet timer, welcher alle Xms eine SIGALRM auslst 
#if 0
  timertime.it_value.tv_sec=0;
  timertime.it_value.tv_usec=TIMER_INT*1000;
  timertime.it_interval.tv_sec =0;
  timertime.it_interval.tv_usec=TIMER_INT*1000;
  setitimer(ITIMER_REAL,&timertime,NULL);
#endif
}

void exit_player(void)
{
  freeplaymem();
  freesongmem();
  printf("exit\n");
  shmdt(lastbuffer);
  shmctl(sid1,IPC_RMID,NULL);
}

void sig_handle(int n)
{
  stop();
  printf("this is probably a bug, abnormal ");
  exit_player();
  exit(1);
      
}









