/*============= s3m loader routine by jensi =======================*/

#include "modc.h"
#include "misc.h"
#include "s3m.h"
#include "effects.h"
#include <stdlib.h>
#include <fstream.h>

extern ifstream f;

static byte *pbuffer;
static ps3mheader s3mheader;      
static pinstruments s3minstruments;
static ps3msample s3msample;

extern int32 s3mchannelmap;

void s3mloaderr1(void)
{
  error = id_nomodfile;
  free(pbuffer);
  free(s3msample);
  free(s3minstruments);
  free(s3mheader);
}

void s3m_getfiledata(void)
{


  ppatterns s3mpatterns;    
  ps3mpatterndata s3mpatterndata; 

  word l;    
  byte what;

  
  for( i=0 ; i<=numpatterns-1;i++)
    for( j=0; j<numtracks;j++) (*tracks)[i][j]=numtracks*parrangement[i]+j;
  /* read header */
  f.seekg (0);
  if ( f.bad() ) { error=id_nomodfile; return; }
  s3mheader=malloc(sizeof(ts3mheader));
  f.read(s3mheader,sizeof(ts3mheader));
  if ( f.gcount()!=sizeof(ts3mheader) ) { 
    error=id_nomodfile; free(s3mheader); 
    return; 
  }
  //with s3mheader^ do
  {
    word &patnum =s3mheader->patnum;
    word &insnum =s3mheader->insnum;
    word &ffv    =s3mheader->ffv;
    word &ordnum =s3mheader->ordnum;

    /* read pattern pointers */
    f.seekg(sizeof(ts3mheader)+s3mheader->ordnum+s3mheader->insnum*2);
    if ( f.bad() ) { 
      error=id_nomodfile; 
      free(s3mheader); 
      return; }
    s3mpatterns=malloc(patnum*2);
    f.read(s3mpatterns,patnum*2);
    if ( f.gcount()!=patnum*2 ){ 
      error=id_nomodfile; 
      free(s3mpatterns); 
      free(s3mheader); 
      return; }
    /* convert patterns */
    s3mpatterndata=malloc(sizeof(ts3mpatterndata));
    for( i=0 ;i<= lastpattern;i++)
      if ( alreadyplayed[i] )
	{
	  /* read single (packed) pattern */
	  f.seekg (int((*s3mpatterns)[i]) << 4);
	  if ( f.bad() )
	    {
s3mloaderr:
	      error=id_nomodfile;
	      free(s3mpatterndata);
	      free(s3mpatterns);
	      free(s3mheader);
	      return;
	    }
	  f.read(s3mpatterndata,sizeof(ts3mpatterndata));
	  if ( f.gcount()<(*s3mpatterndata).length ) goto s3mloaderr;
	  /* convert single pattern */
	  if ( (*s3mpatterndata).length > sizeof(ts3mpatterndata) ) goto s3mloaderr;
	  /* ^^ this is unnecessary ^^ */
	  for( j=0;j<= 63;j++)
	    for( k=0;k< numtracks;k++){ 
	      // with pattern^[k,j] do
	      
	      (*pattern)[k][j].instrument=0;
	      (*pattern)[k][j].ton=0;
	      (*pattern)[k][j].effekt=noeffekt;
	      (*pattern)[k][j].operands=0;
	      (*pattern)[k][j].chnvol=-1;
	    }
	  l=0;
	  for( j=0;j<=63;j++){ 
	    //with s3mpatterndata^ do
	    word &length=s3mpatterndata->length;
	    while (s3mpatterndata->packeddata[l]!=0)
	      {
		byte *const &packeddata = s3mpatterndata->packeddata;
		what=packeddata[l];
		k=what & 0x1f;
		if ( !((1<<k) & s3mchannelmap) )
		  {
		    /* skip dummy data */
		    if ( (what & 0x20)!=0 ) l+=2;
		    if ( (what & 0x40)!=0 ) l++;
		    if ( (what & 0x80)!=0 ) l+=2;
		  } else { 
		    //with pattern^[k, j] do
		    word &ton          = (*pattern)[k][j].ton;
		    byte &instrument   = (*pattern)[k][j].instrument;
		    byte &effekt       = (*pattern)[k][j].effekt;
		    byte &operands     = (*pattern)[k][j].operands;
		    char &chnvol       = (*pattern)[k][j].chnvol;

		    if (( what & 0x20)!=0 )
		      {
			if ( packeddata[l+1]==0xfe ) { ton=13; instrument=255;} else
			  {
			    if ( packeddata[l+1]==0xff) 
			      ton=0; 
			    else 
			      ton=pitchtable[(packeddata[l+1] >> 4)*12+(packeddata[l+1] & 0x0f)+1]<< 2;
			    instrument = packeddata[l+2];
			  }
			l+=2;
		      }
		    if ( (what & 0x40) != 0 ) { chnvol=packeddata[l+1];l++; }
		    if ( (what & 0x80)!=0 ){
		      effekt=packeddata[l+1];
		      operands=packeddata[l+2];
		      l+=2;
		      switch ((effekt-1)+'a'){
		      case 'a': effekt=setspeed;break;
		      case 'b': effekt=positionjump;break;
		      case 'c': effekt=patternbreak;break;
		      case 'd': effekt=volumeslide;break;
		      case 'e': effekt=portamento_down;break;
		      case 'f': effekt=portamento_up;break;
		      case 'g': effekt=tone_portamento;break;
		      case 'h': effekt=vibrato;break;
		      case 'i': effekt=tremor;break;
		      case 'j': effekt=arpeggio;break;
		      case 'k': effekt=vibravolslid;break;
		      case 'l': effekt=portvolslide;break;
		      case 'o': effekt=playoffset;break;
		      case 'q': effekt=retrigvolslide;break;
		      case 'r': effekt=tremolo;break;
		      case 's': {
			effekt=enhanced;
			switch (operands >> 4 ){
			case 0x00:operands=setfilter   << 4+operands & 0x0f;break;
			case 0x01:operands=glissdctrl  << 4+operands & 0x0f;break;
			case 0x02:operands=finetune    << 4+operands & 0x0f;break;
			case 0x03:operands=vibrawave   << 4+operands & 0x0f;break;
			case 0x04:operands=tremwave    << 4+operands & 0x0f;break;
			case 0x08:operands=epanning    << 4+operands & 0x0f;break;
			case 0x0a:{ effekt=stereocontrol; operands=operands & 0x0f; };break;
			case 0x0b:operands=pattrnloop  << 4+operands & 0x0f;break;
			case 0x0c:operands=notecut     << 4+operands & 0x0f;break;
			case 0x0d:operands=notedelay   << 4+operands & 0x0f;break;
			case 0x0e:operands=pattrndelay << 4+operands & 0x0f;break;
			case 0x0f:operands=invloop     << 4+operands & 0x0f;break;
			default: { effekt=noeffekt; operands=0;};break;
			}
		      };break;
		      case 't': { effekt=setbpmspeed; if ( operands<32 ) operands=32; };break;
		      case 'v': effekt=setglobvol;break;
		      case 'x': effekt=panning;break;
		      default: { effekt=noeffekt; operands=0; };break;
		      }
		    }
		  }
		l++;
		if ( l>length-1 ) break;
	      }
	    l++;
	    if ( l>length-1 ) break;
	  }
	  trackwrite(numtracks,64);
	} else trackwrite (numtracks, 0);
    free(s3mpatterndata);
    free(s3mpatterns);
    /* read instrument pointers */
    f.seekg(sizeof(ts3mheader)+ordnum);
    if ( f.bad() ) { 
      error=id_nomodfile; 
      free(s3mheader); 
      return; 
    }
    s3minstruments=malloc(insnum*2);
    f.read(s3minstruments,insnum*2);
    if ( f.gcount()!=insnum*2 ){ 
      error=id_nomodfile; 
      free(s3minstruments); 
      free(s3mheader); 
      return; 
    }
    s3msample = malloc (sizeof (ts3msample));
    /* convert instruments */
    
    
    /****instrumente in speicher einlesen****/
    for( i=1;i<=numinstruments;i++)//orig insnum 
      if ((instruments[i].iend>0)&&(instruments[i].bits<128)) {
	//with instruments[i] do
	char  *const& name=instruments[i].name;
	int32 &offset     =instruments[i].offset    ;
	int32 &iend       =instruments[i].iend;
	int32 &loopstart  =instruments[i].loopstart;
	int32 &loopend    =instruments[i].loopend;
	byte &volume      =instruments[i].volume;
	byte &finetune    =instruments[i].finetune;
	byte &bits        =instruments[i].bits;
	word &tuning      =instruments[i].tuning;
	
	/* find instrument */
	f.seekg(int((*s3minstruments)[i-1]) << 4);
	if ( (f.bad()) || (bits & 0x40)) {s3mloaderr1();return;}
	f.read(s3msample,sizeof(ts3msample)); 
	if ( f.gcount()!=sizeof(ts3msample) ) {s3mloaderr1();return;}
	f.seekg(s3msample->memseq.w1 << 4);  
	if ( f.bad() ) {s3mloaderr1();return;}
	/* read instrument */
	offset=songmemofs;
	
	
        pbuffer=malloc(iend);
	if ( pbuffer == NULL )
	  {
	    error = id_nomem;
	    free(s3msample);
	    free(s3minstruments);
	    free(s3mheader);
	    return;
	  }
	f.read(pbuffer,iend);
        if ( f.gcount()>0 ) 
	  switch (ffv){
          case 1:
	  case 2: songmemwrite(pbuffer,iend,5*((bits & 0x10) >> 4)+(ffv-1));break;
	  default: { s3mloaderr1();return;}
	  }
	if ( iend>0 ){
	  if ( volume>64 ) volume=64;
	  if ( loopend>iend ) loopend=iend;
	  if ( loopstart>iend ) loopstart=0;
	  if ( loopend-loopstart<4 ) { loopstart=0;loopend=0; }
	  iend+=offset;
	  if ( loopend>0 ){
	    loopend+=offset;
	    loopstart+=offset;
	  }
	} else offset=0;
      }
    free(pbuffer);
    free(s3msample);
    free(s3minstruments);
  }
  free(s3mheader);
}





