/********************* s3m format specs by jensi ***********************/

#ifndef s3m_h
#define s3m_h

struct   ts3mheader{
  char s3mname[28] 	__attribute__ ((aligned(1),packed));
  char s3msign1 	__attribute__ ((aligned(1),packed));
  byte filetype 	__attribute__ ((aligned(1),packed));
  byte unused1[2] 	__attribute__ ((aligned(1),packed));
  word ordnum 		__attribute__ ((aligned(1),packed)),
            insnum 	__attribute__ ((aligned(1),packed)),
            patnum 	__attribute__ ((aligned(1),packed)),
            flags 	__attribute__ ((aligned(1),packed)),
            cwt_v	__attribute__ ((aligned(1),packed)),
            ffv 	__attribute__ ((aligned(1),packed));
  char s3msign2[4] 	__attribute__ ((aligned(1),packed));
  byte glob_vol  	__attribute__ ((aligned(1),packed)),
            init_speed 	__attribute__ ((aligned(1),packed)),
            init_tempo	__attribute__ ((aligned(1),packed)),
            mast_vol 	__attribute__ ((aligned(1),packed));
  byte unused2[10] 	__attribute__ ((aligned(1),packed));
  word special 		__attribute__ ((aligned(1),packed));
  byte channels[32] 	__attribute__ ((aligned(1),packed));
};

typedef ts3mheader *ps3mheader;

typedef  byte torders[1];
typedef  torders *porders;

typedef  word tinstruments[1];
typedef  tinstruments *pinstruments;

typedef  word tpatterns[1];
typedef  tpatterns *ppatterns;

struct   ts3mnote { byte b0, 
	b1 __attribute__ ((aligned(1),packed)), 
	b2 __attribute__ ((aligned(1),packed)), 
	b3 __attribute__ ((aligned(1),packed)), 
	b4 __attribute__ ((aligned(1),packed)), 
	b5 __attribute__ ((aligned(1),packed));};

struct   ts3mpatterndata {
  word length __attribute__ ((aligned(1),packed));
  byte packeddata[32 * 64 * sizeof(ts3mnote)] __attribute__ ((aligned(1),packed));
};
typedef  ts3mpatterndata *ps3mpatterndata;

typedef byte tsampletype ;

#define  unused 0 
#define  sample 1
#define  amel   2
#define  abd    3
#define  asnare 4
#define  atom   5
#define  acym   6
#define  ahihat 7

struct tmemseq {
  byte b1  __attribute__ ((aligned(1),packed));
  word w1  __attribute__ ((aligned(1),packed));
};

struct  ts3msample {
  tsampletype sampletype __attribute__ ((aligned(1),packed));
  char dosname[12]       __attribute__ ((aligned(1),packed));
  tmemseq memseq         __attribute__ ((aligned(1),packed));
  int32 length           __attribute__ ((aligned(1),packed)),
        loopbeg          __attribute__ ((aligned(1),packed)),
        loopend          __attribute__ ((aligned(1),packed));
  byte volume		 __attribute__ ((aligned(1),packed)),
            unused1 	__attribute__ ((aligned(1),packed)),
            pack    	__attribute__ ((aligned(1),packed)),
            flags   	__attribute__ ((aligned(1),packed));
  int32 c2_speed    	__attribute__ ((aligned(1),packed)),
             unused2 	__attribute__ ((aligned(1),packed));
  word internal1	__attribute__ ((aligned(1),packed)),
            internal2 	__attribute__ ((aligned(1),packed));
  int32 internal3 	__attribute__ ((aligned(1),packed));
  char samplename[28] __attribute__ ((aligned(1),packed));
  char samplesign[4]  __attribute__ ((aligned(1),packed));
};
typedef ts3msample *ps3msample;

void s3m_getfiledata(void);

#endif




