
/*  
(c) 1994 Carsten Kroll 
*/

#include <stdio.h>
#include <malloc.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/soundcard.h>
#include "sound.h"
#include <signal.h>
#include <sys/shm.h>
#include <sys/wait.h>
#include "modc.h"

#define IOCTL(a,b,c)		ioctl(a,b,&c)

#define MODE_MONO  0
#define MODE_STEREO 1

#define AUDIO "/dev/dsp"

#define min(a,b) 		((a) <= (b) ? (a) : (b))

extern int Wavebeg;
/* global data */

int timelimit = 0;
int audio;
int abuf_size;
int omode,last_pb;
int *distance;

static int pid;
static char *AudioBuffer;

/* Diese Funktion bergibt einen Puffer dem Soundtreiber
   verbleibt aber im Hintergrund d.h. kehrt sofort zurck
   p1 ist offset zur pufferstartaddresse
   bn: Blocknummer
*/
//void WaveWrite(char *AudioBuffer,unsigned int count,unsigned int bn)
void WaveWrite(char *p1,unsigned int count)
{
  unsigned int n;
  // sigset_t s_mask=~SIGALRM;
  // sigprocmask(SIG_BLOCK,&s_mask,NULL);
   
  while (count>abuf_size){
    n=write(audio,p1,abuf_size);
    if(n== -1) {
      perror("audio_write");
      //exit(1);
    }
    p1+=n;
    count-=n;
  } 
     if(write (audio,p1, count)== -1) {
       perror("audio_write");
       //exit(1);
     }
     //sigprocmask(SIG_UNBLOCK,&s_mask,NULL);
}


/* if need a SYNC, 
   (is needed if we plan to change speed, stereo ... during output)
*/
inline void sync_dsp(void)
{
  if (ioctl (audio, SNDCTL_DSP_SYNC, NULL) < 0) {
    perror(AUDIO);
    exit (-1);
  }
}

/* setting the speed for output */
unsigned short int set_dsp_speed (int dsp_speed)
{
  if (IOCTL(audio, SNDCTL_DSP_SPEED, dsp_speed) < 0) {
    fprintf (stderr, "%s: unable to set audio speed\n");
    perror (AUDIO);
    exit (-1);
  }
   return dsp_speed;
}


/* Setz die Parameter der Soundkarte 
   Samplesize 8 o. 16 Bit; Stereo/Mono; Samplefrequenz
   mit Fehlerbehandlung */ 

void Sound_Init (void)
{
  char c;
  
  omode = O_WRONLY;
  audio = open (AUDIO, omode, 0);
  if (audio == -1) {
    close (AUDIO);
    audio = open (AUDIO, omode, 0);
    if (audio == -1) {
      perror (AUDIO);
      printf("Sound_Init failed\n");
      return;
    }
    //exit (-1);
  }
  
  IOCTL(audio, SNDCTL_DSP_GETBLKSIZE, abuf_size);
  if (abuf_size < 4096 || abuf_size > 65536) {
    if (abuf_size == -1)
      perror (AUDIO);
    else
      fprintf (stderr, "Invalid audio buffers size %d\n", abuf_size);
    exit (-1);
  }
}

void do_play_background(int sid,int sid1)
{
  pid=fork();
  if(!pid){
    // Child
    // map the shared memory in
    if(int(AudioBuffer=shmat(sid,NULL,0))==-1) perror ("AudioBuffer");
    if(int(lastbuffer=shmat(sid1,NULL,0))==-1) perror("Control");
    currbuffer=lastbuffer+sizeof(*lastbuffer);
    distance=(int*)(currbuffer+sizeof(*currbuffer));
    *distance=soundsettings.nbuffers;
    //Jetzt ab in die Endlosschleife
    for(;;)
      if((*distance)!=soundsettings.nbuffers){
	// lastbuffer spielen 
	WaveWrite((AudioBuffer+(*lastbuffer)*buffersize)+Wavebeg,buffersize);
	*lastbuffer=(*lastbuffer+1)% soundsettings.nbuffers;
	(*distance)++;//Die Zahl der freien Puffer erhht sich
      }
  }
}

void Set_Sound(tsettings& settings)
{
 int tmps;
  sync_dsp();
  tmps = settings.bits;
  IOCTL(audio, SNDCTL_DSP_SAMPLESIZE, tmps);
  if (tmps != settings.bits) {
    fprintf (stderr," : unable to set %d bit sample size", 
              settings.bits);
    settings.bits = 8;
    IOCTL(audio, SNDCTL_DSP_SAMPLESIZE, settings.bits);
    if (settings.bits != 8) {
        fprintf(stderr, " unable to set 8 bit sample size!\n");
        exit (-1);
    }
    fprintf (stderr, "; playing 8 bit\n");
  } 
  tmps=settings.stereo-1 ;
  if ( IOCTL(audio, SNDCTL_DSP_STEREO, tmps)<0 ) {
      fprintf (stderr, " can't play in Stereo; playing only one channel\n");
      settings.stereo = 1;
      tmps=0;
      IOCTL(audio, SNDCTL_DSP_STEREO,tmps);
    }
  settings.samplerate=set_dsp_speed (settings.samplerate);
}

void Sound_Off(void){
  //printf("kill pid %d\n",pid);
  close(audio);
  if(pid) kill(pid,SIGTERM);
  waitpid(pid,NULL,0);  
}









