#include "modc.h"
#include "misc.h"
#include "stm.h"
#include "mod.h"
#include "effects.h"
#include <stdlib.h>
#include <fstream.h>

extern ifstream f;
static byte *pbuffer;
static unsigned int bufsize,unilong,offset;
static byte reached;

typedef tfilenote notearray[2048];
typedef notearray *pnotearray;

/*###################################  stm  ###############################################################*/
void stm_getfiledata(void)
{
  /*****alle pattern konvertieren*******/
  for( i=0 ;i< numpatterns;i++ ) for( j=0 ;j< numtracks;j++ ) (*tracks)[i][j]=numtracks*parrangement[i]+j+1;
  bufsize=64*sizeof(tfilenote)*numtracks;
  pbuffer=(byte*)malloc(bufsize);
  for( i=0;i < lastpattern;i++ ) 
    if ( i<lastpattern )
  {
    /*einzelnes pattern konvertieren*/
    f.read(pbuffer,bufsize);
    if ( f.gcount()!=bufsize ) { error=id_nomodfile;free(pbuffer);return;}
    if ( alreadyplayed[i] ) for( k=0 ;k <  numtracks;k++){
      reached=false;
      for( j=0 ;j<=63;j++){
	// with pattern^[1][j],pnotearray(pbuffer)^[j*numtracks+k] do
	byte& instrument=(*pattern)[0][j].instrument;
	word& ton=(*pattern)[0][j].ton;
	byte& effekt=(*pattern)[0][j].effekt;
	byte& operands=(*pattern)[0][j].operands;
	char& chnvol=(*pattern)[0][j].chnvol;
	byte& byte1=(*pnotearray(pbuffer))[j*numtracks+k].byte1;
	byte& byte2=(*pnotearray(pbuffer))[j*numtracks+k].byte2;
	byte& byte3=(*pnotearray(pbuffer))[j*numtracks+k].byte3;
	byte& byte4=(*pnotearray(pbuffer))[j*numtracks+k].byte4;
        if ( (byte1==0xff) ) { ton=0;instrument=0;} else
        if ( (byte1==0xfe) ) { ton=13;instrument=255;} else
        {
          if ( ((byte1 & 0xf0)>0x70)||((byte1 & 0x0f)>0x0b)) ton=0;
          else ton=pitchtable[((byte1 >> 4)*12)+((byte1 & 15)+1)];
          instrument=byte2 >> 3;
        }
        chnvol=((byte3 & 0xf0) >> 1)+(byte2 & 0x07);
        operands=byte4;
        switch ( byte3 & 0x0f ){
          case 1/*a*/:{ effekt=setspeed;operands=byte4 >> 4;};break;
          case 2/*b*/:{ effekt=positionjump;operands++;};break;
          case 3/*c*/:effekt=patternbreak;break;
          case 4/*d*/:effekt=volumeslide;break;
          case 5/*e*/:effekt=portamento_down;break;
          case 6/*f*/:effekt=portamento_up;break;
          case 7/*g*/:effekt=tone_portamento;break;
          case 8/*h*/:effekt=vibrato;break;
          case 9/*i*/:effekt=tremor;break;
          case 10/*j*/:effekt=arpeggio;break;
          case 11/*k*/:effekt=vibravolslid;break;
          case 12/*l*/:effekt=enhanced;break;
          case 13/*m*/:effekt=tremolo;break;
          case 14/*n*/:effekt=playoffset;break;
          case 15/*o*/:effekt=portvolslide;break;
          default: effekt=noeffekt;break;
        }
        /*fehlerbehandlung*/
        if ( chnvol>64 ) chnvol=64;
        if ( (chnvol!=-1)||(effekt!=noeffekt)||(operands!=0)||(ton!=0)||(instrument!=0)) reached=true;
      }
      if ( reached ) trackwrite(1,64); else trackwrite(1,0);
    } else trackwrite(numtracks,0);
  } else trackwrite(numtracks,0);
  //free(pbuffer);
  
  /****instrumente in speicher einlesen****/
  for( i=1 ;i<= 31;i++) if ( instruments[i].iend>0 ){
    //with instruments[i] do
    char *const& name=instruments[i].name;
    int32& offset    =instruments[i].offset;
    int32& iend      =instruments[i].iend;
    int32& loopstart =instruments[i].loopstart;
    int32& loopend   =instruments[i].loopend;
    byte& volume     =instruments[i].volume;
    byte& finetune   =instruments[i].finetune;
    byte& bits       =instruments[i].bits;
    word& tuning     =instruments[i].tuning; 
    offset=songmemofs;
    unilong=0;
    f.seekg(16*int(stmsamplememofs[i-1]));
    pbuffer=(byte*)realloc(pbuffer,iend );if ( pbuffer==NULL ) { error=id_nomem;return;}
    offset=songmemofs;
    f.read(pbuffer,iend);
    if ( !f.bad() ) songmemwrite(pbuffer,iend,0);
    if ( volume>64 ) volume=64;
    if ( loopend>iend ) loopend=iend;
    if ( loopstart>iend ) loopstart=0;
    if ( loopend-loopstart<4 ) { loopstart=0;loopend=0; }
    iend+=offset;
    if ( loopend>0 )
      {
	loopend+=offset;
	loopstart+=offset;
      }
  } else instruments[i].offset=0;
  free(pbuffer);
}







