/* 
 * int test_file(const char* Filename)
 * 
 * test Filename auf :  0 file does not exist			-
 *                      1 valid Mod File
 *			2 Directory				-
 * 			3 not supportet File 			
 *			4 exist, but no read permission	        -
 */


#include <sys/stat.h>
#include <sys/types.h>
#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>      //access

#include "player.h"

#include "modc.h"
#include "misc.h"
#include "mod.h"
#include "669.h"
#include "far.h"
#include "oktalyzer.h"
#include "s3m.h"
#include "stm.h"
#include "mtm.h"
#include "xm.h"


#define	file_no_exist	0
#define file_supported  1
#define file_is_dir     2
#define file		3
#define no_read_perm	4

extern ifstream f;
extern string filename;

static int32 result;
static byte *pbuffer;


int get_file_info(boolean uniload);

int test_file(const char* Filename)
{
  char *pstr;
  int	file_status= 0;
  struct stat status;  
  int filetype;
  
  if( (Filename==NULL) || (stat(Filename,&status) != 0) ) 
    return(file_no_exist); 

  
  if( access(Filename,R_OK) == 0 )
  {
    if ( (status.st_mode & S_IFDIR) == S_IFDIR )  	
       return(file_is_dir);		 // dir und lese erlaubnis
    

    if( (S_ISREG(status.st_mode) != 0 ))
    {
       // regular and read permission
   	 pstr=strcpy(filename,Filename);
         f.open(Filename,ios::in);
         if ( f.good() )
         {
       		if (  comment!=NULL )
                {
                	free(comment);
                        comment=NULL;
                }
         }
         if( (get_file_info(false) ) || (get_file_info(true)) )	 
         { 
                f.close(); //  filename = modfile name or header = modfile header
                return(file_supported);
         }
         else
         {
                f.close();
               	return(file);
         }
    }
    else
      return(file);
  }
  else
  {
     return(no_read_perm);
  }
}


int get_file_info(boolean uniload)
{
 char* ext;
 //find the start of the extension
 char *pstr;
 int	support=0;
  ::commentlen=0;
 
 
 ext=strrchr(filename,'.');
 if (!ext) return 0;
 filetype=noisetr;
 if ( uniload ) 
 {
	f.seekg(0,ios::beg);
	pbuffer=(byte*)(malloc(2048));
	f.read(pbuffer,2048);
        support=1;
	if ( !strncmp(pmodheader(pbuffer)->modsign,"M.K.",4 )) filetype=noisetr ;else
	if ( !strncmp(pmodheader(pbuffer)->modsign,"M!K!",4 )) filetype=noisetr ;else
	if ( !strncmp(pmodheader(pbuffer)->modsign,"M&K!",4 )) filetype=noisetr ;else
	if ( !strncmp(pmodheader(pbuffer)->modsign,"M.K!",4 )) filetype=noisetr ;else
	if ( !strncmp(pmodheader(pbuffer)->modsign,"FLT4",4 )) filetype=noisetr ;else
	if ( !strncmp(pmodheader(pbuffer)->modsign,"FLT8",4 )) filetype=noisetr ;else
	if ( !strncmp(pmodheader(pbuffer)->modsign,"EX04",4 )) filetype=noisetr ;else
	if ( !strncmp(pmodheader(pbuffer)->modsign,"EX08",4 )) filetype=noisetr ;else
	if ( !strncmp(pmodheader(pbuffer)->modsign,"OCTA",4 )) filetype=noisetr ;else
	if ( !strncmp(pmodheader(pbuffer)->modsign,"ED81",4 )) filetype=noisetr ;else
	if ( !strncmp(pmodheader(pbuffer)->modsign+2,"CHN",3 )) filetype=noisetr ;else
	if ( !strncmp(pmodheader(pbuffer)->modsign+3,"CH",2  )) filetype=noisetr ;else
	if ( !strncmp(pstmheader(pbuffer)->stmsign,"!Scream!",8 )) filetype=stm     ;else
	if ( !strncmp(pstmheader(pbuffer)->stmsign,"BMOD2STM",8 )) filetype=stm     ;else
	if ( p669header(pbuffer)->f669sign==0x6669             ) filetype=f669    ;else
	if ( p669header(pbuffer)->f669sign==0x4e4a             ) filetype=f669    ;else 
        if ( !strncmp(pmtmheader(pbuffer)->sign,"mtm",3        )) filetype=mtm     ;else
	if ( !strncmp(pfarheader(pbuffer)->farsign,"FAR\0xfe",4 )) filetype=ffar    ;else
	if ( !strncmp(ps3mheader(pbuffer)->s3msign2,"SCRM",4    )) filetype=s3m     ;else
	if ( !strncmp(((XM_Header*)pbuffer)->id_text,"Extended module:",16)) filetype=xm;else
	if ( !strncmp(poktsign(pbuffer)->fullsign,"OKTASONG",8  )) 
           filetype=oktalyz; 
        else
           support=0;
	free(pbuffer);
	f.seekg(0,ios::beg);
 }
 else
 {
	if ((!strcmp(ext,".NST"))||(!strcmp(ext,".nst"))) filetype=noisetr ;else
	if ((!strcmp(ext,".MOD"))||(!strcmp(ext,".mod"))) filetype=noisetr ;else
	if ((!strcmp(ext,".WOW"))||(!strcmp(ext,".wow"))) filetype=wow     ;else
	if ((!strcmp(ext,".MTM"))||(!strcmp(ext,".mtm"))) filetype=mtm     ;else
	if  ((!strcmp(ext,".STM"))||(!strcmp(ext,".stm")))filetype=stm     ;else
	if  ((!strcmp(ext,".669"))			)filetype=f669     ;else
	if  ((!strcmp(ext,".FAR"))||(!strcmp(ext,".far")))filetype=ffar    ;else
	if  ((!strcmp(ext,".S3M"))||(!strcmp(ext,".s3m")))filetype=s3m     ;else
	if  ((!strcmp(ext,".XM"))||(!strcmp(ext,".xm")))filetype=xm      ;else
	if  ((!strcmp(ext,".OKT"))||(!strcmp(ext,".okt")))
		filetype=oktalyz ;
	else
		return(0); 
        support=1;
	
 }
 
 switch  (filetype){
	case oktalyz :
        {
           pbuffer=(byte*)(malloc(8192));
           f.read(pbuffer,sizeof(toktsign));
           if ( (f.gcount()!=sizeof(toktsign))||(poktsign(pbuffer)->fullsign!="oktasong"))
                return(0); 
           
           pstr=strncpy(::modname,filename,int(filename)-int(rindex(filename,'.')));
           do
           {
		f.read(pbuffer,sizeof(toktsign));
		poktsign(pbuffer)->structsize=swaplong(poktsign(pbuffer)->structsize);
		if ( poktsign(pbuffer)->b4sign=="cmod" ) {
		  if ( !(getchannels   (poktsign(pbuffer)->structsize))) goto okterr;
		}
		else if ( poktsign(pbuffer)->b4sign=="samp" ) { 
		  if (!(getinstrdata  (poktsign(pbuffer)->structsize))) goto okterr;
		}
		else if ( poktsign(pbuffer)->b4sign=="spee" ) { 
		  if ( !(getinitspeed  (poktsign(pbuffer)->structsize))) goto okterr;
		}
		else if ( poktsign(pbuffer)->b4sign=="slen" ) { 
		  if ( !(getslen       (poktsign(pbuffer)->structsize))) goto okterr;
		}
		else if ( poktsign(pbuffer)->b4sign=="plen" ) { 
		  if ( !(getarrangesize(poktsign(pbuffer)->structsize))) goto okterr;
		}
		else if ( poktsign(pbuffer)->b4sign=="patt" ) { 
		  if ( !(getarrangement(poktsign(pbuffer)->structsize))) goto okterr;
		}
		else if ( poktsign(pbuffer)->b4sign!="pbod" ) goto okterr;
           }
           while(poktsign(pbuffer)->b4sign!="pbod");
           free(pbuffer);
           return(support);
           okterr:
		free(pbuffer);
                support=0;
        };break;
        case f669 :
        {
	   int S_669h = 497;
	   
           pbuffer=(byte*)(malloc(S_669h));
           f.read(pbuffer,S_669h);result=f.gcount();
           if ((result!=S_669h)) 
           { 
		free(pbuffer); 
                return(0); 
           }
           {
		word f669sign        =p669header(pbuffer)->f669sign;
		byte ninstruments    =p669header(pbuffer)->ninstruments;
		byte numpatts        =p669header(pbuffer)->numpatts;
		if ( !((numpatts >= 1)&&(numpatts<= 127)) ||(f669sign!=0x6669) &&(f669sign!=0x4e4a)
				    ||(ninstruments>64)   ||(ninstruments==0)) 
                { 
                  	free(pbuffer); 
                        return(0); 
                }
           }
           free(pbuffer);
         };break;
         case ffar:
         {
		pbuffer=(byte*)(malloc(sizeof(tfarheader)));
		f.read(pbuffer,sizeof(tfarheader));
		if ((f.gcount()!=sizeof(tfarheader)))
                {
			free(pbuffer); 
                        return(0); 
		}
		{
			char *farsign        =pfarheader(pbuffer)->farsign;
			char *farsign2       =pfarheader(pbuffer)->farsign2;
			word headerlen       =pfarheader(pbuffer)->headerlen;
			byte version         =pfarheader(pbuffer)->version;
			
			if ( (farsign!="far\0xfe")||(farsign2!="\13\10\26"))
                        { 
				free(pbuffer); 
                                return(0); 
			}
			if ( version != 0x10 ) 
                        { 
				free(pbuffer); 
                                return(0); 
			}
			free(pbuffer);
			pbuffer=(byte*)(malloc(sizeof(tfarheader2)));
			f.read(pbuffer,sizeof(tfarheader2));
			if ((f.gcount()!=sizeof(tfarheader2))) 
                        { 
				free(pbuffer); 
                                return(0); 
			}
			
                }
		free(pbuffer);
         };break;
         case s3m :
         {
            	pbuffer=(byte*)(malloc(sizeof(ts3mheader)));
		f.read(pbuffer,sizeof(ts3mheader));
		if ( (f.gcount()!=sizeof(ts3mheader)) ) 
                { 
			free(pbuffer); 
                        return(0); 
		}
		{
		
			char s3msign1=ps3mheader(pbuffer)->s3msign1;
			char *s3msign2=ps3mheader(pbuffer)->s3msign2;
                        byte filetype=ps3mheader(pbuffer)->filetype;
		
			if ( !((s3msign1>=0)&&(s3msign1<=0x1a))|| strncmp(s3msign2,"SCRM",4) )
                        { 
                             free(pbuffer);
                             return(0); 
			}
                        if ((filetype != 16)) 
                        { 
                             free(pbuffer); 
                             return(0); 
                        }
                }
		free(pbuffer);
	};break;
        case xm :
	  {
	  };break;
	case stm:
        {
                  	pbuffer=(byte*)(malloc(sizeof(tstmheader)));
                        f.read(pbuffer,sizeof(tstmheader));
                        if ( (f.gcount()!=sizeof(tstmheader)))
                        { 
                          free(pbuffer); 
                          return(0); 
                        }
                        {
                           char *stmsign   =pstmheader(pbuffer)->stmsign;
                           byte numpatts   =pstmheader(pbuffer)->numpatts;
	    
                           if ((numpatts>127)||(numpatts==0)||(strncmp(stmsign,"!Scream!",8) 
                           	&& strncmp(stmsign,"BMOD2STM",8)))
                           { 
                             free(pbuffer); 
                             return(0); 
                           }
                        }
                        free(pbuffer);
        };break;
	case wow:;
	case noisetr:{
           	pbuffer=(byte*)(malloc(sizeof(tmodheader)));
                f.read(pbuffer,sizeof(tmodheader));
                if ( f.gcount()!=sizeof(tmodheader) ) 
                { 
                     free(pbuffer); 
                     return(0); 
                }
	  result=0;
	  if ( filetype==noisetr )
          {
	    char *modsign=pmodheader(pbuffer)->modsign;
	    if ( !strncmp(modsign,"FLT4",4) ) { filetype=startr; numtracks=4; } else
	      if ( !strncmp(modsign,"FLT8",4 )) { filetype=startr; numtracks=8; } else
		if ( !strncmp(modsign,"M.K.",4 )) { filetype=protr; numtracks=4; } else
		  if ( !strncmp(modsign,"M!K!",4 )) { filetype=protr; numtracks=4; } else
		    if ( !strncmp(modsign,"M&K!",4 )) { filetype=protr; numtracks=4; } else
		      if ( !strncmp(modsign,"M.K!",4 )) { filetype=protr; numtracks=4; } else
			if ( !strncmp(modsign,"EX04" ,4)) { filetype=protr; numtracks=4; } else
			  if ( !strncmp(modsign,"EX08" ,4)) { filetype=protr; numtracks=8; } else
			    if ( !strncmp(modsign,"OCTA" ,4)) { filetype=protr; numtracks=8; } else
			      if ( !strncmp(modsign,"CD81" ,4)) { filetype=protr; numtracks=8; } else
				if ( !strncmp(modsign+2,"CHN",3 ))
				  {
				    filetype=ftrk; 
				    numtracks=modsign[1];
				  }
				else
				  if ( !strncmp(modsign+3,"CH",2 ))
	                          {
				    filetype=ftrk; 
				    numtracks=modsign[1];
				  }
	                          else
				    numtracks=4;
	  }
          else 
             numtracks=8;
	  if ( (result!=0)||(numtracks<4)||(numtracks>32))
	  {
              free(pbuffer); 
              return(0); 
          }
	  free(pbuffer);
	};break;
	case mtm:
        {
        	pbuffer=(byte*)(malloc(sizeof(tmtmheader)));
                f.read(pbuffer,sizeof(tmtmheader));
                if ( f.gcount()!=sizeof(tmtmheader) ) 
                { 
                     free(pbuffer); 
                     return(0); 
                }
                {
                     byte& attribute   =pmtmheader(pbuffer)->attribute;
                     byte& ntracks     =pmtmheader(pbuffer)->ntracks;
                     if ((attribute!=0)	||( ! ((ntracks>=1) &&(ntracks<=32))))
                     { 
                       free(pbuffer); 
                       return(0); 
                     }
		}
	   
	  free(pbuffer);

   	};break;
   default: return(0);
 }
 return(support);
}

