#include "modc.h"
#include "xm.h"
#include "misc.h"
#include <strings.h>
#include <fstream.h>
#include "effects.h"


extern ifstream f;

void xm_getfiledata(void) 
{
   int buffsize;
   unsigned int size=0,pos=0;
   char *pBuffer;
   
   for( int i=0 ;i < numpatterns;i++){
     for( int j=0;j < numtracks ;j++) (*tracks)[i][j]=numtracks * parrangement[i] +j+1;
   }

   f.seekg(sizeof(XM_Header));
   if ( f.fail() ) { 
     error=id_nomodfile; 
     return; 
   }

   //   size=pHeader->header_size;
  
   /************** convert the pattern ***********/

   pos = sizeof(XM_Header);
   XM_Pattern_header *pPattern=new XM_Pattern_header;
   
   for (int i=0;i<numpatterns;i++){

     f.read((char*)pPattern,sizeof(XM_Pattern_header));
     pBuffer= new char[pPattern->datasize];
     if (!pBuffer) {error=id_nomem;delete pPattern;return;}     
     f.read(pBuffer,pPattern->datasize);
     XM_Pattern *pTmp=(XM_Pattern*)pBuffer;

     for (int j=0;j<64;j++){
       for (int k=0;k<numtracks;k++){
	 byte& instrument=(*pattern)[k][j].instrument;
	 word& ton=(*pattern)[k][j].ton;
	 byte& effekt=(*pattern)[k][j].effekt;
	 byte& operands=(*pattern)[k][j].operands;
	 char& chnvol=(*pattern)[k][j].chnvol;
	 //fill with standard values
	 instrument=0;
	 ton=0;
	 effekt=noeffekt;
	 operands=0;
	 chnvol=-1;
	 
	 //check for compressed note
	 char what=pTmp->note & 0x7F;
	 if (pTmp->note & 0x80){
	   //it's compressed
	   (char*)pTmp+=1;
	   int steps=0;
	   if ( what & 0x01){//note follwows
	     ton=pTmp->note << 5;
	     steps++;
	   }
	   if( what & 0x02 ){ //instrument follows
	     instrument=pTmp->instr;
	     steps++;
	   }
	   if( what & 0x04 ){ //volume column byte follows
	     chnvol=pTmp->vol;
	     steps++;
	   }
	   if( what & 0x08 ){ //effect follows
	     effekt=pTmp->eff_type;
	     steps++;
	   }
	   if( what & 0x10 ){ //effect parameter follows
	     operands=pTmp->eff_param;
	     steps++;
	   }
	   (char*)pTmp+=steps;
	 }else{
	   ton=pTmp->note;
	   instrument=pTmp->instr;
	   chnvol=pTmp->vol;
	   effekt=pTmp->eff_type;
	   operands=pTmp->eff_param;
	   pTmp++;
	 }
	 //convert effects
	 if (effekt != noeffekt) effekt>>=4;
#ifndef CLEAN
	 printf("t:%d i:%d cv:%d e:%d o:%d\n",ton,instrument,chnvol,effekt,operands);
#endif
       }
     }
     trackwrite(numtracks,64) ;
     delete pBuffer;
   }
   delete pPattern;

   
   // -- read the Intruments
   XM_Instrument_header* pInst=new XM_Instrument_header;
   XM_Instrument_header2* pInst2=new XM_Instrument_header2;
   //XM_Sample_header* pSample=new XM_Sample_header;
   
   for (int i=0;i<numinstruments;i++){
     long pos=f.tellg();//for later use
     f.read((char*)pInst,sizeof(XM_Instrument_header));
     //char *const &name=instruments[i+1].name;
     int32 &offset    =instruments[i+1].offset;
     int32 &iend      =instruments[i+1].iend;
     int32 &loopstart =instruments[i+1].loopstart;
     int32 &loopend   =instruments[i+1].loopend;
     byte &volume     =instruments[i+1].volume;
     byte &finetune   =instruments[i+1].finetune;
     byte &bits	     =instruments[i+1].bits;
     word &tuning     =instruments[i+1].tuning;
     
     //strncpy(name,pInst->name,22);
     
     //move to next header
     if (!pInst->numsamples){
       f.seekg(pInst->size-sizeof(XM_Instrument_header),ios::cur);
     }else{
       /*there are samples*/
       char old=0;
       f.read((char*)pInst2,sizeof(XM_Instrument_header2));
       f.seekg(pos+pInst->size);
 
       for(int j=0;j < pInst->numsamples;j++){
	 //ignore the sample header
	 f.seekg(sizeof(XM_Sample_header),ios::cur);
	 //Samplelength+=iend;
       }
       //load and convert the sample data
       char *buf=new char[iend];
       f.read(buf,iend);
       int result=f.gcount();
       offset=songmemofs;
       iend+=songmemofs;
       if (loopstart||loopend){
	 loopstart+=songmemofs;
	 loopend+=songmemofs;
       }
#ifndef CLEAN
       printf("offset %d iend %d loopstart %d loopend %d \n",offset,iend,loopstart,loopend);
#endif
       //since the values are delta coded we need to convert them
       char *tmp=buf;
       for(int j=0;j<result;j++){
	 *tmp=old + *tmp;
	 old= *tmp;
	 tmp++;
       }
       songmemwrite(buf,result,0);
       delete buf;
     }
     
   }
   delete pInst;
   // delete pSample;
}
