#ifndef _XM_H
#define _XM_H
/* xm file format 
   (C) Carsten Kroll 1997*/
typedef int          _int32;
typedef unsigned int _uint32;
typedef short int    _int16;
typedef unsigned short int _uint16;
typedef unsigned char _uint8;
typedef char _int8;

struct XM_Header{
  char     id_text[17]	__attribute__ ((aligned(1),packed));
  char     modulename[20]	__attribute__ ((aligned(1),packed));
  char     id	__attribute__ ((aligned(1),packed));
  char     tracker_name[20]	__attribute__ ((aligned(1),packed));
  _int16   version	__attribute__ ((aligned(1),packed));
  _int32   header_size	__attribute__ ((aligned(1),packed));
  _int16   song_length	__attribute__ ((aligned(1),packed));
  _int16   restart_pos	__attribute__ ((aligned(1),packed));
  _int16   numchannels	__attribute__ ((aligned(1),packed));
  _int16   numpatterns	__attribute__ ((aligned(1),packed));
  _int16   numinstr	__attribute__ ((aligned(1),packed));
  _int16   flags	__attribute__ ((aligned(1),packed));
  _int16   tempo	__attribute__ ((aligned(1),packed));
  _int16   BPM	__attribute__ ((aligned(1),packed));
  _uint8   pattorder[256]	__attribute__ ((aligned(1),packed));
};

struct XM_Pattern_header{
  _uint32  length	__attribute__ ((aligned(1),packed));
  _uint8   packing_type	__attribute__ ((aligned(1),packed));
  _uint16  rows	__attribute__ ((aligned(1),packed));
  _uint16  datasize	__attribute__ ((aligned(1),packed));
};

struct XM_Instrument_header{
  _uint32  size	__attribute__ ((aligned(1),packed));
  char     name[22]	__attribute__ ((aligned(1),packed));
  _uint8   type	__attribute__ ((aligned(1),packed));       /*always 0*/
  _uint16  numsamples	__attribute__ ((aligned(1),packed));
};

struct XM_Instrument_header2{  
  _uint32  sample_head_size	__attribute__ ((aligned(1),packed));
  _uint8     samplenumber[96]	__attribute__ ((aligned(1),packed));
  _uint8     volume_points[48]	__attribute__ ((aligned(1),packed));
  _uint8     panning_points[48]	__attribute__ ((aligned(1),packed));
  _uint8     num_vol_points	__attribute__ ((aligned(1),packed));
  _uint8     num_pan_points	__attribute__ ((aligned(1),packed));
  _uint8     vol_sust_point	__attribute__ ((aligned(1),packed));
  _uint8     vol_loop_start	__attribute__ ((aligned(1),packed));
  _uint8     vol_loop_end	__attribute__ ((aligned(1),packed));
  _uint8     pan_sust_point	__attribute__ ((aligned(1),packed));
  _uint8     pan_loop_start	__attribute__ ((aligned(1),packed));
  _uint8     pan_loop_end	__attribute__ ((aligned(1),packed));
  _uint8     vol_type    	__attribute__ ((aligned(1),packed));
  _uint8     pan_type    	__attribute__ ((aligned(1),packed));
  _uint8     vibrato_type	__attribute__ ((aligned(1),packed));
  _uint8     vibrato_sweep      __attribute__ ((aligned(1),packed));
  _uint8     vibrato_depth __attribute__ ((aligned(1),packed));
  _uint8     vibrato_rate __attribute__ ((aligned(1),packed));
  _uint16    vol_fadeout __attribute__ ((aligned(1),packed));
  _uint16    reserved  __attribute__ ((aligned(1),packed));
};

struct XM_Sample_header{
  _uint32  length  __attribute__ ((aligned(1),packed));
  _uint32  loop_start __attribute__ ((aligned(1),packed));
  _uint32  loop_length __attribute__ ((aligned(1),packed));
  _uint8   vol __attribute__ ((aligned(1),packed));
  _int8    finetune __attribute__ ((aligned(1),packed));
  _uint8   type __attribute__ ((aligned(1),packed));
  _uint8   panning __attribute__ ((aligned(1),packed));
  _int8    rel_note_number __attribute__ ((aligned(1),packed));
  _int8    reserved __attribute__ ((aligned(1),packed));
  char     samplename[22] __attribute__ ((aligned(1),packed));
};

struct XM_Pattern{
  _uint8  note __attribute__ ((aligned(1),packed));
  _uint8  instr __attribute__ ((aligned(1),packed));
  _uint8  vol __attribute__ ((aligned(1),packed));
  _uint8  eff_type __attribute__ ((aligned(1),packed));
  _uint8  eff_param __attribute__ ((aligned(1),packed));
};

void xm_getfiledata(void);

#endif

