/* Vol_meter 
    
   Abstnde zwischen den LEDs und Zentrierung fest eingestellt
   (dynamisch geht schlecht, da alles n bichen zu klein ist 
*/

#include "meter.h"

#define GAP  	     	(1)		 /* Gap zwischen LEDs 	*/
#define LED_H		(7)		 /* LED Hhe 		*/
#define ELEMENTS	(20)		 /* Anzahl LEDs		*/
#define MAXVAL 	  	(100)            /* Maximalpegel (Vollaussteuerung) */
#define YELLOW_ON 	ELEMENTS-(0.5*ELEMENTS) /* erste gelbe LED	*/
#define RED_ON    	ELEMENTS-(0.8*ELEMENTS) /* erste rote LED	*/
                     	/* unterste LED (Nr.0) ist Nr. ELEMENTS */

static int 
handle_meter(FL_OBJECT *ob,int event,FL_Coord mx,FL_Coord my,int key,void *xev);

FL_OBJECT *fl_create_meter(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label)
{
  FL_OBJECT *ob;
  ob=fl_make_object(FL_METER,type,x,y,w,h,label,handle_meter);
  /* berechne Hhe eines Elements */
  ((SPEC*)ob->spec) 	   = fl_calloc(1, sizeof(SPEC));
  ((SPEC*)ob->spec)->value = MAXVAL;
  ((SPEC*)ob->spec)->hel   = LED_H;
  ((SPEC*)ob->spec)->y0    = y;
  return ob;
}

FL_OBJECT *fl_add_meter(int type, FL_Coord x,FL_Coord y,FL_Coord w,
			     FL_Coord h, const char *label)
{
  FL_OBJECT *ob=fl_create_meter(type,x,y,w,h,label);
  fl_add_object(fl_current_form,ob);
  return ob;
}

void fl_set_meter(FL_OBJECT *ob,int val)
{
  val=abs(val);
  if (!ob || ob->objclass != FL_METER)
  {
    fprintf(stderr,"set_meter: Bad argument or wrong objtype");
    return;
  }
  if ( ((SPEC*)ob->spec)->value !=val)
  {
    ((SPEC*)ob->spec)->value=(val>MAXVAL) ? MAXVAL : val;
     fl_redraw_object(ob);
  }
}

static int 
handle_meter(FL_OBJECT *ob,int event,FL_Coord mx,FL_Coord my,int key,
	      void *xev)
{
  int n;
  int hel=((SPEC*)ob->spec)->hel;
  int val=MAXVAL-((SPEC*)ob->spec)->value;
  int offset=((SPEC*)ob->spec)->y0;
  
  switch( event)
  {
  case FL_DRAW:
    for (n=1;n<=((val*ELEMENTS)/MAXVAL);n++)
           fl_rectf(ob->x,(hel+GAP)*(n-1)+offset,ob->w,hel,FL_INACTIVE_COL);
    for (n;n<=ELEMENTS;n++)
    {
       if( (n<=ELEMENTS) && (n>YELLOW_ON) )
            fl_rectf(ob->x,(hel+GAP)*(n-1)+offset,ob->w,hel,FL_GREEN);
       else
           if(n<=RED_ON) 
              fl_rectf(ob->x,(hel+GAP)*(n-1)+offset,ob->w,hel,FL_RED);
           else
              fl_rectf(ob->x,(hel+GAP)*(n-1)+offset,ob->w,hel,FL_YELLOW);
    }
  break;   
  case FL_FREEMEM:
    fl_free(((SPEC *)ob->spec));
  break;    
  }
  return 0;
}

/* end Volmeter */
