#include"manager.h"

typedef void Sigfunc(int);

Sigfunc *Signal(int signo, Sigfunc *func) {
    struct sigaction act, oact;
    
    act.sa_handler = func;
    sigemptyset(&act.sa_mask);
    act.sa_flags = 0;
    if (signo == SIGALRM) {
#ifdef SA_INTERRUPT
        act.sa_flags |= SA_INTERRUPT;   /* SonOS 4.x */
#endif
    } else {
#ifdef SA_RESTART
        act.sa_flags |= SA_RESTART;     /* SVR4, 4.4BSD */
#endif
    }
    if (sigaction(signo, &act, &oact) < 0)
        return (SIG_ERR);
    return(oact.sa_handler);
}

void manageit() {

  setpgrp();
//  shmid=shmget((key_t)0xdeadbeef,sizeof(struct shmdata_type),0600|IPC_CREAT|IPC_EXCL);
  if((shmptr=(struct shmdata_type*)shmat(shmid,NULL,0))==(struct shmdata_type*)0)
    perror("can't attach shared memory");
  shmptr->managpid = getpid();
  shmptr->listlen = 0;
  shmptr->pid = 0;
  shmptr->using = 1;
  signal(SIGUSR1,listnext);
  Signal(SIGCHLD,listnext);
  signal(SIGINT,dienow);
  signal(SIGTERM,dienow);

  while(1) select(0,NULL,NULL,NULL,NULL); //oh, oh, oh, oh, stayin' alive, stayin' alive
  exit(0);
}
void listnext(int signum) {
  int i, pid;

  if(shmptr->pause) return;
  if(signum==SIGCHLD) {
    while(waitpid(-1,NULL,WNOHANG) > 0);
    shmptr->pid=0;
    if((shmptr->listlen > 1)) {
      for(i=1;i < shmptr->listlen;i++)
        strcpy(shmptr->playlist[i-1],shmptr->playlist[i]);
      shmptr->playlist[shmptr->listlen][0]='\0';
      shmptr->listlen--;
    } else if(!shmptr->using) dienow(1); else {shmptr->listlen--; return; }
    Signal(SIGCHLD,listnext);
  }
  else {
    if(shmptr->pid) return;
    signal(SIGUSR1,listnext);
  }
  if(shmptr->listlen>0) {
/*    if(shmptr->playlist[0][0]=='%') { system(shmptr->playlist[0]+1); 
      kill(shmptr->managpid,SIGCHLD);
    return; }
*/    pid=fork();
    if(pid==-1) { perror("Cant fork"); exit(0); }
    if(pid==0) {
      sleep(1);
      fclose(stdin);fclose(stdout);fclose(stderr);
      execlp(EXEC_LOC,"mpg123","-q",EXEC_PARAMS,shmptr->playlist[0],0);
      exit(0);
    }
    shmptr->pid=pid;
} }
void dienow(int diedude) {
  if(shmptr->pid) kill(shmptr->pid,SIGINT);

  if(shmdt((char*)shmptr) < 0)
    perror("can't detach shared memory");
  if(shmctl(shmid, IPC_RMID, (struct shmid_ds *) 0) < 0)
    perror("can't remove shared memory");
      
  exit(1);
}
