#include"player.h"
/* You really should let me have this one part for myself */
#define TITLE " Pandama's Cmp3 Player " 

void enditall(int signum) {
  if((signum==SIGINT)||(signum==SIGTERM)||(signum==SIGSEGV)) 
    kill(shmptr->managpid,SIGINT);
  shmptr->using--;
  if(shmdt((char*)shmptr) < 0)
    perror("can't detach shared memory");
  if(signum!=69) {
        curs_set(1);
        endwin();
  }
  close(mixernum);
  exit(1);
}
void initialize() {
  signal(SIGINT,enditall);
  signal(SIGTERM,enditall);
  signal(SIGSEGV,enditall);

  if(!shmptr->using) shmptr->using++;
  srand(time(NULL));
  initscr();
  cbreak();
  keypad(stdscr,TRUE);
  curs_set(0);
  leftwin = newpad(MAX_LIST,MAX_WIDTH);
  rghtwin = newpad(MAX_LIST,MAX_WIDTH);
  rghtshel = newwin(LINES-9,COLS/2-1,3,COLS/2);
  leftshel = newwin(LINES-9,COLS/2-2,3,1);
  listwin = newpad(MAX_LIST, MAX_FULL);
  listshel = newwin(LINES-9,COLS-2,3,1);
  if(has_colors()) {
    start_color(); 
    init_pair(1,COLOR_BLUE,COLOR_BLACK);	//stdwin
    init_pair(2,COLOR_GREEN,COLOR_BLACK);	//leftshel
    init_pair(3,COLOR_RED,COLOR_BLACK);		//rghtshel
    init_pair(4,COLOR_CYAN,COLOR_BLACK);	//listwin
    init_pair(5,COLOR_CYAN,COLOR_YELLOW);	//grabbed file
    attron(COLOR_PAIR(1));
    wattron(listwin,COLOR_PAIR(4));
    wattron(listshel,COLOR_PAIR(4));
    wattron(leftwin,COLOR_PAIR(2));
    wattron(rghtwin,COLOR_PAIR(3));
    wattron(leftshel,COLOR_PAIR(2));
    wattron(rghtshel,COLOR_PAIR(3));
  }
  box(stdscr,0,0); 

  move(1,(COLS/2)-(strlen(TITLE)/2));
  attron(A_REVERSE);
  printw(TITLE);
  attroff(A_REVERSE);
  wattron(leftshel,A_REVERSE);
  mvwprintw(leftshel,1,2,"Directory:");
  wattroff(leftshel,A_REVERSE);
  mvwprintw(rghtshel,1,2,".mp3 files:\n");
  initvol();
  
  box(rghtshel,0,0);
  box(listshel,0,0);
}
void initvol() {
  if ((mixernum=open("/dev/mixer", O_RDWR))<0) {
    fprintf(stderr,"Error with /dev/mixer: %s",strerror(errno));
    enditall(0); }
  ioctl(mixernum, MIXER_READ(SOUND_MIXER_VOLUME), &vol);
  vol=vol & 0xff;
  mvprintw(3,COLS/2-1,"-");
  mvprintw(LINES-7,COLS/2-1,"-");
  mvprintw((LINES-8)-(vol*(LINES-12)/100),COLS/2-1,"*");
}
void volclean() {
  int i;
  for(i=4;i<LINES-7;i++) { mvprintw(i,COLS/2-1,"|"); mvprintw(i,COLS/2-1," "); }
  mvprintw(3,COLS/2-1,"-");
  mvprintw(LINES-7,COLS/2-1,"-");
  mvprintw((LINES-8)-(vol*(LINES-12)/100),COLS/2-1,"*");
}
void volup() {
  int i;
  mvprintw((LINES-8)-(vol*(LINES-12)/100),COLS/2-1," ");
  vol+=3;
  if(vol>100) vol=100;
  i = vol | vol<<8;
  ioctl(mixernum, MIXER_WRITE(SOUND_MIXER_VOLUME), &i);
  mvprintw((LINES-8)-(vol*(LINES-12)/100),COLS/2-1,"*");
}
void voldown() {
  int i;
  mvprintw((LINES-8)-(vol*(LINES-12)/100),COLS/2-1," ");
  vol-=3;
  if(vol<0) vol=0;
  i = vol | vol<<8;
  ioctl(mixernum, MIXER_WRITE(SOUND_MIXER_VOLUME), &i);
  mvprintw((LINES-8)-(vol*(LINES-12)/100),COLS/2-1,"*");
}
int dialogbox(char* message) {
  WINDOW *dialog;
  char answer;
  
  dialog=newwin(LINES/6,COLS/3,LINES/3,COLS/3);
  wattron(dialog,COLOR_PAIR(4));
  mvwaddstr(dialog,1,(COLS/6)-(strlen(message)/2),message);
  box(dialog,0,0);
  wnoutrefresh(dialog);
  refresh();
  answer=getch();
  while(!((answer=='y')||(answer=='n'))) {
    wattron(dialog,A_BLINK);
    mvwaddstr(dialog,2,5,"No you WHORE! (y,n)");
    wattroff(dialog,A_BLINK);
//    move(LINES-1,COLS-1);
    wnoutrefresh(dialog);
    refresh();
    answer=getch();
  }
  if(answer=='n') return(0);
  else return(1);
}
WINDOW * switchwin(WINDOW *curwin) {
  if(curwin==leftwin) {
    curwin = rghtwin;
    wattron(rghtshel,A_REVERSE);
    mvwprintw(rghtshel,1,2,".mp3 files:");
    wattroff(rghtshel,A_REVERSE);
    mvwprintw(leftshel,1,2,"Directory:");
    wnoutrefresh(rghtshel);
    wnoutrefresh(leftshel);
  }
  else {
    curwin = leftwin;
    wattron(leftshel,A_REVERSE);
    mvwprintw(leftshel,1,2,"Directory:");
    wattroff(leftshel,A_REVERSE);
    mvwprintw(rghtshel,1,2,".mp3 files:");
    wnoutrefresh(leftshel);
    wnoutrefresh(rghtshel);
  } 
  wnoutrefresh(stdscr);
  return(curwin);
}
int isdir(char* directory, char* dirname) {
char fullpath[MAX_FULL];
struct stat buffer;
  strcpy(fullpath,directory);
  strcat(fullpath,"/");
  strcat(fullpath,dirname);
  stat(fullpath,&buffer);
  if((buffer.st_mode & S_IFMT)==S_IFDIR) return(1);
  else return(0);  
}
int newdir(char* dirname, int *mp3s) {
  int numfiles, count, dirs=1;
  struct dirent **dirlist;  

  *mp3s = 0;
  { int diff;
    diff=strlen(dirname);
    if(diff>(COLS/2)-14) 
      mvwprintw(leftshel,1,12,"..%s/\n",dirname+(diff-((COLS/2)-18)));
    else mvwprintw(leftshel,1,12,"%s/\n",dirname);
  }
  box(leftshel,0,0);
  wnoutrefresh(leftshel);
  wclear(leftwin);
  wclear(rghtwin);
  for(count=0;count<MAX_LIST;count++) 
    {leftsave[count][0]='\0'; rghtsave[count][0]='\0';}
  mvwprintw(leftwin,0,0,"../\n");
  strcpy(leftsave[0],"..");
  wmove(rghtwin,0,0);
  numfiles = scandir(dirname, &dirlist, 0, alphasort);
  for(count=0;count<numfiles;count++) {
    char * dname = dirlist[count]->d_name;
    if((dname[strlen(dname)-1]!='~')&&(*dname!='.')&&isdir(dirname,dname)) {
       wprintw(leftwin,"%s/\n", dname);
       strcpy(leftsave[dirs],dname);
       leftsave[dirs][strlen(dname)]='\0';
       dirs++;
     }
    else if(!strcmp(dname+(strlen(dname)-4),".mp3")&&(*dname!='.')||(!strcmp(dname+(strlen(dname)-4),".ass"))) {
       wprintw(rghtwin,"%s\n",dname);
       strcpy(rghtsave[*mp3s],dname);
       *mp3s +=1;
  } }
  return(dirs);
}
void refreshit(WINDOW *thewin, int atspot, int atline) {
  if(thewin==leftwin) {
    mvwprintw(leftwin,atspot-1,0,leftsave[atspot-1]);
    mvwprintw(leftwin,atspot+1,0,leftsave[atspot+1]);
    wattron(leftwin,A_REVERSE);
    mvwprintw(leftwin,atspot,0,leftsave[atspot]);
    wattroff(leftwin,A_REVERSE);
    pnoutrefresh(leftwin,atline,0,6,3,LINES-8,COLS/2-4);
  }
  else {
    mvwprintw(rghtwin,atspot-1,0,rghtsave[atspot-1]);
    mvwprintw(rghtwin,atspot+1,0,rghtsave[atspot+1]);
    wattron(rghtwin,A_REVERSE);
    mvwprintw(rghtwin,atspot,0,rghtsave[atspot]);
    wattroff(rghtwin,A_REVERSE);
    pnoutrefresh(rghtwin,atline,0,6,COLS/2+2,LINES-8,COLS-4);
} }
