#include <kapp.h>
#include <X11/Xlib.h>
#include <qstring.h>

#include "ObscureVisApp.h"

ObscureVisApp::ObscureVisApp( int &argc, char **argv ) :
  KApplication( argc, argv )
{
  bFullyObscured = FALSE;
}

ObscureVisApp::ObscureVisApp( int &argc, char **argv,
			      const QString &rAppName ) :
  KApplication( argc, argv, rAppName )
{
  bFullyObscured = FALSE;
}

bool ObscureVisApp::x11EventFilter( XEvent *event )
{
  if ( event->type == VisibilityNotify ) {
    if ( event->xvisibility.state == VisibilityFullyObscured)
      bFullyObscured = TRUE;
    else
      bFullyObscured = FALSE;
  }

  return FALSE;
}

bool ObscureVisApp::isFullyObscured() {
  return bFullyObscured;
}
