#include <qslider.h>
#include "kmp3.h"
#include "configDisplay.h"

#define ktr           klocale->translate

extern KApplication *a;

configDisplay::configDisplay( QWidget *parent, cfg_struct *data, const char *name )
              : QWidget( parent, name ){

  led_color= data->led_color;
  background_color= data->background_color;
  tooltips= data->tooltips;
  docking= data->docking;
  stripname= data->stripname;
  stripend= data->stripend;
  line[0].setStr((const char *)data->line[0]);
  line[1].setStr((const char *)data->line[1]);
  line[2].setStr((const char *)data->line[2]);

  box= new QGroupBox( this, "box" );
  box->setGeometry( 10, 10, 365, 360 );

  ledLabel = new QLabel(this);
  ledLabel->setGeometry(25,25,135,25);
  ledLabel->setText(ktr("LED Color:"));

  ledFrame = new QFrame(this);
  ledFrame->setGeometry(160,25,30,25);
  ledFrame->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
  ledFrame->setBackgroundColor( led_color );

  ledButton = new QPushButton(this);
  ledButton->setGeometry(255,25,100,25);
  ledButton->setText(ktr("Change"));
  connect(ledButton,SIGNAL(clicked()),SLOT(set_led_color()));
	
  backLabel = new QLabel(this);
  backLabel->setGeometry(25,60,135,25);
  backLabel->setText(ktr("Background Color:"));
  
  backFrame = new QFrame(this);
  backFrame->setGeometry(160,60,30,25);
  backFrame->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
  backFrame->setBackgroundColor( background_color );
  
  backButton = new QPushButton(this);
  backButton->setGeometry(255,60,100,25);
  backButton->setText(ktr("Change"));
  connect(backButton,SIGNAL(clicked()),SLOT(set_back_color()));

  toolTipBox = new QCheckBox(ktr("Show Tool Tips"), this, "tooltipbox");
  toolTipBox->setGeometry(30,90,135,25);
  toolTipBox->setChecked(tooltips);
  connect(toolTipBox,SIGNAL(clicked()),SLOT(setToolTips()));

  dockingBox = new QCheckBox(ktr("Toggle panel docking"), this, "dockingbox");
  dockingBox->setGeometry(200,90,155,25);
  dockingBox->setChecked(docking);
  connect(dockingBox,SIGNAL(clicked()),SLOT(setDocking()));  

  stripBox = new QCheckBox(ktr("strip filename"), this, "stripbox");
  stripBox->setGeometry(30,113,155,25);
  stripBox->setChecked(stripname);
  connect(stripBox,SIGNAL(clicked()),SLOT(setStrip()));
 
  stripEndBox = new QCheckBox(ktr("strip extension"), this, "stripbox");
  stripEndBox->setGeometry(200,113,155,25);
  stripEndBox->setChecked(stripend);
  connect(stripEndBox,SIGNAL(clicked()),SLOT(setStripEnd()));

  infoBox= new QGroupBox(ktr("Text for MP3"),this, "box" );
  infoBox->setGeometry(20, 140, 342, 220 );

  line1Label = new QLabel(infoBox);
  line1Label->setGeometry(20,20,60,25);
  line1Label->setText(ktr("Line 1:"));

  line1LE = new QLineEdit(infoBox, "line1");
  line1LE->setGeometry(90,20 ,230,25);
  line1LE->setText((const char *)line[0]);
  connect(line1LE,SIGNAL(textChanged(const char * )),SLOT(setLine1(const char * )));

  line2Label = new QLabel(infoBox);
  line2Label->setGeometry(20,50,135,25);
  line2Label->setText(ktr("Line 2:"));

  line2LE = new QLineEdit(infoBox, "line2");
  line2LE->setGeometry(90,50,230,25);
  line2LE->setText((const char *)line[1]);
  connect(line2LE,SIGNAL(textChanged(const char * )),SLOT(setLine2(const char * )));

  line3Label = new QLabel(infoBox);
  line3Label->setGeometry(20,80,135,25);
  line3Label->setText(ktr("Dock Line:"));

  line3LE = new QLineEdit(infoBox, "dock");
  line3LE->setGeometry(90,80,230,25);
  line3LE->setText((const char *)line[2]);
  connect(line3LE,SIGNAL(textChanged(const char * )),SLOT(setLine3(const char * )));

  legend = new QLabel(infoBox, "Legend");
  legend->setGeometry(20,120,300,90);
  legend->setAlignment(AlignLeft|WordBreak);
  legend->setText(ktr("Legend:"));

  legend = new QLabel(infoBox, "Legend");
  legend->setGeometry(50,140,120,70);
  legend->setAlignment(AlignLeft|WordBreak);
  legend->setText(ktr("%1\t\tArtist\n%2\t\tSong\n%3\t\tAlbum\n%4\t\tYear\n"));
  
  legend = new QLabel(infoBox, "Legend");
  legend->setGeometry(200,140,120,70);
  legend->setAlignment(AlignLeft|WordBreak);
  legend->setText(ktr("%5\t\tGenre\n%6\t\tComment\n%7\t\tFilename\n%%\t\tsymbol '%'"));
}


void configDisplay::setLine1( const char * newText ){
  line[0].setStr(newText);
}

void configDisplay::setLine2( const char * newText ){
  line[1].setStr(newText);
}

void configDisplay::setLine3( const char * newText ){
  line[2].setStr(newText);
}

void configDisplay::set_led_color(){
  KColorDialog::getColor( led_color );
  ledFrame->setBackgroundColor( led_color );
}


void configDisplay::set_back_color(){
  KColorDialog::getColor( background_color );
  backFrame->setBackgroundColor( background_color );
}

void configDisplay::setToolTips(){
  tooltips= toolTipBox->isChecked()?TRUE:FALSE;
}   

void configDisplay::setDocking(){
  docking= dockingBox->isChecked()?TRUE:FALSE;
}

void configDisplay::setStrip(){
  stripname= stripBox->isChecked()?TRUE:FALSE;
} 

void configDisplay::setStripEnd(){
  stripend= stripEndBox->isChecked()?TRUE:FALSE;
}
