#ifndef _CONFIGDISPLAY
#define _CONFIGDISPLAY

#include <qwidget.h>
#include <qgrpbox.h>
#include <qchkbox.h>
#include <qframe.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <kcolordlg.h>
#include "kmp3.h"

class configDisplay : public QWidget{
	Q_OBJECT
	public:
	  configDisplay( QWidget *parent=0, cfg_struct *data=0, const char *name=0 );
          QColor led_color;
          QColor background_color;
          bool tooltips;
	  bool docking;
	  bool stripname;
	  bool stripend;
	  QString line[3];
		
	public slots:
	  void set_led_color();
	  void set_back_color();
	  void setToolTips();
          void setDocking(); 
	  void setStrip();
	  void setStripEnd();
	  void setLine1(const char * newText);
	  void setLine2(const char * newText);
          void setLine3(const char * newText);

	protected:

	private:
	  QGroupBox *box;
	  QGroupBox *infoBox;
	  QCheckBox *toolTipBox;
	  QCheckBox *dockingBox;
	  QCheckBox *stereoBox;
	  QCheckBox *mixDownBox;
	  QCheckBox *loadLastBox;
	  QCheckBox *stripBox;
	  QCheckBox *stripEndBox;
	  QLabel *ledLabel, *backLabel, *line1Label, *line2Label, *line3Label, *legend;
	  QLineEdit * line1LE, * line2LE, * line3LE;
	  QPushButton *ledButton, *backButton;
	  QFrame *ledFrame, *backFrame;
};

#endif
