#include "kmp3.h"
#include "configMisc.h"

#define ktr           klocale->translate

extern KApplication *a;

configMisc::configMisc( QWidget *parent, cfg_struct *data, const char *name )
             : QWidget( parent, name ){

        sensitive= data->sensitive;
        fuzzy= data->fuzzy;
        step= data->step;

	searchFrame = new QGroupBox( ktr("Search properties"), this );
	searchFrame->setGeometry( 5, 10, 370, 200 );

        caseBox = new QCheckBox(ktr("Case sensitve search"), searchFrame, "casebox");
        caseBox->setGeometry(25,35,335,25);
        caseBox->setChecked(sensitive);
        connect(caseBox,SIGNAL(clicked()),SLOT(setCase()));

        tolerantLB = new QLabel(searchFrame);
        tolerantLB->setGeometry(40,100,135,25);
        tolerantLB->setText(ktr("Mode:"));

        tolerantCB = new QComboBox( searchFrame );
        tolerantCB->setGeometry(40,125,85,25);
        setTolerant( step );

        tolerantCB->insertItem( ktr( "fussy" ) );
        tolerantCB->insertItem( ktr( "normal" ) );
        tolerantCB->insertItem( ktr( "lax" ) );
        tolerantCB->setCurrentItem( step );
        connect( tolerantCB, SIGNAL( activated(int) ), SLOT( setTolerant(int) ));

        fuzzyBox = new QCheckBox(ktr("Tolerant fuzzy search"), searchFrame, "fuzzybox");                                 fuzzyBox->setGeometry(25,75,335,25);
	fuzzyBox->setChecked(fuzzy);
	setFuzzy();
	connect(fuzzyBox,SIGNAL(clicked()),SLOT(setFuzzy()));
}


void configMisc::setTolerant( int value ){
        step= value;
}


void configMisc::setCase(){
        sensitive= caseBox->isChecked()?TRUE:FALSE;
}


void configMisc::setFuzzy(){
        fuzzy= fuzzyBox->isChecked()?TRUE:FALSE;
        if( !fuzzy ){
          tolerantLB->setEnabled( false );
          tolerantCB->setEnabled( false );
        }
        else{
          tolerantLB->setEnabled( true );
          tolerantCB->setEnabled( true );
        }
}



