#include "kmp3.h"
#include "configPlayer.h"

#define ktr           klocale->translate

extern KApplication *a;

configPlayer::configPlayer( QWidget *parent, cfg_struct *data, const char *name )
             : QWidget( parent, name ){

	stereo= data->stereo;
	mixdown= data->mixdown;
	loadLast= data->loadLast;
	buffers= data->buffers;
        autostart= data->autoStart;
        autostartcmd= data->autoStartCMD;
	// Added by SMF (12/22/98)
	startLoop = data->startLoop;
        startShuffle = data->startShuffle;

	box= new QGroupBox( this, "box" );
	box->setGeometry( 10, 10, 365, 360 );

	stereoBox = new QCheckBox(ktr("Stereo playing"), this, "stereobox");
	stereoBox->setGeometry(25,35,335,25);
	stereoBox->setChecked(stereo);
	connect(stereoBox,SIGNAL(clicked()),SLOT(setStereo()));

	mixDownBox = new QCheckBox(ktr("Enable downmixing"), this, "mixdownbox");
	mixDownBox->setGeometry(25,75,335,25);
	mixDownBox->setChecked(mixdown);
	connect(mixDownBox,SIGNAL(clicked()),SLOT(setMixDown()));

	loadLastBox = new QCheckBox(ktr("Load last title / list after restart"), 
				    this, "loadlastbox");
	loadLastBox->setGeometry(25,115,335,25);
	loadLastBox->setChecked(loadLast);
	connect(loadLastBox,SIGNAL(clicked()),SLOT(setLoadLast()));

	bufLabel = new QLabel(this);
	bufLabel->setGeometry(25,160,135,25);
	bufLabel->setText(ktr("Buffers in KByte:"));
	
	bufBox = new QLabel( this, "bufbox" );
	bufBox->setFrameStyle( QFrame::WinPanel | QFrame::Sunken);
	bufBox->setBackgroundColor( white );
	bufBox->setGeometry( 25, 190, 40,25);
	bufBox->setAlignment( AlignCenter);

	setBuffers( buffers );	

	bufSlider= new QSlider( 64, 1000, 2, 50, QSlider::Horizontal, this, "bufslide" );
	bufSlider->setTickmarks( (QSlider::TickSetting)2 );
	bufSlider->setTickInterval( 50 );
	bufSlider->setValue(buffers);
	bufSlider->setGeometry(90,190,230,25);
	
	connect( bufSlider, SIGNAL( valueChanged(int) ), SLOT( setBuffers(int) ));

	autoBox = new QCheckBox(ktr("Start playing when launched"), this, "autobox");
	autoBox->setGeometry(25,240,335,25);
	autoBox->setChecked(autostart);
	connect(autoBox,SIGNAL(clicked()),SLOT(setAuto()));

	autoCmdBox = new QCheckBox(ktr("Start playing in commandline mode"), this, "autocmdbox");
	autoCmdBox->setGeometry(25,285,335,25);
	autoCmdBox->setChecked(autostartcmd);
	connect(autoCmdBox,SIGNAL(clicked()),SLOT(setAutoCmd()));

	// Added by SMF (12/23/98)
        startLabel = new QLabel(this);
        startLabel->setGeometry(25,325,100,25);
        startLabel->setText(ktr("Starting Mode :"));

	startShuffleCB = new QComboBox( this );
        startShuffleCB->setGeometry(130,325,110,25);
        setShuffle( startShuffle );
        startShuffleCB->insertItem( ktr( "list order" ) );
        startShuffleCB->insertItem( ktr( "shuffle" ) );
        startShuffleCB->setCurrentItem( startShuffle );
        connect( startShuffleCB, SIGNAL( activated(int) ), SLOT( setShuffle(int) ));	

	startRepeatCB = new QComboBox( this );
        startRepeatCB->setGeometry(245,325,110,25);
        setRepeat( startLoop-1 );
        startRepeatCB->insertItem( ktr( "no loop" ) );
        startRepeatCB->insertItem( ktr( "loop on list" ) );
        startRepeatCB->insertItem( ktr( "loop on song" ) );
        startRepeatCB->setCurrentItem( startLoop-1 );
        connect( startRepeatCB, SIGNAL( activated(int) ), SLOT( setRepeat(int) ));	

}

void configPlayer::setBuffers( int value ){
	QString valueS;
	valueS.sprintf( "%d", buffers );
	bufBox->setText( valueS );
	buffers= value;
}

void configPlayer::setStereo(){
	stereo= stereoBox->isChecked()?TRUE:FALSE;
}   

void configPlayer::setAuto(){
	autostart= autoBox->isChecked()?TRUE:FALSE;
}

void configPlayer::setAutoCmd(){
	autostartcmd= autoCmdBox->isChecked()?TRUE:FALSE;
}


void configPlayer::setMixDown(){
	mixdown= mixDownBox->isChecked()?TRUE:FALSE;
}   

void configPlayer::setLoadLast(){
	loadLast= loadLastBox->isChecked()?TRUE:FALSE;
}   

//Added by SMF (12/23/98)
void configPlayer::setShuffle( int value ) {
  startShuffle = value;
}

void configPlayer::setRepeat( int value ) {
  startLoop = value+1;
}
