// -*- c++ -*-
#ifndef _CONFIGPLAYER
#define _CONFIGPLAYER

#include <qwidget.h>
#include <qgrpbox.h>
#include <qchkbox.h>
#include <qframe.h>
#include <qslider.h>
#include <qlabel.h>
#include "kmp3.h"

class configPlayer : public QWidget{
	Q_OBJECT
	public:
	  configPlayer( QWidget *parent=0, cfg_struct *data=0, const char *name=0 );
          bool stereo;
          bool mixdown;
	  bool loadLast;
	  bool autostart;
          bool autostartcmd;
          int  buffers;
          // Added by SMF (12/22/98)
          bool startShuffle;
          int  startLoop;
		
	public slots:
	  void setStereo();
	  void setAuto();
	  void setAutoCmd();
	  void setMixDown();
	  void setLoadLast();
	  void setBuffers( int value );
          // Added by SMF (12/23/98)
          void setShuffle( int value );
	  void setRepeat( int value );
	protected:

	private:
	  QGroupBox *box;
	  QCheckBox *stereoBox;
	  QCheckBox *mixDownBox;
	  QCheckBox *loadLastBox;
	  QCheckBox *autoBox;
          QCheckBox *autoCmdBox;
	  QLabel    *bufLabel;
	  QLabel    *bufBox;
	  QSlider   *bufSlider;
          // Added by SMF (12/23/98)
	  QLabel    *startLabel;
          QComboBox *startShuffleCB;
          QComboBox *startRepeatCB;

};

#endif
