#include "kmp3.h"

#include <qtooltip.h>
#include <kwm.h>
#include <kapp.h>

#include "ObscureVisApp.h"
#include "docking.h"

extern ObscureVisApp *a;
extern kmp3 *k;

DockWidget::DockWidget(const char *name)
  : QWidget(0, name, 0) {

  docked = false;

  pos_x = pos_y = 0;
  //have_kmp3_position = false;
  QString pixdir = a->kde_datadir() + "/kmp3/pics/";
  QString tmp;

#define PMERROR(pm) \
  tmp.sprintf(klocale->translate("Could not load %s !"), pm); \
  QMessageBox::warning(this, klocale->translate("Error"), tmp);

  if (!idle_pixmap.load(pixdir + "dock_idle.xpm")){
    PMERROR("dock_idle.xpm");
  }

  if (!playing_pixmap.load(pixdir + "dock_playing.xpm")){
    PMERROR("dock_playing.xpm");
  }

  // popup
  popup_m = new QPopupMenu();

  popup_m->insertItem(klocale->translate("Play/Pause"), this, SLOT(playPressed()));
  popup_m->insertItem(klocale->translate("Stop"), this, SLOT(stopPressed()));
  popup_m->insertItem(klocale->translate("Next"), this, SLOT(nextPressed()));
  popup_m->insertItem(klocale->translate("Previous"), this, SLOT(prevPressed()));
  popup_m->insertSeparator();
  popup_m->insertItem(klocale->translate("Exit"), this, SLOT(exitPressed()));
  popup_m->insertSeparator();
  toggleID = popup_m->insertItem(klocale->translate("Show"),
				 this, SLOT(toggle_window_state()));
}

DockWidget::~DockWidget() {
}

void DockWidget::dock() {

  if (!docked) {

    // prepare panel to accept this widget
    KWM::setDockWindow (this->winId());

    // that's all the space there is--don't need to do this!
    //this->setFixedSize( 24, 24);

    // finally dock the widget
    this->show();

    prevKmp3Desk = KWM::currentDesktop();
    bMadeVisible = true;

    // Start timer for changing image
    timed = new QTimer();
    connect( timed, SIGNAL(timeout()), SLOT( timerCall() ) );
    timed->start( 700, FALSE );

    docked = true;
    background= true;
    stat= WAIT;
  }
  if(k){
    QPoint point = k->mapToGlobal (QPoint (0,0));
    pos_x = point.x();
    pos_y = point.y();

  }
}


void DockWidget::undock() {

  if (docked) {

    // destroy timer
    timed->stop();
    delete( timed );

    // the widget's window has to be destroyed in order 
    // to undock from the panel. Simply using hide() is
    // not enough.
    this->destroy(true, true);

    // recreate window for further dockings
    this->create(0, true, false);

    docked = false;
  }
}

const bool DockWidget::isDocked() {

  return docked;

}

void DockWidget::paintEvent (QPaintEvent *e) {

  (void) e;

  paintIcon( BACK );

}

void DockWidget::paintIcon ( int Nr ) {
  int x, y;
  QPixmap *tpPixMap = NULL;
  
  switch( Nr ){
    case BACK:
      tpPixMap = &idle_pixmap;
      break;
    case PLAY:
      tpPixMap = &playing_pixmap;
      break;
  }
  if (tpPixMap != NULL) {
    x = this->width()/2 - tpPixMap->width()/2;
    y = this->height()/2 - tpPixMap->height()/2;
    erase();
    bitBlt(this, x, y, tpPixMap);
  }
}

void DockWidget::timeclick() {

  if(this->isVisible()){
    paintIcon( BACK );
  }  
}


void DockWidget::mousePressEvent(QMouseEvent *e) {

  // open/close connect-window on right mouse button 
  if ( e->button() == LeftButton ) {
    toggle_window_state();
  }

  // open popup menu on left mouse button
  if ( e->button() == RightButton  || e->button() == MidButton) {
    int x = e->x() + this->x();
    int y = e->y() + this->y();

    QString text;
    if(k->isVisible() && !a->isFullyObscured())
      text = klocale->translate("Hide");
    else
      text = klocale->translate("Show");
    
    popup_m->changeItem(text, toggleID);
    popup_m->popup(QPoint(x, y));
    popup_m->exec();
  }
}

void DockWidget::toggle_window_state() {

  // restore/hide connect-window
  if(k != 0L)  {
    // first check if on the same desktop as kmp3
    int currDesk = KWM::currentDesktop();
    if ((prevKmp3Desk != currDesk)) {
      prevKmp3Desk = currDesk;
      if (bMadeVisible) {
	// it is currently visible (on other desk),
	// so move it to the current desk
	if (k != 0) {
	  KWM::moveToDesktop(k->winId(), currDesk);
	  if (KWM::isIconified(k->winId()))
	    KWM::setIconify(k->winId(), false);
	  else
	    KWM::setIconify(k->winId(), true);
	      
	  return;
	}
      }
    }
    
    // restore/hide connect-window
    if (k->isVisible()){

     QPoint point = k->mapToGlobal (QPoint (0,0));
     pos_x = point.x();
     pos_y = point.y();
     // check if fully obscured by other windows
     // if so, raise it to the top!
     if (a->isFullyObscured())
       // using KWM function because
       // k->raise(); k->setActiveWindow();
       // doesn't make the window active!
       KWM::activate(k->winId());
     else {
       k->hide();
       bMadeVisible = false;
     }
    }
    else {
      //if(!have_kmp3_position) {
	//SaveKmp3Position();
      //}

      k->setGeometry(
		     pos_x, 
		     pos_y,
		     k->width(),
		     k->height());
      
      k->show();
      bMadeVisible = true;
    }
  }
}

/*
void DockWidget::SaveKmp3Position(){

     QPoint point = k->mapToGlobal (QPoint (0,0));
     pos_x = point.x();
     pos_y = point.y();
     have_kmp3_position = true;

}
*/


void DockWidget::playPressed(){
  k->playPressed();
}


void DockWidget::stopPressed(){
  k->stopPressed();
}


void DockWidget::nextPressed(){
  k->nextPressed();
}


void DockWidget::prevPressed(){
  k->prevPressed();
}

void DockWidget::exitPressed() {
  k->powerPressed();
}



void DockWidget::timerCall(){
  if( docked ){
    switch( stat ){
      case PLAY:	if( background ){
			  background= false;
			  paintIcon( BACK );
			}
			else{
			  background= true;
			  paintIcon( PLAY );
			}
			break;

      case WAIT:	if( background ){
      			  background= false;
			  paintIcon( BACK );
			}
			break;
    }
  }
}

